/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.xmlrpc;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;

public class RPCServer
extends GroovyObjectSupport {
    protected final Map registeredMethods = Collections.synchronizedMap(new HashMap());
    protected Closure defaultMethod = null;
    protected Closure preCallMethod = null;
    protected Closure postCallMethod = null;
    protected Closure faultMethod = null;

    public Object getProperty(final String string) {
        return new GroovyObjectSupport(){
            private final StringBuffer propertyPrefix;
            {
                this.propertyPrefix = new StringBuffer(string + ".");
            }

            public Object getProperty(String string2) {
                this.propertyPrefix.append(string2).append('.');
                return this;
            }

            public void setProperty(String string2, Object object) {
                RPCServer.this.setProperty(this.propertyPrefix + string2, string2, object);
            }
        };
    }

    public void setProperty(String string, Object object) {
        this.setProperty(string, string, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setProperty(String string, String string2, Object object) {
        Closure closure = null;
        if (object instanceof Closure) {
            try {
                closure = (Closure)((Closure)object).clone();
                closure.setDelegate((Object)this);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        } else if (object instanceof Class) {
            int n = this.getNumberOfParameters(9, ((Class)object).getMethods(), string2);
            if (n == -1) throw new GroovyRuntimeException("No static method " + string2 + " on class " + ((Class)object).getName());
            closure = this.makeMethodProxy(string2, n, ((Class)object).getName());
        } else {
            int n = this.getNumberOfParameters(1, object.getClass().getMethods(), string2);
            if (n == -1) throw new GroovyRuntimeException("No method " + string2 + " on class " + object.getClass().getName());
            closure = this.makeMethodProxy(string2, n, "delegate");
            closure.setDelegate(object);
        }
        this.registeredMethods.put(string, closure);
    }

    private int getNumberOfParameters(int n, Method[] methodArray, String string) {
        boolean bl = false;
        int n2 = -1;
        for (int i = 0; i != methodArray.length; ++i) {
            if ((methodArray[i].getModifiers() & n) != n || !methodArray[i].getName().equals(string)) continue;
            if (bl) {
                if (n2 == methodArray[i].getParameterTypes().length) continue;
                throw new GroovyRuntimeException("More than one methods " + string + " on class " + methodArray[i].getDeclaringClass().getName() + " with different numbers of parameters");
            }
            bl = true;
            n2 = methodArray[i].getParameterTypes().length;
        }
        return n2;
    }

    private Closure makeMethodProxy(String string, int n, String string2) {
        CharSequence charSequence;
        String string3;
        String string4;
        if (n == 0) {
            string4 = "";
            string3 = "";
        } else {
            charSequence = new StringBuffer();
            for (int i = 0; i != n; ++i) {
                ((StringBuffer)charSequence).append(", p" + i);
            }
            string4 = ((StringBuffer)charSequence).delete(0, 2).toString();
            string3 = string4 + " -> ";
        }
        charSequence = "class X { public def closure = {" + string3 + " " + string2 + "." + string + "(" + string4 + ") }}";
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)charSequence).getBytes());
            GroovyObject groovyObject = (GroovyObject)new GroovyClassLoader().parseClass((InputStream)byteArrayInputStream, string).newInstance();
            return (Closure)groovyObject.getProperty("closure");
        }
        catch (Exception exception) {
            throw new GroovyRuntimeException("Can't generate proxy for XML-RPC method " + string, (Throwable)exception);
        }
    }

    public void returnFault(String string, int n) throws XMLRPCFailException {
        throw new XMLRPCFailException(string, n);
    }

    public void returnFault(GString gString, int n) throws XMLRPCFailException {
        this.returnFault(gString.toString(), n);
    }

    public void setupDefaultMethod(Closure closure) {
        if (closure != null) {
            this.defaultMethod = closure;
        }
    }

    public void setupPreCallMethod(Closure closure) {
        if (closure != null) {
            this.preCallMethod = closure;
        }
    }

    public void setupPostCallMethod(Closure closure) {
        if (closure != null) {
            this.postCallMethod = closure;
        }
    }

    public void setupFaultMethod(Closure closure) {
        if (closure != null) {
            this.faultMethod = closure;
        }
    }
}

