/*
 * Decompiled with CFR 0.152.
 */
package uk.co.wilson.net.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import uk.co.wilson.net.MinMLSocketServer;

public abstract class MinMLHTTPServer
extends MinMLSocketServer {
    protected static byte[] host;
    private int keepAliveCount = 0;
    protected final int maxKeepAlives;
    protected final int socketReadTimeout;
    protected static final byte[] okMessage;
    protected static final byte[] endOfLine;
    static final byte[] get;
    static final byte[] head;
    static final byte[] post;
    static final byte[] put;
    static final byte[] errorMessage1;
    static final byte[] errorMessage2;
    static final byte[] keepConnection;
    static final byte[] closeConnection;

    public MinMLHTTPServer(ServerSocket serverSocket, int n, int n2, int n3, int n4, int n5) {
        super(serverSocket, n, n2, n4);
        this.maxKeepAlives = n3;
        this.socketReadTimeout = n5;
    }

    private synchronized boolean startKeepAlive() {
        if (this.keepAliveCount < this.maxKeepAlives) {
            ++this.keepAliveCount;
            return true;
        }
        return false;
    }

    private synchronized void endKeepAlive() {
        --this.keepAliveCount;
    }

    static {
        try {
            host = ("Host: " + InetAddress.getLocalHost().getHostName() + "\r\n").getBytes();
        }
        catch (UnknownHostException unknownHostException) {
            host = "Host: unknown\r\n ".getBytes();
        }
        okMessage = " 200 OK \r\nServer: uk.co.wilson.net.http.HTTPServer\r\n".getBytes();
        endOfLine = "\r\n".getBytes();
        get = "GET".getBytes();
        head = "HEAD".getBytes();
        post = "POST".getBytes();
        put = "PUT".getBytes();
        errorMessage1 = " 400 Bad Request\r\nServer: uk.co.wilson.net.http.HTTPServer\r\n\r\nMethod ".getBytes();
        errorMessage2 = " not implemented\r\n".getBytes();
        keepConnection = "Connection: Keep-Alive\r\n".getBytes();
        closeConnection = "Connection: Close\r\n".getBytes();
    }

    protected abstract class HTTPWorker
    extends MinMLSocketServer.ServerSocketWorker {
        private final byte[] buf;
        private int count;
        private boolean keepAlive;

        protected HTTPWorker() {
            super(MinMLHTTPServer.this);
            this.buf = new byte[256];
            this.count = 0;
            this.keepAlive = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void process(Object object) throws Exception {
            Socket socket = (Socket)object;
            try {
                int n;
                socket.setSoTimeout(MinMLHTTPServer.this.socketReadTimeout);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
                do {
                    Object object2;
                    String string;
                    n = -1;
                    while (this.readLine(bufferedInputStream) != -1 && this.count == 0) {
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(new String(this.buf, 0, this.count));
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    String string4 = string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                    while (this.readLine(bufferedInputStream) != -1 && this.count != 0) {
                        object2 = new String(this.buf, 0, this.count).trim().toLowerCase();
                        if (((String)object2).startsWith("connection:")) {
                            if (((String)object2).endsWith("keep-alive")) {
                                if (this.keepAlive) continue;
                                this.keepAlive = MinMLHTTPServer.this.startKeepAlive();
                                continue;
                            }
                            if (!this.keepAlive) continue;
                            MinMLHTTPServer.this.endKeepAlive();
                            this.keepAlive = false;
                            continue;
                        }
                        if (!((String)object2).startsWith("content-length:")) continue;
                        n = Integer.parseInt(((String)object2).substring(15).trim());
                    }
                    if (n == -1) {
                        this.processMethod(bufferedInputStream, bufferedOutputStream, string2, string3, string);
                    } else {
                        object2 = new LimitedInputStream(bufferedInputStream, n);
                        this.processMethod((InputStream)object2, bufferedOutputStream, string2, string3, string);
                        ((InputStream)object2).close();
                    }
                    ((OutputStream)bufferedOutputStream).flush();
                } while (n != -1 && this.keepAlive);
            }
            finally {
                if (this.keepAlive) {
                    MinMLHTTPServer.this.endKeepAlive();
                    this.keepAlive = false;
                }
            }
        }

        protected void processMethod(InputStream inputStream, OutputStream outputStream, String string, String string2, String string3) throws Exception {
            if (string.equalsIgnoreCase("GET")) {
                this.processGet(inputStream, outputStream, string2, string3);
            } else if (string.equalsIgnoreCase("HEAD")) {
                this.processHead(inputStream, outputStream, string2, string3);
            } else if (string.equalsIgnoreCase("POST")) {
                this.processPost(inputStream, outputStream, string2, string3);
            } else if (string.equalsIgnoreCase("PUT")) {
                this.processPut(inputStream, outputStream, string2, string3);
            } else {
                this.processOther(inputStream, outputStream, string, string2, string3);
            }
        }

        protected void processGet(InputStream inputStream, OutputStream outputStream, String string, String string2) throws Exception {
            outputStream.write(string2.getBytes());
            outputStream.write(errorMessage1);
            outputStream.write(get);
            outputStream.write(errorMessage2);
        }

        protected void processHead(InputStream inputStream, OutputStream outputStream, String string, String string2) throws Exception {
            outputStream.write(string2.getBytes());
            outputStream.write(errorMessage1);
            outputStream.write(head);
            outputStream.write(errorMessage2);
        }

        protected void processPost(InputStream inputStream, OutputStream outputStream, String string, String string2) throws Exception {
            outputStream.write(string2.getBytes());
            outputStream.write(errorMessage1);
            outputStream.write(post);
            outputStream.write(errorMessage2);
        }

        protected void processPut(InputStream inputStream, OutputStream outputStream, String string, String string2) throws Exception {
            outputStream.write(string2.getBytes());
            outputStream.write(errorMessage1);
            outputStream.write(put);
            outputStream.write(errorMessage2);
        }

        protected void processOther(InputStream inputStream, OutputStream outputStream, String string, String string2, String string3) throws Exception {
            outputStream.write(string3.getBytes());
            outputStream.write(errorMessage1);
            outputStream.write(string.getBytes());
            outputStream.write(errorMessage2);
        }

        protected void writeKeepAlive(OutputStream outputStream) throws IOException {
            outputStream.write(this.keepAlive ? keepConnection : closeConnection);
        }

        private int readLine(InputStream inputStream) throws IOException {
            int n;
            this.count = 0;
            while (((n = inputStream.read()) != 13 || (n = inputStream.read()) != 10) && n != -1) {
                this.buf[this.count] = (byte)n;
                if (this.count == this.buf.length - 1) continue;
                ++this.count;
            }
            return n;
        }
    }

    private static class LimitedInputStream
    extends InputStream {
        private int contentLength;
        private final InputStream in;

        public LimitedInputStream(InputStream inputStream, int n) {
            this.in = inputStream;
            this.contentLength = n;
        }

        public int available() throws IOException {
            return Math.min(this.in.available(), this.contentLength);
        }

        public void close() throws IOException {
            this.skip(this.contentLength);
        }

        public int read() throws IOException {
            if (this.contentLength == 0) {
                return -1;
            }
            --this.contentLength;
            return this.in.read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.contentLength == 0) {
                return -1;
            }
            if ((n2 = this.in.read(byArray, n, Math.min(n2, this.contentLength))) != -1) {
                this.contentLength -= n2;
            }
            return n2;
        }

        public long skip(long l) throws IOException {
            l = Math.min(l, (long)this.contentLength);
            this.contentLength = (int)((long)this.contentLength - l);
            return this.in.skip(l);
        }
    }
}

