/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.MetaClass;
import groovy.lang.Range;
import groovy.lang.Reference;
import groovy.lang.Script;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.vmplugin.VMPluginFactory;

public class ClassHelper {
    private static final Class[] classes;
    private static final String[] primitiveClassNames;
    public static final ClassNode DYNAMIC_TYPE;
    public static final ClassNode OBJECT_TYPE;
    public static final ClassNode VOID_TYPE;
    public static final ClassNode CLOSURE_TYPE;
    public static final ClassNode GSTRING_TYPE;
    public static final ClassNode LIST_TYPE;
    public static final ClassNode MAP_TYPE;
    public static final ClassNode RANGE_TYPE;
    public static final ClassNode PATTERN_TYPE;
    public static final ClassNode STRING_TYPE;
    public static final ClassNode SCRIPT_TYPE;
    public static final ClassNode REFERENCE_TYPE;
    public static final ClassNode boolean_TYPE;
    public static final ClassNode char_TYPE;
    public static final ClassNode byte_TYPE;
    public static final ClassNode int_TYPE;
    public static final ClassNode long_TYPE;
    public static final ClassNode short_TYPE;
    public static final ClassNode double_TYPE;
    public static final ClassNode float_TYPE;
    public static final ClassNode Byte_TYPE;
    public static final ClassNode Short_TYPE;
    public static final ClassNode Integer_TYPE;
    public static final ClassNode Long_TYPE;
    public static final ClassNode Character_TYPE;
    public static final ClassNode Float_TYPE;
    public static final ClassNode Double_TYPE;
    public static final ClassNode Boolean_TYPE;
    public static final ClassNode BigInteger_TYPE;
    public static final ClassNode BigDecimal_TYPE;
    public static final ClassNode void_WRAPPER_TYPE;
    public static final ClassNode CLASS_Type;
    public static final ClassNode METACLASS_TYPE;
    public static final ClassNode GENERATED_CLOSURE_Type;
    public static final ClassNode Enum_Type;
    public static final ClassNode Annotation_TYPE;
    public static final ClassNode ELEMENT_TYPE_TYPE;
    private static ClassNode[] types;
    private static ClassNode[] numbers;
    protected static final ClassNode[] EMPTY_TYPE_ARRAY;
    public static final String OBJECT = "java.lang.Object";
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$util$regex$Pattern;
    static /* synthetic */ Class class$org$codehaus$groovy$runtime$GeneratedClosure;
    static /* synthetic */ Class class$groovy$lang$Script;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$groovy$lang$MetaClass;
    static /* synthetic */ Class class$groovy$lang$Range;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$groovy$lang$GString;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$groovy$lang$Reference;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$groovy$lang$Closure;

    public static ClassNode[] make(Class[] classes) {
        ClassNode[] cns = new ClassNode[classes.length];
        for (int i = 0; i < cns.length; ++i) {
            cns[i] = ClassHelper.make(classes[i]);
        }
        return cns;
    }

    public static ClassNode make(Class c) {
        return ClassHelper.make(c, true);
    }

    public static ClassNode make(Class c, boolean includeGenerics) {
        for (int i = 0; i < classes.length; ++i) {
            if (c != classes[i]) continue;
            return types[i];
        }
        if (c.isArray()) {
            ClassNode cn = ClassHelper.make(c.getComponentType(), includeGenerics);
            return cn.makeArray();
        }
        return ClassHelper.makeWithoutCaching(c, includeGenerics);
    }

    public static ClassNode makeWithoutCaching(Class c) {
        return ClassHelper.makeWithoutCaching(c, true);
    }

    public static ClassNode makeWithoutCaching(Class c, boolean includeGenerics) {
        ClassNode t = new ClassNode(c);
        if (includeGenerics) {
            VMPluginFactory.getPlugin().setAdditionalClassInformation(t);
        }
        return t;
    }

    public static ClassNode makeWithoutCaching(String name) {
        ClassNode cn = new ClassNode(name, 1, OBJECT_TYPE);
        cn.isPrimaryNode = false;
        return cn;
    }

    public static ClassNode make(String name) {
        int i;
        if (name == null || name.length() == 0) {
            return DYNAMIC_TYPE;
        }
        for (i = 0; i < primitiveClassNames.length; ++i) {
            if (!primitiveClassNames[i].equals(name)) continue;
            return types[i];
        }
        for (i = 0; i < classes.length; ++i) {
            String cname = classes[i].getName();
            if (!name.equals(cname)) continue;
            return types[i];
        }
        return ClassHelper.makeWithoutCaching(name);
    }

    public static ClassNode getWrapper(ClassNode cn) {
        if (!ClassHelper.isPrimitiveType(cn = cn.redirect())) {
            return cn;
        }
        if (cn == boolean_TYPE) {
            return Boolean_TYPE;
        }
        if (cn == byte_TYPE) {
            return Byte_TYPE;
        }
        if (cn == char_TYPE) {
            return Character_TYPE;
        }
        if (cn == short_TYPE) {
            return Short_TYPE;
        }
        if (cn == int_TYPE) {
            return Integer_TYPE;
        }
        if (cn == long_TYPE) {
            return Long_TYPE;
        }
        if (cn == float_TYPE) {
            return Float_TYPE;
        }
        if (cn == double_TYPE) {
            return Double_TYPE;
        }
        if (cn == VOID_TYPE) {
            return void_WRAPPER_TYPE;
        }
        return cn;
    }

    public static ClassNode getUnwrapper(ClassNode cn) {
        if (ClassHelper.isPrimitiveType(cn = cn.redirect())) {
            return cn;
        }
        if (cn == Boolean_TYPE) {
            return boolean_TYPE;
        }
        if (cn == Byte_TYPE) {
            return byte_TYPE;
        }
        if (cn == Character_TYPE) {
            return char_TYPE;
        }
        if (cn == Short_TYPE) {
            return short_TYPE;
        }
        if (cn == Integer_TYPE) {
            return int_TYPE;
        }
        if (cn == Long_TYPE) {
            return long_TYPE;
        }
        if (cn == Float_TYPE) {
            return float_TYPE;
        }
        if (cn == Double_TYPE) {
            return double_TYPE;
        }
        return cn;
    }

    public static boolean isPrimitiveType(ClassNode cn) {
        return cn == boolean_TYPE || cn == char_TYPE || cn == byte_TYPE || cn == short_TYPE || cn == int_TYPE || cn == long_TYPE || cn == float_TYPE || cn == double_TYPE || cn == VOID_TYPE;
    }

    public static boolean isNumberType(ClassNode cn) {
        return cn == Byte_TYPE || cn == Short_TYPE || cn == Integer_TYPE || cn == Long_TYPE || cn == Float_TYPE || cn == Double_TYPE || cn == byte_TYPE || cn == short_TYPE || cn == int_TYPE || cn == long_TYPE || cn == float_TYPE || cn == double_TYPE;
    }

    public static ClassNode makeReference() {
        Class<?> clazz = class$groovy$lang$Reference;
        if (clazz == null) {
            clazz = class$groovy$lang$Reference = new Reference[0].getClass().getComponentType();
        }
        return ClassHelper.make(clazz);
    }

    public static boolean isCachedType(ClassNode type) {
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != type) continue;
            return true;
        }
        return false;
    }

    static {
        Class<?> clazz;
        Class clazz2;
        Class clazz3;
        Class clazz4;
        Class clazz5;
        Class clazz6;
        Class clazz7;
        Class clazz8;
        Class clazz9;
        Class clazz10;
        Class clazz11;
        Class clazz12;
        Class clazz13;
        Class clazz14;
        Class clazz15;
        Class clazz16;
        Class clazz17;
        Class clazz18;
        Class clazz19;
        Class clazz20;
        Class clazz21;
        Class[] classArray = new Class[32];
        Class<?> clazz22 = class$java$lang$Object;
        if (clazz22 == null) {
            clazz22 = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        classArray[0] = clazz22;
        classArray[1] = Boolean.TYPE;
        classArray[2] = Character.TYPE;
        classArray[3] = Byte.TYPE;
        classArray[4] = Short.TYPE;
        classArray[5] = Integer.TYPE;
        classArray[6] = Long.TYPE;
        classArray[7] = Double.TYPE;
        classArray[8] = Float.TYPE;
        classArray[9] = Void.TYPE;
        Class clazz23 = class$groovy$lang$Closure;
        if (clazz23 == null) {
            clazz23 = classArray[10] = (class$groovy$lang$Closure = new Closure[0].getClass().getComponentType());
        }
        if ((clazz21 = class$groovy$lang$GString) == null) {
            clazz21 = classArray[11] = (class$groovy$lang$GString = new GString[0].getClass().getComponentType());
        }
        if ((clazz20 = class$java$util$List) == null) {
            clazz20 = classArray[12] = (class$java$util$List = new List[0].getClass().getComponentType());
        }
        if ((clazz19 = class$java$util$Map) == null) {
            clazz19 = classArray[13] = (class$java$util$Map = new Map[0].getClass().getComponentType());
        }
        if ((clazz18 = class$groovy$lang$Range) == null) {
            clazz18 = classArray[14] = (class$groovy$lang$Range = new Range[0].getClass().getComponentType());
        }
        if ((clazz17 = class$java$util$regex$Pattern) == null) {
            clazz17 = classArray[15] = (class$java$util$regex$Pattern = new Pattern[0].getClass().getComponentType());
        }
        if ((clazz16 = class$groovy$lang$Script) == null) {
            clazz16 = classArray[16] = (class$groovy$lang$Script = new Script[0].getClass().getComponentType());
        }
        if ((clazz15 = class$java$lang$String) == null) {
            clazz15 = classArray[17] = (class$java$lang$String = new String[0].getClass().getComponentType());
        }
        if ((clazz14 = class$java$lang$Boolean) == null) {
            clazz14 = classArray[18] = (class$java$lang$Boolean = new Boolean[0].getClass().getComponentType());
        }
        if ((clazz13 = class$java$lang$Character) == null) {
            clazz13 = classArray[19] = (class$java$lang$Character = new Character[0].getClass().getComponentType());
        }
        if ((clazz12 = class$java$lang$Byte) == null) {
            clazz12 = classArray[20] = (class$java$lang$Byte = new Byte[0].getClass().getComponentType());
        }
        if ((clazz11 = class$java$lang$Short) == null) {
            clazz11 = classArray[21] = (class$java$lang$Short = new Short[0].getClass().getComponentType());
        }
        if ((clazz10 = class$java$lang$Integer) == null) {
            clazz10 = classArray[22] = (class$java$lang$Integer = new Integer[0].getClass().getComponentType());
        }
        if ((clazz9 = class$java$lang$Long) == null) {
            clazz9 = classArray[23] = (class$java$lang$Long = new Long[0].getClass().getComponentType());
        }
        if ((clazz8 = class$java$lang$Double) == null) {
            clazz8 = classArray[24] = (class$java$lang$Double = new Double[0].getClass().getComponentType());
        }
        if ((clazz7 = class$java$lang$Float) == null) {
            clazz7 = classArray[25] = (class$java$lang$Float = new Float[0].getClass().getComponentType());
        }
        if ((clazz6 = class$java$math$BigDecimal) == null) {
            clazz6 = classArray[26] = (class$java$math$BigDecimal = new BigDecimal[0].getClass().getComponentType());
        }
        if ((clazz5 = class$java$math$BigInteger) == null) {
            clazz5 = classArray[27] = (class$java$math$BigInteger = new BigInteger[0].getClass().getComponentType());
        }
        if ((clazz4 = class$java$lang$Void) == null) {
            clazz4 = classArray[28] = (class$java$lang$Void = new Void[0].getClass().getComponentType());
        }
        if ((clazz3 = class$groovy$lang$Reference) == null) {
            clazz3 = classArray[29] = (class$groovy$lang$Reference = new Reference[0].getClass().getComponentType());
        }
        if ((clazz2 = class$java$lang$Class) == null) {
            clazz2 = classArray[30] = (class$java$lang$Class = new Class[0].getClass().getComponentType());
        }
        if ((clazz = class$groovy$lang$MetaClass) == null) {
            clazz = class$groovy$lang$MetaClass = new MetaClass[0].getClass().getComponentType();
        }
        classArray[31] = clazz;
        classes = classArray;
        primitiveClassNames = new String[]{"", "boolean", "char", "byte", "short", "int", "long", "double", "float", "void"};
        Class<?> clazz24 = class$java$lang$Object;
        if (clazz24 == null) {
            clazz24 = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        OBJECT_TYPE = DYNAMIC_TYPE = new ClassNode(clazz24);
        VOID_TYPE = new ClassNode(Void.TYPE);
        Class<?> clazz25 = class$groovy$lang$Closure;
        if (clazz25 == null) {
            clazz25 = class$groovy$lang$Closure = new Closure[0].getClass().getComponentType();
        }
        CLOSURE_TYPE = new ClassNode(clazz25);
        Class<?> clazz26 = class$groovy$lang$GString;
        if (clazz26 == null) {
            clazz26 = class$groovy$lang$GString = new GString[0].getClass().getComponentType();
        }
        GSTRING_TYPE = new ClassNode(clazz26);
        Class<?> clazz27 = class$java$util$List;
        if (clazz27 == null) {
            clazz27 = class$java$util$List = new List[0].getClass().getComponentType();
        }
        LIST_TYPE = ClassHelper.makeWithoutCaching(clazz27);
        Class<?> clazz28 = class$java$util$Map;
        if (clazz28 == null) {
            clazz28 = class$java$util$Map = new Map[0].getClass().getComponentType();
        }
        MAP_TYPE = ClassHelper.makeWithoutCaching(clazz28);
        Class<?> clazz29 = class$groovy$lang$Range;
        if (clazz29 == null) {
            clazz29 = class$groovy$lang$Range = new Range[0].getClass().getComponentType();
        }
        RANGE_TYPE = new ClassNode(clazz29);
        Class<?> clazz30 = class$java$util$regex$Pattern;
        if (clazz30 == null) {
            clazz30 = class$java$util$regex$Pattern = new Pattern[0].getClass().getComponentType();
        }
        PATTERN_TYPE = new ClassNode(clazz30);
        Class<?> clazz31 = class$java$lang$String;
        if (clazz31 == null) {
            clazz31 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        STRING_TYPE = new ClassNode(clazz31);
        Class<?> clazz32 = class$groovy$lang$Script;
        if (clazz32 == null) {
            clazz32 = class$groovy$lang$Script = new Script[0].getClass().getComponentType();
        }
        SCRIPT_TYPE = new ClassNode(clazz32);
        Class<?> clazz33 = class$groovy$lang$Reference;
        if (clazz33 == null) {
            clazz33 = class$groovy$lang$Reference = new Reference[0].getClass().getComponentType();
        }
        REFERENCE_TYPE = ClassHelper.makeWithoutCaching(clazz33);
        boolean_TYPE = new ClassNode(Boolean.TYPE);
        char_TYPE = new ClassNode(Character.TYPE);
        byte_TYPE = new ClassNode(Byte.TYPE);
        int_TYPE = new ClassNode(Integer.TYPE);
        long_TYPE = new ClassNode(Long.TYPE);
        short_TYPE = new ClassNode(Short.TYPE);
        double_TYPE = new ClassNode(Double.TYPE);
        float_TYPE = new ClassNode(Float.TYPE);
        Class<?> clazz34 = class$java$lang$Byte;
        if (clazz34 == null) {
            clazz34 = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
        }
        Byte_TYPE = new ClassNode(clazz34);
        Class<?> clazz35 = class$java$lang$Short;
        if (clazz35 == null) {
            clazz35 = class$java$lang$Short = new Short[0].getClass().getComponentType();
        }
        Short_TYPE = new ClassNode(clazz35);
        Class<?> clazz36 = class$java$lang$Integer;
        if (clazz36 == null) {
            clazz36 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
        }
        Integer_TYPE = new ClassNode(clazz36);
        Class<?> clazz37 = class$java$lang$Long;
        if (clazz37 == null) {
            clazz37 = class$java$lang$Long = new Long[0].getClass().getComponentType();
        }
        Long_TYPE = new ClassNode(clazz37);
        Class<?> clazz38 = class$java$lang$Character;
        if (clazz38 == null) {
            clazz38 = class$java$lang$Character = new Character[0].getClass().getComponentType();
        }
        Character_TYPE = new ClassNode(clazz38);
        Class<?> clazz39 = class$java$lang$Float;
        if (clazz39 == null) {
            clazz39 = class$java$lang$Float = new Float[0].getClass().getComponentType();
        }
        Float_TYPE = new ClassNode(clazz39);
        Class<?> clazz40 = class$java$lang$Double;
        if (clazz40 == null) {
            clazz40 = class$java$lang$Double = new Double[0].getClass().getComponentType();
        }
        Double_TYPE = new ClassNode(clazz40);
        Class<?> clazz41 = class$java$lang$Boolean;
        if (clazz41 == null) {
            clazz41 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
        }
        Boolean_TYPE = new ClassNode(clazz41);
        Class<?> clazz42 = class$java$math$BigInteger;
        if (clazz42 == null) {
            clazz42 = class$java$math$BigInteger = new BigInteger[0].getClass().getComponentType();
        }
        BigInteger_TYPE = new ClassNode(clazz42);
        Class<?> clazz43 = class$java$math$BigDecimal;
        if (clazz43 == null) {
            clazz43 = class$java$math$BigDecimal = new BigDecimal[0].getClass().getComponentType();
        }
        BigDecimal_TYPE = new ClassNode(clazz43);
        Class<?> clazz44 = class$java$lang$Void;
        if (clazz44 == null) {
            clazz44 = class$java$lang$Void = new Void[0].getClass().getComponentType();
        }
        void_WRAPPER_TYPE = new ClassNode(clazz44);
        Class<?> clazz45 = class$java$lang$Class;
        if (clazz45 == null) {
            clazz45 = class$java$lang$Class = new Class[0].getClass().getComponentType();
        }
        CLASS_Type = ClassHelper.makeWithoutCaching(clazz45);
        Class<?> clazz46 = class$groovy$lang$MetaClass;
        if (clazz46 == null) {
            clazz46 = class$groovy$lang$MetaClass = new MetaClass[0].getClass().getComponentType();
        }
        METACLASS_TYPE = new ClassNode(clazz46);
        Class<?> clazz47 = class$org$codehaus$groovy$runtime$GeneratedClosure;
        if (clazz47 == null) {
            clazz47 = class$org$codehaus$groovy$runtime$GeneratedClosure = new GeneratedClosure[0].getClass().getComponentType();
        }
        GENERATED_CLOSURE_Type = new ClassNode(clazz47);
        Enum_Type = new ClassNode("java.lang.Enum", 0, OBJECT_TYPE);
        Annotation_TYPE = new ClassNode("java.lang.annotation.Annotation", 0, OBJECT_TYPE);
        ELEMENT_TYPE_TYPE = new ClassNode("java.lang.annotation.ElementType", 0, Enum_Type);
        ClassHelper.Enum_Type.isPrimaryNode = false;
        ClassHelper.Annotation_TYPE.isPrimaryNode = false;
        types = new ClassNode[]{OBJECT_TYPE, boolean_TYPE, char_TYPE, byte_TYPE, short_TYPE, int_TYPE, long_TYPE, double_TYPE, float_TYPE, VOID_TYPE, CLOSURE_TYPE, GSTRING_TYPE, LIST_TYPE, MAP_TYPE, RANGE_TYPE, PATTERN_TYPE, SCRIPT_TYPE, STRING_TYPE, Boolean_TYPE, Character_TYPE, Byte_TYPE, Short_TYPE, Integer_TYPE, Long_TYPE, Double_TYPE, Float_TYPE, BigDecimal_TYPE, BigInteger_TYPE, void_WRAPPER_TYPE, REFERENCE_TYPE, CLASS_Type, METACLASS_TYPE, GENERATED_CLOSURE_Type, Enum_Type, Annotation_TYPE};
        numbers = new ClassNode[]{char_TYPE, byte_TYPE, short_TYPE, int_TYPE, long_TYPE, double_TYPE, float_TYPE, Short_TYPE, Byte_TYPE, Character_TYPE, Integer_TYPE, Float_TYPE, Long_TYPE, Double_TYPE, BigInteger_TYPE, BigDecimal_TYPE};
        EMPTY_TYPE_ARRAY = new ClassNode[0];
    }
}

