/*
 * Decompiled with CFR 0.152.
 */
package groovy.xml;

import groovy.util.BuilderSupport;
import groovy.util.IndentPrinter;
import groovy.xml.MarkupBuilderHelper;
import groovy.xml.QName;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupBuilder
extends BuilderSupport {
    private IndentPrinter out;
    private boolean nospace;
    private int state;
    private boolean nodeIsEmpty = true;
    private boolean useDoubleQuotes = false;
    private boolean omitNullAttributes = false;
    private boolean omitEmptyAttributes = false;

    public MarkupBuilder() {
        this(new IndentPrinter());
    }

    public MarkupBuilder(PrintWriter pw) {
        this(new IndentPrinter(pw));
    }

    public MarkupBuilder(Writer writer) {
        this(new IndentPrinter(new PrintWriter(writer)));
    }

    public MarkupBuilder(IndentPrinter out) {
        this.out = out;
    }

    public boolean getDoubleQuotes() {
        return this.useDoubleQuotes;
    }

    public void setDoubleQuotes(boolean useDoubleQuotes) {
        this.useDoubleQuotes = useDoubleQuotes;
    }

    public boolean isOmitNullAttributes() {
        return this.omitNullAttributes;
    }

    public void setOmitNullAttributes(boolean omitNullAttributes) {
        this.omitNullAttributes = omitNullAttributes;
    }

    public boolean isOmitEmptyAttributes() {
        return this.omitEmptyAttributes;
    }

    public void setOmitEmptyAttributes(boolean omitEmptyAttributes) {
        this.omitEmptyAttributes = omitEmptyAttributes;
    }

    protected IndentPrinter getPrinter() {
        return this.out;
    }

    @Override
    protected void setParent(Object parent, Object child) {
    }

    public Object getMkp() {
        return new MarkupBuilderHelper(this);
    }

    public void yield(String value) {
        this.yield(value, true);
    }

    public void yieldUnescaped(String value) {
        this.yield(value, false);
    }

    void pi(Map<String, Map<String, Object>> args) {
        Iterator<Map.Entry<String, Map<String, Object>>> iterator = args.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, Map<String, Object>> mapEntry = iterator.next();
            this.createNode((Object)new StringBuffer().append("?").append(mapEntry.getKey()).toString(), mapEntry.getValue());
            this.state = 2;
            this.out.println("?>");
        }
    }

    void yield(String value, boolean escaping) {
        if (this.state == 1) {
            this.state = 2;
            this.nodeIsEmpty = false;
            this.out.print(">");
        }
        if (this.state == 2 || this.state == 3) {
            this.out.print(escaping ? this.escapeElementContent(value) : value);
        }
    }

    @Override
    protected Object createNode(Object name) {
        Object theName = this.getName(name);
        this.toState(1, theName);
        this.nodeIsEmpty = true;
        return theName;
    }

    @Override
    protected Object createNode(Object name, Object value) {
        Object theName = this.getName(name);
        if (value == null) {
            return this.createNode(theName);
        }
        this.toState(2, theName);
        this.nodeIsEmpty = false;
        this.out.print(">");
        this.out.print(this.escapeElementContent(value.toString()));
        return theName;
    }

    @Override
    protected Object createNode(Object name, Map attributes, Object value) {
        Object theName = this.getName(name);
        this.toState(1, theName);
        for (Map.Entry entry : attributes.entrySet()) {
            boolean skipEmpty;
            Object attributeValue = entry.getValue();
            boolean skipNull = attributeValue == null && this.omitNullAttributes;
            boolean bl = skipEmpty = attributeValue != null && this.omitEmptyAttributes && attributeValue.toString().length() == 0;
            if (skipNull || skipEmpty) continue;
            this.out.print(" ");
            this.print(entry.getKey().toString());
            this.out.print(this.useDoubleQuotes ? "=\"" : "='");
            this.print(attributeValue == null ? "" : this.escapeAttributeValue(attributeValue.toString()));
            this.out.print(this.useDoubleQuotes ? "\"" : "'");
        }
        if (value != null) {
            this.yield(value.toString(), true);
        } else {
            this.nodeIsEmpty = true;
        }
        return theName;
    }

    @Override
    protected Object createNode(Object name, Map attributes) {
        return this.createNode(name, attributes, null);
    }

    @Override
    protected void nodeCompleted(Object parent, Object node) {
        this.toState(3, node);
        this.out.flush();
    }

    protected void print(Object node) {
        this.out.print(node == null ? "null" : node.toString());
    }

    @Override
    protected Object getName(String methodName) {
        return super.getName(methodName);
    }

    protected String transformValue(String value) {
        if (value.matches(".*&.*")) {
            value = value.replaceAll("&", "&amp;");
        }
        if (value.matches(".*\\'.*")) {
            value = value.replaceAll("\\'", "&apos;");
        }
        if (value.matches(".*<.*")) {
            value = value.replaceAll("<", "&lt;");
        }
        if (value.matches(".*>.*")) {
            value = value.replaceAll(">", "&gt;");
        }
        return value;
    }

    private String escapeAttributeValue(String value) {
        return this.escapeXmlValue(value, true);
    }

    private String escapeElementContent(String value) {
        return this.escapeXmlValue(value, false);
    }

    private String escapeXmlValue(String value, boolean isAttrValue) {
        StringBuffer buffer = new StringBuffer(value);
        int n = buffer.length();
        block7: for (int i = 0; i < n; ++i) {
            switch (buffer.charAt(i)) {
                case '&': {
                    buffer.replace(i, i + 1, "&amp;");
                    i += 4;
                    n += 4;
                    continue block7;
                }
                case '<': {
                    buffer.replace(i, i + 1, "&lt;");
                    i += 3;
                    n += 3;
                    continue block7;
                }
                case '>': {
                    buffer.replace(i, i + 1, "&gt;");
                    i += 3;
                    n += 3;
                    continue block7;
                }
                case '\"': {
                    if (!isAttrValue || !this.useDoubleQuotes) continue block7;
                    buffer.replace(i, i + 1, "&quot;");
                    i += 5;
                    n += 5;
                    continue block7;
                }
                case '\'': {
                    if (!isAttrValue || this.useDoubleQuotes) continue block7;
                    buffer.replace(i, i + 1, "&apos;");
                    i += 5;
                    n += 5;
                    continue block7;
                }
            }
        }
        return buffer.toString();
    }

    private void toState(int next, Object name) {
        block0 : switch (this.state) {
            case 0: {
                switch (next) {
                    case 1: 
                    case 2: {
                        this.out.print("<");
                        this.print(name);
                        break block0;
                    }
                    case 3: {
                        throw new Error();
                    }
                }
                break;
            }
            case 1: {
                switch (next) {
                    case 1: 
                    case 2: {
                        this.out.print(">");
                        if (this.nospace) {
                            this.nospace = false;
                        } else {
                            this.out.println();
                            this.out.incrementIndent();
                            this.out.printIndent();
                        }
                        this.out.print("<");
                        this.print(name);
                        break;
                    }
                    case 3: {
                        if (!this.nodeIsEmpty) break;
                        this.out.print(" />");
                    }
                }
                break;
            }
            case 2: {
                switch (next) {
                    case 1: 
                    case 2: {
                        if (!this.nodeIsEmpty) {
                            this.out.println();
                            this.out.incrementIndent();
                            this.out.printIndent();
                        }
                        this.out.print("<");
                        this.print(name);
                        break;
                    }
                    case 3: {
                        this.out.print("</");
                        this.print(name);
                        this.out.print(">");
                    }
                }
                break;
            }
            case 3: {
                switch (next) {
                    case 1: 
                    case 2: {
                        if (this.nospace) {
                            this.nospace = false;
                        } else {
                            this.out.println();
                            this.out.printIndent();
                        }
                        this.out.print("<");
                        this.print(name);
                        break block0;
                    }
                    case 3: {
                        if (this.nospace) {
                            this.nospace = false;
                        } else {
                            this.out.println();
                            this.out.decrementIndent();
                            this.out.printIndent();
                        }
                        this.out.print("</");
                        this.print(name);
                        this.out.print(">");
                    }
                }
            }
        }
        this.state = next;
    }

    private Object getName(Object name) {
        if (name instanceof QName) {
            return ((QName)name).getQualifiedName();
        }
        return name;
    }
}

