/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;

public abstract class ClassCodeExpressionTransformer
extends ClassCodeVisitorSupport
implements ExpressionTransformer {
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        Parameter[] paras = node.getParameters();
        for (int i = 0; i < paras.length; ++i) {
            Parameter p = paras[i];
            if (!p.hasInitialExpression()) continue;
            Expression init = p.getInitialExpression();
            p.setInitialExpression(this.transform(init));
        }
        super.visitConstructorOrMethod(node, isConstructor);
    }

    public void visitSwitch(SwitchStatement statement) {
        Expression exp = statement.getExpression();
        statement.setExpression(this.transform(exp));
        List list = statement.getCaseStatements();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            CaseStatement caseStatement = (CaseStatement)iter.next();
            caseStatement.visit(this);
        }
        statement.getDefaultStatement().visit(this);
    }

    public void visitField(FieldNode node) {
        this.visitAnnotations(node);
        Expression init = node.getInitialExpression();
        node.setInitialValueExpression(this.transform(init));
    }

    public void visitProperty(PropertyNode node) {
        this.visitAnnotations(node);
        Statement statement = node.getGetterBlock();
        this.visitClassCodeContainer(statement);
        statement = node.getSetterBlock();
        this.visitClassCodeContainer(statement);
    }

    public void visitIfElse(IfStatement ifElse) {
        ifElse.setBooleanExpression((BooleanExpression)this.transform(ifElse.getBooleanExpression()));
        ifElse.getIfBlock().visit(this);
        ifElse.getElseBlock().visit(this);
    }

    public Expression transform(Expression exp) {
        if (exp == null) {
            return null;
        }
        return exp.transformExpression(this);
    }

    public void visitAnnotations(AnnotatedNode node) {
        List annotions = node.getAnnotations();
        if (annotions.isEmpty()) {
            return;
        }
        Iterator it = annotions.iterator();
        while (it.hasNext()) {
            AnnotationNode an = (AnnotationNode)it.next();
            if (an.isBuiltIn()) continue;
            Iterator iter = an.getMembers().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry member = iter.next();
                Expression memberValue = (Expression)member.getValue();
                member.setValue(this.transform(memberValue));
            }
        }
    }

    public void visitReturnStatement(ReturnStatement statement) {
        statement.setExpression(this.transform(statement.getExpression()));
    }

    public void visitAssertStatement(AssertStatement as) {
        as.setBooleanExpression((BooleanExpression)this.transform(as.getBooleanExpression()));
        as.setMessageExpression(this.transform(as.getMessageExpression()));
    }

    public void visitCaseStatement(CaseStatement statement) {
        statement.setExpression(this.transform(statement.getExpression()));
        statement.getCode().visit(this);
    }

    public void visitDoWhileLoop(DoWhileStatement loop) {
        loop.setBooleanExpression((BooleanExpression)this.transform(loop.getBooleanExpression()));
        super.visitDoWhileLoop(loop);
    }

    public void visitForLoop(ForStatement forLoop) {
        forLoop.setCollectionExpression(this.transform(forLoop.getCollectionExpression()));
        super.visitForLoop(forLoop);
    }

    public void visitSynchronizedStatement(SynchronizedStatement sync) {
        sync.setExpression(this.transform(sync.getExpression()));
        super.visitSynchronizedStatement(sync);
    }

    public void visitThrowStatement(ThrowStatement ts) {
        ts.setExpression(this.transform(ts.getExpression()));
    }

    public void visitWhileLoop(WhileStatement loop) {
        loop.setBooleanExpression((BooleanExpression)this.transform(loop.getBooleanExpression()));
        super.visitWhileLoop(loop);
    }

    public void visitExpressionStatement(ExpressionStatement es) {
        es.setExpression(this.transform(es.getExpression()));
    }
}

