/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import java.lang.ref.SoftReference;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.objectweb.asm.Opcodes;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class LazyASTTransformation
implements ASTTransformation,
Opcodes {
    static final ClassNode SOFT_REF;
    static /* synthetic */ Class class$java$lang$ref$SoftReference;

    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (!(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (parent instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)parent;
            Expression member = node.getMember("soft");
            Expression init = this.getInitExpr(fieldNode);
            fieldNode.rename("$" + fieldNode.getName());
            fieldNode.setModifiers(2 | fieldNode.getModifiers() & 0xFFFFFFFA);
            if (member instanceof ConstantExpression && ((ConstantExpression)member).getValue().equals(true)) {
                this.createSoft(fieldNode, init);
            } else {
                this.create(fieldNode, init);
            }
        }
    }

    private void create(FieldNode fieldNode, Expression initExpr) {
        BlockStatement body = new BlockStatement();
        FieldExpression fieldExpr = new FieldExpression(fieldNode);
        if ((fieldNode.getModifiers() & 0x40) == 0) {
            body.addStatement(new IfStatement(new BooleanExpression(new BinaryExpression(fieldExpr, Token.newSymbol("!=", -1, -1), ConstantExpression.NULL)), new ExpressionStatement(fieldExpr), new ExpressionStatement(new BinaryExpression(fieldExpr, Token.newSymbol("=", -1, -1), initExpr))));
        } else {
            body.addStatement(new IfStatement(new BooleanExpression(new BinaryExpression(fieldExpr, Token.newSymbol("!=", -1, -1), ConstantExpression.NULL)), new ReturnStatement(fieldExpr), new SynchronizedStatement(VariableExpression.THIS_EXPRESSION, new IfStatement(new BooleanExpression(new BinaryExpression(fieldExpr, Token.newSymbol("!=", -1, -1), ConstantExpression.NULL)), new ReturnStatement(fieldExpr), new ReturnStatement(new BinaryExpression(fieldExpr, Token.newSymbol("=", -1, -1), initExpr))))));
        }
        String name = "get" + MetaClassHelper.capitalize(fieldNode.getName().substring(1));
        fieldNode.getDeclaringClass().addMethod(name, 1, fieldNode.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body);
    }

    private void createSoft(FieldNode fieldNode, Expression initExpr) {
        ClassNode type = fieldNode.getType();
        fieldNode.setType(SOFT_REF);
        this.createSoftGetter(fieldNode, initExpr, type);
        this.createSoftSetter(fieldNode, type);
    }

    private void createSoftGetter(FieldNode fieldNode, Expression initExpr, ClassNode type) {
        BlockStatement body = new BlockStatement();
        FieldExpression fieldExpr = new FieldExpression(fieldNode);
        VariableExpression resExpr = new VariableExpression("res", type);
        MethodCallExpression callExpression = new MethodCallExpression((Expression)new FieldExpression(fieldNode), "get", (Expression)new ArgumentListExpression());
        callExpression.setSafe(true);
        body.addStatement(new ExpressionStatement(new DeclarationExpression(resExpr, Token.newSymbol("=", -1, -1), (Expression)callExpression)));
        BlockStatement elseBlock = new BlockStatement();
        elseBlock.addStatement(new ExpressionStatement(new BinaryExpression(resExpr, Token.newSymbol("=", -1, -1), initExpr)));
        elseBlock.addStatement(new ExpressionStatement(new BinaryExpression(fieldExpr, Token.newSymbol("=", -1, -1), new ConstructorCallExpression(SOFT_REF, resExpr))));
        elseBlock.addStatement(new ExpressionStatement(resExpr));
        IfStatement mainIf = new IfStatement(new BooleanExpression(new BinaryExpression(resExpr, Token.newSymbol("!=", -1, -1), ConstantExpression.NULL)), new ExpressionStatement(resExpr), elseBlock);
        if ((fieldNode.getModifiers() & 0x40) == 0) {
            body.addStatement(mainIf);
        } else {
            body.addStatement(new IfStatement(new BooleanExpression(new BinaryExpression(resExpr, Token.newSymbol("!=", -1, -1), ConstantExpression.NULL)), new ExpressionStatement(resExpr), new SynchronizedStatement(VariableExpression.THIS_EXPRESSION, mainIf)));
        }
        String name = "get" + MetaClassHelper.capitalize(fieldNode.getName().substring(1));
        fieldNode.getDeclaringClass().addMethod(name, 1, type, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body);
    }

    private void createSoftSetter(FieldNode fieldNode, ClassNode type) {
        BlockStatement body = new BlockStatement();
        FieldExpression fieldExpr = new FieldExpression(fieldNode);
        String name = "set" + MetaClassHelper.capitalize(fieldNode.getName().substring(1));
        Parameter parameter = new Parameter(type, "value");
        VariableExpression paramExpr = new VariableExpression(parameter);
        body.addStatement(new IfStatement(new BooleanExpression(new BinaryExpression(paramExpr, Token.newSymbol("!=", -1, -1), ConstantExpression.NULL)), new ExpressionStatement(new BinaryExpression(fieldExpr, Token.newSymbol("=", -1, -1), new ConstructorCallExpression(SOFT_REF, paramExpr))), new ExpressionStatement(new BinaryExpression(fieldExpr, Token.newSymbol("=", -1, -1), ConstantExpression.NULL))));
        fieldNode.getDeclaringClass().addMethod(name, 1, ClassHelper.VOID_TYPE, new Parameter[]{parameter}, ClassNode.EMPTY_ARRAY, body);
    }

    private Expression getInitExpr(FieldNode fieldNode) {
        Expression initExpr = fieldNode.getInitialValueExpression();
        fieldNode.setInitialValueExpression(null);
        if (initExpr == null) {
            initExpr = new ConstructorCallExpression(fieldNode.getType(), new ArgumentListExpression());
        }
        return initExpr;
    }

    static {
        Class<?> clazz = class$java$lang$ref$SoftReference;
        if (clazz == null) {
            clazz = class$java$lang$ref$SoftReference = new SoftReference[0].getClass().getComponentType();
        }
        SOFT_REF = ClassHelper.make(clazz);
    }
}

