/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.GroovyObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.retrotranslator.runtime.java.lang._Class;
import net.sf.retrotranslator.runtime.java.util.EnumMap_;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.vmplugin.VMPluginFactory;
import org.objectweb.asm.Opcodes;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNode
extends AnnotatedNode
implements Opcodes {
    public static ClassNode[] EMPTY_ARRAY = new ClassNode[0];
    public static ClassNode THIS;
    public static ClassNode SUPER;
    private String name;
    private final int modifiers;
    private ClassNode[] interfaces;
    private MixinNode[] mixins;
    private List constructors = new ArrayList();
    private List objectInitializers = new ArrayList();
    private MapOfLists methods;
    private List<MethodNode> methodsList;
    private LinkedList<FieldNode> fields = new LinkedList();
    private List properties = new ArrayList();
    private Map fieldIndex = new HashMap();
    private ModuleNode module;
    private CompileUnit compileUnit;
    private boolean staticClass = false;
    private boolean scriptBody = false;
    private boolean script;
    private ClassNode superClass;
    protected boolean isPrimaryNode;
    private Map<CompilePhase, Map<Class<? extends ASTTransformation>, Set<ASTNode>>> transformInstances;
    protected Object lazyInitLock = new Object();
    protected Class clazz;
    private boolean lazyInitDone = true;
    private ClassNode componentType = null;
    private ClassNode redirect = null;
    private boolean annotated;
    private GenericsType[] genericsTypes = null;
    private boolean usesGenerics = false;
    private boolean placeholder;
    private MethodNode enclosingMethod = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$groovy$lang$GroovyObject;
    static /* synthetic */ Class class$org$codehaus$groovy$control$CompilePhase;
    static /* synthetic */ Class class$org$codehaus$groovy$transform$GroovyASTTransformation;

    public ClassNode redirect() {
        if (this.redirect == null) {
            return this;
        }
        return this.redirect.redirect();
    }

    public void setRedirect(ClassNode cn) {
        if (this.isPrimaryNode) {
            throw new GroovyBugError(new StringBuffer().append("tried to set a redirect for a primary ClassNode (").append(this.getName()).append("->").append(cn.getName()).append(").").toString());
        }
        if (cn != null) {
            cn = cn.redirect();
        }
        if (cn == this) {
            return;
        }
        this.redirect = cn;
    }

    public ClassNode makeArray() {
        ClassNode cn;
        if (this.redirect != null) {
            return this.redirect().makeArray();
        }
        if (this.clazz != null) {
            Class<?> ret = Array.newInstance(this.clazz, 0).getClass();
            cn = new ClassNode(ret, this);
        } else {
            cn = new ClassNode(this);
        }
        return cn;
    }

    public boolean isPrimaryClassNode() {
        return this.redirect().isPrimaryNode || this.componentType != null && this.componentType.isPrimaryClassNode();
    }

    private ClassNode(ClassNode componentType) {
        this(new StringBuffer().append(componentType.getName()).append("[]").toString(), 1, ClassHelper.OBJECT_TYPE);
        this.componentType = componentType.redirect();
        this.isPrimaryNode = false;
    }

    private ClassNode(Class c, ClassNode componentType) {
        this(c);
        this.componentType = componentType;
        this.isPrimaryNode = false;
    }

    public ClassNode(Class c) {
        this(c.getName(), c.getModifiers(), null, null, MixinNode.EMPTY_ARRAY);
        this.clazz = c;
        this.lazyInitDone = false;
        CompileUnit cu = this.getCompileUnit();
        if (cu != null) {
            cu.addClass(this);
        }
        this.isPrimaryNode = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyClassInit() {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.redirect != null) {
                throw new GroovyBugError("lazyClassInit called on a proxy ClassNode, that must not happen.A redirect() call is missing somewhere!");
            }
            if (this.lazyInitDone) {
                return;
            }
            VMPluginFactory.getPlugin().configureClassNode(this.compileUnit, this);
            this.lazyInitDone = true;
        }
    }

    public MethodNode getEnclosingMethod() {
        return this.redirect().enclosingMethod;
    }

    public void setEnclosingMethod(MethodNode enclosingMethod) {
        this.redirect().enclosingMethod = enclosingMethod;
    }

    public ClassNode(String name, int modifiers, ClassNode superClass) {
        this(name, modifiers, superClass, EMPTY_ARRAY, MixinNode.EMPTY_ARRAY);
    }

    public ClassNode(String name, int modifiers, ClassNode superClass, ClassNode[] interfaces, MixinNode[] mixins) {
        Class<?> clazz;
        this.name = name;
        this.modifiers = modifiers;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.mixins = mixins;
        this.isPrimaryNode = true;
        if (superClass != null) {
            this.usesGenerics = superClass.isUsingGenerics();
        }
        if (!this.usesGenerics && interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                this.usesGenerics = this.usesGenerics || interfaces[i].isUsingGenerics();
            }
        }
        this.methods = new MapOfLists();
        this.methodsList = new ArrayList<MethodNode>();
        if ((modifiers & 0x200) == 0) {
            this.addField("$ownClass", 4121, ClassHelper.CLASS_Type, new ClassExpression(this)).setSynthetic(true);
        }
        if ((clazz = class$org$codehaus$groovy$control$CompilePhase) == null) {
            clazz = class$org$codehaus$groovy$control$CompilePhase = new CompilePhase[0].getClass().getComponentType();
        }
        this.transformInstances = new EnumMap_((Class)clazz);
        for (CompilePhase phase : CompilePhase.values()) {
            this.transformInstances.put(phase, new HashMap());
        }
    }

    public void setSuperClass(ClassNode superClass) {
        this.redirect().superClass = superClass;
    }

    public List<FieldNode> getFields() {
        if (!this.redirect().lazyInitDone) {
            this.redirect().lazyClassInit();
        }
        if (this.redirect != null) {
            return this.redirect().getFields();
        }
        return this.fields;
    }

    public ClassNode[] getInterfaces() {
        if (!this.redirect().lazyInitDone) {
            this.redirect().lazyClassInit();
        }
        if (this.redirect != null) {
            return this.redirect().getInterfaces();
        }
        return this.interfaces;
    }

    public void setInterfaces(ClassNode[] interfaces) {
        if (this.redirect != null) {
            this.redirect().setInterfaces(interfaces);
        } else {
            this.interfaces = interfaces;
        }
    }

    public MixinNode[] getMixins() {
        return this.redirect().mixins;
    }

    public List<MethodNode> getMethods() {
        if (!this.redirect().lazyInitDone) {
            this.redirect().lazyClassInit();
        }
        if (this.redirect != null) {
            return this.redirect().getMethods();
        }
        return this.methodsList;
    }

    public List getAbstractMethods() {
        ArrayList<MethodNode> result = new ArrayList<MethodNode>(3);
        Map declaredMethods = this.getDeclaredMethodsMap();
        for (MethodNode method : declaredMethods.values()) {
            if (!method.isAbstract()) continue;
            result.add(method);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List getAllDeclaredMethods() {
        return new ArrayList(this.getDeclaredMethodsMap().values());
    }

    public Set getAllInterfaces() {
        HashSet res = new HashSet();
        this.getAllInterfaces(res);
        return res;
    }

    private void getAllInterfaces(Set res) {
        if (this.isInterface()) {
            res.add(this);
        }
        ClassNode[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            res.add(interfaces[i]);
            interfaces[i].getAllInterfaces(res);
        }
    }

    public Map getDeclaredMethodsMap() {
        ClassNode parent = this.getSuperClass();
        HashMap<String, MethodNode> result = null;
        result = parent != null ? parent.getDeclaredMethodsMap() : new HashMap<String, MethodNode>();
        ClassNode[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ClassNode iface = interfaces[i];
            Map ifaceMethodsMap = iface.getDeclaredMethodsMap();
            for (Object o : ifaceMethodsMap.keySet()) {
                String methSig = (String)o;
                if (result.containsKey(methSig)) continue;
                MethodNode methNode = (MethodNode)ifaceMethodsMap.get(methSig);
                result.put(methSig, methNode);
            }
        }
        Iterator<MethodNode> i$ = this.getMethods().iterator();
        while (i$.hasNext()) {
            MethodNode o;
            MethodNode method = o = i$.next();
            String sig = method.getTypeDescriptor();
            result.put(sig, method);
        }
        return result;
    }

    public String getName() {
        return this.redirect().name;
    }

    public String setName(String name) {
        this.redirect().name = name;
        return this.redirect().name;
    }

    public int getModifiers() {
        return this.redirect().modifiers;
    }

    public List getProperties() {
        return this.redirect().properties;
    }

    public List getDeclaredConstructors() {
        if (!this.redirect().lazyInitDone) {
            this.redirect().lazyClassInit();
        }
        return this.redirect().constructors;
    }

    public ModuleNode getModule() {
        return this.redirect().module;
    }

    public void setModule(ModuleNode module) {
        this.redirect().module = module;
        if (module != null) {
            this.redirect().compileUnit = module.getUnit();
        }
    }

    public void addField(FieldNode node) {
        node.setDeclaringClass(this.redirect());
        node.setOwner(this.redirect());
        this.redirect().fields.add(node);
        this.redirect().fieldIndex.put(node.getName(), node);
    }

    public void addProperty(PropertyNode node) {
        node.setDeclaringClass(this.redirect());
        FieldNode field = node.getField();
        this.addField(field);
        this.redirect().properties.add(node);
    }

    public PropertyNode addProperty(String name, int modifiers, ClassNode type, Expression initialValueExpression, Statement getterBlock, Statement setterBlock) {
        for (Object o : this.getProperties()) {
            PropertyNode pn = (PropertyNode)o;
            if (!pn.getName().equals(name)) continue;
            if (pn.getInitialExpression() == null && initialValueExpression != null) {
                pn.getField().setInitialValueExpression(initialValueExpression);
            }
            if (pn.getGetterBlock() == null && getterBlock != null) {
                pn.setGetterBlock(getterBlock);
            }
            if (pn.getSetterBlock() == null && setterBlock != null) {
                pn.setSetterBlock(setterBlock);
            }
            return pn;
        }
        PropertyNode node = new PropertyNode(name, modifiers, type, this.redirect(), initialValueExpression, getterBlock, setterBlock);
        this.addProperty(node);
        return node;
    }

    public boolean hasProperty(String name) {
        return this.getProperty(name) != null;
    }

    public PropertyNode getProperty(String name) {
        for (Object o : this.getProperties()) {
            PropertyNode pn = (PropertyNode)o;
            if (!pn.getName().equals(name)) continue;
            return pn;
        }
        return null;
    }

    public void addConstructor(ConstructorNode node) {
        node.setDeclaringClass(this);
        this.redirect().constructors.add(node);
    }

    public ConstructorNode addConstructor(int modifiers, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        ConstructorNode node = new ConstructorNode(modifiers, parameters, exceptions, code);
        this.addConstructor(node);
        return node;
    }

    public void addMethod(MethodNode node) {
        node.setDeclaringClass(this);
        this.redirect().methodsList.add(node);
        this.redirect().methods.put(node.getName(), node);
    }

    public MethodNode addMethod(String name, int modifiers, ClassNode returnType, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        MethodNode other = this.getDeclaredMethod(name, parameters);
        if (other != null) {
            return other;
        }
        MethodNode node = new MethodNode(name, modifiers, returnType, parameters, exceptions, code);
        this.addMethod(node);
        return node;
    }

    public boolean hasDeclaredMethod(String name, Parameter[] parameters) {
        MethodNode other = this.getDeclaredMethod(name, parameters);
        return other != null;
    }

    public boolean hasMethod(String name, Parameter[] parameters) {
        MethodNode other = this.getMethod(name, parameters);
        return other != null;
    }

    public MethodNode addSyntheticMethod(String name, int modifiers, ClassNode returnType, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        MethodNode answer = this.addMethod(name, modifiers | 0x1000, returnType, parameters, exceptions, code);
        answer.setSynthetic(true);
        return answer;
    }

    public FieldNode addField(String name, int modifiers, ClassNode type, Expression initialValue) {
        FieldNode node = new FieldNode(name, modifiers, type, this.redirect(), initialValue);
        this.addField(node);
        return node;
    }

    public void addInterface(ClassNode type) {
        boolean skip = false;
        ClassNode[] interfaces = this.redirect().interfaces;
        for (int i = 0; i < interfaces.length; ++i) {
            if (!type.equals(interfaces[i])) continue;
            skip = true;
        }
        if (!skip) {
            ClassNode[] newInterfaces = new ClassNode[interfaces.length + 1];
            System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
            newInterfaces[interfaces.length] = type;
            this.redirect().interfaces = newInterfaces;
        }
    }

    public boolean equals(Object o) {
        if (this.redirect != null) {
            return this.redirect().equals(o);
        }
        ClassNode cn = (ClassNode)o;
        return cn.getName().equals(this.getName());
    }

    public int hashCode() {
        if (this.redirect != null) {
            return this.redirect().hashCode();
        }
        return this.getName().hashCode();
    }

    public void addMixin(MixinNode mixin) {
        MixinNode[] mixins = this.redirect().mixins;
        boolean skip = false;
        for (int i = 0; i < mixins.length; ++i) {
            if (!mixin.equals(mixins[i])) continue;
            skip = true;
        }
        if (!skip) {
            MixinNode[] newMixins = new MixinNode[mixins.length + 1];
            System.arraycopy(mixins, 0, newMixins, 0, mixins.length);
            newMixins[mixins.length] = mixin;
            this.redirect().mixins = newMixins;
        }
    }

    public FieldNode getDeclaredField(String name) {
        return (FieldNode)this.redirect().fieldIndex.get(name);
    }

    public FieldNode getField(String name) {
        for (ClassNode node = this; node != null; node = node.getSuperClass()) {
            FieldNode fn = node.getDeclaredField(name);
            if (fn == null) continue;
            return fn;
        }
        return null;
    }

    public FieldNode getOuterField(String name) {
        return null;
    }

    public ClassNode getOuterClass() {
        return null;
    }

    public void addObjectInitializerStatements(Statement statements) {
        this.objectInitializers.add(statements);
    }

    public List getObjectInitializerStatements() {
        return this.objectInitializers;
    }

    public void addStaticInitializerStatements(List staticStatements, boolean fieldInit) {
        MethodNode method = null;
        List declaredMethods = this.getDeclaredMethods("<clinit>");
        if (declaredMethods.isEmpty()) {
            method = this.addMethod("<clinit>", 8, ClassHelper.VOID_TYPE, Parameter.EMPTY_ARRAY, EMPTY_ARRAY, new BlockStatement());
            method.setSynthetic(true);
        } else {
            method = (MethodNode)declaredMethods.get(0);
        }
        BlockStatement block = null;
        Statement statement = method.getCode();
        if (statement == null) {
            block = new BlockStatement();
        } else if (statement instanceof BlockStatement) {
            block = (BlockStatement)statement;
        } else {
            block = new BlockStatement();
            block.addStatement(statement);
        }
        if (!fieldInit) {
            block.addStatements(staticStatements);
        } else {
            List blockStatements = block.getStatements();
            staticStatements.addAll(blockStatements);
            blockStatements.clear();
            blockStatements.addAll(staticStatements);
        }
    }

    public List getDeclaredMethods(String name) {
        if (!this.redirect().lazyInitDone) {
            this.redirect().lazyClassInit();
        }
        if (this.redirect != null) {
            return this.redirect().getDeclaredMethods(name);
        }
        return this.methods.getNotNull(name);
    }

    public List getMethods(String name) {
        ArrayList answer = new ArrayList();
        for (ClassNode node = this; node != null; node = node.getSuperClass()) {
            answer.addAll(node.getDeclaredMethods(name));
        }
        return answer;
    }

    public MethodNode getDeclaredMethod(String name, Parameter[] parameters) {
        for (Object o : this.getDeclaredMethods(name)) {
            MethodNode method = (MethodNode)o;
            if (!this.parametersEqual(method.getParameters(), parameters)) continue;
            return method;
        }
        return null;
    }

    public MethodNode getMethod(String name, Parameter[] parameters) {
        for (Object o : this.getMethods(name)) {
            MethodNode method = (MethodNode)o;
            if (!this.parametersEqual(method.getParameters(), parameters)) continue;
            return method;
        }
        return null;
    }

    public boolean isDerivedFrom(ClassNode type) {
        if (type.equals(ClassHelper.OBJECT_TYPE)) {
            return true;
        }
        for (ClassNode node = this; node != null; node = node.getSuperClass()) {
            if (!type.equals(node)) continue;
            return true;
        }
        return false;
    }

    public boolean isDerivedFromGroovyObject() {
        Class<?> clazz = class$groovy$lang$GroovyObject;
        if (clazz == null) {
            clazz = class$groovy$lang$GroovyObject = new GroovyObject[0].getClass().getComponentType();
        }
        return this.implementsInterface(ClassHelper.make(clazz));
    }

    public boolean implementsInterface(ClassNode classNode) {
        ClassNode node = this.redirect();
        do {
            if (!node.declaresInterface(classNode)) continue;
            return true;
        } while ((node = node.getSuperClass()) != null);
        return false;
    }

    public boolean declaresInterface(ClassNode classNode) {
        ClassNode[] interfaces = this.redirect().getInterfaces();
        if (this.declaresInterfaceDirect(interfaces, classNode)) {
            return true;
        }
        List<ClassNode> superInterfaces = Arrays.asList(interfaces);
        while (superInterfaces.size() > 0) {
            ArrayList<ClassNode> keep = new ArrayList<ClassNode>();
            for (int i = 0; i < superInterfaces.size(); ++i) {
                ClassNode cn = superInterfaces.get(i);
                if (cn.declaresInterface(classNode)) {
                    return true;
                }
                keep.addAll(Arrays.asList(cn.getInterfaces()));
            }
            superInterfaces = keep;
        }
        return false;
    }

    private boolean declaresInterfaceDirect(ClassNode[] interfaces, ClassNode classNode) {
        int size = interfaces.length;
        for (int i = 0; i < size; ++i) {
            if (!interfaces[i].equals(classNode)) continue;
            return true;
        }
        return false;
    }

    public ClassNode getSuperClass() {
        if (!this.lazyInitDone && !this.isResolved()) {
            throw new GroovyBugError(new StringBuffer().append("ClassNode#getSuperClass for ").append(this.getName()).append(" called before class resolving").toString());
        }
        ClassNode sn = this.redirect().getUnresolvedSuperClass();
        if (sn != null) {
            sn = sn.redirect();
        }
        return sn;
    }

    public ClassNode getUnresolvedSuperClass() {
        return this.getUnresolvedSuperClass(true);
    }

    public ClassNode getUnresolvedSuperClass(boolean useRedirect) {
        if (!useRedirect) {
            return this.superClass;
        }
        if (!this.redirect().lazyInitDone) {
            this.redirect().lazyClassInit();
        }
        return this.redirect().superClass;
    }

    public void setUnresolvedSuperClass(ClassNode sn) {
        this.superClass = sn;
    }

    public CompileUnit getCompileUnit() {
        if (this.redirect != null) {
            return this.redirect().getCompileUnit();
        }
        if (this.compileUnit == null && this.module != null) {
            this.compileUnit = this.module.getUnit();
        }
        return this.compileUnit;
    }

    protected void setCompileUnit(CompileUnit cu) {
        if (this.redirect != null) {
            this.redirect().setCompileUnit(cu);
        }
        if (this.compileUnit != null) {
            this.compileUnit = cu;
        }
    }

    protected boolean parametersEqual(Parameter[] a, Parameter[] b) {
        if (a.length == b.length) {
            boolean answer = true;
            for (int i = 0; i < a.length; ++i) {
                if (a[i].getType().equals(b[i].getType())) continue;
                answer = false;
                break;
            }
            return answer;
        }
        return false;
    }

    public String getPackageName() {
        int idx = this.getName().lastIndexOf(46);
        if (idx > 0) {
            return this.getName().substring(0, idx);
        }
        return null;
    }

    public String getNameWithoutPackage() {
        int idx = this.getName().lastIndexOf(46);
        if (idx > 0) {
            return this.getName().substring(idx + 1);
        }
        return this.getName();
    }

    public void visitContents(GroovyClassVisitor visitor) {
        for (Object e : this.getProperties()) {
            PropertyNode pn = (PropertyNode)e;
            visitor.visitProperty(pn);
        }
        Iterator<Object> i$ = this.getFields().iterator();
        while (i$.hasNext()) {
            FieldNode fieldNode;
            FieldNode fn = fieldNode = (FieldNode)i$.next();
            visitor.visitField(fn);
        }
        for (Object object : this.getDeclaredConstructors()) {
            ConstructorNode cn = (ConstructorNode)object;
            visitor.visitConstructor(cn);
        }
        i$ = this.getMethods().iterator();
        while (i$.hasNext()) {
            MethodNode methodNode;
            MethodNode mn = methodNode = (MethodNode)i$.next();
            visitor.visitMethod(mn);
        }
    }

    public MethodNode getGetterMethod(String getterName) {
        for (Object o : this.getDeclaredMethods(getterName)) {
            MethodNode method = (MethodNode)o;
            if (!getterName.equals(method.getName()) || ClassHelper.VOID_TYPE == method.getReturnType() || method.getParameters().length != 0) continue;
            return method;
        }
        ClassNode parent = this.getSuperClass();
        if (parent != null) {
            return parent.getGetterMethod(getterName);
        }
        return null;
    }

    public MethodNode getSetterMethod(String setterName) {
        for (Object o : this.getDeclaredMethods(setterName)) {
            MethodNode method = (MethodNode)o;
            if (!setterName.equals(method.getName()) || ClassHelper.VOID_TYPE != method.getReturnType() || method.getParameters().length != 1) continue;
            return method;
        }
        ClassNode parent = this.getSuperClass();
        if (parent != null) {
            return parent.getSetterMethod(setterName);
        }
        return null;
    }

    public boolean isStaticClass() {
        return this.redirect().staticClass;
    }

    public void setStaticClass(boolean staticClass) {
        this.redirect().staticClass = staticClass;
    }

    public boolean isScriptBody() {
        return this.redirect().scriptBody;
    }

    public void setScriptBody(boolean scriptBody) {
        this.redirect().scriptBody = scriptBody;
    }

    public boolean isScript() {
        return this.redirect().script || this.isDerivedFrom(ClassHelper.SCRIPT_TYPE);
    }

    public void setScript(boolean script) {
        this.redirect().script = script;
    }

    public String toString() {
        String ret = this.getName();
        if (this.genericsTypes != null) {
            ret = new StringBuffer().append(ret).append(" <").toString();
            for (int i = 0; i < this.genericsTypes.length; ++i) {
                if (i != 0) {
                    ret = new StringBuffer().append(ret).append(", ").toString();
                }
                ret = new StringBuffer().append(ret).append(this.genericsTypes[i]).toString();
            }
            ret = new StringBuffer().append(ret).append(">").toString();
        }
        if (this.redirect != null) {
            ret = new StringBuffer().append(ret).append(" -> ").append(this.redirect().toString()).toString();
        }
        return ret;
    }

    public boolean hasPossibleMethod(String name, Expression arguments) {
        int count = 0;
        if (arguments instanceof TupleExpression) {
            TupleExpression tuple = (TupleExpression)arguments;
            count = tuple.getExpressions().size();
        }
        ClassNode node = this;
        do {
            for (Object o : this.getMethods(name)) {
                MethodNode method = (MethodNode)o;
                if (method.getParameters().length != count) continue;
                return true;
            }
        } while ((node = node.getSuperClass()) != null);
        return false;
    }

    public MethodNode tryFindPossibleMethod(String name, Expression arguments) {
        int count = 0;
        if (!(arguments instanceof TupleExpression)) {
            return null;
        }
        TupleExpression tuple = (TupleExpression)arguments;
        count = tuple.getExpressions().size();
        MethodNode res = null;
        ClassNode node = this;
        TupleExpression args = (TupleExpression)arguments;
        do {
            for (Object o : node.getMethods(name)) {
                int i;
                MethodNode method = (MethodNode)o;
                if (method.getParameters().length != count) continue;
                boolean match = true;
                for (i = 0; i != count; ++i) {
                    if (args.getType().isDerivedFrom(method.getParameters()[i].getType())) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                if (res == null) {
                    res = method;
                    continue;
                }
                if (res.getParameters().length != count) {
                    return null;
                }
                if (node.equals(this)) {
                    return null;
                }
                match = true;
                for (i = 0; i != count; ++i) {
                    if (res.getParameters()[i].getType().equals(method.getParameters()[i].getType())) continue;
                    match = false;
                    break;
                }
                if (match) continue;
                return null;
            }
        } while ((node = node.getSuperClass()) != null);
        return res;
    }

    public boolean hasPossibleStaticMethod(String name, Expression arguments) {
        int count = 0;
        if (arguments instanceof TupleExpression) {
            TupleExpression tuple = (TupleExpression)arguments;
            count = tuple.getExpressions().size();
        } else if (arguments instanceof MapExpression) {
            count = 1;
        }
        for (Object o : this.getMethods(name)) {
            MethodNode method = (MethodNode)o;
            if (!method.isStatic()) continue;
            Parameter[] parameters = method.getParameters();
            if (parameters.length == count) {
                return true;
            }
            if (parameters.length > 0 && parameters[parameters.length - 1].getType().isArray() && count >= parameters.length - 1) {
                return true;
            }
            int nonDefaultParameters = 0;
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].hasInitialExpression()) continue;
                ++nonDefaultParameters;
            }
            if (count >= parameters.length || nonDefaultParameters > count) continue;
            return true;
        }
        return false;
    }

    public boolean isInterface() {
        return (this.getModifiers() & 0x200) > 0;
    }

    public boolean isResolved() {
        return this.redirect().clazz != null || this.componentType != null && this.componentType.isResolved();
    }

    public boolean isArray() {
        return this.componentType != null;
    }

    public ClassNode getComponentType() {
        return this.componentType;
    }

    public Class getTypeClass() {
        Class c = this.redirect().clazz;
        if (c != null) {
            return c;
        }
        ClassNode component = this.redirect().componentType;
        if (component != null && component.isResolved()) {
            ClassNode cn = component.makeArray();
            this.setRedirect(cn);
            return this.redirect().clazz;
        }
        throw new GroovyBugError(new StringBuffer().append("ClassNode#getTypeClass for ").append(this.getName()).append(" is called before the type class is set ").toString());
    }

    public boolean hasPackageName() {
        return this.redirect().name.indexOf(46) > 0;
    }

    public void setAnnotated(boolean flag) {
        this.annotated = flag;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public GenericsType[] getGenericsTypes() {
        return this.genericsTypes;
    }

    public void setGenericsTypes(GenericsType[] genericsTypes) {
        this.usesGenerics = this.usesGenerics || genericsTypes != null;
        this.genericsTypes = genericsTypes;
    }

    public void setGenericsPlaceHolder(boolean b) {
        this.usesGenerics = this.usesGenerics || b;
        this.placeholder = b;
    }

    public boolean isGenericsPlaceHolder() {
        return this.placeholder;
    }

    public boolean isUsingGenerics() {
        return this.usesGenerics;
    }

    public void setUsingGenerics(boolean b) {
        this.usesGenerics = b;
    }

    public ClassNode getPlainNodeReference() {
        if (ClassHelper.isPrimitiveType(this)) {
            return this;
        }
        ClassNode n = new ClassNode(this.getName(), this.getModifiers(), this.getSuperClass(), null, null);
        n.isPrimaryNode = false;
        n.setRedirect(this.redirect);
        return n;
    }

    public boolean isAnnotationDefinition() {
        return this.redirect().isPrimaryNode && this.isInterface() && (this.getModifiers() & 0x2000) != 0;
    }

    @Override
    public List getAnnotations() {
        if (this.redirect != null) {
            return this.redirect.getAnnotations();
        }
        this.lazyClassInit();
        return super.getAnnotations();
    }

    @Override
    public List getAnnotations(ClassNode type) {
        if (this.redirect != null) {
            return this.redirect.getAnnotations(type);
        }
        this.lazyClassInit();
        return super.getAnnotations(type);
    }

    public void addTransform(Class<? extends ASTTransformation> transform, ASTNode node) {
        GroovyASTTransformation annotation;
        Set<ASTNode> nodes;
        Class<?> clazz = class$org$codehaus$groovy$transform$GroovyASTTransformation;
        if (clazz == null) {
            clazz = class$org$codehaus$groovy$transform$GroovyASTTransformation = new GroovyASTTransformation[0].getClass().getComponentType();
        }
        if ((nodes = this.transformInstances.get((Object)(annotation = (GroovyASTTransformation)_Class.getAnnotation(transform, (Class)clazz)).phase()).get(transform)) == null) {
            nodes = new LinkedHashSet<ASTNode>();
            this.transformInstances.get((Object)annotation.phase()).put(transform, nodes);
        }
        nodes.add(node);
    }

    public Map<Class<? extends ASTTransformation>, Set<ASTNode>> getTransforms(CompilePhase phase) {
        return this.transformInstances.get((Object)phase);
    }

    public void renameField(String oldName, String newName) {
        Map index = this.redirect().fieldIndex;
        index.put(newName, index.remove(oldName));
    }

    static {
        Class<?> clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        THIS = new ClassNode(clazz);
        Class<?> clazz2 = class$java$lang$Object;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        SUPER = new ClassNode(clazz2);
    }

    private static class MapOfLists {
        private Map map = new HashMap();

        private MapOfLists() {
        }

        public List get(Object key) {
            return (List)this.map.get(key);
        }

        public List getNotNull(Object key) {
            List ret = this.get(key);
            if (ret == null) {
                ret = Collections.EMPTY_LIST;
            }
            return ret;
        }

        public void put(Object key, Object value) {
            if (this.map.containsKey(key)) {
                this.get(key).add(value);
            } else {
                ArrayList<Object> list = new ArrayList<Object>(2);
                list.add(value);
                this.map.put(key, list);
            }
        }
    }
}

