/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import java.util.List;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class GrailsGlobalPluginAwareEntityInjector
extends CompilationUnit.PrimaryClassNodeOperation {
    private static final boolean DEBUG = false;
    private GroovyClassLoader groovyClassLoader;
    private boolean broken = false;

    private static void debug(String msg) {
        System.out.println(msg);
    }

    public GrailsGlobalPluginAwareEntityInjector(GroovyClassLoader groovyClassLoader) {
        this.groovyClassLoader = groovyClassLoader;
    }

    public void call(SourceUnit sourceUnit, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
        if (this.broken) {
            return;
        }
        try {
            if (classNode.isAnnotationDefinition()) {
                return;
            }
            if (!this.isFirstClassInModule(classNode)) {
                return;
            }
            String sourcePathString = sourceUnit.getName();
            Path sourcePath = new Path(sourcePathString);
            PluginInfo info = GrailsGlobalPluginAwareEntityInjector.getInfo(sourcePath);
            if (info != null) {
                Class<?> GrailsPlugin_class = Class.forName("org.codehaus.groovy.grails.plugins.metadata.GrailsPlugin", false, this.groovyClassLoader);
                ClassNode annotation = new ClassNode(GrailsPlugin_class);
                List<AnnotationNode> list = classNode.getAnnotations(annotation);
                if (!list.isEmpty()) {
                    return;
                }
                AnnotationNode annotationNode = new AnnotationNode(annotation);
                annotationNode.addMember("name", new ConstantExpression(info.name));
                annotationNode.addMember("version", new ConstantExpression(info.version));
                annotationNode.setRuntimeRetention(true);
                annotationNode.setClassRetention(true);
                classNode.addAnnotation(annotationNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.broken = true;
        }
    }

    private boolean isFirstClassInModule(ClassNode classNode) {
        List<ClassNode> classes;
        ModuleNode module = classNode.getModule();
        if (module != null && (classes = module.getClasses()) != null && classes.size() > 0) {
            return classes.get(0) == classNode;
        }
        return false;
    }

    public static PluginInfo getInfo(IPath sourcePath) {
        String pluginNameAndVersion;
        int split;
        String link;
        if (sourcePath.segmentCount() > 3 && (link = sourcePath.segment(1)).equals(".link_to_grails_plugins") && (split = GrailsGlobalPluginAwareEntityInjector.findVersionDash(pluginNameAndVersion = sourcePath.segment(2))) >= 0) {
            if ("test".equals(sourcePath.segment(3))) {
                return null;
            }
            return new PluginInfo(pluginNameAndVersion.substring(0, split), pluginNameAndVersion.substring(split + 1));
        }
        return null;
    }

    private static int findVersionDash(String pluginNameAndVersion) {
        int split = pluginNameAndVersion.lastIndexOf(45);
        if (pluginNameAndVersion.endsWith("-SNAPSHOT")) {
            split = pluginNameAndVersion.lastIndexOf(45, split - 1);
        }
        return split;
    }

    private static class PluginInfo {
        final String name;
        final String version;

        public PluginInfo(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String toString() {
            return "Plugin(name=" + this.name + ", version=" + this.version + ")";
        }
    }
}

