/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.util.AntBuilderLocator;
import groovy.util.BuilderSupport;
import groovy.xml.QName;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.NoBannerLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.dispatch.DispatchUtils;
import org.apache.tools.ant.helper.AntXMLContext;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.codehaus.groovy.ant.FileScanner;
import org.codehaus.groovy.runtime.DefaultGroovyMethodsSupport;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class AntBuilder
extends BuilderSupport {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private Project project;
    private final AntXMLContext antXmlContext;
    private final ProjectHelper2.ElementHandler antElementHandler = new ProjectHelper2.ElementHandler();
    private final ProjectHelper2.TargetHandler antTargetHandler = new ProjectHelper2.TargetHandler();
    private final Target collectorTarget;
    private final Target implicitTarget;
    private Object lastCompletedNode;
    boolean insideTask;
    private boolean saveStreams = true;
    private static Integer streamCount = 0;
    private static InputStream savedIn;
    private static PrintStream savedErr;
    private static PrintStream savedOut;
    private static DemuxInputStream demuxInputStream;
    private static DemuxOutputStream demuxOutputStream;
    private static DemuxOutputStream demuxErrorStream;
    private static InputStream savedProjectInputStream;

    public AntBuilder() {
        this(AntBuilder.createProject());
    }

    public AntBuilder(Project project) {
        this(project, new Target());
    }

    public AntBuilder(Project project, Target owningTarget) {
        this.project = project;
        this.collectorTarget = owningTarget;
        this.antXmlContext = new AntXMLContext(project);
        this.collectorTarget.setProject(project);
        this.antXmlContext.setCurrentTarget(this.collectorTarget);
        this.antXmlContext.setLocator((Locator)new AntBuilderLocator());
        this.antXmlContext.setCurrentTargets(new HashMap());
        this.implicitTarget = new Target();
        this.implicitTarget.setProject(project);
        this.implicitTarget.setName("");
        this.antXmlContext.setImplicitTarget(this.implicitTarget);
        project.addDataTypeDefinition("fileScanner", FileScanner.class);
    }

    public AntBuilder(Task parentTask) {
        this(parentTask.getProject(), parentTask.getOwningTarget());
        UnknownElement ue = new UnknownElement(parentTask.getTaskName());
        ue.setProject(parentTask.getProject());
        ue.setTaskType(parentTask.getTaskType());
        ue.setTaskName(parentTask.getTaskName());
        ue.setLocation(parentTask.getLocation());
        ue.setOwningTarget(parentTask.getOwningTarget());
        ue.setRuntimeConfigurableWrapper(parentTask.getRuntimeConfigurableWrapper());
        parentTask.getRuntimeConfigurableWrapper().setProxy((Object)ue);
        this.antXmlContext.pushWrapper(parentTask.getRuntimeConfigurableWrapper());
    }

    public Project getProject() {
        return this.project;
    }

    public AntXMLContext getAntXmlContext() {
        return this.antXmlContext;
    }

    public boolean isSaveStreams() {
        return this.saveStreams;
    }

    public void setSaveStreams(boolean saveStreams) {
        this.saveStreams = saveStreams;
    }

    protected static Project createProject() {
        Project project = new Project();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        project.addReference("ant.projectHelper", (Object)helper);
        helper.getImportStack().addElement("AntBuilder");
        NoBannerLogger logger = new NoBannerLogger();
        logger.setMessageOutputLevel(2);
        logger.setOutputPrintStream(System.out);
        logger.setErrorPrintStream(System.err);
        project.addBuildListener((BuildListener)logger);
        project.init();
        project.getBaseDir();
        return project;
    }

    protected void setParent(Object parent, Object child) {
    }

    protected Object doInvokeMethod(String methodName, Object name, Object args) {
        super.doInvokeMethod(methodName, name, args);
        return this.lastCompletedNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void nodeCompleted(Object parent, Object node) {
        if (parent == null) {
            this.insideTask = false;
        }
        this.antElementHandler.onEndElement(null, null, this.antXmlContext);
        this.lastCompletedNode = node;
        if (parent != null && !(parent instanceof Target)) {
            this.log.finest("parent is not null: no perform on nodeCompleted");
            return;
        }
        if (node instanceof Task) {
            Task task = (Task)node;
            String taskName = task.getTaskName();
            if ("antcall".equals(taskName) && parent == null) {
                throw new BuildException("antcall not supported within AntBuilder, consider using 'ant.project.executeTarget('targetName')' instead.");
            }
            if (this.saveStreams) {
                Class<AntBuilder> clazz = AntBuilder.class;
                // MONITORENTER : groovy.util.AntBuilder.class
                Integer n = streamCount;
                Integer n2 = streamCount = Integer.valueOf(streamCount + 1);
                int currentStreamCount = n;
                if (currentStreamCount == 0) {
                    savedProjectInputStream = this.project.getDefaultInputStream();
                    savedIn = System.in;
                    savedErr = System.err;
                    savedOut = System.out;
                    if (!(savedIn instanceof DemuxInputStream)) {
                        this.project.setDefaultInputStream(savedIn);
                        demuxInputStream = new DemuxInputStream(this.project);
                        System.setIn((InputStream)demuxInputStream);
                    }
                    demuxOutputStream = new DemuxOutputStream(this.project, false);
                    System.setOut(new PrintStream((OutputStream)demuxOutputStream));
                    demuxErrorStream = new DemuxOutputStream(this.project, true);
                    System.setErr(new PrintStream((OutputStream)demuxErrorStream));
                }
                // MONITOREXIT : clazz
            }
            try {
                this.lastCompletedNode = this.performTask(task);
                Object var11_10 = null;
                if (this.saveStreams) {
                    Class<AntBuilder> clazz = AntBuilder.class;
                    // MONITORENTER : groovy.util.AntBuilder.class
                    streamCount = streamCount - 1;
                    int currentStreamCount = streamCount;
                    if (currentStreamCount == 0) {
                        this.project.setDefaultInputStream(savedProjectInputStream);
                        System.setOut(savedOut);
                        System.setErr(savedErr);
                        if (demuxInputStream != null) {
                            System.setIn(savedIn);
                            DefaultGroovyMethodsSupport.closeQuietly((Closeable)demuxInputStream);
                            demuxInputStream = null;
                        }
                        DefaultGroovyMethodsSupport.closeQuietly((Closeable)demuxOutputStream);
                        DefaultGroovyMethodsSupport.closeQuietly((Closeable)demuxErrorStream);
                        demuxOutputStream = null;
                        demuxErrorStream = null;
                    }
                    // MONITOREXIT : clazz
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (!this.saveStreams) throw throwable;
                Class<AntBuilder> clazz = AntBuilder.class;
                // MONITORENTER : groovy.util.AntBuilder.class
                streamCount = streamCount - 1;
                int currentStreamCount = streamCount;
                if (currentStreamCount == 0) {
                    this.project.setDefaultInputStream(savedProjectInputStream);
                    System.setOut(savedOut);
                    System.setErr(savedErr);
                    if (demuxInputStream != null) {
                        System.setIn(savedIn);
                        DefaultGroovyMethodsSupport.closeQuietly((Closeable)demuxInputStream);
                        demuxInputStream = null;
                    }
                    DefaultGroovyMethodsSupport.closeQuietly((Closeable)demuxOutputStream);
                    DefaultGroovyMethodsSupport.closeQuietly((Closeable)demuxErrorStream);
                    demuxOutputStream = null;
                    demuxErrorStream = null;
                }
                // MONITOREXIT : clazz
                throw throwable;
            }
            if (!"import".equals(taskName)) return;
            this.antXmlContext.setCurrentTarget(this.collectorTarget);
            return;
        }
        if (node instanceof Target) {
            this.antXmlContext.setCurrentTarget(this.collectorTarget);
            return;
        }
        RuntimeConfigurable r = (RuntimeConfigurable)node;
        r.maybeConfigure(this.project);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object performTask(Task task) {
        Object object;
        Throwable reason = null;
        try {
            try {
                Method fireTaskStarted = Project.class.getDeclaredMethod("fireTaskStarted", Task.class);
                fireTaskStarted.setAccessible(true);
                fireTaskStarted.invoke((Object)this.project, task);
                Object realThing = task;
                task.maybeConfigure();
                if (task instanceof UnknownElement) {
                    realThing = ((UnknownElement)task).getRealThing();
                }
                DispatchUtils.execute((Object)task);
                object = realThing != null ? realThing : task;
                Object var7_10 = null;
            }
            catch (BuildException ex) {
                if (ex.getLocation() == Location.UNKNOWN_LOCATION) {
                    ex.setLocation(task.getLocation());
                }
                reason = ex;
                throw ex;
            }
            catch (Exception ex) {
                reason = ex;
                BuildException be = new BuildException((Throwable)ex);
                be.setLocation(task.getLocation());
                throw be;
            }
            catch (Error ex) {
                reason = ex;
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            try {
                Method fireTaskFinished = Project.class.getDeclaredMethod("fireTaskFinished", Task.class, Throwable.class);
                fireTaskFinished.setAccessible(true);
                fireTaskFinished.invoke((Object)this.project, task, reason);
                throw throwable;
            }
            catch (Exception e) {
                BuildException be = new BuildException((Throwable)e);
                be.setLocation(task.getLocation());
                throw be;
            }
        }
        try {}
        catch (Exception e) {
            BuildException be = new BuildException((Throwable)e);
            be.setLocation(task.getLocation());
            throw be;
        }
        Method fireTaskFinished = Project.class.getDeclaredMethod("fireTaskFinished", Task.class, Throwable.class);
        fireTaskFinished.setAccessible(true);
        fireTaskFinished.invoke((Object)this.project, task, reason);
        return object;
    }

    protected Object createNode(Object tagName) {
        return this.createNode(tagName, Collections.EMPTY_MAP);
    }

    protected Object createNode(Object name, Object value) {
        Object task = this.createNode(name);
        this.setText(task, value.toString());
        return task;
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        Object task = this.createNode(name, attributes);
        this.setText(task, value.toString());
        return task;
    }

    protected static Attributes buildAttributes(Map attributes) {
        AttributesImpl attr = new AttributesImpl();
        Iterator i$ = attributes.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            String attributeName = (String)entry.getKey();
            String attributeValue = String.valueOf(entry.getValue());
            attr.addAttribute(null, attributeName, attributeName, "CDATA", attributeValue);
        }
        return attr;
    }

    protected Object createNode(Object name, Map attributes) {
        Attributes attrs = AntBuilder.buildAttributes(attributes);
        String tagName = name.toString();
        String ns = "";
        if (name instanceof QName) {
            QName q = (QName)name;
            tagName = q.getLocalPart();
            ns = q.getNamespaceURI();
        }
        if ("import".equals(name)) {
            this.antXmlContext.setCurrentTarget(this.implicitTarget);
        } else if ("target".equals(name) && !this.insideTask) {
            return this.onStartTarget(attrs, tagName, ns);
        }
        try {
            this.antElementHandler.onStartElement(ns, tagName, tagName, attrs, this.antXmlContext);
        }
        catch (SAXParseException e) {
            this.log.log(Level.SEVERE, "Caught: " + e, e);
        }
        this.insideTask = true;
        RuntimeConfigurable wrapper = (RuntimeConfigurable)this.antXmlContext.getWrapperStack().lastElement();
        return wrapper.getProxy();
    }

    private Target onStartTarget(Attributes attrs, String tagName, String ns) {
        Target target = new Target();
        target.setProject(this.project);
        target.setLocation(new Location(this.antXmlContext.getLocator()));
        try {
            this.antTargetHandler.onStartElement(ns, tagName, tagName, attrs, this.antXmlContext);
            Target newTarget = (Target)this.getProject().getTargets().get(attrs.getValue("name"));
            Vector targets = new Vector();
            Enumeration deps = newTarget.getDependencies();
            while (deps.hasMoreElements()) {
                String targetName = (String)deps.nextElement();
                targets.add(this.project.getTargets().get(targetName));
            }
            this.getProject().executeSortedTargets(targets);
            this.antXmlContext.setCurrentTarget(newTarget);
            return newTarget;
        }
        catch (SAXParseException e) {
            this.log.log(Level.SEVERE, "Caught: " + e, e);
            return null;
        }
    }

    protected void setText(Object task, String text) {
        char[] characters = text.toCharArray();
        try {
            this.antElementHandler.characters(characters, 0, characters.length, this.antXmlContext);
        }
        catch (SAXParseException e) {
            this.log.log(Level.WARNING, "SetText failed: " + task + ". Reason: " + e, e);
        }
    }

    public Project getAntProject() {
        return this.project;
    }
}

