/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

public class ArrayTypeUtils {
    public static int dimension(Class clazz) {
        ArrayTypeUtils.checkArrayType(clazz);
        int result = 0;
        while (clazz.isArray()) {
            ++result;
            clazz = clazz.getComponentType();
        }
        return result;
    }

    public static Class elementType(Class clazz) {
        ArrayTypeUtils.checkArrayType(clazz);
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static Class reduceDimension(Class clazz, int dim) {
        ArrayTypeUtils.checkArrayType(clazz);
        if (dim < 0) {
            throw new IllegalArgumentException("The target dimension should not be less than zero: " + dim);
        }
        while (clazz.isArray() && ArrayTypeUtils.dimension(clazz) > dim) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    private static void checkArrayType(Class clazz) {
        if (null == clazz) {
            throw new IllegalArgumentException("clazz can not be null");
        }
        if (!clazz.isArray()) {
            throw new IllegalArgumentException(clazz.getCanonicalName() + " is not array type");
        }
    }
}

