/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.parser.antlr4;

import groovy.lang.IntRange;
import groovyjarjarantlr4.v4.runtime.ANTLRErrorListener;
import groovyjarjarantlr4.v4.runtime.CharStream;
import groovyjarjarantlr4.v4.runtime.CharStreams;
import groovyjarjarantlr4.v4.runtime.CodePointCharStream;
import groovyjarjarantlr4.v4.runtime.CommonTokenStream;
import groovyjarjarantlr4.v4.runtime.RecognitionException;
import groovyjarjarantlr4.v4.runtime.Recognizer;
import groovyjarjarantlr4.v4.runtime.atn.ParserATNSimulator;
import groovyjarjarantlr4.v4.runtime.atn.PredictionMode;
import groovyjarjarantlr4.v4.runtime.misc.ParseCancellationException;
import groovyjarjarantlr4.v4.runtime.tree.ParseTree;
import groovyjarjarantlr4.v4.runtime.tree.TerminalNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.groovy.parser.antlr4.GroovyLangLexer;
import org.apache.groovy.parser.antlr4.GroovyLangParser;
import org.apache.groovy.parser.antlr4.GroovyParser;
import org.apache.groovy.parser.antlr4.GroovyParserBaseVisitor;
import org.apache.groovy.parser.antlr4.GroovyParserVisitor;
import org.apache.groovy.parser.antlr4.GroovySyntaxError;
import org.apache.groovy.parser.antlr4.GroovydocManager;
import org.apache.groovy.parser.antlr4.ModifierManager;
import org.apache.groovy.parser.antlr4.ModifierNode;
import org.apache.groovy.parser.antlr4.TryWithResourcesASTTransformation;
import org.apache.groovy.parser.antlr4.internal.AtnManager;
import org.apache.groovy.parser.antlr4.internal.DescriptiveErrorStrategy;
import org.apache.groovy.parser.antlr4.util.StringUtils;
import org.apache.groovy.util.Maps;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.antlr.EnumHelper;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.EnumConstantClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.NodeMetaDataHandler;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.LambdaExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.MethodReferenceExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.syntax.Numbers;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;

public class AstBuilder
extends GroovyParserBaseVisitor<Object>
implements GroovyParserVisitor<Object> {
    private static final Map<ClassNode, Object> TYPE_DEFAULT_VALUE_MAP = Maps.of(ClassHelper.int_TYPE, 0, ClassHelper.long_TYPE, 0L, ClassHelper.double_TYPE, 0.0, ClassHelper.float_TYPE, Float.valueOf(0.0f), ClassHelper.short_TYPE, (short)0, ClassHelper.byte_TYPE, (byte)0, ClassHelper.char_TYPE, Character.valueOf('\u0000'), ClassHelper.boolean_TYPE, Boolean.FALSE);
    private final ModuleNode moduleNode;
    private final SourceUnit sourceUnit;
    private final ClassLoader classLoader;
    private final GroovyLangLexer lexer;
    private final GroovyLangParser parser;
    private final TryWithResourcesASTTransformation tryWithResourcesASTTransformation;
    private final GroovydocManager groovydocManager;
    private final List<ClassNode> classNodeList = new LinkedList<ClassNode>();
    private final Deque<ClassNode> classNodeStack = new ArrayDeque<ClassNode>();
    private final Deque<List<InnerClassNode>> anonymousInnerClassesDefinedInMethodStack = new ArrayDeque<List<InnerClassNode>>();
    private int anonymousInnerClassCounter = 1;
    private Pair<GroovyParser.GroovyParserRuleContext, Exception> numberFormatError;
    private static final String QUESTION_STR = "?";
    private static final String DOT_STR = ".";
    private static final String SUB_STR = "-";
    private static final String ASSIGN_STR = "=";
    private static final String VALUE_STR = "value";
    private static final String DOLLAR_STR = "$";
    private static final String CALL_STR = "call";
    private static final String THIS_STR = "this";
    private static final String SUPER_STR = "super";
    private static final String VOID_STR = "void";
    private static final String PACKAGE_INFO = "package-info";
    private static final String PACKAGE_INFO_FILE_NAME = "package-info.groovy";
    private static final String GROOVY_TRANSFORM_TRAIT = "groovy.transform.Trait";
    private static final Set<String> PRIMITIVE_TYPE_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("boolean", "char", "byte", "short", "int", "long", "float", "double")));
    private static final Logger LOGGER = Logger.getLogger(AstBuilder.class.getName());
    private static final String INSIDE_PARENTHESES_LEVEL = "_INSIDE_PARENTHESES_LEVEL";
    private static final String IS_INSIDE_INSTANCEOF_EXPR = "_IS_INSIDE_INSTANCEOF_EXPR";
    private static final String IS_SWITCH_DEFAULT = "_IS_SWITCH_DEFAULT";
    private static final String IS_NUMERIC = "_IS_NUMERIC";
    private static final String IS_STRING = "_IS_STRING";
    private static final String IS_INTERFACE_WITH_DEFAULT_METHODS = "_IS_INTERFACE_WITH_DEFAULT_METHODS";
    private static final String IS_INSIDE_CONDITIONAL_EXPRESSION = "_IS_INSIDE_CONDITIONAL_EXPRESSION";
    private static final String PATH_EXPRESSION_BASE_EXPR = "_PATH_EXPRESSION_BASE_EXPR";
    private static final String PATH_EXPRESSION_BASE_EXPR_GENERICS_TYPES = "_PATH_EXPRESSION_BASE_EXPR_GENERICS_TYPES";
    private static final String CMD_EXPRESSION_BASE_EXPR = "_CMD_EXPRESSION_BASE_EXPR";
    private static final String TYPE_DECLARATION_MODIFIERS = "_TYPE_DECLARATION_MODIFIERS";
    private static final String CLASS_DECLARATION_CLASS_NODE = "_CLASS_DECLARATION_CLASS_NODE";
    private static final String VARIABLE_DECLARATION_VARIABLE_TYPE = "_VARIABLE_DECLARATION_VARIABLE_TYPE";
    private static final String ANONYMOUS_INNER_CLASS_SUPER_CLASS = "_ANONYMOUS_INNER_CLASS_SUPER_CLASS";
    private static final String INTEGER_LITERAL_TEXT = "_INTEGER_LITERAL_TEXT";
    private static final String FLOATING_POINT_LITERAL_TEXT = "_FLOATING_POINT_LITERAL_TEXT";
    private static final String CLASS_NAME = "_CLASS_NAME";

    public AstBuilder(SourceUnit sourceUnit, ClassLoader classLoader) {
        this.sourceUnit = sourceUnit;
        this.moduleNode = new ModuleNode(sourceUnit);
        this.classLoader = classLoader;
        CharStream charStream = this.createCharStream(sourceUnit);
        this.lexer = new GroovyLangLexer(charStream);
        this.parser = new GroovyLangParser(new CommonTokenStream(this.lexer));
        this.parser.setErrorHandler(new DescriptiveErrorStrategy(charStream));
        this.tryWithResourcesASTTransformation = new TryWithResourcesASTTransformation(this);
        this.groovydocManager = new GroovydocManager(this);
    }

    private CharStream createCharStream(SourceUnit sourceUnit) {
        CodePointCharStream charStream;
        try {
            charStream = CharStreams.fromReader(new BufferedReader(sourceUnit.getSource().getReader()), sourceUnit.getName());
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred when reading source code.", e);
        }
        return charStream;
    }

    private GroovyParser.GroovyParserRuleContext buildCST() throws CompilationFailedException {
        GroovyParser.GroovyParserRuleContext result;
        try {
            AtnManager.RRWL.readLock().lock();
            try {
                result = this.buildCST(PredictionMode.SLL);
            }
            catch (Throwable t) {
                if (t instanceof GroovySyntaxError && 0 == ((GroovySyntaxError)((Object)t)).getSource()) {
                    throw t;
                }
                result = this.buildCST(PredictionMode.LL);
            }
            finally {
                AtnManager.RRWL.readLock().unlock();
            }
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
        return result;
    }

    private GroovyParser.GroovyParserRuleContext buildCST(PredictionMode predictionMode) {
        ((ParserATNSimulator)this.parser.getInterpreter()).setPredictionMode(predictionMode);
        if (PredictionMode.SLL.equals((Object)predictionMode)) {
            this.removeErrorListeners();
        } else {
            this.parser.getInputStream().seek(0);
            this.addErrorListeners();
        }
        return this.parser.compilationUnit();
    }

    private CompilationFailedException convertException(Throwable t) {
        CompilationFailedException cfe = t instanceof CompilationFailedException ? (CompilationFailedException)t : (t instanceof ParseCancellationException ? this.createParsingFailedException(t.getCause()) : this.createParsingFailedException(t));
        return cfe;
    }

    public ModuleNode buildAST() {
        try {
            return (ModuleNode)this.visit(this.buildCST());
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
    }

    @Override
    public ModuleNode visitCompilationUnit(GroovyParser.CompilationUnitContext ctx) {
        this.visit(ctx.packageDeclaration());
        for (GroovyParser.StatementContext statementContext : ctx.statement()) {
            Object e = this.visit(statementContext);
            if (e instanceof DeclarationListStatement) {
                for (Statement statement : ((DeclarationListStatement)e).getDeclarationStatements()) {
                    this.moduleNode.addStatement(statement);
                }
                continue;
            }
            if (e instanceof Statement) {
                this.moduleNode.addStatement((Statement)e);
                continue;
            }
            if (!(e instanceof MethodNode)) continue;
            this.moduleNode.addMethod((MethodNode)e);
        }
        for (ClassNode classNode : this.classNodeList) {
            this.moduleNode.addClass(classNode);
        }
        if (this.isPackageInfoDeclaration()) {
            this.addPackageInfoClassNode();
        } else if (this.isBlankScript(ctx)) {
            this.addEmptyReturnStatement();
        }
        this.configureScriptClassNode();
        if (null != this.numberFormatError) {
            throw this.createParsingFailedException(((Exception)((Pair)this.numberFormatError).value).getMessage(), (GroovyParser.GroovyParserRuleContext)((Pair)this.numberFormatError).key);
        }
        return this.moduleNode;
    }

    @Override
    public PackageNode visitPackageDeclaration(GroovyParser.PackageDeclarationContext ctx) {
        String packageName = this.visitQualifiedName(ctx.qualifiedName());
        this.moduleNode.setPackageName(packageName + DOT_STR);
        PackageNode packageNode = this.moduleNode.getPackage();
        packageNode.addAnnotations((List<AnnotationNode>)this.visitAnnotationsOpt(ctx.annotationsOpt()));
        return this.configureAST(packageNode, ctx);
    }

    @Override
    public ImportNode visitImportDeclaration(GroovyParser.ImportDeclarationContext ctx) {
        ImportNode importNode;
        boolean hasStatic = DefaultGroovyMethods.asBoolean(ctx.STATIC());
        boolean hasStar = DefaultGroovyMethods.asBoolean(ctx.MUL());
        boolean hasAlias = DefaultGroovyMethods.asBoolean(ctx.alias);
        Object annotationNodeList = this.visitAnnotationsOpt(ctx.annotationsOpt());
        if (hasStatic) {
            if (hasStar) {
                String qualifiedName = this.visitQualifiedName(ctx.qualifiedName());
                ClassNode type = ClassHelper.make(qualifiedName);
                this.configureAST(type, ctx);
                this.moduleNode.addStaticStarImport(type.getText(), type, (List<AnnotationNode>)annotationNodeList);
                importNode = DefaultGroovyMethods.last(this.moduleNode.getStaticStarImports().values());
            } else {
                LinkedList<? extends GroovyParser.QualifiedNameElementContext> identifierList = new LinkedList<GroovyParser.QualifiedNameElementContext>(ctx.qualifiedName().qualifiedNameElement());
                int identifierListSize = identifierList.size();
                String name = ((GroovyParser.QualifiedNameElementContext)identifierList.get(identifierListSize - 1)).getText();
                StringBuilder builder = new StringBuilder();
                long limit = identifierListSize - 1;
                for (GroovyParser.GroovyParserRuleContext groovyParserRuleContext : identifierList) {
                    if (limit-- == 0L) break;
                    String text = groovyParserRuleContext.getText();
                    if (builder.length() > 0) {
                        builder.append(DOT_STR);
                    }
                    builder.append(text);
                }
                ClassNode classNode = ClassHelper.make(builder.toString());
                String string = hasAlias ? ctx.alias.getText() : name;
                this.configureAST(classNode, ctx);
                this.moduleNode.addStaticImport(classNode, name, string, (List<AnnotationNode>)annotationNodeList);
                importNode = DefaultGroovyMethods.last(this.moduleNode.getStaticImports().values());
            }
        } else if (hasStar) {
            String qualifiedName = this.visitQualifiedName(ctx.qualifiedName());
            this.moduleNode.addStarImport(qualifiedName + DOT_STR, (List<AnnotationNode>)annotationNodeList);
            importNode = DefaultGroovyMethods.last(this.moduleNode.getStarImports());
        } else {
            String qualifiedName = this.visitQualifiedName(ctx.qualifiedName());
            String name = DefaultGroovyMethods.last(ctx.qualifiedName().qualifiedNameElement()).getText();
            ClassNode classNode = ClassHelper.make(qualifiedName);
            String alias = hasAlias ? ctx.alias.getText() : name;
            this.configureAST(classNode, ctx);
            this.moduleNode.addImport(alias, classNode, (List<AnnotationNode>)annotationNodeList);
            importNode = DefaultGroovyMethods.last(this.moduleNode.getImports());
        }
        return this.configureAST(importNode, ctx);
    }

    @Override
    public AssertStatement visitAssertStatement(GroovyParser.AssertStatementContext ctx) {
        BinaryExpression binaryExpression;
        Expression conditionExpression = (Expression)this.visit(ctx.ce);
        if (conditionExpression instanceof BinaryExpression && (binaryExpression = (BinaryExpression)conditionExpression).getOperation().getType() == 100) {
            throw this.createParsingFailedException("Assignment expression is not allowed in the assert statement", conditionExpression);
        }
        BooleanExpression booleanExpression = this.configureAST(new BooleanExpression(conditionExpression), conditionExpression);
        if (!DefaultGroovyMethods.asBoolean(ctx.me)) {
            return this.configureAST(new AssertStatement(booleanExpression), ctx);
        }
        return this.configureAST(new AssertStatement(booleanExpression, (Expression)this.visit(ctx.me)), ctx);
    }

    @Override
    public AssertStatement visitAssertStmtAlt(GroovyParser.AssertStmtAltContext ctx) {
        return this.configureAST(this.visitAssertStatement(ctx.assertStatement()), ctx);
    }

    @Override
    public IfStatement visitIfElseStmtAlt(GroovyParser.IfElseStmtAltContext ctx) {
        Expression conditionExpression = this.visitExpressionInPar(ctx.expressionInPar());
        BooleanExpression booleanExpression = this.configureAST(new BooleanExpression(conditionExpression), conditionExpression);
        Statement ifBlock = this.unpackStatement((Statement)this.visit(ctx.tb));
        Statement elseBlock = this.unpackStatement(DefaultGroovyMethods.asBoolean(ctx.ELSE()) ? (Statement)this.visit(ctx.fb) : EmptyStatement.INSTANCE);
        return this.configureAST(new IfStatement(booleanExpression, ifBlock, elseBlock), ctx);
    }

    @Override
    public Statement visitLoopStmtAlt(GroovyParser.LoopStmtAltContext ctx) {
        return this.configureAST((Statement)this.visit(ctx.loopStatement()), ctx);
    }

    @Override
    public ForStatement visitForStmtAlt(GroovyParser.ForStmtAltContext ctx) {
        Object controlPair = this.visitForControl(ctx.forControl());
        Statement loopBlock = this.unpackStatement((Statement)this.visit(ctx.statement()));
        return this.configureAST(new ForStatement((Parameter)((Pair)controlPair).getKey(), (Expression)((Pair)controlPair).getValue(), DefaultGroovyMethods.asBoolean(loopBlock) ? loopBlock : EmptyStatement.INSTANCE), ctx);
    }

    @Override
    public Pair<Parameter, Expression> visitForControl(GroovyParser.ForControlContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.enhancedForControl())) {
            return this.visitEnhancedForControl(ctx.enhancedForControl());
        }
        if (DefaultGroovyMethods.asBoolean(ctx.classicalForControl())) {
            return this.visitClassicalForControl(ctx.classicalForControl());
        }
        throw this.createParsingFailedException("Unsupported for control: " + ctx.getText(), ctx);
    }

    @Override
    public Expression visitForInit(GroovyParser.ForInitContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return EmptyExpression.INSTANCE;
        }
        if (DefaultGroovyMethods.asBoolean(ctx.localVariableDeclaration())) {
            DeclarationListStatement declarationListStatement = this.visitLocalVariableDeclaration(ctx.localVariableDeclaration());
            List<Expression> declarationExpressionList = declarationListStatement.getDeclarationExpressions();
            if (declarationExpressionList.size() == 1) {
                return this.configureAST((Expression)declarationExpressionList.get(0), ctx);
            }
            return this.configureAST(new ClosureListExpression(declarationExpressionList), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.expressionList())) {
            return this.translateExpressionList(ctx.expressionList());
        }
        throw this.createParsingFailedException("Unsupported for init: " + ctx.getText(), ctx);
    }

    @Override
    public Expression visitForUpdate(GroovyParser.ForUpdateContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return EmptyExpression.INSTANCE;
        }
        return this.translateExpressionList(ctx.expressionList());
    }

    private Expression translateExpressionList(GroovyParser.ExpressionListContext ctx) {
        Object expressionList = this.visitExpressionList(ctx);
        if (expressionList.size() == 1) {
            return (Expression)this.configureAST((ASTNode)expressionList.get(0), ctx);
        }
        return this.configureAST(new ClosureListExpression((List<Expression>)expressionList), ctx);
    }

    @Override
    public Pair<Parameter, Expression> visitEnhancedForControl(GroovyParser.EnhancedForControlContext ctx) {
        Parameter parameter = this.configureAST(new Parameter(this.visitType(ctx.type()), this.visitVariableDeclaratorId(ctx.variableDeclaratorId()).getName()), ctx.variableDeclaratorId());
        return new Pair<Parameter, Expression>(parameter, (Expression)this.visit(ctx.expression()));
    }

    @Override
    public Pair<Parameter, Expression> visitClassicalForControl(GroovyParser.ClassicalForControlContext ctx) {
        ClosureListExpression closureListExpression = new ClosureListExpression();
        closureListExpression.addExpression(this.visitForInit(ctx.forInit()));
        closureListExpression.addExpression(DefaultGroovyMethods.asBoolean(ctx.expression()) ? (Expression)this.visit(ctx.expression()) : EmptyExpression.INSTANCE);
        closureListExpression.addExpression(this.visitForUpdate(ctx.forUpdate()));
        return new Pair<Parameter, Expression>(ForStatement.FOR_LOOP_DUMMY, closureListExpression);
    }

    @Override
    public WhileStatement visitWhileStmtAlt(GroovyParser.WhileStmtAltContext ctx) {
        Expression conditionExpression = this.visitExpressionInPar(ctx.expressionInPar());
        BooleanExpression booleanExpression = this.configureAST(new BooleanExpression(conditionExpression), conditionExpression);
        Statement loopBlock = this.unpackStatement((Statement)this.visit(ctx.statement()));
        return this.configureAST(new WhileStatement(booleanExpression, DefaultGroovyMethods.asBoolean(loopBlock) ? loopBlock : EmptyStatement.INSTANCE), ctx);
    }

    @Override
    public DoWhileStatement visitDoWhileStmtAlt(GroovyParser.DoWhileStmtAltContext ctx) {
        Expression conditionExpression = this.visitExpressionInPar(ctx.expressionInPar());
        BooleanExpression booleanExpression = this.configureAST(new BooleanExpression(conditionExpression), conditionExpression);
        Statement loopBlock = this.unpackStatement((Statement)this.visit(ctx.statement()));
        return this.configureAST(new DoWhileStatement(booleanExpression, DefaultGroovyMethods.asBoolean(loopBlock) ? loopBlock : EmptyStatement.INSTANCE), ctx);
    }

    @Override
    public Statement visitTryCatchStmtAlt(GroovyParser.TryCatchStmtAltContext ctx) {
        return this.configureAST(this.visitTryCatchStatement(ctx.tryCatchStatement()), ctx);
    }

    @Override
    public Statement visitTryCatchStatement(GroovyParser.TryCatchStatementContext ctx) {
        TryCatchStatement tryCatchStatement = new TryCatchStatement((Statement)this.visit(ctx.block()), this.visitFinallyBlock(ctx.finallyBlock()));
        if (DefaultGroovyMethods.asBoolean(ctx.resources())) {
            Iterator<GroovyParser.CatchClauseContext> iterator = this.visitResources(ctx.resources()).iterator();
            while (iterator.hasNext()) {
                ExpressionStatement expressionStatement = (ExpressionStatement)((Object)iterator.next());
                tryCatchStatement.addResource(expressionStatement);
            }
        }
        for (GroovyParser.CatchClauseContext catchClauseContext : ctx.catchClause()) {
            Object list = this.visitCatchClause(catchClauseContext);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CatchStatement cs = (CatchStatement)iterator.next();
                tryCatchStatement.addCatch(cs);
            }
        }
        return this.configureAST(this.tryWithResourcesASTTransformation.transform(this.configureAST(tryCatchStatement, ctx)), ctx);
    }

    @Override
    public List<ExpressionStatement> visitResources(GroovyParser.ResourcesContext ctx) {
        return this.visitResourceList(ctx.resourceList());
    }

    @Override
    public List<ExpressionStatement> visitResourceList(GroovyParser.ResourceListContext ctx) {
        ArrayList<ExpressionStatement> list = new ArrayList<ExpressionStatement>();
        for (GroovyParser.ResourceContext resourceContext : ctx.resource()) {
            ExpressionStatement expressionStatement = this.visitResource(resourceContext);
            list.add(expressionStatement);
        }
        return list;
    }

    @Override
    public ExpressionStatement visitResource(GroovyParser.ResourceContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.localVariableDeclaration())) {
            List<ExpressionStatement> declarationStatements = this.visitLocalVariableDeclaration(ctx.localVariableDeclaration()).getDeclarationStatements();
            if (declarationStatements.size() > 1) {
                throw this.createParsingFailedException("Multi resources can not be declared in one statement", ctx);
            }
            return declarationStatements.get(0);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.expression())) {
            Expression expression = (Expression)this.visit(ctx.expression());
            if (!(expression instanceof BinaryExpression) || 100 != ((BinaryExpression)expression).getOperation().getType() || !(((BinaryExpression)expression).getLeftExpression() instanceof VariableExpression)) {
                throw this.createParsingFailedException("Only variable declarations are allowed to declare resource", ctx);
            }
            BinaryExpression assignmentExpression = (BinaryExpression)expression;
            return this.configureAST(new ExpressionStatement(this.configureAST(new DeclarationExpression(this.configureAST(new VariableExpression(assignmentExpression.getLeftExpression().getText()), assignmentExpression.getLeftExpression()), assignmentExpression.getOperation(), assignmentExpression.getRightExpression()), ctx)), ctx);
        }
        throw this.createParsingFailedException("Unsupported resource declaration: " + ctx.getText(), ctx);
    }

    @Override
    public List<CatchStatement> visitCatchClause(GroovyParser.CatchClauseContext ctx) {
        ArrayList<CatchStatement> list = new ArrayList<CatchStatement>();
        Iterator iterator = this.visitCatchType(ctx.catchType()).iterator();
        while (iterator.hasNext()) {
            ClassNode e = (ClassNode)iterator.next();
            CatchStatement catchStatement = this.configureAST(new CatchStatement(new Parameter(e, this.visitIdentifier(ctx.identifier())), this.visitBlock(ctx.block())), ctx);
            list.add(catchStatement);
        }
        return list;
    }

    @Override
    public List<ClassNode> visitCatchType(GroovyParser.CatchTypeContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return Collections.singletonList(ClassHelper.OBJECT_TYPE);
        }
        ArrayList<ClassNode> list = new ArrayList<ClassNode>();
        for (GroovyParser.QualifiedClassNameContext qualifiedClassNameContext : ctx.qualifiedClassName()) {
            ClassNode classNode = this.visitQualifiedClassName(qualifiedClassNameContext);
            list.add(classNode);
        }
        return list;
    }

    @Override
    public Statement visitFinallyBlock(GroovyParser.FinallyBlockContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return EmptyStatement.INSTANCE;
        }
        return this.configureAST(this.createBlockStatement((Statement)this.visit(ctx.block())), ctx);
    }

    @Override
    public SwitchStatement visitSwitchStmtAlt(GroovyParser.SwitchStmtAltContext ctx) {
        return this.configureAST(this.visitSwitchStatement(ctx.switchStatement()), ctx);
    }

    @Override
    public SwitchStatement visitSwitchStatement(GroovyParser.SwitchStatementContext ctx) {
        LinkedList statementList = new LinkedList();
        for (GroovyParser.SwitchBlockStatementGroupContext switchBlockStatementGroupContext : ctx.switchBlockStatementGroup()) {
            statementList.addAll(this.visitSwitchBlockStatementGroup(switchBlockStatementGroupContext));
        }
        LinkedList<CaseStatement> caseStatementList = new LinkedList<CaseStatement>();
        LinkedList<Statement> linkedList = new LinkedList<Statement>();
        for (Statement e : statementList) {
            if (e instanceof CaseStatement) {
                caseStatementList.add((CaseStatement)e);
                continue;
            }
            if (!this.isTrue(e, IS_SWITCH_DEFAULT)) continue;
            linkedList.add(e);
        }
        int defaultStatementListSize = linkedList.size();
        if (defaultStatementListSize > 1) {
            throw this.createParsingFailedException("switch statement should have only one default case, which should appear at last", (ASTNode)linkedList.get(0));
        }
        if (defaultStatementListSize > 0 && DefaultGroovyMethods.last(statementList) instanceof CaseStatement) {
            throw this.createParsingFailedException("default case should appear at last", (ASTNode)linkedList.get(0));
        }
        return this.configureAST(new SwitchStatement(this.visitExpressionInPar(ctx.expressionInPar()), caseStatementList, defaultStatementListSize == 0 ? EmptyStatement.INSTANCE : (Statement)linkedList.get(0)), ctx);
    }

    @Override
    public List<Statement> visitSwitchBlockStatementGroup(GroovyParser.SwitchBlockStatementGroupContext ctx) {
        int labelCnt = ctx.switchLabel().size();
        ArrayList firstLabelHolder = new ArrayList(1);
        ArrayList<Statement> statementList = new ArrayList<Statement>(4);
        for (GroovyParser.SwitchLabelContext switchLabelContext : ctx.switchLabel()) {
            Object pair = this.visitSwitchLabel(switchLabelContext);
            boolean isLast = labelCnt - 1 == statementList.size();
            switch (((groovyjarjarantlr4.v4.runtime.Token)((Pair)pair).getKey()).getType()) {
                case 16: {
                    if (!DefaultGroovyMethods.asBoolean(statementList)) {
                        firstLabelHolder.add(((Pair)pair).getKey());
                    }
                    statementList.add(this.configureAST(new CaseStatement((Expression)((Pair)pair).getValue(), isLast ? this.visitBlockStatements(ctx.blockStatements()) : EmptyStatement.INSTANCE), (groovyjarjarantlr4.v4.runtime.Token)firstLabelHolder.get(0)));
                    break;
                }
                case 21: {
                    BlockStatement blockStatement = this.visitBlockStatements(ctx.blockStatements());
                    blockStatement.putNodeMetaData(IS_SWITCH_DEFAULT, true);
                    statementList.add(blockStatement);
                    break;
                }
            }
        }
        return statementList;
    }

    @Override
    public Pair<groovyjarjarantlr4.v4.runtime.Token, Expression> visitSwitchLabel(GroovyParser.SwitchLabelContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.CASE())) {
            return new Pair<groovyjarjarantlr4.v4.runtime.Token, Expression>(ctx.CASE().getSymbol(), (Expression)this.visit(ctx.expression()));
        }
        if (DefaultGroovyMethods.asBoolean(ctx.DEFAULT())) {
            return new Pair<groovyjarjarantlr4.v4.runtime.Token, Expression>(ctx.DEFAULT().getSymbol(), EmptyExpression.INSTANCE);
        }
        throw this.createParsingFailedException("Unsupported switch label: " + ctx.getText(), ctx);
    }

    @Override
    public SynchronizedStatement visitSynchronizedStmtAlt(GroovyParser.SynchronizedStmtAltContext ctx) {
        return this.configureAST(new SynchronizedStatement(this.visitExpressionInPar(ctx.expressionInPar()), this.visitBlock(ctx.block())), ctx);
    }

    @Override
    public ExpressionStatement visitExpressionStmtAlt(GroovyParser.ExpressionStmtAltContext ctx) {
        return (ExpressionStatement)this.visit(ctx.statementExpression());
    }

    @Override
    public ReturnStatement visitReturnStmtAlt(GroovyParser.ReturnStmtAltContext ctx) {
        return this.configureAST(new ReturnStatement(DefaultGroovyMethods.asBoolean(ctx.expression()) ? (Expression)this.visit(ctx.expression()) : ConstantExpression.EMPTY_EXPRESSION), ctx);
    }

    @Override
    public ThrowStatement visitThrowStmtAlt(GroovyParser.ThrowStmtAltContext ctx) {
        return this.configureAST(new ThrowStatement((Expression)this.visit(ctx.expression())), ctx);
    }

    @Override
    public Statement visitLabeledStmtAlt(GroovyParser.LabeledStmtAltContext ctx) {
        Statement statement = (Statement)this.visit(ctx.statement());
        statement.addStatementLabel(this.visitIdentifier(ctx.identifier()));
        return statement;
    }

    @Override
    public BreakStatement visitBreakStatement(GroovyParser.BreakStatementContext ctx) {
        String label = DefaultGroovyMethods.asBoolean(ctx.identifier()) ? this.visitIdentifier(ctx.identifier()) : null;
        return this.configureAST(new BreakStatement(label), ctx);
    }

    @Override
    public BreakStatement visitBreakStmtAlt(GroovyParser.BreakStmtAltContext ctx) {
        return this.configureAST(this.visitBreakStatement(ctx.breakStatement()), ctx);
    }

    @Override
    public ContinueStatement visitContinueStatement(GroovyParser.ContinueStatementContext ctx) {
        String label = DefaultGroovyMethods.asBoolean(ctx.identifier()) ? this.visitIdentifier(ctx.identifier()) : null;
        return this.configureAST(new ContinueStatement(label), ctx);
    }

    @Override
    public ContinueStatement visitContinueStmtAlt(GroovyParser.ContinueStmtAltContext ctx) {
        return this.configureAST(this.visitContinueStatement(ctx.continueStatement()), ctx);
    }

    @Override
    public ImportNode visitImportStmtAlt(GroovyParser.ImportStmtAltContext ctx) {
        return this.configureAST(this.visitImportDeclaration(ctx.importDeclaration()), ctx);
    }

    @Override
    public ClassNode visitTypeDeclarationStmtAlt(GroovyParser.TypeDeclarationStmtAltContext ctx) {
        return this.configureAST(this.visitTypeDeclaration(ctx.typeDeclaration()), ctx);
    }

    @Override
    public Statement visitLocalVariableDeclarationStmtAlt(GroovyParser.LocalVariableDeclarationStmtAltContext ctx) {
        return this.configureAST(this.visitLocalVariableDeclaration(ctx.localVariableDeclaration()), ctx);
    }

    @Override
    public MethodNode visitMethodDeclarationStmtAlt(GroovyParser.MethodDeclarationStmtAltContext ctx) {
        return this.configureAST(this.visitMethodDeclaration(ctx.methodDeclaration()), ctx);
    }

    @Override
    public ClassNode visitTypeDeclaration(GroovyParser.TypeDeclarationContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.classDeclaration())) {
            ctx.classDeclaration().putNodeMetaData(TYPE_DECLARATION_MODIFIERS, this.visitClassOrInterfaceModifiersOpt(ctx.classOrInterfaceModifiersOpt()));
            return this.configureAST(this.visitClassDeclaration(ctx.classDeclaration()), ctx);
        }
        throw this.createParsingFailedException("Unsupported type declaration: " + ctx.getText(), ctx);
    }

    private void initUsingGenerics(ClassNode classNode) {
        if (classNode.isUsingGenerics()) {
            return;
        }
        if (!classNode.isEnum()) {
            classNode.setUsingGenerics(classNode.getSuperClass().isUsingGenerics());
        }
        if (!classNode.isUsingGenerics() && null != classNode.getInterfaces()) {
            for (ClassNode anInterface : classNode.getInterfaces()) {
                classNode.setUsingGenerics(classNode.isUsingGenerics() || anInterface.isUsingGenerics());
                if (classNode.isUsingGenerics()) break;
            }
        }
    }

    @Override
    public ClassNode visitClassDeclaration(GroovyParser.ClassDeclarationContext ctx) {
        String packageName = this.moduleNode.getPackageName();
        packageName = null != packageName ? packageName : "";
        List modifierNodeList = (List)ctx.getNodeMetaData(TYPE_DECLARATION_MODIFIERS);
        Objects.requireNonNull(modifierNodeList, "modifierNodeList should not be null");
        ModifierManager modifierManager = new ModifierManager(this, modifierNodeList);
        int modifiers = modifierManager.getClassModifiersOpValue();
        boolean syntheticPublic = (modifiers & 0x1000) != 0;
        ClassNode outerClass = this.classNodeStack.peek();
        String className = this.visitIdentifier(ctx.identifier());
        ClassNode classNode = DefaultGroovyMethods.asBoolean(ctx.ENUM()) ? EnumHelper.makeEnumNode(DefaultGroovyMethods.asBoolean(outerClass) ? className : packageName + className, modifiers, null, outerClass) : (DefaultGroovyMethods.asBoolean(outerClass) ? new InnerClassNode(outerClass, outerClass.getName() + DOLLAR_STR + className, modifiers | (outerClass.isInterface() ? 8 : 0), ClassHelper.OBJECT_TYPE) : new ClassNode(packageName + className, modifiers &= 0xFFFFEFFF, ClassHelper.OBJECT_TYPE));
        this.configureAST(classNode, ctx);
        classNode.putNodeMetaData(CLASS_NAME, className);
        classNode.setSyntheticPublic(syntheticPublic);
        if (DefaultGroovyMethods.asBoolean(ctx.TRAIT())) {
            classNode.addAnnotation(new AnnotationNode(ClassHelper.make(GROOVY_TRANSFORM_TRAIT)));
        }
        classNode.addAnnotations(modifierManager.getAnnotations());
        classNode.setGenericsTypes(this.visitTypeParameters(ctx.typeParameters()));
        boolean isInterface = DefaultGroovyMethods.asBoolean(ctx.INTERFACE()) && !DefaultGroovyMethods.asBoolean(ctx.AT());
        boolean isInterfaceWithDefaultMethods = false;
        if (isInterface && this.containsDefaultMethods(ctx)) {
            isInterfaceWithDefaultMethods = true;
            classNode.addAnnotation(new AnnotationNode(ClassHelper.make(GROOVY_TRANSFORM_TRAIT)));
            classNode.putNodeMetaData(IS_INTERFACE_WITH_DEFAULT_METHODS, true);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.CLASS()) || DefaultGroovyMethods.asBoolean(ctx.TRAIT()) || isInterfaceWithDefaultMethods) {
            classNode.setSuperClass(this.visitType(ctx.sc));
            classNode.setInterfaces(this.visitTypeList(ctx.is));
            this.initUsingGenerics(classNode);
        } else if (isInterface) {
            classNode.setModifiers(classNode.getModifiers() | 0x200 | 0x400);
            classNode.setSuperClass(ClassHelper.OBJECT_TYPE);
            classNode.setInterfaces(this.visitTypeList(ctx.scs));
            this.initUsingGenerics(classNode);
            this.hackMixins(classNode);
        } else if (DefaultGroovyMethods.asBoolean(ctx.ENUM())) {
            classNode.setModifiers(classNode.getModifiers() | 0x4000 | 0x10);
            classNode.setInterfaces(this.visitTypeList(ctx.is));
            this.initUsingGenerics(classNode);
        } else if (DefaultGroovyMethods.asBoolean(ctx.AT())) {
            classNode.setModifiers(classNode.getModifiers() | 0x200 | 0x400 | 0x2000);
            classNode.addInterface(ClassHelper.Annotation_TYPE);
            this.hackMixins(classNode);
        } else {
            throw this.createParsingFailedException("Unsupported class declaration: " + ctx.getText(), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.CLASS()) || DefaultGroovyMethods.asBoolean(ctx.TRAIT())) {
            this.classNodeList.add(classNode);
        }
        int oldAnonymousInnerClassCounter = this.anonymousInnerClassCounter;
        this.classNodeStack.push(classNode);
        ctx.classBody().putNodeMetaData(CLASS_DECLARATION_CLASS_NODE, classNode);
        this.visitClassBody(ctx.classBody());
        this.classNodeStack.pop();
        this.anonymousInnerClassCounter = oldAnonymousInnerClassCounter;
        if (!DefaultGroovyMethods.asBoolean(ctx.CLASS()) && !DefaultGroovyMethods.asBoolean(ctx.TRAIT())) {
            this.classNodeList.add(classNode);
        }
        this.groovydocManager.handle(classNode, ctx);
        return classNode;
    }

    private boolean containsDefaultMethods(GroovyParser.ClassDeclarationContext ctx) {
        for (GroovyParser.ClassBodyDeclarationContext classBodyDeclarationContext : ctx.classBody().classBodyDeclaration()) {
            GroovyParser.MethodDeclarationContext methodDeclarationContext;
            GroovyParser.MemberDeclarationContext memberDeclarationContext = classBodyDeclarationContext.memberDeclaration();
            if (memberDeclarationContext == null || (methodDeclarationContext = memberDeclarationContext.methodDeclaration()) == null || !this.createModifierManager(methodDeclarationContext).contains(21)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Void visitClassBody(GroovyParser.ClassBodyContext ctx) {
        ClassNode classNode = (ClassNode)ctx.getNodeMetaData(CLASS_DECLARATION_CLASS_NODE);
        Objects.requireNonNull(classNode, "classNode should not be null");
        if (DefaultGroovyMethods.asBoolean(ctx.enumConstants())) {
            ctx.enumConstants().putNodeMetaData(CLASS_DECLARATION_CLASS_NODE, classNode);
            this.visitEnumConstants(ctx.enumConstants());
        }
        for (GroovyParser.ClassBodyDeclarationContext classBodyDeclarationContext : ctx.classBodyDeclaration()) {
            classBodyDeclarationContext.putNodeMetaData(CLASS_DECLARATION_CLASS_NODE, classNode);
            this.visitClassBodyDeclaration(classBodyDeclarationContext);
        }
        return null;
    }

    @Override
    public List<FieldNode> visitEnumConstants(GroovyParser.EnumConstantsContext ctx) {
        ClassNode classNode = (ClassNode)ctx.getNodeMetaData(CLASS_DECLARATION_CLASS_NODE);
        Objects.requireNonNull(classNode, "classNode should not be null");
        LinkedList<FieldNode> list = new LinkedList<FieldNode>();
        for (GroovyParser.EnumConstantContext enumConstantContext : ctx.enumConstant()) {
            enumConstantContext.putNodeMetaData(CLASS_DECLARATION_CLASS_NODE, classNode);
            list.add(this.visitEnumConstant(enumConstantContext));
        }
        return list;
    }

    @Override
    public FieldNode visitEnumConstant(GroovyParser.EnumConstantContext ctx) {
        ClassNode classNode = (ClassNode)ctx.getNodeMetaData(CLASS_DECLARATION_CLASS_NODE);
        Objects.requireNonNull(classNode, "classNode should not be null");
        InnerClassNode anonymousInnerClassNode = null;
        if (DefaultGroovyMethods.asBoolean(ctx.anonymousInnerClassDeclaration())) {
            ctx.anonymousInnerClassDeclaration().putNodeMetaData(ANONYMOUS_INNER_CLASS_SUPER_CLASS, classNode);
            anonymousInnerClassNode = this.visitAnonymousInnerClassDeclaration(ctx.anonymousInnerClassDeclaration());
        }
        FieldNode enumConstant = EnumHelper.addEnumConstant(classNode, this.visitIdentifier(ctx.identifier()), this.createEnumConstantInitExpression(ctx.arguments(), anonymousInnerClassNode));
        enumConstant.addAnnotations((List<AnnotationNode>)this.visitAnnotationsOpt(ctx.annotationsOpt()));
        this.groovydocManager.handle(enumConstant, ctx);
        return this.configureAST(enumConstant, ctx);
    }

    private Expression createEnumConstantInitExpression(GroovyParser.ArgumentsContext ctx, InnerClassNode anonymousInnerClassNode) {
        if (!DefaultGroovyMethods.asBoolean(ctx) && !DefaultGroovyMethods.asBoolean(anonymousInnerClassNode)) {
            return null;
        }
        TupleExpression argumentListExpression = (TupleExpression)this.visitArguments(ctx);
        List<Expression> expressions = argumentListExpression.getExpressions();
        if (expressions.size() == 1) {
            Expression expression = expressions.get(0);
            if (expression instanceof NamedArgumentListExpression) {
                List<MapEntryExpression> mapEntryExpressionList = ((NamedArgumentListExpression)expression).getMapEntryExpressions();
                ArrayList<Expression> list = new ArrayList<Expression>();
                Iterator<MapEntryExpression> iterator = mapEntryExpressionList.iterator();
                while (iterator.hasNext()) {
                    MapEntryExpression e;
                    MapEntryExpression e1 = e = iterator.next();
                    list.add(e1);
                }
                ListExpression listExpression = new ListExpression(list);
                if (DefaultGroovyMethods.asBoolean(anonymousInnerClassNode)) {
                    listExpression.addExpression(this.configureAST(new ClassExpression(anonymousInnerClassNode), anonymousInnerClassNode));
                }
                if (mapEntryExpressionList.size() > 1) {
                    listExpression.setWrapped(true);
                }
                return this.configureAST(listExpression, ctx);
            }
            if (!DefaultGroovyMethods.asBoolean(anonymousInnerClassNode)) {
                if (expression instanceof ListExpression) {
                    ListExpression listExpression = new ListExpression();
                    listExpression.addExpression(expression);
                    return this.configureAST(listExpression, ctx);
                }
                return expression;
            }
            ListExpression listExpression = new ListExpression();
            if (expression instanceof ListExpression) {
                for (Expression e : ((ListExpression)expression).getExpressions()) {
                    listExpression.addExpression(e);
                }
            } else {
                listExpression.addExpression(expression);
            }
            listExpression.addExpression(this.configureAST(new ClassExpression(anonymousInnerClassNode), anonymousInnerClassNode));
            return this.configureAST(listExpression, ctx);
        }
        ListExpression listExpression = new ListExpression(expressions);
        if (DefaultGroovyMethods.asBoolean(anonymousInnerClassNode)) {
            listExpression.addExpression(this.configureAST(new ClassExpression(anonymousInnerClassNode), anonymousInnerClassNode));
        }
        if (DefaultGroovyMethods.asBoolean(ctx)) {
            listExpression.setWrapped(true);
        }
        return DefaultGroovyMethods.asBoolean(ctx) ? this.configureAST(listExpression, ctx) : this.configureAST(listExpression, anonymousInnerClassNode);
    }

    @Override
    public Void visitClassBodyDeclaration(GroovyParser.ClassBodyDeclarationContext ctx) {
        ClassNode classNode = (ClassNode)ctx.getNodeMetaData(CLASS_DECLARATION_CLASS_NODE);
        Objects.requireNonNull(classNode, "classNode should not be null");
        if (DefaultGroovyMethods.asBoolean(ctx.memberDeclaration())) {
            ctx.memberDeclaration().putNodeMetaData(CLASS_DECLARATION_CLASS_NODE, classNode);
            this.visitMemberDeclaration(ctx.memberDeclaration());
        } else if (DefaultGroovyMethods.asBoolean(ctx.block())) {
            Statement statement = this.visitBlock(ctx.block());
            if (DefaultGroovyMethods.asBoolean(ctx.STATIC())) {
                classNode.addStaticInitializerStatements(Collections.singletonList(statement), false);
            } else {
                classNode.addObjectInitializerStatements(this.configureAST(this.createBlockStatement(statement), statement));
            }
        }
        return null;
    }

    @Override
    public Void visitMemberDeclaration(GroovyParser.MemberDeclarationContext ctx) {
        ClassNode classNode = (ClassNode)ctx.getNodeMetaData(CLASS_DECLARATION_CLASS_NODE);
        Objects.requireNonNull(classNode, "classNode should not be null");
        if (DefaultGroovyMethods.asBoolean(ctx.methodDeclaration())) {
            ctx.methodDeclaration().putNodeMetaData(CLASS_DECLARATION_CLASS_NODE, classNode);
            this.visitMethodDeclaration(ctx.methodDeclaration());
        } else if (DefaultGroovyMethods.asBoolean(ctx.fieldDeclaration())) {
            ctx.fieldDeclaration().putNodeMetaData(CLASS_DECLARATION_CLASS_NODE, classNode);
            this.visitFieldDeclaration(ctx.fieldDeclaration());
        } else if (DefaultGroovyMethods.asBoolean(ctx.classDeclaration())) {
            ctx.classDeclaration().putNodeMetaData(TYPE_DECLARATION_MODIFIERS, this.visitModifiersOpt(ctx.modifiersOpt()));
            ctx.classDeclaration().putNodeMetaData(CLASS_DECLARATION_CLASS_NODE, classNode);
            this.visitClassDeclaration(ctx.classDeclaration());
        }
        return null;
    }

    @Override
    public GenericsType[] visitTypeParameters(GroovyParser.TypeParametersContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return null;
        }
        ArrayList<GenericsType> list = new ArrayList<GenericsType>();
        for (GroovyParser.TypeParameterContext typeParameterContext : ctx.typeParameter()) {
            GenericsType genericsType = this.visitTypeParameter(typeParameterContext);
            list.add(genericsType);
        }
        return list.toArray(new GenericsType[0]);
    }

    @Override
    public GenericsType visitTypeParameter(GroovyParser.TypeParameterContext ctx) {
        return this.configureAST(new GenericsType(this.configureAST(ClassHelper.make(this.visitClassName(ctx.className())), ctx), this.visitTypeBound(ctx.typeBound()), null), ctx);
    }

    @Override
    public ClassNode[] visitTypeBound(GroovyParser.TypeBoundContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return null;
        }
        ArrayList<ClassNode> list = new ArrayList<ClassNode>();
        for (GroovyParser.TypeContext typeContext : ctx.type()) {
            ClassNode classNode = this.visitType(typeContext);
            list.add(classNode);
        }
        return list.toArray(new ClassNode[0]);
    }

    @Override
    public Void visitFieldDeclaration(GroovyParser.FieldDeclarationContext ctx) {
        ClassNode classNode = (ClassNode)ctx.getNodeMetaData(CLASS_DECLARATION_CLASS_NODE);
        Objects.requireNonNull(classNode, "classNode should not be null");
        ctx.variableDeclaration().putNodeMetaData(CLASS_DECLARATION_CLASS_NODE, classNode);
        this.visitVariableDeclaration(ctx.variableDeclaration());
        return null;
    }

    private ConstructorCallExpression checkThisAndSuperConstructorCall(Statement statement) {
        if (!(statement instanceof BlockStatement)) {
            return null;
        }
        BlockStatement blockStatement = (BlockStatement)statement;
        List<Statement> statementList = blockStatement.getStatements();
        int n = statementList.size();
        for (int i = 0; i < n; ++i) {
            Expression expression;
            Statement s = statementList.get(i);
            if (!(s instanceof ExpressionStatement) || !((expression = ((ExpressionStatement)s).getExpression()) instanceof ConstructorCallExpression) || 0 == i) continue;
            return (ConstructorCallExpression)expression;
        }
        return null;
    }

    private ModifierManager createModifierManager(GroovyParser.MethodDeclarationContext ctx) {
        Object modifierNodeList = Collections.emptyList();
        if (DefaultGroovyMethods.asBoolean(ctx.modifiers())) {
            modifierNodeList = this.visitModifiers(ctx.modifiers());
        } else if (DefaultGroovyMethods.asBoolean(ctx.modifiersOpt())) {
            modifierNodeList = this.visitModifiersOpt(ctx.modifiersOpt());
        }
        return new ModifierManager(this, (List<ModifierNode>)modifierNodeList);
    }

    private void validateParametersOfMethodDeclaration(Parameter[] parameters, ClassNode classNode) {
        if (!classNode.isInterface()) {
            return;
        }
        for (Parameter e : parameters) {
            if (!e.hasInitialExpression()) continue;
            throw this.createParsingFailedException("Cannot specify default value for method parameter '" + e.getName() + " = " + e.getInitialExpression().getText() + "' inside an interface", e);
        }
    }

    @Override
    public MethodNode visitMethodDeclaration(GroovyParser.MethodDeclarationContext ctx) {
        MethodNode methodNode;
        ModifierManager modifierManager = this.createModifierManager(ctx);
        String methodName = this.visitMethodName(ctx.methodName());
        ClassNode returnType = this.visitReturnType(ctx.returnType());
        Parameter[] parameters = this.visitFormalParameters(ctx.formalParameters());
        ClassNode[] exceptions = this.visitQualifiedClassNameList(ctx.qualifiedClassNameList());
        this.anonymousInnerClassesDefinedInMethodStack.push(new LinkedList());
        Statement code = this.visitMethodBody(ctx.methodBody());
        List<InnerClassNode> anonymousInnerClassList = this.anonymousInnerClassesDefinedInMethodStack.pop();
        ClassNode classNode = (ClassNode)ctx.getNodeMetaData(CLASS_DECLARATION_CLASS_NODE);
        if (DefaultGroovyMethods.asBoolean(classNode)) {
            this.validateParametersOfMethodDeclaration(parameters, classNode);
            methodNode = this.createConstructorOrMethodNodeForClass(ctx, modifierManager, methodName, returnType, parameters, exceptions, code, classNode);
        } else {
            methodNode = this.createScriptMethodNode(modifierManager, methodName, returnType, parameters, exceptions, code);
        }
        for (InnerClassNode e : anonymousInnerClassList) {
            e.setEnclosingMethod(methodNode);
        }
        methodNode.setGenericsTypes(this.visitTypeParameters(ctx.typeParameters()));
        methodNode.setSyntheticPublic(this.isSyntheticPublic(this.isAnnotationDeclaration(classNode), classNode instanceof EnumConstantClassNode, DefaultGroovyMethods.asBoolean(ctx.returnType()), modifierManager));
        if (modifierManager.contains(42)) {
            for (Parameter e : methodNode.getParameters()) {
                e.setInStaticContext(true);
            }
            methodNode.getVariableScope().setInStaticContext(true);
        }
        this.configureAST(methodNode, ctx);
        this.validateMethodDeclaration(ctx, methodNode, modifierManager, classNode);
        this.groovydocManager.handle(methodNode, ctx);
        return methodNode;
    }

    private void validateMethodDeclaration(GroovyParser.MethodDeclarationContext ctx, MethodNode methodNode, ModifierManager modifierManager, ClassNode classNode) {
        boolean isAbstractMethod = methodNode.isAbstract();
        boolean hasMethodBody = DefaultGroovyMethods.asBoolean(methodNode.getCode());
        if (9 == ctx.ct) {
            if (isAbstractMethod || !hasMethodBody) {
                throw this.createParsingFailedException("You can not define a " + (isAbstractMethod ? "abstract" : "") + " method[" + methodNode.getName() + "] " + (!hasMethodBody ? "without method body" : "") + " in the script. Try " + (isAbstractMethod ? "removing the 'abstract'" : "") + (isAbstractMethod && !hasMethodBody ? " and" : "") + (!hasMethodBody ? " adding a method body" : ""), methodNode);
            }
        } else {
            boolean isInterfaceOrAbstractClass;
            if (!isAbstractMethod && !hasMethodBody) {
                throw this.createParsingFailedException("You defined a method[" + methodNode.getName() + "] without body. Try adding a method body, or declare it abstract", methodNode);
            }
            boolean bl = isInterfaceOrAbstractClass = DefaultGroovyMethods.asBoolean(classNode) && classNode.isAbstract() && !classNode.isAnnotationDefinition();
            if (isInterfaceOrAbstractClass && !modifierManager.contains(21) && isAbstractMethod && hasMethodBody) {
                throw this.createParsingFailedException("You defined an abstract method[" + methodNode.getName() + "] with body. Try removing the method body" + (classNode.isInterface() ? ", or declare it default" : ""), methodNode);
            }
        }
        modifierManager.validate(methodNode);
        if (methodNode instanceof ConstructorNode) {
            modifierManager.validate((ConstructorNode)methodNode);
        }
    }

    private MethodNode createScriptMethodNode(ModifierManager modifierManager, String methodName, ClassNode returnType, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        MethodNode methodNode = new MethodNode(methodName, modifierManager.contains(38) ? 2 : 1, returnType, parameters, exceptions, code);
        modifierManager.processMethodNode(methodNode);
        return methodNode;
    }

    private MethodNode createConstructorOrMethodNodeForClass(GroovyParser.MethodDeclarationContext ctx, ModifierManager modifierManager, String methodName, ClassNode returnType, Parameter[] parameters, ClassNode[] exceptions, Statement code, ClassNode classNode) {
        MethodNode methodNode;
        String className = (String)classNode.getNodeMetaData(CLASS_NAME);
        int modifiers = modifierManager.getClassMemberModifiersOpValue();
        boolean hasReturnType = DefaultGroovyMethods.asBoolean(ctx.returnType());
        boolean hasMethodBody = DefaultGroovyMethods.asBoolean(ctx.methodBody());
        if (!hasReturnType && hasMethodBody && methodName.equals(className)) {
            methodNode = this.createConstructorNodeForClass(methodName, parameters, exceptions, code, classNode, modifiers);
        } else {
            if (!hasReturnType && hasMethodBody && 0 == modifierManager.getModifierCount()) {
                throw this.createParsingFailedException("Invalid method declaration: " + methodName, ctx);
            }
            methodNode = this.createMethodNodeForClass(ctx, modifierManager, methodName, returnType, parameters, exceptions, code, classNode, modifiers);
        }
        modifierManager.attachAnnotations(methodNode);
        return methodNode;
    }

    private MethodNode createMethodNodeForClass(GroovyParser.MethodDeclarationContext ctx, ModifierManager modifierManager, String methodName, ClassNode returnType, Parameter[] parameters, ClassNode[] exceptions, Statement code, ClassNode classNode, int modifiers) {
        if (DefaultGroovyMethods.asBoolean(ctx.elementValue())) {
            code = this.configureAST(new ExpressionStatement(this.visitElementValue(ctx.elementValue())), ctx.elementValue());
        }
        int n = !modifierManager.contains(42) && (classNode.isInterface() || this.isTrue(classNode, IS_INTERFACE_WITH_DEFAULT_METHODS) && !modifierManager.contains(21)) ? 1024 : 0;
        this.checkWhetherMethodNodeWithSameSignatureExists(classNode, methodName, parameters, ctx);
        MethodNode methodNode = classNode.addMethod(methodName, modifiers |= n, returnType, parameters, exceptions, code);
        methodNode.setAnnotationDefault(DefaultGroovyMethods.asBoolean(ctx.elementValue()));
        return methodNode;
    }

    private void checkWhetherMethodNodeWithSameSignatureExists(ClassNode classNode, String methodName, Parameter[] parameters, GroovyParser.MethodDeclarationContext ctx) {
        MethodNode sameSigMethodNode = classNode.getDeclaredMethod(methodName, parameters);
        if (null == sameSigMethodNode) {
            return;
        }
        throw this.createParsingFailedException("The method " + sameSigMethodNode.getText() + " duplicates another method of the same signature", ctx);
    }

    private ConstructorNode createConstructorNodeForClass(String methodName, Parameter[] parameters, ClassNode[] exceptions, Statement code, ClassNode classNode, int modifiers) {
        ConstructorCallExpression thisOrSuperConstructorCallExpression = this.checkThisAndSuperConstructorCall(code);
        if (DefaultGroovyMethods.asBoolean(thisOrSuperConstructorCallExpression)) {
            throw this.createParsingFailedException(thisOrSuperConstructorCallExpression.getText() + " should be the first statement in the constructor[" + methodName + "]", thisOrSuperConstructorCallExpression);
        }
        return classNode.addConstructor(modifiers, parameters, exceptions, code);
    }

    @Override
    public String visitMethodName(GroovyParser.MethodNameContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.identifier())) {
            return this.visitIdentifier(ctx.identifier());
        }
        if (DefaultGroovyMethods.asBoolean(ctx.stringLiteral())) {
            return this.visitStringLiteral(ctx.stringLiteral()).getText();
        }
        throw this.createParsingFailedException("Unsupported method name: " + ctx.getText(), ctx);
    }

    @Override
    public ClassNode visitReturnType(GroovyParser.ReturnTypeContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return ClassHelper.OBJECT_TYPE;
        }
        if (DefaultGroovyMethods.asBoolean(ctx.type())) {
            return this.visitType(ctx.type());
        }
        if (DefaultGroovyMethods.asBoolean(ctx.VOID())) {
            return ClassHelper.VOID_TYPE;
        }
        throw this.createParsingFailedException("Unsupported return type: " + ctx.getText(), ctx);
    }

    @Override
    public Statement visitMethodBody(GroovyParser.MethodBodyContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return null;
        }
        return this.configureAST(this.visitBlock(ctx.block()), ctx);
    }

    @Override
    public DeclarationListStatement visitLocalVariableDeclaration(GroovyParser.LocalVariableDeclarationContext ctx) {
        return this.configureAST(this.visitVariableDeclaration(ctx.variableDeclaration()), ctx);
    }

    private ModifierManager createModifierManager(GroovyParser.VariableDeclarationContext ctx) {
        Object modifierNodeList = Collections.emptyList();
        if (DefaultGroovyMethods.asBoolean(ctx.variableModifiers())) {
            modifierNodeList = this.visitVariableModifiers(ctx.variableModifiers());
        } else if (DefaultGroovyMethods.asBoolean(ctx.variableModifiersOpt())) {
            modifierNodeList = this.visitVariableModifiersOpt(ctx.variableModifiersOpt());
        } else if (DefaultGroovyMethods.asBoolean(ctx.modifiers())) {
            modifierNodeList = this.visitModifiers(ctx.modifiers());
        } else if (DefaultGroovyMethods.asBoolean(ctx.modifiersOpt())) {
            modifierNodeList = this.visitModifiersOpt(ctx.modifiersOpt());
        }
        return new ModifierManager(this, (List<ModifierNode>)modifierNodeList);
    }

    private DeclarationListStatement createMultiAssignmentDeclarationListStatement(GroovyParser.VariableDeclarationContext ctx, ModifierManager modifierManager) {
        if (!modifierManager.contains(8)) {
            throw this.createParsingFailedException("keyword def is required to declare tuple, e.g. def (int a, int b) = [1, 2]", ctx);
        }
        ArrayList<Expression> list = new ArrayList<Expression>();
        Iterator iterator = this.visitTypeNamePairs(ctx.typeNamePairs()).iterator();
        while (iterator.hasNext()) {
            Expression e = (Expression)iterator.next();
            modifierManager.processVariableExpression((VariableExpression)e);
            list.add(e);
        }
        return this.configureAST(new DeclarationListStatement(this.configureAST(modifierManager.attachAnnotations(new DeclarationExpression(new ArgumentListExpression(list), this.createGroovyTokenByType(ctx.ASSIGN().getSymbol(), 100), this.visitVariableInitializer(ctx.variableInitializer()))), ctx)), ctx);
    }

    @Override
    public DeclarationListStatement visitVariableDeclaration(GroovyParser.VariableDeclarationContext ctx) {
        ModifierManager modifierManager = this.createModifierManager(ctx);
        if (DefaultGroovyMethods.asBoolean(ctx.typeNamePairs())) {
            return this.createMultiAssignmentDeclarationListStatement(ctx, modifierManager);
        }
        ClassNode variableType = this.visitType(ctx.type());
        ctx.variableDeclarators().putNodeMetaData(VARIABLE_DECLARATION_VARIABLE_TYPE, variableType);
        Object declarationExpressionList = this.visitVariableDeclarators(ctx.variableDeclarators());
        ClassNode classNode = (ClassNode)ctx.getNodeMetaData(CLASS_DECLARATION_CLASS_NODE);
        if (DefaultGroovyMethods.asBoolean(classNode)) {
            return this.createFieldDeclarationListStatement(ctx, modifierManager, variableType, (List<DeclarationExpression>)declarationExpressionList, classNode);
        }
        Iterator iterator = declarationExpressionList.iterator();
        while (iterator.hasNext()) {
            DeclarationExpression e = (DeclarationExpression)iterator.next();
            VariableExpression variableExpression = (VariableExpression)e.getLeftExpression();
            modifierManager.processVariableExpression(variableExpression);
            modifierManager.attachAnnotations(e);
        }
        int size = declarationExpressionList.size();
        if (size > 0) {
            DeclarationExpression declarationExpression = (DeclarationExpression)declarationExpressionList.get(0);
            if (1 == size) {
                this.configureAST(declarationExpression, ctx);
            } else {
                declarationExpression.setLineNumber(ctx.getStart().getLine());
                declarationExpression.setColumnNumber(ctx.getStart().getCharPositionInLine() + 1);
            }
        }
        return this.configureAST(new DeclarationListStatement((List<DeclarationExpression>)declarationExpressionList), ctx);
    }

    private DeclarationListStatement createFieldDeclarationListStatement(GroovyParser.VariableDeclarationContext ctx, ModifierManager modifierManager, ClassNode variableType, List<DeclarationExpression> declarationExpressionList, ClassNode classNode) {
        int n = declarationExpressionList.size();
        for (int i = 0; i < n; ++i) {
            DeclarationExpression declarationExpression = declarationExpressionList.get(i);
            VariableExpression variableExpression = (VariableExpression)declarationExpression.getLeftExpression();
            String fieldName = variableExpression.getName();
            int modifiers = modifierManager.getClassMemberModifiersOpValue();
            Expression initialValue = EmptyExpression.INSTANCE.equals(declarationExpression.getRightExpression()) ? null : declarationExpression.getRightExpression();
            Object defaultValue = this.findDefaultValueByType(variableType);
            if (classNode.isInterface()) {
                if (!DefaultGroovyMethods.asBoolean(initialValue)) {
                    initialValue = !DefaultGroovyMethods.asBoolean(defaultValue) ? null : new ConstantExpression(defaultValue);
                }
                modifiers |= 0x19;
            }
            if (this.isFieldDeclaration(modifierManager, classNode)) {
                this.declareField(ctx, modifierManager, variableType, classNode, i, variableExpression, fieldName, modifiers, initialValue);
                continue;
            }
            this.declareProperty(ctx, modifierManager, variableType, classNode, i, variableExpression, fieldName, modifiers, initialValue);
        }
        return null;
    }

    private void declareProperty(GroovyParser.VariableDeclarationContext ctx, ModifierManager modifierManager, ClassNode variableType, ClassNode classNode, int i, VariableExpression variableExpression, String fieldName, int modifiers, Expression initialValue) {
        PropertyNode propertyNode;
        if (classNode.hasProperty(fieldName)) {
            throw this.createParsingFailedException("The property '" + fieldName + "' is declared multiple times", ctx);
        }
        FieldNode fieldNode = classNode.getDeclaredField(fieldName);
        if (fieldNode != null && !classNode.hasProperty(fieldName)) {
            classNode.getFields().remove(fieldNode);
            propertyNode = new PropertyNode(fieldNode, modifiers | 1, null, null);
            classNode.addProperty(propertyNode);
        } else {
            propertyNode = classNode.addProperty(fieldName, modifiers | 1, variableType, initialValue, null, null);
            fieldNode = propertyNode.getField();
        }
        fieldNode.setModifiers(modifiers & 0xFFFFFFFE | 2);
        fieldNode.setSynthetic(!classNode.isInterface());
        modifierManager.attachAnnotations(fieldNode);
        this.groovydocManager.handle(fieldNode, ctx);
        this.groovydocManager.handle(propertyNode, ctx);
        if (0 == i) {
            this.configureAST(fieldNode, ctx, (ASTNode)initialValue);
            this.configureAST(propertyNode, ctx, (ASTNode)initialValue);
        } else {
            this.configureAST(fieldNode, variableExpression, (ASTNode)initialValue);
            this.configureAST(propertyNode, variableExpression, (ASTNode)initialValue);
        }
    }

    private void declareField(GroovyParser.VariableDeclarationContext ctx, ModifierManager modifierManager, ClassNode variableType, ClassNode classNode, int i, VariableExpression variableExpression, String fieldName, int modifiers, Expression initialValue) {
        FieldNode fieldNode;
        FieldNode existingFieldNode = classNode.getDeclaredField(fieldName);
        if (null != existingFieldNode && !existingFieldNode.isSynthetic()) {
            throw this.createParsingFailedException("The field '" + fieldName + "' is declared multiple times", ctx);
        }
        PropertyNode propertyNode = classNode.getProperty(fieldName);
        if (null != propertyNode && propertyNode.getField().isSynthetic()) {
            classNode.getFields().remove(propertyNode.getField());
            fieldNode = new FieldNode(fieldName, modifiers, variableType, classNode.redirect(), initialValue);
            propertyNode.setField(fieldNode);
            classNode.addField(fieldNode);
        } else {
            fieldNode = classNode.addField(fieldName, modifiers, variableType, initialValue);
        }
        modifierManager.attachAnnotations(fieldNode);
        this.groovydocManager.handle(fieldNode, ctx);
        if (0 == i) {
            this.configureAST(fieldNode, ctx, (ASTNode)initialValue);
        } else {
            this.configureAST(fieldNode, variableExpression, (ASTNode)initialValue);
        }
    }

    private boolean isFieldDeclaration(ModifierManager modifierManager, ClassNode classNode) {
        return classNode.isInterface() || modifierManager.containsVisibilityModifier();
    }

    @Override
    public List<Expression> visitTypeNamePairs(GroovyParser.TypeNamePairsContext ctx) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (GroovyParser.TypeNamePairContext typeNamePairContext : ctx.typeNamePair()) {
            VariableExpression variableExpression = this.visitTypeNamePair(typeNamePairContext);
            list.add(variableExpression);
        }
        return list;
    }

    @Override
    public VariableExpression visitTypeNamePair(GroovyParser.TypeNamePairContext ctx) {
        return this.configureAST(new VariableExpression(this.visitVariableDeclaratorId(ctx.variableDeclaratorId()).getName(), this.visitType(ctx.type())), ctx);
    }

    @Override
    public List<DeclarationExpression> visitVariableDeclarators(GroovyParser.VariableDeclaratorsContext ctx) {
        ClassNode variableType = (ClassNode)ctx.getNodeMetaData(VARIABLE_DECLARATION_VARIABLE_TYPE);
        Objects.requireNonNull(variableType, "variableType should not be null");
        LinkedList<DeclarationExpression> list = new LinkedList<DeclarationExpression>();
        for (GroovyParser.VariableDeclaratorContext variableDeclaratorContext : ctx.variableDeclarator()) {
            variableDeclaratorContext.putNodeMetaData(VARIABLE_DECLARATION_VARIABLE_TYPE, variableType);
            list.add(this.visitVariableDeclarator(variableDeclaratorContext));
        }
        return list;
    }

    @Override
    public DeclarationExpression visitVariableDeclarator(GroovyParser.VariableDeclaratorContext ctx) {
        ClassNode variableType = (ClassNode)ctx.getNodeMetaData(VARIABLE_DECLARATION_VARIABLE_TYPE);
        Objects.requireNonNull(variableType, "variableType should not be null");
        Token token = DefaultGroovyMethods.asBoolean(ctx.ASSIGN()) ? this.createGroovyTokenByType(ctx.ASSIGN().getSymbol(), 100) : new Token(100, ASSIGN_STR, ctx.start.getLine(), 1);
        return this.configureAST(new DeclarationExpression(this.configureAST(new VariableExpression(this.visitVariableDeclaratorId(ctx.variableDeclaratorId()).getName(), variableType), ctx.variableDeclaratorId()), token, this.visitVariableInitializer(ctx.variableInitializer())), ctx);
    }

    @Override
    public Expression visitVariableInitializer(GroovyParser.VariableInitializerContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return EmptyExpression.INSTANCE;
        }
        return this.configureAST(this.visitEnhancedStatementExpression(ctx.enhancedStatementExpression()), ctx);
    }

    @Override
    public List<Expression> visitVariableInitializers(GroovyParser.VariableInitializersContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return Collections.emptyList();
        }
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (GroovyParser.VariableInitializerContext variableInitializerContext : ctx.variableInitializer()) {
            Expression expression = this.visitVariableInitializer(variableInitializerContext);
            list.add(expression);
        }
        return list;
    }

    @Override
    public List<Expression> visitArrayInitializer(GroovyParser.ArrayInitializerContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return Collections.emptyList();
        }
        return this.visitVariableInitializers(ctx.variableInitializers());
    }

    @Override
    public Statement visitBlock(GroovyParser.BlockContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return this.createBlockStatement(new Statement[0]);
        }
        return this.configureAST(this.visitBlockStatementsOpt(ctx.blockStatementsOpt()), ctx);
    }

    @Override
    public ExpressionStatement visitNormalExprAlt(GroovyParser.NormalExprAltContext ctx) {
        return this.configureAST(new ExpressionStatement((Expression)this.visit(ctx.expression())), ctx);
    }

    @Override
    public ExpressionStatement visitCommandExprAlt(GroovyParser.CommandExprAltContext ctx) {
        return this.configureAST(new ExpressionStatement(this.visitCommandExpression(ctx.commandExpression())), ctx);
    }

    @Override
    public Expression visitCommandExpression(GroovyParser.CommandExpressionContext ctx) {
        MethodCallExpression methodCallExpression;
        Expression baseExpr = this.visitPathExpression(ctx.pathExpression());
        Expression arguments = this.visitEnhancedArgumentList(ctx.enhancedArgumentList());
        if (baseExpr instanceof PropertyExpression) {
            methodCallExpression = this.configureAST(this.createMethodCallExpression((PropertyExpression)baseExpr, arguments), arguments);
        } else if (baseExpr instanceof MethodCallExpression && !this.isInsideParentheses(baseExpr)) {
            if (DefaultGroovyMethods.asBoolean(arguments)) {
                throw new GroovyBugError("When baseExpr is a instance of MethodCallExpression, which should follow NO argumentList");
            }
            methodCallExpression = (MethodCallExpression)baseExpr;
        } else {
            methodCallExpression = !this.isInsideParentheses(baseExpr) && (baseExpr instanceof VariableExpression || baseExpr instanceof GStringExpression || baseExpr instanceof ConstantExpression && this.isTrue(baseExpr, IS_STRING)) ? this.configureAST(this.createMethodCallExpression(baseExpr, arguments), arguments) : this.configureAST(this.createCallMethodCallExpression(baseExpr, arguments), arguments);
        }
        if (!DefaultGroovyMethods.asBoolean(ctx.commandArgument())) {
            return this.configureAST(methodCallExpression, ctx);
        }
        Expression r = methodCallExpression;
        for (GroovyParser.CommandArgumentContext commandArgumentContext : ctx.commandArgument()) {
            commandArgumentContext.putNodeMetaData(CMD_EXPRESSION_BASE_EXPR, r);
            r = this.visitCommandArgument(commandArgumentContext);
        }
        return this.configureAST(r, ctx);
    }

    @Override
    public Expression visitCommandArgument(GroovyParser.CommandArgumentContext ctx) {
        Expression baseExpr = (Expression)ctx.getNodeMetaData(CMD_EXPRESSION_BASE_EXPR);
        Expression primaryExpr = (Expression)this.visit(ctx.primary());
        if (DefaultGroovyMethods.asBoolean(ctx.enhancedArgumentList())) {
            if (baseExpr instanceof PropertyExpression) {
                throw this.createParsingFailedException("Unsupported command argument: " + ctx.getText(), ctx);
            }
            MethodCallExpression methodCallExpression = new MethodCallExpression(baseExpr, this.createConstantExpression(primaryExpr), this.visitEnhancedArgumentList(ctx.enhancedArgumentList()));
            methodCallExpression.setImplicitThis(false);
            return this.configureAST(methodCallExpression, ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.pathElement())) {
            Expression pathExpression = this.createPathExpression(this.configureAST(new PropertyExpression(baseExpr, this.createConstantExpression(primaryExpr)), primaryExpr), ctx.pathElement());
            return this.configureAST(pathExpression, ctx);
        }
        return this.configureAST(new PropertyExpression(baseExpr, primaryExpr instanceof VariableExpression ? this.createConstantExpression(primaryExpr) : primaryExpr), primaryExpr);
    }

    @Override
    public ClassNode visitCastParExpression(GroovyParser.CastParExpressionContext ctx) {
        return this.visitType(ctx.type());
    }

    @Override
    public Expression visitParExpression(GroovyParser.ParExpressionContext ctx) {
        Expression expression = this.visitExpressionInPar(ctx.expressionInPar());
        Integer insideParenLevel = (Integer)expression.getNodeMetaData(INSIDE_PARENTHESES_LEVEL);
        if (null != insideParenLevel) {
            Integer n = insideParenLevel;
            Integer n2 = insideParenLevel = Integer.valueOf(insideParenLevel + 1);
        } else {
            insideParenLevel = 1;
        }
        expression.putNodeMetaData(INSIDE_PARENTHESES_LEVEL, insideParenLevel);
        return this.configureAST(expression, ctx);
    }

    @Override
    public Expression visitExpressionInPar(GroovyParser.ExpressionInParContext ctx) {
        return this.visitEnhancedStatementExpression(ctx.enhancedStatementExpression());
    }

    @Override
    public Expression visitEnhancedStatementExpression(GroovyParser.EnhancedStatementExpressionContext ctx) {
        Expression expression;
        if (DefaultGroovyMethods.asBoolean(ctx.statementExpression())) {
            expression = ((ExpressionStatement)this.visit(ctx.statementExpression())).getExpression();
        } else if (DefaultGroovyMethods.asBoolean(ctx.standardLambdaExpression())) {
            expression = this.visitStandardLambdaExpression(ctx.standardLambdaExpression());
        } else {
            throw this.createParsingFailedException("Unsupported enhanced statement expression: " + ctx.getText(), ctx);
        }
        return this.configureAST(expression, ctx);
    }

    @Override
    public Expression visitPathExpression(GroovyParser.PathExpressionContext ctx) {
        return this.createPathExpression((Expression)this.visit(ctx.primary()), ctx.pathElement());
    }

    @Override
    public Expression visitPathElement(GroovyParser.PathElementContext ctx) {
        MethodCallExpression methodCallExpression;
        Expression baseExpr = (Expression)ctx.getNodeMetaData(PATH_EXPRESSION_BASE_EXPR);
        Objects.requireNonNull(baseExpr, "baseExpr is required!");
        if (DefaultGroovyMethods.asBoolean(ctx.namePart())) {
            Expression namePartExpr = this.visitNamePart(ctx.namePart());
            GenericsType[] genericsTypes = this.visitNonWildcardTypeArguments(ctx.nonWildcardTypeArguments());
            if (DefaultGroovyMethods.asBoolean(ctx.DOT())) {
                if (DefaultGroovyMethods.asBoolean(ctx.AT())) {
                    return this.configureAST(new AttributeExpression(baseExpr, namePartExpr), ctx);
                }
                PropertyExpression propertyExpression = new PropertyExpression(baseExpr, namePartExpr);
                propertyExpression.putNodeMetaData(PATH_EXPRESSION_BASE_EXPR_GENERICS_TYPES, genericsTypes);
                return this.configureAST(propertyExpression, ctx);
            }
            if (DefaultGroovyMethods.asBoolean(ctx.SAFE_DOT())) {
                if (DefaultGroovyMethods.asBoolean(ctx.AT())) {
                    return this.configureAST(new AttributeExpression(baseExpr, namePartExpr, true), ctx);
                }
                PropertyExpression propertyExpression = new PropertyExpression(baseExpr, namePartExpr, true);
                propertyExpression.putNodeMetaData(PATH_EXPRESSION_BASE_EXPR_GENERICS_TYPES, genericsTypes);
                return this.configureAST(propertyExpression, ctx);
            }
            if (DefaultGroovyMethods.asBoolean(ctx.METHOD_POINTER())) {
                return this.configureAST(new MethodPointerExpression(baseExpr, namePartExpr), ctx);
            }
            if (DefaultGroovyMethods.asBoolean(ctx.METHOD_REFERENCE())) {
                return this.configureAST(new MethodReferenceExpression(baseExpr, namePartExpr), ctx);
            }
            if (DefaultGroovyMethods.asBoolean(ctx.SPREAD_DOT())) {
                if (DefaultGroovyMethods.asBoolean(ctx.AT())) {
                    AttributeExpression attributeExpression = new AttributeExpression(baseExpr, namePartExpr, true);
                    attributeExpression.setSpreadSafe(true);
                    return this.configureAST(attributeExpression, ctx);
                }
                PropertyExpression propertyExpression = new PropertyExpression(baseExpr, namePartExpr, true);
                propertyExpression.putNodeMetaData(PATH_EXPRESSION_BASE_EXPR_GENERICS_TYPES, genericsTypes);
                propertyExpression.setSpreadSafe(true);
                return this.configureAST(propertyExpression, ctx);
            }
        }
        if (DefaultGroovyMethods.asBoolean(ctx.indexPropertyArgs())) {
            Object pair = this.visitIndexPropertyArgs(ctx.indexPropertyArgs());
            return this.configureAST(new BinaryExpression(baseExpr, this.createGroovyToken((groovyjarjarantlr4.v4.runtime.Token)((Pair)pair).getKey()), (Expression)((Pair)pair).getValue(), DefaultGroovyMethods.asBoolean(ctx.indexPropertyArgs().QUESTION())), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.namedPropertyArgs())) {
            Expression right;
            Object mapEntryExpressionList = this.visitNamedPropertyArgs(ctx.namedPropertyArgs());
            if (mapEntryExpressionList.size() == 1) {
                MapEntryExpression mapEntryExpression = (MapEntryExpression)mapEntryExpressionList.get(0);
                right = mapEntryExpression.getKeyExpression() instanceof SpreadMapExpression ? mapEntryExpression.getKeyExpression() : mapEntryExpression;
            } else {
                LinkedList<Expression> list = new LinkedList<Expression>();
                Iterator iterator = mapEntryExpressionList.iterator();
                while (iterator.hasNext()) {
                    MapEntryExpression e = (MapEntryExpression)iterator.next();
                    list.add(e.getKeyExpression() instanceof SpreadMapExpression ? e.getKeyExpression() : e);
                }
                ListExpression listExpression = this.configureAST(new ListExpression(list), ctx.namedPropertyArgs());
                listExpression.setWrapped(true);
                right = listExpression;
            }
            return this.configureAST(new BinaryExpression(baseExpr, this.createGroovyToken(ctx.namedPropertyArgs().LBRACK().getSymbol()), right), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.arguments())) {
            String baseExprText;
            Expression argumentsExpr = this.visitArguments(ctx.arguments());
            this.configureAST(argumentsExpr, ctx);
            if (this.isInsideParentheses(baseExpr)) {
                return this.configureAST(this.createCallMethodCallExpression(baseExpr, argumentsExpr), ctx);
            }
            if (baseExpr instanceof AttributeExpression) {
                AttributeExpression attributeExpression = (AttributeExpression)baseExpr;
                attributeExpression.setSpreadSafe(false);
                return this.configureAST(this.createCallMethodCallExpression(attributeExpression, argumentsExpr, true), ctx);
            }
            if (baseExpr instanceof PropertyExpression) {
                methodCallExpression = this.createMethodCallExpression((PropertyExpression)baseExpr, argumentsExpr);
                return this.configureAST(methodCallExpression, ctx);
            }
            if (baseExpr instanceof VariableExpression) {
                baseExprText = baseExpr.getText();
                if (VOID_STR.equals(baseExprText)) {
                    return this.configureAST(this.createCallMethodCallExpression(this.createConstantExpression(baseExpr), argumentsExpr), ctx);
                }
                if (PRIMITIVE_TYPE_SET.contains(baseExprText)) {
                    throw this.createParsingFailedException("Primitive type literal: " + baseExprText + " cannot be used as a method name", ctx);
                }
            }
            if (baseExpr instanceof VariableExpression || baseExpr instanceof GStringExpression || baseExpr instanceof ConstantExpression && this.isTrue(baseExpr, IS_STRING)) {
                baseExprText = baseExpr.getText();
                if (SUPER_STR.equals(baseExprText) || THIS_STR.equals(baseExprText)) {
                    if (ctx.isInsideClosure) {
                        return this.configureAST(new MethodCallExpression(baseExpr, baseExprText, argumentsExpr), ctx);
                    }
                    return this.configureAST(new ConstructorCallExpression(SUPER_STR.equals(baseExprText) ? ClassNode.SUPER : ClassNode.THIS, argumentsExpr), ctx);
                }
                MethodCallExpression methodCallExpression2 = this.createMethodCallExpression(baseExpr, argumentsExpr);
                return this.configureAST(methodCallExpression2, ctx);
            }
            return this.configureAST(this.createCallMethodCallExpression(baseExpr, argumentsExpr), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.closure())) {
            ClosureExpression closureExpression = this.visitClosure(ctx.closure());
            if (baseExpr instanceof MethodCallExpression) {
                methodCallExpression = (MethodCallExpression)baseExpr;
                Expression argumentsExpression = methodCallExpression.getArguments();
                if (argumentsExpression instanceof ArgumentListExpression) {
                    ArgumentListExpression argumentListExpression = (ArgumentListExpression)argumentsExpression;
                    argumentListExpression.getExpressions().add(closureExpression);
                    return this.configureAST(methodCallExpression, ctx);
                }
                if (argumentsExpression instanceof TupleExpression) {
                    TupleExpression tupleExpression = (TupleExpression)argumentsExpression;
                    NamedArgumentListExpression namedArgumentListExpression = (NamedArgumentListExpression)tupleExpression.getExpression(0);
                    if (DefaultGroovyMethods.asBoolean(tupleExpression.getExpressions())) {
                        ArrayList<Expression> list = new ArrayList<Expression>();
                        for (Expression expression : Arrays.asList(this.configureAST(new MapExpression(namedArgumentListExpression.getMapEntryExpressions()), namedArgumentListExpression), closureExpression)) {
                            list.add(expression);
                        }
                        methodCallExpression.setArguments(this.configureAST(new ArgumentListExpression(list), tupleExpression));
                    } else {
                        methodCallExpression.setArguments(this.configureAST(new ArgumentListExpression(closureExpression), tupleExpression));
                    }
                    return this.configureAST(methodCallExpression, ctx);
                }
            }
            if (baseExpr instanceof ConstantExpression && this.isTrue(baseExpr, IS_NUMERIC)) {
                return this.configureAST(this.createCallMethodCallExpression(baseExpr, this.configureAST(new ArgumentListExpression(closureExpression), closureExpression)), ctx);
            }
            if (baseExpr instanceof PropertyExpression) {
                PropertyExpression propertyExpression = (PropertyExpression)baseExpr;
                MethodCallExpression methodCallExpression3 = this.createMethodCallExpression(propertyExpression, (Expression)this.configureAST(new ArgumentListExpression(closureExpression), closureExpression));
                return this.configureAST(methodCallExpression3, ctx);
            }
            methodCallExpression = new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, baseExpr instanceof VariableExpression ? this.createConstantExpression(baseExpr) : baseExpr, (Expression)this.configureAST(new ArgumentListExpression(closureExpression), closureExpression));
            return this.configureAST(methodCallExpression, ctx);
        }
        throw this.createParsingFailedException("Unsupported path element: " + ctx.getText(), ctx);
    }

    private MethodCallExpression createCallMethodCallExpression(Expression baseExpr, Expression argumentsExpr) {
        return this.createCallMethodCallExpression(baseExpr, argumentsExpr, false);
    }

    private MethodCallExpression createCallMethodCallExpression(Expression baseExpr, Expression argumentsExpr, boolean implicitThis) {
        MethodCallExpression methodCallExpression = new MethodCallExpression(baseExpr, CALL_STR, argumentsExpr);
        methodCallExpression.setImplicitThis(implicitThis);
        return methodCallExpression;
    }

    @Override
    public GenericsType[] visitNonWildcardTypeArguments(GroovyParser.NonWildcardTypeArgumentsContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return null;
        }
        ArrayList<GenericsType> list = new ArrayList<GenericsType>();
        for (ClassNode classNode : this.visitTypeList(ctx.typeList())) {
            GenericsType genericsType = this.createGenericsType(classNode);
            list.add(genericsType);
        }
        return list.toArray(new GenericsType[0]);
    }

    @Override
    public ClassNode[] visitTypeList(GroovyParser.TypeListContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return new ClassNode[0];
        }
        ArrayList<ClassNode> list = new ArrayList<ClassNode>();
        for (GroovyParser.TypeContext typeContext : ctx.type()) {
            ClassNode classNode = this.visitType(typeContext);
            list.add(classNode);
        }
        return list.toArray(new ClassNode[0]);
    }

    @Override
    public Expression visitArguments(GroovyParser.ArgumentsContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx) || !DefaultGroovyMethods.asBoolean(ctx.enhancedArgumentList())) {
            return new ArgumentListExpression();
        }
        return this.configureAST(this.visitEnhancedArgumentList(ctx.enhancedArgumentList()), ctx);
    }

    @Override
    public Expression visitEnhancedArgumentList(GroovyParser.EnhancedArgumentListContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return null;
        }
        LinkedList<Expression> expressionList = new LinkedList<Expression>();
        LinkedList<MapEntryExpression> mapEntryExpressionList = new LinkedList<MapEntryExpression>();
        for (GroovyParser.EnhancedArgumentListElementContext enhancedArgumentListElementContext : ctx.enhancedArgumentListElement()) {
            Expression e = this.visitEnhancedArgumentListElement(enhancedArgumentListElementContext);
            if (e instanceof MapEntryExpression) {
                MapEntryExpression mapEntryExpression = (MapEntryExpression)e;
                this.validateDuplicatedNamedParameter(mapEntryExpressionList, mapEntryExpression);
                mapEntryExpressionList.add(mapEntryExpression);
                continue;
            }
            expressionList.add(e);
        }
        if (!DefaultGroovyMethods.asBoolean(mapEntryExpressionList)) {
            return this.configureAST(new ArgumentListExpression(expressionList), ctx);
        }
        if (!DefaultGroovyMethods.asBoolean(expressionList)) {
            return this.configureAST(new TupleExpression(this.configureAST(new NamedArgumentListExpression(mapEntryExpressionList), ctx)), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(mapEntryExpressionList) && DefaultGroovyMethods.asBoolean(expressionList)) {
            ArgumentListExpression argumentListExpression = new ArgumentListExpression(expressionList);
            argumentListExpression.getExpressions().add(0, new MapExpression(mapEntryExpressionList));
            return this.configureAST(argumentListExpression, ctx);
        }
        throw this.createParsingFailedException("Unsupported argument list: " + ctx.getText(), ctx);
    }

    private void validateDuplicatedNamedParameter(List<MapEntryExpression> mapEntryExpressionList, MapEntryExpression mapEntryExpression) {
        Expression keyExpression = mapEntryExpression.getKeyExpression();
        if (null == keyExpression) {
            return;
        }
        String parameterName = keyExpression.getText();
        boolean isDuplicatedNamedParameter = false;
        for (MapEntryExpression me : mapEntryExpressionList) {
            if (!me.getKeyExpression().getText().equals(parameterName)) continue;
            isDuplicatedNamedParameter = true;
            break;
        }
        if (!isDuplicatedNamedParameter) {
            return;
        }
        throw this.createParsingFailedException("Duplicated named parameter '" + parameterName + "' found", mapEntryExpression);
    }

    @Override
    public Expression visitEnhancedArgumentListElement(GroovyParser.EnhancedArgumentListElementContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.expressionListElement())) {
            return this.configureAST(this.visitExpressionListElement(ctx.expressionListElement()), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.standardLambdaExpression())) {
            return this.configureAST(this.visitStandardLambdaExpression(ctx.standardLambdaExpression()), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.mapEntry())) {
            return this.configureAST(this.visitMapEntry(ctx.mapEntry()), ctx);
        }
        throw this.createParsingFailedException("Unsupported enhanced argument list element: " + ctx.getText(), ctx);
    }

    @Override
    public ConstantExpression visitStringLiteral(GroovyParser.StringLiteralContext ctx) {
        String text = ctx.StringLiteral().getText();
        int slashyType = this.getSlashyType(text);
        if (text.startsWith("'''") || text.startsWith("\"\"\"")) {
            text = StringUtils.removeCR(text);
            text = StringUtils.trimQuotations(text, 3);
        } else if (text.startsWith("'") || text.startsWith("/") || text.startsWith("\"")) {
            if (text.startsWith("/")) {
                text = StringUtils.removeCR(text);
            }
            text = StringUtils.trimQuotations(text, 1);
        } else if (text.startsWith("$/")) {
            text = StringUtils.removeCR(text);
            text = StringUtils.trimQuotations(text, 2);
        }
        text = StringUtils.replaceEscapes(text, slashyType);
        ConstantExpression constantExpression = new ConstantExpression(text, true);
        constantExpression.putNodeMetaData(IS_STRING, true);
        return this.configureAST(constantExpression, ctx);
    }

    private int getSlashyType(String text) {
        return text.startsWith("/") ? 1 : (text.startsWith("$/") ? 2 : 0);
    }

    @Override
    public Pair<groovyjarjarantlr4.v4.runtime.Token, Expression> visitIndexPropertyArgs(GroovyParser.IndexPropertyArgsContext ctx) {
        Object expressionList = this.visitExpressionList(ctx.expressionList());
        if (expressionList.size() == 1) {
            Expression indexExpr;
            Expression expr = (Expression)expressionList.get(0);
            if (expr instanceof SpreadExpression) {
                ListExpression listExpression = new ListExpression((List<Expression>)expressionList);
                listExpression.setWrapped(false);
                indexExpr = listExpression;
            } else {
                indexExpr = expr;
            }
            return new Pair<groovyjarjarantlr4.v4.runtime.Token, Expression>(ctx.LBRACK().getSymbol(), indexExpr);
        }
        ListExpression listExpression = new ListExpression((List<Expression>)expressionList);
        listExpression.setWrapped(true);
        return new Pair<groovyjarjarantlr4.v4.runtime.Token, Expression>(ctx.LBRACK().getSymbol(), this.configureAST(listExpression, ctx));
    }

    @Override
    public List<MapEntryExpression> visitNamedPropertyArgs(GroovyParser.NamedPropertyArgsContext ctx) {
        return this.visitMapEntryList(ctx.mapEntryList());
    }

    @Override
    public Expression visitNamePart(GroovyParser.NamePartContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.identifier())) {
            return this.configureAST(new ConstantExpression(this.visitIdentifier(ctx.identifier())), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.stringLiteral())) {
            return this.configureAST(this.visitStringLiteral(ctx.stringLiteral()), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.dynamicMemberName())) {
            return this.configureAST(this.visitDynamicMemberName(ctx.dynamicMemberName()), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.keywords())) {
            return this.configureAST(new ConstantExpression(ctx.keywords().getText()), ctx);
        }
        throw this.createParsingFailedException("Unsupported name part: " + ctx.getText(), ctx);
    }

    @Override
    public Expression visitDynamicMemberName(GroovyParser.DynamicMemberNameContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.parExpression())) {
            return this.configureAST(this.visitParExpression(ctx.parExpression()), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.gstring())) {
            return this.configureAST(this.visitGstring(ctx.gstring()), ctx);
        }
        throw this.createParsingFailedException("Unsupported dynamic member name: " + ctx.getText(), ctx);
    }

    @Override
    public Expression visitPostfixExpression(GroovyParser.PostfixExpressionContext ctx) {
        Expression pathExpr = this.visitPathExpression(ctx.pathExpression());
        if (DefaultGroovyMethods.asBoolean(ctx.op)) {
            PostfixExpression postfixExpression = new PostfixExpression(pathExpr, this.createGroovyToken(ctx.op));
            if (ctx.isInsideAssert) {
                return this.configureAST(postfixExpression, ctx.op);
            }
            return this.configureAST(postfixExpression, ctx);
        }
        return this.configureAST(pathExpr, ctx);
    }

    @Override
    public Expression visitPostfixExprAlt(GroovyParser.PostfixExprAltContext ctx) {
        return this.visitPostfixExpression(ctx.postfixExpression());
    }

    @Override
    public Expression visitUnaryNotExprAlt(GroovyParser.UnaryNotExprAltContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.NOT())) {
            return this.configureAST(new NotExpression((Expression)this.visit(ctx.expression())), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.BITNOT())) {
            return this.configureAST(new BitwiseNegationExpression((Expression)this.visit(ctx.expression())), ctx);
        }
        throw this.createParsingFailedException("Unsupported unary expression: " + ctx.getText(), ctx);
    }

    @Override
    public CastExpression visitCastExprAlt(GroovyParser.CastExprAltContext ctx) {
        return this.configureAST(new CastExpression(this.visitCastParExpression(ctx.castParExpression()), (Expression)this.visit(ctx.expression())), ctx);
    }

    @Override
    public BinaryExpression visitPowerExprAlt(GroovyParser.PowerExprAltContext ctx) {
        return this.createBinaryExpression(ctx.left, ctx.op, ctx.right, ctx);
    }

    @Override
    public Expression visitUnaryAddExprAlt(GroovyParser.UnaryAddExprAltContext ctx) {
        GroovyParser.ExpressionContext expressionCtx = ctx.expression();
        Expression expression = (Expression)this.visit(expressionCtx);
        Boolean insidePar = this.isInsideParentheses(expression);
        switch (ctx.op.getType()) {
            case 100: {
                if (expression instanceof ConstantExpression && !insidePar.booleanValue()) {
                    return this.configureAST(expression, ctx);
                }
                return this.configureAST(new UnaryPlusExpression(expression), ctx);
            }
            case 101: {
                if (expression instanceof ConstantExpression && !insidePar.booleanValue()) {
                    ConstantExpression constantExpression = (ConstantExpression)expression;
                    try {
                        String integerLiteralText = (String)constantExpression.getNodeMetaData(INTEGER_LITERAL_TEXT);
                        if (null != integerLiteralText) {
                            ConstantExpression result = new ConstantExpression(Numbers.parseInteger(null, SUB_STR + integerLiteralText));
                            this.numberFormatError = null;
                            return this.configureAST(result, ctx);
                        }
                        String floatingPointLiteralText = (String)constantExpression.getNodeMetaData(FLOATING_POINT_LITERAL_TEXT);
                        if (null != floatingPointLiteralText) {
                            ConstantExpression result = new ConstantExpression(Numbers.parseDecimal(SUB_STR + floatingPointLiteralText));
                            this.numberFormatError = null;
                            return this.configureAST(result, ctx);
                        }
                    }
                    catch (Exception e) {
                        throw this.createParsingFailedException(e.getMessage(), ctx);
                    }
                    throw new GroovyBugError("Failed to find the original number literal text: " + constantExpression.getText());
                }
                return this.configureAST(new UnaryMinusExpression(expression), ctx);
            }
            case 98: 
            case 99: {
                return this.configureAST(new PrefixExpression(this.createGroovyToken(ctx.op), expression), ctx);
            }
        }
        throw this.createParsingFailedException("Unsupported unary operation: " + ctx.getText(), ctx);
    }

    @Override
    public BinaryExpression visitMultiplicativeExprAlt(GroovyParser.MultiplicativeExprAltContext ctx) {
        return this.createBinaryExpression(ctx.left, ctx.op, ctx.right, ctx);
    }

    @Override
    public BinaryExpression visitAdditiveExprAlt(GroovyParser.AdditiveExprAltContext ctx) {
        return this.createBinaryExpression(ctx.left, ctx.op, ctx.right, ctx);
    }

    @Override
    public Expression visitShiftExprAlt(GroovyParser.ShiftExprAltContext ctx) {
        groovyjarjarantlr4.v4.runtime.Token antlrToken;
        Token op;
        Expression left = (Expression)this.visit(ctx.left);
        Expression right = (Expression)this.visit(ctx.right);
        if (DefaultGroovyMethods.asBoolean(ctx.rangeOp)) {
            return this.configureAST(new RangeExpression(left, right, !ctx.rangeOp.getText().endsWith("<")), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.dlOp)) {
            op = this.createGroovyToken(ctx.dlOp, 2);
            antlrToken = ctx.dlOp;
        } else if (DefaultGroovyMethods.asBoolean(ctx.dgOp)) {
            op = this.createGroovyToken(ctx.dgOp, 2);
            antlrToken = ctx.dgOp;
        } else if (DefaultGroovyMethods.asBoolean(ctx.tgOp)) {
            op = this.createGroovyToken(ctx.tgOp, 3);
            antlrToken = ctx.tgOp;
        } else {
            throw this.createParsingFailedException("Unsupported shift expression: " + ctx.getText(), ctx);
        }
        BinaryExpression binaryExpression = new BinaryExpression(left, op, right);
        if (this.isTrue(ctx, IS_INSIDE_CONDITIONAL_EXPRESSION)) {
            return this.configureAST(binaryExpression, antlrToken);
        }
        return this.configureAST(binaryExpression, ctx);
    }

    @Override
    public Expression visitRelationalExprAlt(GroovyParser.RelationalExprAltContext ctx) {
        switch (ctx.op.getType()) {
            case 7: {
                return this.configureAST(CastExpression.asExpression(this.visitType(ctx.type()), (Expression)this.visit(ctx.left)), ctx);
            }
            case 33: 
            case 74: {
                ctx.type().putNodeMetaData(IS_INSIDE_INSTANCEOF_EXPR, true);
                return this.configureAST(new BinaryExpression((Expression)this.visit(ctx.left), this.createGroovyToken(ctx.op), this.configureAST(new ClassExpression(this.visitType(ctx.type())), ctx.type())), ctx);
            }
            case 9: 
            case 75: 
            case 86: 
            case 87: 
            case 93: 
            case 94: {
                if (ctx.op.getType() == 9 || ctx.op.getType() == 75) {
                    return this.createBinaryExpression(ctx.left, ctx.op, ctx.right, ctx);
                }
                return this.configureAST(this.createBinaryExpression(ctx.left, ctx.op, ctx.right), ctx);
            }
        }
        throw this.createParsingFailedException("Unsupported relational expression: " + ctx.getText(), ctx);
    }

    @Override
    public BinaryExpression visitEqualityExprAlt(GroovyParser.EqualityExprAltContext ctx) {
        return this.configureAST(this.createBinaryExpression(ctx.left, ctx.op, ctx.right), ctx);
    }

    @Override
    public BinaryExpression visitRegexExprAlt(GroovyParser.RegexExprAltContext ctx) {
        return this.configureAST(this.createBinaryExpression(ctx.left, ctx.op, ctx.right), ctx);
    }

    @Override
    public BinaryExpression visitAndExprAlt(GroovyParser.AndExprAltContext ctx) {
        return this.createBinaryExpression(ctx.left, ctx.op, ctx.right, ctx);
    }

    @Override
    public BinaryExpression visitExclusiveOrExprAlt(GroovyParser.ExclusiveOrExprAltContext ctx) {
        return this.createBinaryExpression(ctx.left, ctx.op, ctx.right, ctx);
    }

    @Override
    public BinaryExpression visitInclusiveOrExprAlt(GroovyParser.InclusiveOrExprAltContext ctx) {
        return this.createBinaryExpression(ctx.left, ctx.op, ctx.right, ctx);
    }

    @Override
    public BinaryExpression visitLogicalAndExprAlt(GroovyParser.LogicalAndExprAltContext ctx) {
        return this.configureAST(this.createBinaryExpression(ctx.left, ctx.op, ctx.right), ctx);
    }

    @Override
    public BinaryExpression visitLogicalOrExprAlt(GroovyParser.LogicalOrExprAltContext ctx) {
        return this.configureAST(this.createBinaryExpression(ctx.left, ctx.op, ctx.right), ctx);
    }

    @Override
    public Expression visitConditionalExprAlt(GroovyParser.ConditionalExprAltContext ctx) {
        ctx.fb.putNodeMetaData(IS_INSIDE_CONDITIONAL_EXPRESSION, true);
        if (DefaultGroovyMethods.asBoolean(ctx.ELVIS())) {
            return this.configureAST(new ElvisOperatorExpression((Expression)this.visit(ctx.con), (Expression)this.visit(ctx.fb)), ctx);
        }
        ctx.tb.putNodeMetaData(IS_INSIDE_CONDITIONAL_EXPRESSION, true);
        return this.configureAST(new TernaryExpression(this.configureAST(new BooleanExpression((Expression)this.visit(ctx.con)), ctx.con), (Expression)this.visit(ctx.tb), (Expression)this.visit(ctx.fb)), ctx);
    }

    @Override
    public BinaryExpression visitMultipleAssignmentExprAlt(GroovyParser.MultipleAssignmentExprAltContext ctx) {
        return this.configureAST(new BinaryExpression(this.visitVariableNames(ctx.left), this.createGroovyToken(ctx.op), ((ExpressionStatement)this.visit(ctx.right)).getExpression()), ctx);
    }

    @Override
    public BinaryExpression visitAssignmentExprAlt(GroovyParser.AssignmentExprAltContext ctx) {
        Expression leftExpr = (Expression)this.visit(ctx.left);
        if (leftExpr instanceof VariableExpression && this.isInsideParentheses(leftExpr)) {
            if ((Integer)leftExpr.getNodeMetaData(INSIDE_PARENTHESES_LEVEL) > 1) {
                throw this.createParsingFailedException("Nested parenthesis is not allowed in multiple assignment, e.g. ((a)) = b", ctx);
            }
            return this.configureAST(new BinaryExpression(this.configureAST(new TupleExpression(leftExpr), ctx.left), this.createGroovyToken(ctx.op), this.visitEnhancedStatementExpression(ctx.enhancedStatementExpression())), ctx);
        }
        if (!(leftExpr instanceof VariableExpression && !this.isInsideParentheses(leftExpr) || leftExpr instanceof PropertyExpression || leftExpr instanceof BinaryExpression && 30 == ((BinaryExpression)leftExpr).getOperation().getType())) {
            throw this.createParsingFailedException("The LHS of an assignment should be a variable or a field accessing expression", ctx);
        }
        return this.configureAST(new BinaryExpression(leftExpr, this.createGroovyToken(ctx.op), this.visitEnhancedStatementExpression(ctx.enhancedStatementExpression())), ctx);
    }

    @Override
    public VariableExpression visitIdentifierPrmrAlt(GroovyParser.IdentifierPrmrAltContext ctx) {
        return this.configureAST(new VariableExpression(this.visitIdentifier(ctx.identifier())), ctx);
    }

    @Override
    public ConstantExpression visitLiteralPrmrAlt(GroovyParser.LiteralPrmrAltContext ctx) {
        return this.configureAST((ConstantExpression)this.visit(ctx.literal()), ctx);
    }

    @Override
    public GStringExpression visitGstringPrmrAlt(GroovyParser.GstringPrmrAltContext ctx) {
        return this.configureAST((GStringExpression)this.visit(ctx.gstring()), ctx);
    }

    @Override
    public Expression visitNewPrmrAlt(GroovyParser.NewPrmrAltContext ctx) {
        return this.configureAST(this.visitCreator(ctx.creator()), ctx);
    }

    @Override
    public VariableExpression visitThisPrmrAlt(GroovyParser.ThisPrmrAltContext ctx) {
        return this.configureAST(new VariableExpression(ctx.THIS().getText()), ctx);
    }

    @Override
    public VariableExpression visitSuperPrmrAlt(GroovyParser.SuperPrmrAltContext ctx) {
        return this.configureAST(new VariableExpression(ctx.SUPER().getText()), ctx);
    }

    @Override
    public Expression visitParenPrmrAlt(GroovyParser.ParenPrmrAltContext ctx) {
        return this.configureAST(this.visitParExpression(ctx.parExpression()), ctx);
    }

    @Override
    public ClosureExpression visitClosurePrmrAlt(GroovyParser.ClosurePrmrAltContext ctx) {
        return this.configureAST(this.visitClosure(ctx.closure()), ctx);
    }

    @Override
    public ClosureExpression visitLambdaPrmrAlt(GroovyParser.LambdaPrmrAltContext ctx) {
        return this.configureAST(this.visitStandardLambdaExpression(ctx.standardLambdaExpression()), ctx);
    }

    @Override
    public ListExpression visitListPrmrAlt(GroovyParser.ListPrmrAltContext ctx) {
        return this.configureAST(this.visitList(ctx.list()), ctx);
    }

    @Override
    public MapExpression visitMapPrmrAlt(GroovyParser.MapPrmrAltContext ctx) {
        return this.configureAST(this.visitMap(ctx.map()), ctx);
    }

    @Override
    public VariableExpression visitTypePrmrAlt(GroovyParser.TypePrmrAltContext ctx) {
        return this.configureAST(this.visitBuiltInType(ctx.builtInType()), ctx);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Expression visitCreator(GroovyParser.CreatorContext ctx) {
        ClassNode classNode = this.visitCreatedName(ctx.createdName());
        Expression arguments = this.visitArguments(ctx.arguments());
        if (DefaultGroovyMethods.asBoolean(ctx.arguments())) {
            if (DefaultGroovyMethods.asBoolean(ctx.anonymousInnerClassDeclaration())) {
                ctx.anonymousInnerClassDeclaration().putNodeMetaData(ANONYMOUS_INNER_CLASS_SUPER_CLASS, classNode);
                InnerClassNode anonymousInnerClassNode = this.visitAnonymousInnerClassDeclaration(ctx.anonymousInnerClassDeclaration());
                List<InnerClassNode> anonymousInnerClassList = this.anonymousInnerClassesDefinedInMethodStack.peek();
                if (null != anonymousInnerClassList) {
                    anonymousInnerClassList.add(anonymousInnerClassNode);
                }
                ConstructorCallExpression constructorCallExpression = new ConstructorCallExpression(anonymousInnerClassNode, arguments);
                constructorCallExpression.setUsingAnonymousInnerClass(true);
                return this.configureAST(constructorCallExpression, ctx);
            }
            return this.configureAST(new ConstructorCallExpression(classNode, arguments), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.LBRACK()) || DefaultGroovyMethods.asBoolean(ctx.dims())) {
            ArrayExpression arrayExpression;
            ArrayList allDimList;
            if (DefaultGroovyMethods.asBoolean(ctx.arrayInitializer())) {
                ClassNode elementType = classNode;
                allDimList = this.visitDims(ctx.dims());
                int n = allDimList.size() - 1;
                for (int i = 0; i < n; ++i) {
                    elementType = elementType.makeArray();
                }
                arrayExpression = new ArrayExpression(elementType, (List<Expression>)this.visitArrayInitializer(ctx.arrayInitializer()));
            } else {
                void var11_21;
                Expression[] empties;
                Object emptyDimList = this.visitDimsOpt(ctx.dimsOpt());
                if (DefaultGroovyMethods.asBoolean((Collection)emptyDimList)) {
                    empties = new Expression[emptyDimList.size()];
                    for (int i = 0; i < empties.length; ++i) {
                        empties[i] = ConstantExpression.EMPTY_EXPRESSION;
                    }
                } else {
                    empties = new Expression[]{};
                }
                LinkedList<Expression> sizes = new LinkedList<Expression>();
                for (GroovyParser.ExpressionContext expressionContext : ctx.expression()) {
                    sizes.add((Expression)this.visit(expressionContext));
                }
                Expression[] expressionArray = empties;
                int n = expressionArray.length;
                boolean bl = false;
                while (var11_21 < n) {
                    Expression e = expressionArray[var11_21];
                    sizes.add(e);
                    ++var11_21;
                }
                arrayExpression = new ArrayExpression(classNode, null, sizes);
                ArrayList<Object> exprDimList = new ArrayList<Object>();
                for (GroovyParser.AnnotationsOptContext annotationsOptContext : ctx.annotationsOpt()) {
                    exprDimList.add(this.visitAnnotationsOpt(annotationsOptContext));
                }
                allDimList = new ArrayList(exprDimList);
                Collections.reverse(emptyDimList);
                allDimList.addAll(emptyDimList);
                Collections.reverse(allDimList);
            }
            arrayExpression.setType(this.createArrayType(classNode, allDimList));
            return this.configureAST(arrayExpression, ctx);
        }
        throw this.createParsingFailedException("Unsupported creator: " + ctx.getText(), ctx);
    }

    private ClassNode createArrayType(ClassNode classNode, List<List<AnnotationNode>> dimList) {
        ClassNode arrayType = classNode;
        int n = dimList.size();
        for (int i = 0; i < n; ++i) {
            arrayType = arrayType.makeArray();
            arrayType.addAnnotations(dimList.get(i));
        }
        return arrayType;
    }

    private String genAnonymousClassName(String outerClassName) {
        return outerClassName + DOLLAR_STR + this.anonymousInnerClassCounter++;
    }

    @Override
    public InnerClassNode visitAnonymousInnerClassDeclaration(GroovyParser.AnonymousInnerClassDeclarationContext ctx) {
        InnerClassNode anonymousInnerClass;
        ClassNode superClass = (ClassNode)ctx.getNodeMetaData(ANONYMOUS_INNER_CLASS_SUPER_CLASS);
        Objects.requireNonNull(superClass, "superClass should not be null");
        ClassNode outerClass = this.classNodeStack.peek();
        outerClass = DefaultGroovyMethods.asBoolean(outerClass) ? outerClass : this.moduleNode.getScriptClassDummy();
        String fullName = this.genAnonymousClassName(outerClass.getName());
        if (1 == ctx.t) {
            anonymousInnerClass = new EnumConstantClassNode(outerClass, fullName, superClass.getModifiers() | 0x10, superClass.getPlainNodeReference());
            superClass.setModifiers(superClass.getModifiers() & 0xFFFFFFEF);
        } else {
            anonymousInnerClass = new InnerClassNode(outerClass, fullName, 1, superClass);
        }
        anonymousInnerClass.setUsingGenerics(false);
        anonymousInnerClass.setAnonymous(true);
        anonymousInnerClass.putNodeMetaData(CLASS_NAME, fullName);
        this.configureAST(anonymousInnerClass, ctx);
        this.classNodeStack.push(anonymousInnerClass);
        ctx.classBody().putNodeMetaData(CLASS_DECLARATION_CLASS_NODE, anonymousInnerClass);
        this.visitClassBody(ctx.classBody());
        this.classNodeStack.pop();
        this.classNodeList.add(anonymousInnerClass);
        return anonymousInnerClass;
    }

    @Override
    public ClassNode visitCreatedName(GroovyParser.CreatedNameContext ctx) {
        ClassNode classNode = null;
        if (DefaultGroovyMethods.asBoolean(ctx.qualifiedClassName())) {
            classNode = this.visitQualifiedClassName(ctx.qualifiedClassName());
            if (DefaultGroovyMethods.asBoolean(ctx.typeArgumentsOrDiamond())) {
                classNode.setGenericsTypes(this.visitTypeArgumentsOrDiamond(ctx.typeArgumentsOrDiamond()));
            }
            classNode = this.configureAST(classNode, ctx);
        } else if (DefaultGroovyMethods.asBoolean(ctx.primitiveType())) {
            classNode = this.configureAST(this.visitPrimitiveType(ctx.primitiveType()), ctx);
        }
        if (!DefaultGroovyMethods.asBoolean(classNode)) {
            throw this.createParsingFailedException("Unsupported created name: " + ctx.getText(), ctx);
        }
        classNode.addAnnotations((List<AnnotationNode>)this.visitAnnotationsOpt(ctx.annotationsOpt()));
        return classNode;
    }

    @Override
    public MapExpression visitMap(GroovyParser.MapContext ctx) {
        return this.configureAST(new MapExpression((List<MapEntryExpression>)this.visitMapEntryList(ctx.mapEntryList())), ctx);
    }

    @Override
    public List<MapEntryExpression> visitMapEntryList(GroovyParser.MapEntryListContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return Collections.emptyList();
        }
        return this.createMapEntryList(ctx.mapEntry());
    }

    private List<MapEntryExpression> createMapEntryList(List<? extends GroovyParser.MapEntryContext> mapEntryContextList) {
        if (!DefaultGroovyMethods.asBoolean(mapEntryContextList)) {
            return Collections.emptyList();
        }
        ArrayList<MapEntryExpression> list = new ArrayList<MapEntryExpression>();
        for (GroovyParser.MapEntryContext mapEntryContext : mapEntryContextList) {
            MapEntryExpression mapEntryExpression = this.visitMapEntry(mapEntryContext);
            list.add(mapEntryExpression);
        }
        return list;
    }

    @Override
    public MapEntryExpression visitMapEntry(GroovyParser.MapEntryContext ctx) {
        Expression keyExpr;
        Expression valueExpr = (Expression)this.visit(ctx.expression());
        if (DefaultGroovyMethods.asBoolean(ctx.MUL())) {
            keyExpr = this.configureAST(new SpreadMapExpression(valueExpr), ctx);
        } else if (DefaultGroovyMethods.asBoolean(ctx.mapEntryLabel())) {
            keyExpr = this.visitMapEntryLabel(ctx.mapEntryLabel());
        } else {
            throw this.createParsingFailedException("Unsupported map entry: " + ctx.getText(), ctx);
        }
        return this.configureAST(new MapEntryExpression(keyExpr, valueExpr), ctx);
    }

    @Override
    public Expression visitMapEntryLabel(GroovyParser.MapEntryLabelContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.keywords())) {
            return this.configureAST(this.visitKeywords(ctx.keywords()), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.primary())) {
            Expression expression = (Expression)this.visit(ctx.primary());
            if (expression instanceof VariableExpression && !this.isInsideParentheses(expression)) {
                expression = this.configureAST(new ConstantExpression(((VariableExpression)expression).getName()), expression);
            }
            return this.configureAST(expression, ctx);
        }
        throw this.createParsingFailedException("Unsupported map entry label: " + ctx.getText(), ctx);
    }

    @Override
    public ConstantExpression visitKeywords(GroovyParser.KeywordsContext ctx) {
        return this.configureAST(new ConstantExpression(ctx.getText()), ctx);
    }

    @Override
    public VariableExpression visitBuiltInType(GroovyParser.BuiltInTypeContext ctx) {
        String text;
        if (DefaultGroovyMethods.asBoolean(ctx.VOID())) {
            text = ctx.VOID().getText();
        } else if (DefaultGroovyMethods.asBoolean(ctx.BuiltInPrimitiveType())) {
            text = ctx.BuiltInPrimitiveType().getText();
        } else {
            throw this.createParsingFailedException("Unsupported built-in type: " + ctx, ctx);
        }
        return this.configureAST(new VariableExpression(text), ctx);
    }

    @Override
    public ListExpression visitList(GroovyParser.ListContext ctx) {
        return this.configureAST(new ListExpression((List<Expression>)this.visitExpressionList(ctx.expressionList())), ctx);
    }

    @Override
    public List<Expression> visitExpressionList(GroovyParser.ExpressionListContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return Collections.emptyList();
        }
        return this.createExpressionList(ctx.expressionListElement());
    }

    private List<Expression> createExpressionList(List<? extends GroovyParser.ExpressionListElementContext> expressionListElementContextList) {
        if (!DefaultGroovyMethods.asBoolean(expressionListElementContextList)) {
            return Collections.emptyList();
        }
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (GroovyParser.ExpressionListElementContext expressionListElementContext : expressionListElementContextList) {
            Expression expression = this.visitExpressionListElement(expressionListElementContext);
            list.add(expression);
        }
        return list;
    }

    @Override
    public Expression visitExpressionListElement(GroovyParser.ExpressionListElementContext ctx) {
        Expression expression = (Expression)this.visit(ctx.expression());
        if (DefaultGroovyMethods.asBoolean(ctx.MUL())) {
            return this.configureAST(new SpreadExpression(expression), ctx);
        }
        return this.configureAST(expression, ctx);
    }

    @Override
    public ConstantExpression visitIntegerLiteralAlt(GroovyParser.IntegerLiteralAltContext ctx) {
        String text = ctx.IntegerLiteral().getText();
        Number num = null;
        try {
            num = Numbers.parseInteger(null, text);
        }
        catch (Exception e) {
            this.numberFormatError = new Pair<GroovyParser.IntegerLiteralAltContext, Exception>(ctx, e);
        }
        ConstantExpression constantExpression = new ConstantExpression(num, !text.startsWith(SUB_STR));
        constantExpression.putNodeMetaData(IS_NUMERIC, true);
        constantExpression.putNodeMetaData(INTEGER_LITERAL_TEXT, text);
        return this.configureAST(constantExpression, ctx);
    }

    @Override
    public ConstantExpression visitFloatingPointLiteralAlt(GroovyParser.FloatingPointLiteralAltContext ctx) {
        String text = ctx.FloatingPointLiteral().getText();
        Number num = null;
        try {
            num = Numbers.parseDecimal(text);
        }
        catch (Exception e) {
            this.numberFormatError = new Pair<GroovyParser.FloatingPointLiteralAltContext, Exception>(ctx, e);
        }
        ConstantExpression constantExpression = new ConstantExpression(num, !text.startsWith(SUB_STR));
        constantExpression.putNodeMetaData(IS_NUMERIC, true);
        constantExpression.putNodeMetaData(FLOATING_POINT_LITERAL_TEXT, text);
        return this.configureAST(constantExpression, ctx);
    }

    @Override
    public ConstantExpression visitStringLiteralAlt(GroovyParser.StringLiteralAltContext ctx) {
        return this.configureAST(this.visitStringLiteral(ctx.stringLiteral()), ctx);
    }

    @Override
    public ConstantExpression visitBooleanLiteralAlt(GroovyParser.BooleanLiteralAltContext ctx) {
        return this.configureAST(new ConstantExpression("true".equals(ctx.BooleanLiteral().getText()), true), ctx);
    }

    @Override
    public ConstantExpression visitNullLiteralAlt(GroovyParser.NullLiteralAltContext ctx) {
        return this.configureAST(new ConstantExpression(null), ctx);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GStringExpression visitGstring(GroovyParser.GstringContext ctx) {
        void var8_17;
        LinkedList<ConstantExpression> strings = new LinkedList<ConstantExpression>();
        String begin = ctx.GStringBegin().getText();
        int slashyType = this.getSlashyType(begin);
        String it = begin;
        if (it.startsWith("\"\"\"")) {
            it = StringUtils.removeCR(it);
            it = it.substring(2);
        } else if (it.startsWith("$/")) {
            it = StringUtils.removeCR(it);
            it = "\"" + it.substring(2);
        } else if (it.startsWith("/")) {
            it = StringUtils.removeCR(it);
        }
        it = StringUtils.replaceEscapes(it, slashyType);
        it = it.length() == 2 ? "" : StringGroovyMethods.getAt(it, new IntRange(true, 1, -2));
        strings.add(this.configureAST(new ConstantExpression(it), ctx.GStringBegin()));
        LinkedList<ConstantExpression> partStrings = new LinkedList<ConstantExpression>();
        for (TerminalNode terminalNode : ctx.GStringPart()) {
            String string4 = terminalNode.getText();
            string4 = StringUtils.removeCR(string4);
            string4 = StringUtils.replaceEscapes(string4, slashyType);
            string4 = string4.length() == 1 ? "" : StringGroovyMethods.getAt(string4, new IntRange(true, 0, -2));
            partStrings.add(this.configureAST(new ConstantExpression(string4), terminalNode));
        }
        strings.addAll(partStrings);
        String it3 = ctx.GStringEnd().getText();
        if (it3.endsWith("\"\"\"")) {
            it3 = StringUtils.removeCR(it3);
            it3 = StringGroovyMethods.getAt(it3, new IntRange(true, 0, -3));
        } else if (it3.endsWith("/$")) {
            it3 = StringUtils.removeCR(it3);
            it3 = StringGroovyMethods.getAt(it3, new IntRange(false, 0, -2)) + "\"";
        } else if (it3.endsWith("/")) {
            it3 = StringUtils.removeCR(it3);
        }
        it3 = StringUtils.replaceEscapes(it3, slashyType);
        it3 = it3.length() == 1 ? "" : StringGroovyMethods.getAt(it3, new IntRange(true, 0, -2));
        strings.add(this.configureAST(new ConstantExpression(it3), ctx.GStringEnd()));
        LinkedList<Expression> values = new LinkedList<Expression>();
        for (GroovyParser.GstringValueContext gstringValueContext : ctx.gstringValue()) {
            Expression expression = this.visitGstringValue(gstringValueContext);
            if (expression instanceof ClosureExpression && !DefaultGroovyMethods.asBoolean(gstringValueContext.closure().ARROW())) {
                List<Statement> statementList = ((BlockStatement)((ClosureExpression)expression).getCode()).getStatements();
                boolean allFalse = true;
                for (Statement x : statementList) {
                    if (!DefaultGroovyMethods.asBoolean(x)) continue;
                    allFalse = false;
                    break;
                }
                if (allFalse) {
                    values.add(this.configureAST(new ConstantExpression(null), gstringValueContext));
                    continue;
                }
                values.add(this.configureAST(this.createCallMethodCallExpression(expression, new ArgumentListExpression(), true), gstringValueContext));
                continue;
            }
            values.add(expression);
        }
        StringBuilder stringBuilder = new StringBuilder(ctx.getText().length());
        boolean bl = false;
        int n = strings.size();
        int s = values.size();
        while (var8_17 < n) {
            Expression value;
            stringBuilder.append(((ConstantExpression)strings.get((int)var8_17)).getValue());
            if (var8_17 != s && DefaultGroovyMethods.asBoolean(value = (Expression)values.get((int)var8_17))) {
                stringBuilder.append(DOLLAR_STR);
                stringBuilder.append(value.getText());
            }
            ++var8_17;
        }
        return this.configureAST(new GStringExpression(stringBuilder.toString(), strings, values), ctx);
    }

    @Override
    public Expression visitGstringValue(GroovyParser.GstringValueContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.gstringPath())) {
            return this.configureAST(this.visitGstringPath(ctx.gstringPath()), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.LBRACE())) {
            if (DefaultGroovyMethods.asBoolean(ctx.statementExpression())) {
                return this.configureAST(((ExpressionStatement)this.visit(ctx.statementExpression())).getExpression(), ctx.statementExpression());
            }
            return this.configureAST(new ConstantExpression(null), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.closure())) {
            return this.configureAST(this.visitClosure(ctx.closure()), ctx);
        }
        throw this.createParsingFailedException("Unsupported gstring value: " + ctx.getText(), ctx);
    }

    @Override
    public Expression visitGstringPath(GroovyParser.GstringPathContext ctx) {
        VariableExpression variableExpression = new VariableExpression(this.visitIdentifier(ctx.identifier()));
        if (DefaultGroovyMethods.asBoolean(ctx.GStringPathPart())) {
            Expression propertyExpression = this.configureAST(variableExpression, ctx.identifier());
            for (TerminalNode terminalNode : ctx.GStringPathPart()) {
                Expression expression = this.configureAST(new ConstantExpression(terminalNode.getText().substring(1)), terminalNode);
                propertyExpression = this.configureAST(new PropertyExpression(propertyExpression, expression), expression);
            }
            return this.configureAST(propertyExpression, ctx);
        }
        return this.configureAST(variableExpression, ctx);
    }

    @Override
    public LambdaExpression visitStandardLambdaExpression(GroovyParser.StandardLambdaExpressionContext ctx) {
        return this.configureAST(this.createLambda(ctx.standardLambdaParameters(), ctx.lambdaBody()), ctx);
    }

    private LambdaExpression createLambda(GroovyParser.StandardLambdaParametersContext standardLambdaParametersContext, GroovyParser.LambdaBodyContext lambdaBodyContext) {
        return new LambdaExpression(this.visitStandardLambdaParameters(standardLambdaParametersContext), this.visitLambdaBody(lambdaBodyContext));
    }

    @Override
    public Parameter[] visitStandardLambdaParameters(GroovyParser.StandardLambdaParametersContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.variableDeclaratorId())) {
            return new Parameter[]{this.configureAST(new Parameter(ClassHelper.OBJECT_TYPE, this.visitVariableDeclaratorId(ctx.variableDeclaratorId()).getName()), ctx.variableDeclaratorId())};
        }
        Parameter[] parameters = this.visitFormalParameters(ctx.formalParameters());
        if (0 == parameters.length) {
            return null;
        }
        return parameters;
    }

    @Override
    public Statement visitLambdaBody(GroovyParser.LambdaBodyContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.statementExpression())) {
            return this.configureAST((ExpressionStatement)this.visit(ctx.statementExpression()), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.block())) {
            return this.configureAST(this.visitBlock(ctx.block()), ctx);
        }
        throw this.createParsingFailedException("Unsupported lambda body: " + ctx.getText(), ctx);
    }

    @Override
    public ClosureExpression visitClosure(GroovyParser.ClosureContext ctx) {
        Parameter[] parameters;
        Parameter[] parameterArray = parameters = DefaultGroovyMethods.asBoolean(ctx.formalParameterList()) ? this.visitFormalParameterList(ctx.formalParameterList()) : null;
        if (!DefaultGroovyMethods.asBoolean(ctx.ARROW())) {
            parameters = Parameter.EMPTY_ARRAY;
        }
        BlockStatement code = this.visitBlockStatementsOpt(ctx.blockStatementsOpt());
        return this.configureAST(new ClosureExpression(parameters, code), ctx);
    }

    @Override
    public Parameter[] visitFormalParameters(GroovyParser.FormalParametersContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return new Parameter[0];
        }
        return this.visitFormalParameterList(ctx.formalParameterList());
    }

    @Override
    public Parameter[] visitFormalParameterList(GroovyParser.FormalParameterListContext ctx) {
        List<? extends GroovyParser.FormalParameterContext> formalParameterList;
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return new Parameter[0];
        }
        LinkedList<Parameter> parameterList = new LinkedList<Parameter>();
        if (DefaultGroovyMethods.asBoolean(ctx.thisFormalParameter())) {
            parameterList.add(this.visitThisFormalParameter(ctx.thisFormalParameter()));
        }
        if (DefaultGroovyMethods.asBoolean(formalParameterList = ctx.formalParameter())) {
            this.validateVarArgParameter(formalParameterList);
            ArrayList<Parameter> list = new ArrayList<Parameter>();
            for (GroovyParser.FormalParameterContext formalParameterContext : formalParameterList) {
                Parameter parameter = this.visitFormalParameter(formalParameterContext);
                list.add(parameter);
            }
            parameterList.addAll(list);
        }
        this.validateParameterList(parameterList);
        return parameterList.toArray(new Parameter[0]);
    }

    private void validateVarArgParameter(List<? extends GroovyParser.FormalParameterContext> formalParameterList) {
        int n = formalParameterList.size();
        for (int i = 0; i < n - 1; ++i) {
            GroovyParser.FormalParameterContext formalParameterContext = formalParameterList.get(i);
            if (!DefaultGroovyMethods.asBoolean(formalParameterContext.ELLIPSIS())) continue;
            throw this.createParsingFailedException("The var-arg parameter strs must be the last parameter", formalParameterContext);
        }
    }

    private void validateParameterList(List<Parameter> parameterList) {
        int n = parameterList.size();
        for (int i = n - 1; i >= 0; --i) {
            Parameter parameter = parameterList.get(i);
            for (Parameter otherParameter : parameterList) {
                if (otherParameter == parameter || !otherParameter.getName().equals(parameter.getName())) continue;
                throw this.createParsingFailedException("Duplicated parameter '" + parameter.getName() + "' found.", parameter);
            }
        }
    }

    @Override
    public Parameter visitFormalParameter(GroovyParser.FormalParameterContext ctx) {
        return this.processFormalParameter(ctx, ctx.variableModifiersOpt(), ctx.type(), ctx.ELLIPSIS(), ctx.variableDeclaratorId(), ctx.expression());
    }

    @Override
    public Parameter visitThisFormalParameter(GroovyParser.ThisFormalParameterContext ctx) {
        return this.configureAST(new Parameter(this.visitType(ctx.type()), THIS_STR), ctx);
    }

    @Override
    public List<ModifierNode> visitClassOrInterfaceModifiersOpt(GroovyParser.ClassOrInterfaceModifiersOptContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.classOrInterfaceModifiers())) {
            return this.visitClassOrInterfaceModifiers(ctx.classOrInterfaceModifiers());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ModifierNode> visitClassOrInterfaceModifiers(GroovyParser.ClassOrInterfaceModifiersContext ctx) {
        ArrayList<ModifierNode> list = new ArrayList<ModifierNode>();
        for (GroovyParser.ClassOrInterfaceModifierContext classOrInterfaceModifierContext : ctx.classOrInterfaceModifier()) {
            ModifierNode modifierNode = this.visitClassOrInterfaceModifier(classOrInterfaceModifierContext);
            list.add(modifierNode);
        }
        return list;
    }

    @Override
    public ModifierNode visitClassOrInterfaceModifier(GroovyParser.ClassOrInterfaceModifierContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.annotation())) {
            return this.configureAST(new ModifierNode(this.visitAnnotation(ctx.annotation()), ctx.getText()), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.m)) {
            return this.configureAST(new ModifierNode(ctx.m.getType(), ctx.getText()), ctx);
        }
        throw this.createParsingFailedException("Unsupported class or interface modifier: " + ctx.getText(), ctx);
    }

    @Override
    public ModifierNode visitModifier(GroovyParser.ModifierContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.classOrInterfaceModifier())) {
            return this.configureAST(this.visitClassOrInterfaceModifier(ctx.classOrInterfaceModifier()), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.m)) {
            return this.configureAST(new ModifierNode(ctx.m.getType(), ctx.getText()), ctx);
        }
        throw this.createParsingFailedException("Unsupported modifier: " + ctx.getText(), ctx);
    }

    @Override
    public List<ModifierNode> visitModifiers(GroovyParser.ModifiersContext ctx) {
        ArrayList<ModifierNode> list = new ArrayList<ModifierNode>();
        for (GroovyParser.ModifierContext modifierContext : ctx.modifier()) {
            ModifierNode modifierNode = this.visitModifier(modifierContext);
            list.add(modifierNode);
        }
        return list;
    }

    @Override
    public List<ModifierNode> visitModifiersOpt(GroovyParser.ModifiersOptContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.modifiers())) {
            return this.visitModifiers(ctx.modifiers());
        }
        return Collections.emptyList();
    }

    @Override
    public ModifierNode visitVariableModifier(GroovyParser.VariableModifierContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.annotation())) {
            return this.configureAST(new ModifierNode(this.visitAnnotation(ctx.annotation()), ctx.getText()), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.m)) {
            return this.configureAST(new ModifierNode(ctx.m.getType(), ctx.getText()), ctx);
        }
        throw this.createParsingFailedException("Unsupported variable modifier", ctx);
    }

    @Override
    public List<ModifierNode> visitVariableModifiersOpt(GroovyParser.VariableModifiersOptContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.variableModifiers())) {
            return this.visitVariableModifiers(ctx.variableModifiers());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ModifierNode> visitVariableModifiers(GroovyParser.VariableModifiersContext ctx) {
        ArrayList<ModifierNode> list = new ArrayList<ModifierNode>();
        for (GroovyParser.VariableModifierContext variableModifierContext : ctx.variableModifier()) {
            ModifierNode modifierNode = this.visitVariableModifier(variableModifierContext);
            list.add(modifierNode);
        }
        return list;
    }

    @Override
    public List<List<AnnotationNode>> visitDims(GroovyParser.DimsContext ctx) {
        ArrayList<List<AnnotationNode>> dimList = new ArrayList<List<AnnotationNode>>();
        for (GroovyParser.AnnotationsOptContext annotationsOptContext : ctx.annotationsOpt()) {
            dimList.add((List<AnnotationNode>)this.visitAnnotationsOpt(annotationsOptContext));
        }
        Collections.reverse(dimList);
        return dimList;
    }

    @Override
    public List<List<AnnotationNode>> visitDimsOpt(GroovyParser.DimsOptContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx.dims())) {
            return Collections.emptyList();
        }
        return this.visitDims(ctx.dims());
    }

    @Override
    public ClassNode visitType(GroovyParser.TypeContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return ClassHelper.OBJECT_TYPE;
        }
        ClassNode classNode = null;
        if (DefaultGroovyMethods.asBoolean(ctx.classOrInterfaceType())) {
            ctx.classOrInterfaceType().putNodeMetaData(IS_INSIDE_INSTANCEOF_EXPR, ctx.getNodeMetaData(IS_INSIDE_INSTANCEOF_EXPR));
            classNode = this.visitClassOrInterfaceType(ctx.classOrInterfaceType());
        } else if (DefaultGroovyMethods.asBoolean(ctx.primitiveType())) {
            classNode = this.visitPrimitiveType(ctx.primitiveType());
        }
        if (!DefaultGroovyMethods.asBoolean(classNode)) {
            throw this.createParsingFailedException("Unsupported type: " + ctx.getText(), ctx);
        }
        classNode.addAnnotations((List<AnnotationNode>)this.visitAnnotationsOpt(ctx.annotationsOpt()));
        Object dimList = this.visitDimsOpt(ctx.dimsOpt());
        if (DefaultGroovyMethods.asBoolean((Collection)dimList)) {
            classNode.setGenericsTypes(null);
            classNode.setUsingGenerics(false);
            classNode = this.createArrayType(classNode, (List<List<AnnotationNode>>)dimList);
        }
        return this.configureAST(classNode, ctx);
    }

    @Override
    public ClassNode visitClassOrInterfaceType(GroovyParser.ClassOrInterfaceTypeContext ctx) {
        ClassNode classNode;
        if (DefaultGroovyMethods.asBoolean(ctx.qualifiedClassName())) {
            ctx.qualifiedClassName().putNodeMetaData(IS_INSIDE_INSTANCEOF_EXPR, ctx.getNodeMetaData(IS_INSIDE_INSTANCEOF_EXPR));
            classNode = this.visitQualifiedClassName(ctx.qualifiedClassName());
        } else {
            ctx.qualifiedStandardClassName().putNodeMetaData(IS_INSIDE_INSTANCEOF_EXPR, ctx.getNodeMetaData(IS_INSIDE_INSTANCEOF_EXPR));
            classNode = this.visitQualifiedStandardClassName(ctx.qualifiedStandardClassName());
        }
        if (DefaultGroovyMethods.asBoolean(ctx.typeArguments())) {
            classNode.setGenericsTypes(this.visitTypeArguments(ctx.typeArguments()));
        }
        return this.configureAST(classNode, ctx);
    }

    @Override
    public GenericsType[] visitTypeArgumentsOrDiamond(GroovyParser.TypeArgumentsOrDiamondContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.typeArguments())) {
            return this.visitTypeArguments(ctx.typeArguments());
        }
        if (DefaultGroovyMethods.asBoolean(ctx.LT())) {
            return new GenericsType[0];
        }
        throw this.createParsingFailedException("Unsupported type arguments or diamond: " + ctx.getText(), ctx);
    }

    @Override
    public GenericsType[] visitTypeArguments(GroovyParser.TypeArgumentsContext ctx) {
        ArrayList<GenericsType> list = new ArrayList<GenericsType>();
        for (GroovyParser.TypeArgumentContext typeArgumentContext : ctx.typeArgument()) {
            GenericsType genericsType = this.visitTypeArgument(typeArgumentContext);
            list.add(genericsType);
        }
        return list.toArray(new GenericsType[0]);
    }

    @Override
    public GenericsType visitTypeArgument(GroovyParser.TypeArgumentContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.QUESTION())) {
            ClassNode baseType = this.configureAST(ClassHelper.makeWithoutCaching(QUESTION_STR), ctx.QUESTION());
            baseType.addAnnotations((List<AnnotationNode>)this.visitAnnotationsOpt(ctx.annotationsOpt()));
            if (!DefaultGroovyMethods.asBoolean(ctx.type())) {
                GenericsType genericsType = new GenericsType(baseType);
                genericsType.setWildcard(true);
                genericsType.setName(QUESTION_STR);
                return this.configureAST(genericsType, ctx);
            }
            ClassNode[] upperBounds = null;
            ClassNode lowerBound = null;
            ClassNode classNode = this.visitType(ctx.type());
            if (DefaultGroovyMethods.asBoolean(ctx.EXTENDS())) {
                upperBounds = new ClassNode[]{classNode};
            } else if (DefaultGroovyMethods.asBoolean(ctx.SUPER())) {
                lowerBound = classNode;
            }
            GenericsType genericsType = new GenericsType(baseType, upperBounds, lowerBound);
            genericsType.setWildcard(true);
            genericsType.setName(QUESTION_STR);
            return this.configureAST(genericsType, ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.type())) {
            return this.configureAST(this.createGenericsType(this.visitType(ctx.type())), ctx);
        }
        throw this.createParsingFailedException("Unsupported type argument: " + ctx.getText(), ctx);
    }

    @Override
    public ClassNode visitPrimitiveType(GroovyParser.PrimitiveTypeContext ctx) {
        return this.configureAST(ClassHelper.make(ctx.getText()), ctx);
    }

    @Override
    public VariableExpression visitVariableDeclaratorId(GroovyParser.VariableDeclaratorIdContext ctx) {
        return this.configureAST(new VariableExpression(this.visitIdentifier(ctx.identifier())), ctx);
    }

    @Override
    public TupleExpression visitVariableNames(GroovyParser.VariableNamesContext ctx) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (GroovyParser.VariableDeclaratorIdContext variableDeclaratorIdContext : ctx.variableDeclaratorId()) {
            VariableExpression variableExpression = this.visitVariableDeclaratorId(variableDeclaratorIdContext);
            list.add(variableExpression);
        }
        return this.configureAST(new TupleExpression(list), ctx);
    }

    @Override
    public BlockStatement visitBlockStatementsOpt(GroovyParser.BlockStatementsOptContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.blockStatements())) {
            return this.configureAST(this.visitBlockStatements(ctx.blockStatements()), ctx);
        }
        return this.configureAST(this.createBlockStatement(new Statement[0]), ctx);
    }

    @Override
    public BlockStatement visitBlockStatements(GroovyParser.BlockStatementsContext ctx) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (GroovyParser.BlockStatementContext blockStatementContext : ctx.blockStatement()) {
            Statement e = this.visitBlockStatement(blockStatementContext);
            if (!DefaultGroovyMethods.asBoolean(e)) continue;
            result.add(e);
        }
        return this.configureAST(this.createBlockStatement(result), ctx);
    }

    @Override
    public Statement visitBlockStatement(GroovyParser.BlockStatementContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.localVariableDeclaration())) {
            return this.configureAST(this.visitLocalVariableDeclaration(ctx.localVariableDeclaration()), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.statement())) {
            Object astNode = this.visit(ctx.statement());
            if (astNode instanceof MethodNode) {
                throw this.createParsingFailedException("Method definition not expected here", ctx);
            }
            return (Statement)astNode;
        }
        throw this.createParsingFailedException("Unsupported block statement: " + ctx.getText(), ctx);
    }

    @Override
    public List<AnnotationNode> visitAnnotationsOpt(GroovyParser.AnnotationsOptContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return Collections.emptyList();
        }
        LinkedList<AnnotationNode> list = new LinkedList<AnnotationNode>();
        for (GroovyParser.AnnotationContext annotationContext : ctx.annotation()) {
            list.add(this.visitAnnotation(annotationContext));
        }
        return list;
    }

    @Override
    public AnnotationNode visitAnnotation(GroovyParser.AnnotationContext ctx) {
        String annotationName = this.visitAnnotationName(ctx.annotationName());
        AnnotationNode annotationNode = new AnnotationNode(ClassHelper.make(annotationName));
        Object annotationElementValues = this.visitElementValues(ctx.elementValues());
        Iterator iterator = annotationElementValues.iterator();
        while (iterator.hasNext()) {
            Pair e = (Pair)iterator.next();
            annotationNode.addMember((String)e.getKey(), (Expression)e.getValue());
        }
        return this.configureAST(annotationNode, ctx);
    }

    @Override
    public List<Pair<String, Expression>> visitElementValues(GroovyParser.ElementValuesContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return Collections.emptyList();
        }
        LinkedList<Pair<String, Expression>> annotationElementValues = new LinkedList<Pair<String, Expression>>();
        if (DefaultGroovyMethods.asBoolean(ctx.elementValuePairs())) {
            for (Map.Entry e : this.visitElementValuePairs(ctx.elementValuePairs()).entrySet()) {
                annotationElementValues.add(new Pair(e.getKey(), e.getValue()));
            }
        } else if (DefaultGroovyMethods.asBoolean(ctx.elementValue())) {
            annotationElementValues.add(new Pair<String, Expression>(VALUE_STR, this.visitElementValue(ctx.elementValue())));
        }
        return annotationElementValues;
    }

    @Override
    public String visitAnnotationName(GroovyParser.AnnotationNameContext ctx) {
        return this.visitQualifiedClassName(ctx.qualifiedClassName()).getName();
    }

    @Override
    public Map<String, Expression> visitElementValuePairs(GroovyParser.ElementValuePairsContext ctx) {
        LinkedHashMap<String, Expression> map = new LinkedHashMap<String, Expression>();
        for (GroovyParser.ElementValuePairContext elementValuePairContext : ctx.elementValuePair()) {
            Object stringExpressionPair = this.visitElementValuePair(elementValuePairContext);
            if (map.containsKey(((Pair)stringExpressionPair).getKey())) {
                throw new IllegalStateException(String.format("Duplicate key %s", ((Pair)stringExpressionPair).getKey()));
            }
            map.put((String)((Pair)stringExpressionPair).getKey(), (Expression)((Pair)stringExpressionPair).getValue());
        }
        return map;
    }

    @Override
    public Pair<String, Expression> visitElementValuePair(GroovyParser.ElementValuePairContext ctx) {
        return new Pair<String, Expression>(ctx.elementValuePairName().getText(), this.visitElementValue(ctx.elementValue()));
    }

    @Override
    public Expression visitElementValue(GroovyParser.ElementValueContext ctx) {
        if (DefaultGroovyMethods.asBoolean(ctx.expression())) {
            return this.configureAST((Expression)this.visit(ctx.expression()), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.annotation())) {
            return this.configureAST(new AnnotationConstantExpression(this.visitAnnotation(ctx.annotation())), ctx);
        }
        if (DefaultGroovyMethods.asBoolean(ctx.elementValueArrayInitializer())) {
            return this.configureAST(this.visitElementValueArrayInitializer(ctx.elementValueArrayInitializer()), ctx);
        }
        throw this.createParsingFailedException("Unsupported element value: " + ctx.getText(), ctx);
    }

    @Override
    public ListExpression visitElementValueArrayInitializer(GroovyParser.ElementValueArrayInitializerContext ctx) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (GroovyParser.ElementValueContext elementValueContext : ctx.elementValue()) {
            Expression expression = this.visitElementValue(elementValueContext);
            list.add(expression);
        }
        return this.configureAST(new ListExpression(list), ctx);
    }

    @Override
    public String visitClassName(GroovyParser.ClassNameContext ctx) {
        String text = ctx.getText();
        if (!text.contains("\\")) {
            return text;
        }
        return StringUtils.replaceHexEscapes(text);
    }

    @Override
    public String visitIdentifier(GroovyParser.IdentifierContext ctx) {
        String text = ctx.getText();
        if (!text.contains("\\")) {
            return text;
        }
        return StringUtils.replaceHexEscapes(text);
    }

    @Override
    public String visitQualifiedName(GroovyParser.QualifiedNameContext ctx) {
        StringBuilder builder = new StringBuilder();
        for (GroovyParser.QualifiedNameElementContext qualifiedNameElementContext : ctx.qualifiedNameElement()) {
            String text = qualifiedNameElementContext.getText();
            if (builder.length() > 0) {
                builder.append(DOT_STR);
            }
            builder.append(text);
        }
        return builder.toString();
    }

    @Override
    public ClassNode visitAnnotatedQualifiedClassName(GroovyParser.AnnotatedQualifiedClassNameContext ctx) {
        ClassNode classNode = this.visitQualifiedClassName(ctx.qualifiedClassName());
        classNode.addAnnotations((List<AnnotationNode>)this.visitAnnotationsOpt(ctx.annotationsOpt()));
        return classNode;
    }

    @Override
    public ClassNode[] visitQualifiedClassNameList(GroovyParser.QualifiedClassNameListContext ctx) {
        if (!DefaultGroovyMethods.asBoolean(ctx)) {
            return new ClassNode[0];
        }
        ArrayList<ClassNode> list = new ArrayList<ClassNode>();
        for (GroovyParser.AnnotatedQualifiedClassNameContext annotatedQualifiedClassNameContext : ctx.annotatedQualifiedClassName()) {
            ClassNode classNode = this.visitAnnotatedQualifiedClassName(annotatedQualifiedClassNameContext);
            list.add(classNode);
        }
        return list.toArray(new ClassNode[0]);
    }

    @Override
    public ClassNode visitQualifiedClassName(GroovyParser.QualifiedClassNameContext ctx) {
        return this.createClassNode(ctx);
    }

    @Override
    public ClassNode visitQualifiedStandardClassName(GroovyParser.QualifiedStandardClassNameContext ctx) {
        return this.createClassNode(ctx);
    }

    private ClassNode createClassNode(GroovyParser.GroovyParserRuleContext ctx) {
        ClassNode result = ClassHelper.make(ctx.getText());
        if (!this.isTrue(ctx, IS_INSIDE_INSTANCEOF_EXPR)) {
            result = this.proxyClassNode(result);
        }
        return this.configureAST(result, ctx);
    }

    private ClassNode proxyClassNode(ClassNode classNode) {
        if (!classNode.isUsingGenerics()) {
            return classNode;
        }
        ClassNode cn = ClassHelper.makeWithoutCaching(classNode.getName());
        cn.setRedirect(classNode);
        return cn;
    }

    @Override
    public Object visit(ParseTree tree) {
        if (!DefaultGroovyMethods.asBoolean(tree)) {
            return null;
        }
        return super.visit(tree);
    }

    private MethodCallExpression createMethodCallExpression(PropertyExpression propertyExpression, Expression arguments) {
        MethodCallExpression methodCallExpression = new MethodCallExpression(propertyExpression.getObjectExpression(), propertyExpression.getProperty(), arguments);
        methodCallExpression.setImplicitThis(false);
        methodCallExpression.setSafe(propertyExpression.isSafe());
        methodCallExpression.setSpreadSafe(propertyExpression.isSpreadSafe());
        if (propertyExpression.isSpreadSafe()) {
            methodCallExpression.setSafe(false);
        }
        methodCallExpression.setGenericsTypes((GenericsType[])propertyExpression.getNodeMetaData(PATH_EXPRESSION_BASE_EXPR_GENERICS_TYPES));
        return methodCallExpression;
    }

    private MethodCallExpression createMethodCallExpression(Expression baseExpr, Expression arguments) {
        return new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, baseExpr instanceof VariableExpression ? this.createConstantExpression(baseExpr) : baseExpr, arguments);
    }

    private Parameter processFormalParameter(GroovyParser.GroovyParserRuleContext ctx, GroovyParser.VariableModifiersOptContext variableModifiersOptContext, GroovyParser.TypeContext typeContext, TerminalNode ellipsis, GroovyParser.VariableDeclaratorIdContext variableDeclaratorIdContext, GroovyParser.ExpressionContext expressionContext) {
        ClassNode classNode = this.visitType(typeContext);
        if (DefaultGroovyMethods.asBoolean(ellipsis)) {
            classNode = this.configureAST(classNode.makeArray(), classNode);
        }
        Parameter parameter = new ModifierManager(this, (List<ModifierNode>)this.visitVariableModifiersOpt(variableModifiersOptContext)).processParameter(this.configureAST(new Parameter(classNode, this.visitVariableDeclaratorId(variableDeclaratorIdContext).getName()), ctx));
        if (DefaultGroovyMethods.asBoolean(expressionContext)) {
            parameter.setInitialExpression((Expression)this.visit(expressionContext));
        }
        return parameter;
    }

    private Expression createPathExpression(Expression primaryExpr, List<? extends GroovyParser.PathElementContext> pathElementContextList) {
        Expression expr = primaryExpr;
        for (GroovyParser.PathElementContext pathElementContext : pathElementContextList) {
            pathElementContext.putNodeMetaData(PATH_EXPRESSION_BASE_EXPR, expr);
            expr = this.visitPathElement(pathElementContext);
        }
        return expr;
    }

    private GenericsType createGenericsType(ClassNode classNode) {
        return this.configureAST(new GenericsType(classNode), classNode);
    }

    private ConstantExpression createConstantExpression(Expression expression) {
        if (expression instanceof ConstantExpression) {
            return (ConstantExpression)expression;
        }
        return this.configureAST(new ConstantExpression(expression.getText()), expression);
    }

    private BinaryExpression createBinaryExpression(GroovyParser.ExpressionContext left, groovyjarjarantlr4.v4.runtime.Token op, GroovyParser.ExpressionContext right) {
        return new BinaryExpression((Expression)this.visit(left), this.createGroovyToken(op), (Expression)this.visit(right));
    }

    private BinaryExpression createBinaryExpression(GroovyParser.ExpressionContext left, groovyjarjarantlr4.v4.runtime.Token op, GroovyParser.ExpressionContext right, GroovyParser.ExpressionContext ctx) {
        BinaryExpression binaryExpression = this.createBinaryExpression(left, op, right);
        if (this.isTrue(ctx, IS_INSIDE_CONDITIONAL_EXPRESSION)) {
            return this.configureAST(binaryExpression, op);
        }
        return this.configureAST(binaryExpression, ctx);
    }

    private Statement unpackStatement(Statement statement) {
        if (statement instanceof DeclarationListStatement) {
            List<ExpressionStatement> expressionStatementList = ((DeclarationListStatement)statement).getDeclarationStatements();
            if (1 == expressionStatementList.size()) {
                return expressionStatementList.get(0);
            }
            return this.configureAST(this.createBlockStatement(statement), statement);
        }
        return statement;
    }

    public BlockStatement createBlockStatement(Statement ... statements) {
        return this.createBlockStatement(Arrays.asList(statements));
    }

    private BlockStatement createBlockStatement(List<Statement> statementList) {
        return this.appendStatementsToBlockStatement(new BlockStatement(), statementList);
    }

    public BlockStatement appendStatementsToBlockStatement(BlockStatement bs, Statement ... statements) {
        return this.appendStatementsToBlockStatement(bs, Arrays.asList(statements));
    }

    private BlockStatement appendStatementsToBlockStatement(BlockStatement bs, List<Statement> statementList) {
        for (Statement e : statementList) {
            if (e instanceof DeclarationListStatement) {
                for (ExpressionStatement s : ((DeclarationListStatement)e).getDeclarationStatements()) {
                    bs.addStatement(s);
                }
                continue;
            }
            bs.addStatement(e);
        }
        return bs;
    }

    private boolean isAnnotationDeclaration(ClassNode classNode) {
        return DefaultGroovyMethods.asBoolean(classNode) && classNode.isAnnotationDefinition();
    }

    private boolean isSyntheticPublic(boolean isAnnotationDeclaration, boolean isAnonymousInnerEnumDeclaration, boolean hasReturnType, ModifierManager modifierManager) {
        return this.isSyntheticPublic(isAnnotationDeclaration, isAnonymousInnerEnumDeclaration, modifierManager.containsAnnotations(), modifierManager.containsVisibilityModifier(), modifierManager.containsNonVisibilityModifier(), hasReturnType, modifierManager.contains(8));
    }

    private boolean isSyntheticPublic(boolean isAnnotationDeclaration, boolean isAnonymousInnerEnumDeclaration, boolean hasAnnotation, boolean hasVisibilityModifier, boolean hasModifier, boolean hasReturnType, boolean hasDef) {
        if (hasVisibilityModifier) {
            return false;
        }
        if (isAnnotationDeclaration) {
            return true;
        }
        if (hasDef && hasReturnType) {
            return true;
        }
        if (hasModifier || hasAnnotation || !hasReturnType) {
            return true;
        }
        return isAnonymousInnerEnumDeclaration;
    }

    private void hackMixins(ClassNode classNode) {
        classNode.setMixins(null);
    }

    private Object findDefaultValueByType(ClassNode type) {
        return TYPE_DEFAULT_VALUE_MAP.get(type);
    }

    private boolean isPackageInfoDeclaration() {
        String name = this.sourceUnit.getName();
        return null != name && name.endsWith(PACKAGE_INFO_FILE_NAME);
    }

    private boolean isBlankScript(GroovyParser.CompilationUnitContext ctx) {
        return this.moduleNode.getStatementBlock().isEmpty() && this.moduleNode.getMethods().isEmpty() && this.moduleNode.getClasses().isEmpty();
    }

    private boolean isInsideParentheses(NodeMetaDataHandler nodeMetaDataHandler) {
        Integer insideParenLevel = (Integer)nodeMetaDataHandler.getNodeMetaData(INSIDE_PARENTHESES_LEVEL);
        if (null != insideParenLevel) {
            return insideParenLevel > 0;
        }
        return false;
    }

    private void addEmptyReturnStatement() {
        this.moduleNode.addStatement(ReturnStatement.RETURN_NULL_OR_VOID);
    }

    private void addPackageInfoClassNode() {
        ClassNode packageInfoClassNode;
        List<ClassNode> classNodeList = this.moduleNode.getClasses();
        if (!classNodeList.contains(packageInfoClassNode = ClassHelper.make(this.moduleNode.getPackageName() + PACKAGE_INFO))) {
            this.moduleNode.addClass(packageInfoClassNode);
        }
    }

    private Token createGroovyTokenByType(groovyjarjarantlr4.v4.runtime.Token token, int type) {
        if (null == token) {
            throw new IllegalArgumentException("token should not be null");
        }
        return new Token(type, token.getText(), token.getLine(), token.getCharPositionInLine());
    }

    private Token createGroovyToken(groovyjarjarantlr4.v4.runtime.Token token) {
        return this.createGroovyToken(token, 1);
    }

    private Token createGroovyToken(groovyjarjarantlr4.v4.runtime.Token token, int cardinality) {
        String text = StringGroovyMethods.multiply((CharSequence)token.getText(), (Number)cardinality);
        return new Token("..<".equals(token.getText()) || "..".equals(token.getText()) ? 1104 : Types.lookup(text, 1000), text, token.getLine(), token.getCharPositionInLine() + 1);
    }

    private void configureScriptClassNode() {
        ClassNode scriptClassNode = this.moduleNode.getScriptClassDummy();
        if (!DefaultGroovyMethods.asBoolean(scriptClassNode)) {
            return;
        }
        List<Statement> statements = this.moduleNode.getStatementBlock().getStatements();
        if (!statements.isEmpty()) {
            Statement firstStatement = statements.get(0);
            Statement lastStatement = statements.get(statements.size() - 1);
            scriptClassNode.setSourcePosition(firstStatement);
            scriptClassNode.setLastColumnNumber(lastStatement.getLastColumnNumber());
            scriptClassNode.setLastLineNumber(lastStatement.getLastLineNumber());
        }
    }

    private <T extends ASTNode> T configureAST(T astNode, GroovyParser.GroovyParserRuleContext ctx) {
        groovyjarjarantlr4.v4.runtime.Token start = ctx.getStart();
        groovyjarjarantlr4.v4.runtime.Token stop = ctx.getStop();
        astNode.setLineNumber(start.getLine());
        astNode.setColumnNumber(start.getCharPositionInLine() + 1);
        Pair<Integer, Integer> stopTokenEndPosition = this.endPosition(stop);
        astNode.setLastLineNumber(stopTokenEndPosition.getKey());
        astNode.setLastColumnNumber(stopTokenEndPosition.getValue());
        return astNode;
    }

    private Pair<Integer, Integer> endPosition(groovyjarjarantlr4.v4.runtime.Token token) {
        String stopText = token.getText();
        int stopTextLength = 0;
        int newLineCnt = 0;
        if (null != stopText) {
            stopTextLength = stopText.length();
            newLineCnt = (int)StringUtils.countChar(stopText, '\n');
        }
        if (0 == newLineCnt) {
            return new Pair<Integer, Integer>(token.getLine(), token.getCharPositionInLine() + 1 + token.getText().length());
        }
        return new Pair<Integer, Integer>(token.getLine() + newLineCnt, stopTextLength - stopText.lastIndexOf(10));
    }

    private <T extends ASTNode> T configureAST(T astNode, TerminalNode terminalNode) {
        return this.configureAST(astNode, terminalNode.getSymbol());
    }

    private <T extends ASTNode> T configureAST(T astNode, groovyjarjarantlr4.v4.runtime.Token token) {
        astNode.setLineNumber(token.getLine());
        astNode.setColumnNumber(token.getCharPositionInLine() + 1);
        astNode.setLastLineNumber(token.getLine());
        astNode.setLastColumnNumber(token.getCharPositionInLine() + 1 + token.getText().length());
        return astNode;
    }

    private <T extends ASTNode> T configureAST(T astNode, ASTNode source) {
        astNode.setLineNumber(source.getLineNumber());
        astNode.setColumnNumber(source.getColumnNumber());
        astNode.setLastLineNumber(source.getLastLineNumber());
        astNode.setLastColumnNumber(source.getLastColumnNumber());
        return astNode;
    }

    private <T extends ASTNode> T configureAST(T astNode, GroovyParser.GroovyParserRuleContext ctx, ASTNode stop) {
        groovyjarjarantlr4.v4.runtime.Token start = ctx.getStart();
        astNode.setLineNumber(start.getLine());
        astNode.setColumnNumber(start.getCharPositionInLine() + 1);
        if (DefaultGroovyMethods.asBoolean(stop)) {
            astNode.setLastLineNumber(stop.getLastLineNumber());
            astNode.setLastColumnNumber(stop.getLastColumnNumber());
        } else {
            Pair<Integer, Integer> endPosition = this.endPosition(start);
            astNode.setLastLineNumber(endPosition.getKey());
            astNode.setLastColumnNumber(endPosition.getValue());
        }
        return astNode;
    }

    private <T extends ASTNode> T configureAST(T astNode, ASTNode start, ASTNode stop) {
        astNode.setLineNumber(start.getLineNumber());
        astNode.setColumnNumber(start.getColumnNumber());
        if (DefaultGroovyMethods.asBoolean(stop)) {
            astNode.setLastLineNumber(stop.getLastLineNumber());
            astNode.setLastColumnNumber(stop.getLastColumnNumber());
        } else {
            astNode.setLastLineNumber(start.getLastLineNumber());
            astNode.setLastColumnNumber(start.getLastColumnNumber());
        }
        return astNode;
    }

    private boolean isTrue(NodeMetaDataHandler nodeMetaDataHandler, String key) {
        Object nmd = nodeMetaDataHandler.getNodeMetaData(key);
        if (null == nmd) {
            return false;
        }
        if (!(nmd instanceof Boolean)) {
            throw new GroovyBugError(nodeMetaDataHandler + " node meta data[" + key + "] is not an instance of Boolean");
        }
        return (Boolean)nmd;
    }

    private CompilationFailedException createParsingFailedException(String msg, GroovyParser.GroovyParserRuleContext ctx) {
        return this.createParsingFailedException(new SyntaxException(msg, ctx.start.getLine(), ctx.start.getCharPositionInLine() + 1, ctx.stop.getLine(), ctx.stop.getCharPositionInLine() + 1 + ctx.stop.getText().length()));
    }

    public CompilationFailedException createParsingFailedException(String msg, ASTNode node) {
        Objects.requireNonNull(node, "node passed into createParsingFailedException should not be null");
        return this.createParsingFailedException(new SyntaxException(msg, node.getLineNumber(), node.getColumnNumber(), node.getLastLineNumber(), node.getLastColumnNumber()));
    }

    private CompilationFailedException createParsingFailedException(Throwable t) {
        if (t instanceof SyntaxException) {
            this.collectSyntaxError((SyntaxException)t);
        } else if (t instanceof GroovySyntaxError) {
            GroovySyntaxError groovySyntaxError = (GroovySyntaxError)((Object)t);
            this.collectSyntaxError(new SyntaxException(groovySyntaxError.getMessage(), (Throwable)((Object)groovySyntaxError), groovySyntaxError.getLine(), groovySyntaxError.getColumn()));
        } else if (t instanceof Exception) {
            this.collectException((Exception)t);
        }
        return new CompilationFailedException(CompilePhase.PARSING.getPhaseNumber(), this.sourceUnit, t);
    }

    private void collectSyntaxError(SyntaxException e) {
        this.sourceUnit.getErrorCollector().addFatalError(new SyntaxErrorMessage(e, this.sourceUnit));
    }

    private void collectException(Exception e) {
        this.sourceUnit.getErrorCollector().addException(e, this.sourceUnit);
    }

    private ANTLRErrorListener createANTLRErrorListener() {
        return new ANTLRErrorListener(){

            public void syntaxError(Recognizer recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                AstBuilder.this.collectSyntaxError(new SyntaxException(msg, line, charPositionInLine + 1));
            }
        };
    }

    private void removeErrorListeners() {
        this.lexer.removeErrorListeners();
        this.parser.removeErrorListeners();
    }

    private void addErrorListeners() {
        this.lexer.removeErrorListeners();
        this.lexer.addErrorListener(this.createANTLRErrorListener());
        this.parser.removeErrorListeners();
        this.parser.addErrorListener(this.createANTLRErrorListener());
    }

    private String createExceptionMessage(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
        }
        return sw.toString();
    }

    private static class Pair<K, V> {
        private K key;
        private V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return Objects.equals(this.key, pair.key) && Objects.equals(this.value, pair.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }

    private class DeclarationListStatement
    extends Statement {
        private final List<ExpressionStatement> declarationStatements;

        public DeclarationListStatement(DeclarationExpression ... declarations) {
            this(Arrays.asList(declarations));
        }

        public DeclarationListStatement(List<DeclarationExpression> declarations) {
            ArrayList<ExpressionStatement> list = new ArrayList<ExpressionStatement>();
            for (DeclarationExpression e : declarations) {
                ExpressionStatement expressionStatement = (ExpressionStatement)AstBuilder.this.configureAST(new ExpressionStatement(e), e);
                list.add(expressionStatement);
            }
            this.declarationStatements = list;
        }

        public List<ExpressionStatement> getDeclarationStatements() {
            List<String> declarationListStatementLabels = this.getStatementLabels();
            for (ExpressionStatement e : this.declarationStatements) {
                if (null == declarationListStatementLabels) continue;
                if (null != e.getStatementLabels()) {
                    e.getStatementLabels().clear();
                }
                for (String s : declarationListStatementLabels) {
                    e.addStatementLabel(s);
                }
            }
            return this.declarationStatements;
        }

        public List<DeclarationExpression> getDeclarationExpressions() {
            ArrayList<DeclarationExpression> list = new ArrayList<DeclarationExpression>();
            for (ExpressionStatement e : this.declarationStatements) {
                DeclarationExpression expression = (DeclarationExpression)e.getExpression();
                list.add(expression);
            }
            return list;
        }
    }
}

