/*
 * Decompiled with CFR 0.152.
 */
package groovy.grape;

import groovy.grape.Grape;
import groovy.lang.Grab;
import groovy.lang.Grapes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CONVERSION)
public class GrabAnnotationTransformation
extends ClassCodeVisitorSupport
implements ASTTransformation {
    private static final String GRAB_CLASS_NAME = Grab.class.getName();
    private static final String GRAB_DOT_NAME = GRAB_CLASS_NAME.substring(GRAB_CLASS_NAME.lastIndexOf("."));
    private static final String GRAB_SHORT_NAME = GRAB_DOT_NAME.substring(1);
    private static final String GRAPES_CLASS_NAME = Grapes.class.getName();
    private static final String GRAPES_DOT_NAME = GRAPES_CLASS_NAME.substring(GRAPES_CLASS_NAME.lastIndexOf("."));
    private static final String GRAPES_SHORT_NAME = GRAPES_DOT_NAME.substring(1);
    boolean allowShortGrab;
    Set<String> grabAliases;
    List<AnnotationNode> grabAnnotations;
    boolean allowShortGrapes;
    Set<String> grapesAliases;
    List<AnnotationNode> grapesAnnotations;
    SourceUnit sourceUnit;

    public SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.sourceUnit = source;
        ModuleNode mn = (ModuleNode)nodes[0];
        this.allowShortGrab = true;
        this.allowShortGrapes = true;
        this.grabAliases = new HashSet<String>();
        this.grapesAliases = new HashSet<String>();
        for (ImportNode im : mn.getImports()) {
            String alias = im.getAlias();
            String className = im.getClassName();
            if (className.endsWith(GRAB_DOT_NAME) && (alias == null || alias.length() == 0) || GRAB_CLASS_NAME.equals(alias)) {
                this.allowShortGrab = false;
            } else if (GRAB_CLASS_NAME.equals(className)) {
                this.grabAliases.add(im.getAlias());
            }
            if (className.endsWith(GRAPES_DOT_NAME) && (alias == null || alias.length() == 0) || GRAPES_CLASS_NAME.equals(alias)) {
                this.allowShortGrapes = false;
                continue;
            }
            if (!GRAPES_CLASS_NAME.equals(className)) continue;
            this.grapesAliases.add(im.getAlias());
        }
        ArrayList grabMaps = new ArrayList();
        for (ClassNode classNode : this.sourceUnit.getAST().getClasses()) {
            this.grabAnnotations = new ArrayList<AnnotationNode>();
            this.grapesAnnotations = new ArrayList<AnnotationNode>();
            this.visitClass(classNode);
            ClassNode grapeClassNode = new ClassNode(Grape.class);
            if (!this.grapesAnnotations.isEmpty()) {
                for (AnnotationNode node : this.grapesAnnotations) {
                    Expression init = node.getMember("initClass");
                    Expression value = node.getMember("value");
                    if (value instanceof ListExpression) {
                        for (Expression o : ((ListExpression)value).getExpressions()) {
                            if (!(o instanceof ConstantExpression)) continue;
                            this.extractGrab(init, (ConstantExpression)o);
                        }
                        continue;
                    }
                    if (!(value instanceof ConstantExpression)) continue;
                    this.extractGrab(init, (ConstantExpression)value);
                }
            }
            if (this.grabAnnotations.isEmpty()) continue;
            block6: for (AnnotationNode node : this.grabAnnotations) {
                HashMap<String, Object> grabMap = new HashMap<String, Object>();
                this.checkForConvenienceForm(node);
                for (String s : new String[]{"group", "module", "version", "classifier"}) {
                    Expression member = node.getMember(s);
                    if (member == null && !s.equals("classifier")) {
                        this.addError("The missing attribute \"" + s + "\" is required in @" + node.getClassNode().getNameWithoutPackage() + " annotations", node);
                        continue block6;
                    }
                    if (member == null || member instanceof ConstantExpression) continue;
                    this.addError("Attribute \"" + s + "\" has value " + member.getText() + " but should be an inline constant in @" + node.getClassNode().getNameWithoutPackage() + " annotations", node);
                    continue block6;
                }
                grabMap.put("group", ((ConstantExpression)node.getMember("group")).getValue());
                grabMap.put("module", ((ConstantExpression)node.getMember("module")).getValue());
                grabMap.put("version", ((ConstantExpression)node.getMember("version")).getValue());
                if (node.getMember("classifier") != null) {
                    grabMap.put("classifier", ((ConstantExpression)node.getMember("classifier")).getValue());
                }
                grabMaps.add(grabMap);
                if (node.getMember("initClass") != null && node.getMember("initClass") != ConstantExpression.TRUE) continue;
                ArrayList<Statement> grabInitializers = new ArrayList<Statement>();
                MapExpression me = new MapExpression();
                me.addMapEntryExpression(new ConstantExpression("group"), node.getMember("group"));
                me.addMapEntryExpression(new ConstantExpression("module"), node.getMember("module"));
                me.addMapEntryExpression(new ConstantExpression("version"), node.getMember("version"));
                if (node.getMember("classifier") != null) {
                    me.addMapEntryExpression(new ConstantExpression("classifier"), node.getMember("classifier"));
                }
                grabInitializers.add(new ExpressionStatement(new StaticMethodCallExpression(grapeClassNode, "grab", new ArgumentListExpression(me))));
                classNode.addStaticInitializerStatements(grabInitializers, true);
            }
        }
        if (!grabMaps.isEmpty()) {
            HashMap<String, Object> basicArgs = new HashMap<String, Object>();
            basicArgs.put("classLoader", this.sourceUnit.getClassLoader());
            try {
                Grape.grab(basicArgs, grabMaps.toArray(new Map[grabMaps.size()]));
            }
            catch (RuntimeException re) {
                source.addException(re);
            }
        }
    }

    private void checkForConvenienceForm(AnnotationNode node) {
        Expression val = node.getMember("value");
        if (val == null || !(val instanceof ConstantExpression)) {
            return;
        }
        Object allParts = ((ConstantExpression)val).getValue();
        if (!(allParts instanceof String)) {
            return;
        }
        String allstr = (String)allParts;
        if (allstr.contains(":")) {
            String[] parts = allstr.split(":");
            if (parts.length > 4) {
                return;
            }
            if (parts.length > 3) {
                node.addMember("classifier", new ConstantExpression(parts[3]));
            }
            if (parts.length > 2) {
                node.addMember("version", new ConstantExpression(parts[2]));
            } else {
                node.addMember("version", new ConstantExpression("*"));
            }
            node.addMember("module", new ConstantExpression(parts[1]));
            node.addMember("group", new ConstantExpression(parts[0]));
        }
    }

    private void extractGrab(Expression init, ConstantExpression ce) {
        if (ce.getValue() instanceof AnnotationNode) {
            String name;
            AnnotationNode annotation = (AnnotationNode)ce.getValue();
            if (init != null && annotation.getMember("initClass") != null) {
                annotation.setMember("initClass", init);
            }
            if (GRAB_CLASS_NAME.equals(name = annotation.getClassNode().getName()) || this.allowShortGrab && GRAB_SHORT_NAME.equals(name) || this.grabAliases.contains(name)) {
                this.grabAnnotations.add(annotation);
            }
        }
    }

    public void visitAnnotations(AnnotatedNode node) {
        super.visitAnnotations(node);
        for (AnnotationNode an : node.getAnnotations()) {
            String name = an.getClassNode().getName();
            if (GRAB_CLASS_NAME.equals(name) || this.allowShortGrab && GRAB_SHORT_NAME.equals(name) || this.grabAliases.contains(name)) {
                this.grabAnnotations.add(an);
            }
            if (!GRAPES_CLASS_NAME.equals(name) && (!this.allowShortGrapes || !GRAPES_SHORT_NAME.equals(name)) && !this.grapesAliases.contains(name)) continue;
            this.grapesAnnotations.add(an);
        }
    }
}

