/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import groovyjarjarretroruntime.java.lang._String;
import groovyjarjarretroruntime.java.util.regex._Matcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.groovydoc.GroovyAnnotationRef;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.groovydoc.GroovyConstructorDoc;
import org.codehaus.groovy.groovydoc.GroovyFieldDoc;
import org.codehaus.groovy.groovydoc.GroovyMethodDoc;
import org.codehaus.groovy.groovydoc.GroovyPackageDoc;
import org.codehaus.groovy.groovydoc.GroovyParameter;
import org.codehaus.groovy.groovydoc.GroovyRootDoc;
import org.codehaus.groovy.groovydoc.GroovyType;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.tools.groovydoc.ExternalGroovyClassDoc;
import org.codehaus.groovy.tools.groovydoc.LinkArgument;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyAnnotationRef;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyFieldDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyParameter;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyProgramElementDoc;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleGroovyClassDoc
extends SimpleGroovyProgramElementDoc
implements GroovyClassDoc {
    private static final Pattern TAG_REGEX = Pattern.compile("(?m)@([a-z]+)\\s+(.*$[^@]*)");
    private static final Pattern LINK_REGEX = Pattern.compile("(?m)[{]@(link)\\s+([^}]*)}");
    private static final Pattern CODE_REGEX = Pattern.compile("(?m)[{]@(code)\\s+([^}]*)}");
    private final List<GroovyConstructorDoc> constructors;
    private final List<GroovyFieldDoc> fields;
    private final List<GroovyFieldDoc> properties;
    private final List<GroovyFieldDoc> enumConstants;
    private final List<GroovyMethodDoc> methods;
    private final List<String> importedClassesAndPackages;
    private final List<String> interfaceNames;
    private final List<GroovyClassDoc> interfaceClasses;
    private final List<GroovyClassDoc> nested;
    private final List<LinkArgument> links;
    private GroovyClassDoc superClass;
    private GroovyClassDoc outer;
    private String superClassName;
    private String fullPathName;
    static /* synthetic */ Class class$java$lang$Object;

    public SimpleGroovyClassDoc(List<String> importedClassesAndPackages, String name, List<LinkArgument> links) {
        super(name);
        this.importedClassesAndPackages = importedClassesAndPackages;
        this.links = links;
        this.constructors = new ArrayList<GroovyConstructorDoc>();
        this.fields = new ArrayList<GroovyFieldDoc>();
        this.properties = new ArrayList<GroovyFieldDoc>();
        this.enumConstants = new ArrayList<GroovyFieldDoc>();
        this.methods = new ArrayList<GroovyMethodDoc>();
        this.interfaceNames = new ArrayList<String>();
        this.interfaceClasses = new ArrayList<GroovyClassDoc>();
        this.nested = new ArrayList<GroovyClassDoc>();
    }

    public SimpleGroovyClassDoc(List<String> importedClassesAndPackages, String name) {
        this(importedClassesAndPackages, name, new ArrayList<LinkArgument>());
    }

    @Override
    public GroovyConstructorDoc[] constructors() {
        Collections.sort(this.constructors);
        return this.constructors.toArray(new GroovyConstructorDoc[this.constructors.size()]);
    }

    public boolean add(GroovyConstructorDoc constructor) {
        return this.constructors.add(constructor);
    }

    public GroovyClassDoc getOuter() {
        return this.outer;
    }

    public void setOuter(GroovyClassDoc outer) {
        this.outer = outer;
    }

    @Override
    public GroovyClassDoc[] innerClasses() {
        Collections.sort(this.nested);
        return this.nested.toArray(new GroovyClassDoc[this.nested.size()]);
    }

    public boolean addNested(GroovyClassDoc nestedClass) {
        return this.nested.add(nestedClass);
    }

    @Override
    public GroovyFieldDoc[] fields() {
        Collections.sort(this.fields);
        return this.fields.toArray(new GroovyFieldDoc[this.fields.size()]);
    }

    public boolean add(GroovyFieldDoc field) {
        return this.fields.add(field);
    }

    @Override
    public GroovyFieldDoc[] properties() {
        Collections.sort(this.properties);
        return this.properties.toArray(new GroovyFieldDoc[this.properties.size()]);
    }

    public boolean addProperty(GroovyFieldDoc property) {
        return this.properties.add(property);
    }

    @Override
    public GroovyFieldDoc[] enumConstants() {
        Collections.sort(this.enumConstants);
        return this.enumConstants.toArray(new GroovyFieldDoc[this.enumConstants.size()]);
    }

    public boolean addEnumConstant(GroovyFieldDoc field) {
        return this.enumConstants.add(field);
    }

    @Override
    public GroovyMethodDoc[] methods() {
        Collections.sort(this.methods);
        return this.methods.toArray(new GroovyMethodDoc[this.methods.size()]);
    }

    public boolean add(GroovyMethodDoc method) {
        return this.methods.add(method);
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassName(String className) {
        this.superClassName = className;
    }

    @Override
    public GroovyClassDoc superclass() {
        return this.superClass;
    }

    public void setSuperClass(GroovyClassDoc doc) {
        this.superClass = doc;
    }

    @Override
    public String getFullPathName() {
        return this.fullPathName;
    }

    public void setFullPathName(String fullPathName) {
        this.fullPathName = fullPathName;
    }

    @Override
    public String getRelativeRootPath() {
        StringTokenizer tokenizer = new StringTokenizer(this.fullPathName, "/");
        StringBuffer sb = new StringBuffer();
        if (tokenizer.hasMoreTokens()) {
            tokenizer.nextToken();
        }
        while (tokenizer.hasMoreTokens()) {
            tokenizer.nextToken();
            sb.append("../");
        }
        return sb.toString();
    }

    public List<GroovyClassDoc> getParentClasses() {
        LinkedList<GroovyClassDoc> result = new LinkedList<GroovyClassDoc>();
        if (this.isInterface()) {
            return result;
        }
        result.add(0, this);
        GroovyClassDoc next = this;
        while (next.superclass() != null && !"java.lang.Object".equals(next.qualifiedTypeName())) {
            next = next.superclass();
            result.add(0, next);
        }
        GroovyClassDoc prev = next;
        Class nextClass = this.getClassOf(next.qualifiedTypeName());
        while (nextClass != null && nextClass.getSuperclass() != null) {
            Class<?> clazz = class$java$lang$Object;
            if (clazz == null) {
                clazz = new Object[0].getClass().getComponentType();
            }
            if (clazz.equals(nextClass)) break;
            nextClass = nextClass.getSuperclass();
            ExternalGroovyClassDoc nextDoc = new ExternalGroovyClassDoc(nextClass);
            if (prev instanceof SimpleGroovyClassDoc) {
                SimpleGroovyClassDoc parent = prev;
                parent.setSuperClass(nextDoc);
            }
            result.add(0, nextDoc);
            prev = nextDoc;
        }
        if (!((GroovyClassDoc)result.get(0)).qualifiedTypeName().equals("java.lang.Object")) {
            Class<?> clazz = class$java$lang$Object;
            if (clazz == null) {
                clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
            }
            result.add(0, new ExternalGroovyClassDoc(clazz));
        }
        return result;
    }

    public Set<GroovyClassDoc> getParentInterfaces() {
        HashSet<GroovyClassDoc> result = new HashSet<GroovyClassDoc>();
        result.add(this);
        Set<GroovyClassDoc> next = new HashSet<GroovyClassDoc>();
        next.addAll(Arrays.asList(this.interfaces()));
        while (next.size() > 0) {
            HashSet<GroovyClassDoc> temp = next;
            next = new HashSet();
            for (GroovyClassDoc t : temp) {
                if (t instanceof SimpleGroovyClassDoc) {
                    next.addAll(((SimpleGroovyClassDoc)t).getParentInterfaces());
                    continue;
                }
                if (!(t instanceof ExternalGroovyClassDoc)) continue;
                ExternalGroovyClassDoc d = (ExternalGroovyClassDoc)t;
                next.addAll(this.getJavaInterfaces(d));
            }
            next = DefaultGroovyMethods.minus(next, result);
            result.addAll(next);
        }
        return result;
    }

    private Set<GroovyClassDoc> getJavaInterfaces(ExternalGroovyClassDoc d) {
        HashSet<GroovyClassDoc> result = new HashSet<GroovyClassDoc>();
        Class<?>[] interfaces = d.externalClass().getInterfaces();
        if (interfaces != null) {
            for (Class<?> i : interfaces) {
                ExternalGroovyClassDoc doc = new ExternalGroovyClassDoc(i);
                result.add(doc);
                result.addAll(this.getJavaInterfaces(doc));
            }
        }
        return result;
    }

    private Class getClassOf(String next) {
        try {
            return Class.forName(_String.replace(next, "/", "."));
        }
        catch (Throwable t) {
            return null;
        }
    }

    void resolve(GroovyRootDoc rootDoc) {
        Map visibleClasses = rootDoc.getVisibleClasses(this.importedClassesAndPackages);
        for (GroovyConstructorDoc constructor : this.constructors) {
            for (GroovyParameter groovyParameter : constructor.parameters()) {
                SimpleGroovyParameter param = (SimpleGroovyParameter)groovyParameter;
                String paramTypeName = param.typeName();
                if (!visibleClasses.containsKey(paramTypeName)) continue;
                param.setType((GroovyType)visibleClasses.get(paramTypeName));
            }
        }
        for (GroovyFieldDoc field : this.fields) {
            SimpleGroovyFieldDoc mutableField = (SimpleGroovyFieldDoc)field;
            GroovyType fieldType = field.type();
            String typeName = fieldType.typeName();
            if (!visibleClasses.containsKey(typeName)) continue;
            mutableField.setType((GroovyType)visibleClasses.get(typeName));
        }
        for (GroovyMethodDoc method : this.methods) {
            GroovyType returnType = method.returnType();
            String typeName = returnType.typeName();
            if (visibleClasses.containsKey(typeName)) {
                method.setReturnType((GroovyType)visibleClasses.get(typeName));
            }
            for (GroovyParameter groovyParameter : method.parameters()) {
                SimpleGroovyParameter param = (SimpleGroovyParameter)groovyParameter;
                String paramTypeName = param.typeName();
                if (!visibleClasses.containsKey(paramTypeName)) continue;
                param.setType((GroovyType)visibleClasses.get(paramTypeName));
            }
        }
        if (this.superClassName != null && this.superClass == null) {
            this.superClass = this.resolveClass(rootDoc, this.superClassName);
        }
        for (String name : this.interfaceNames) {
            this.interfaceClasses.add(this.resolveClass(rootDoc, name));
        }
        for (GroovyAnnotationRef annotation : this.annotations()) {
            SimpleGroovyAnnotationRef ref = (SimpleGroovyAnnotationRef)annotation;
            ref.setType(this.resolveClass(rootDoc, ref.name()));
        }
    }

    public String getDocUrl(String type) {
        return this.getDocUrl(type, false);
    }

    public String getDocUrl(String type, boolean full) {
        Class c;
        if (type == null) {
            return type;
        }
        if ((type = type.trim()).startsWith("#")) {
            return new StringBuffer().append("<a href='").append(type).append("'>").append(type).append("</a>").toString();
        }
        if (type.endsWith("[]")) {
            return new StringBuffer().append(this.getDocUrl(type.substring(0, type.length() - 2), full)).append("[]").toString();
        }
        if (type.indexOf(46) == -1 && (c = this.resolveExternalClassFromImport(type)) != null) {
            type = c.getName();
        }
        if (type.indexOf(46) == -1) {
            return type;
        }
        String[] target = type.split("#");
        String shortClassName = target[0].replaceAll(".*\\.", "");
        shortClassName = new StringBuffer().append(shortClassName).append(target.length > 1 ? new StringBuffer().append("#").append(target[1].split("\\(")[0]).toString() : "").toString();
        String name = full ? target[0] : shortClassName;
        for (LinkArgument link : this.links) {
            StringTokenizer tokenizer = new StringTokenizer(link.getPackages(), ", ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!type.startsWith(token)) continue;
                return this.buildUrl(link.getHref(), target, name);
            }
        }
        return type;
    }

    private String buildUrl(String relativeRoot, String[] target, String shortClassName) {
        if (!relativeRoot.endsWith("/")) {
            relativeRoot = new StringBuffer().append(relativeRoot).append("/").toString();
        }
        String url = new StringBuffer().append(relativeRoot).append(target[0].replace('.', '/')).append(".html").append(target.length > 1 ? new StringBuffer().append("#").append(target[1]).toString() : "").toString();
        return new StringBuffer().append("<a href='").append(url).append("' title='").append(shortClassName).append("'>").append(shortClassName).append("</a>").toString();
    }

    private GroovyClassDoc resolveClass(GroovyRootDoc rootDoc, String name) {
        GroovyClassDoc doc = rootDoc.classNamed(name);
        if (doc != null) {
            return doc;
        }
        String shortname = name;
        int slashIndex = name.lastIndexOf("/");
        Class c = null;
        if (slashIndex > 0) {
            shortname = name.substring(slashIndex + 1);
            c = this.resolveExternalClass(name);
        } else {
            c = this.resolveExternalClassFromImport(name);
        }
        if (c != null) {
            return new ExternalGroovyClassDoc(c);
        }
        SimpleGroovyClassDoc placeholder = new SimpleGroovyClassDoc(null, shortname);
        placeholder.setFullPathName(name);
        return placeholder;
    }

    private Class resolveExternalClassFromImport(String name) {
        for (String importName : this.importedClassesAndPackages) {
            if (!importName.endsWith("/*")) continue;
            String candidate = new StringBuffer().append(importName.substring(0, importName.length() - 2).replace('/', '.')).append(".").append(name).toString();
            try {
                return Class.forName(candidate);
            }
            catch (ClassNotFoundException e) {
            }
        }
        return null;
    }

    private Class resolveExternalClass(String name) {
        String candidate = name.replace('/', '.');
        try {
            return Class.forName(candidate);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public GroovyConstructorDoc[] constructors(boolean filter) {
        return null;
    }

    @Override
    public boolean definesSerializableFields() {
        return false;
    }

    @Override
    public GroovyFieldDoc[] fields(boolean filter) {
        return null;
    }

    @Override
    public GroovyClassDoc findClass(String className) {
        return null;
    }

    @Override
    public GroovyClassDoc[] importedClasses() {
        return null;
    }

    @Override
    public GroovyPackageDoc[] importedPackages() {
        return null;
    }

    @Override
    public GroovyClassDoc[] innerClasses(boolean filter) {
        return null;
    }

    @Override
    public GroovyClassDoc[] interfaces() {
        Collections.sort(this.interfaceClasses);
        return this.interfaceClasses.toArray(new GroovyClassDoc[this.interfaceClasses.size()]);
    }

    @Override
    public GroovyType[] interfaceTypes() {
        return null;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isExternalizable() {
        return false;
    }

    @Override
    public boolean isSerializable() {
        return false;
    }

    @Override
    public GroovyMethodDoc[] methods(boolean filter) {
        return null;
    }

    @Override
    public GroovyFieldDoc[] serializableFields() {
        return null;
    }

    @Override
    public GroovyMethodDoc[] serializationMethods() {
        return null;
    }

    @Override
    public boolean subclassOf(GroovyClassDoc gcd) {
        return false;
    }

    @Override
    public GroovyType superclassType() {
        return null;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public String qualifiedTypeName() {
        return this.fullPathName == null ? "null" : this.fullPathName.replace('/', '.');
    }

    @Override
    public String simpleTypeName() {
        String typeName = this.qualifiedTypeName();
        int lastDot = typeName.lastIndexOf(46);
        if (lastDot < 0) {
            return typeName;
        }
        return typeName.substring(lastDot + 1);
    }

    @Override
    public String typeName() {
        return null;
    }

    public void addInterfaceName(String className) {
        this.interfaceNames.add(className);
    }

    @Override
    public void setRawCommentText(String rawCommentText) {
        super.setRawCommentText(rawCommentText);
        this.setCommentText(this.replaceTags(rawCommentText));
    }

    public String replaceTags(String comment) {
        String result = comment.replaceAll("(?m)^\\s*\\*", "");
        result = this.replaceAllTags(result, "", "", LINK_REGEX);
        result = this.replaceAllTags(result, "<TT>", "</TT>", CODE_REGEX);
        result = this.replaceAllTags(result, "<DL><DT><B>$1:</B></DT><DD>", "</DD></DL>", TAG_REGEX);
        return this.decodeSpecialSymbols(result);
    }

    public String replaceAllTags(String self, String s1, String s2, Pattern regex) {
        Matcher matcher = regex.matcher(self);
        if (matcher.find()) {
            matcher.reset();
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String tagname = matcher.group(1);
                if (tagname.equals("see") || tagname.equals("link")) {
                    matcher.appendReplacement(sb, new StringBuffer().append(s1).append(this.getDocUrl(this.encodeSpecialSymbols(matcher.group(2)))).append(s2).toString());
                    continue;
                }
                if (tagname.equals("interface")) continue;
                matcher.appendReplacement(sb, new StringBuffer().append(s1).append(this.encodeSpecialSymbols(matcher.group(2))).append(s2).toString());
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return self;
    }

    private String encodeSpecialSymbols(String text) {
        return _Matcher.quoteReplacement(text.replaceAll("@", "&at;"));
    }

    private String decodeSpecialSymbols(String text) {
        return text.replaceAll("&at;", "@");
    }
}

