/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovyjarjarbackport.java.util.concurrent.ConcurrentHashMap;
import groovyjarjarbackport.java.util.concurrent.atomic.AtomicInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.metaclass.NewInstanceMetaMethod;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyCategorySupport {
    private static AtomicInteger categoriesInUse = new AtomicInteger();
    private static final MyThreadLocal threadInfo = new MyThreadLocal();

    public static AtomicInteger getCategoryNameUsage(String name) {
        return threadInfo.getUsage(name);
    }

    public static Object use(Class categoryClass, Closure closure) {
        return ((ThreadCategoryInfo)GroovyCategorySupport.threadInfo.get()).use(categoryClass, closure);
    }

    public static Object use(List<Class> categoryClasses, Closure closure) {
        return ((ThreadCategoryInfo)threadInfo.get()).use(categoryClasses, closure);
    }

    public static boolean hasCategoryInCurrentThread() {
        return categoriesInUse.get() != 0 && ((ThreadCategoryInfo)GroovyCategorySupport.threadInfo.get()).level != 0;
    }

    public static boolean hasCategoryInAnyThread() {
        return categoriesInUse.get() != 0;
    }

    public static CategoryMethodList getCategoryMethods(String name) {
        return ((ThreadCategoryInfo)threadInfo.get()).getCategoryMethods(name);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyThreadLocal
    extends ThreadLocal<ThreadCategoryInfo> {
        ConcurrentHashMap<String, AtomicInteger> usage = new ConcurrentHashMap();

        private MyThreadLocal() {
        }

        @Override
        protected ThreadCategoryInfo initialValue() {
            return new ThreadCategoryInfo();
        }

        public AtomicInteger getUsage(String name) {
            AtomicInteger u = (AtomicInteger)this.usage.get((Object)name);
            if (u != null) {
                return u;
            }
            AtomicInteger ai = new AtomicInteger();
            AtomicInteger prev = (AtomicInteger)this.usage.putIfAbsent((Object)name, (Object)ai);
            return prev == null ? ai : prev;
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.initialValue();
        }
    }

    private static class CategoryMethod
    extends NewInstanceMetaMethod
    implements Comparable {
        private final Class metaClass;
        static /* synthetic */ Class class$java$lang$Object;

        public CategoryMethod(CachedMethod metaMethod, Class metaClass) {
            super(metaMethod);
            this.metaClass = metaClass;
        }

        public boolean isCacheable() {
            return false;
        }

        public int compareTo(Object o) {
            CategoryMethod thatMethod = (CategoryMethod)o;
            Class thisClass = this.metaClass;
            Class thatClass = thatMethod.metaClass;
            if (thisClass == thatClass) {
                return 0;
            }
            if (this.isChildOfParent(thisClass, thatClass)) {
                return -1;
            }
            if (this.isChildOfParent(thatClass, thisClass)) {
                return 1;
            }
            return 0;
        }

        private boolean isChildOfParent(Class candidateChild, Class candidateParent) {
            Class loop = candidateChild;
            while (loop != null) {
                Class<?> clazz = class$java$lang$Object;
                if (clazz == null) {
                    clazz = new Object[0].getClass().getComponentType();
                }
                if (loop == clazz) break;
                if ((loop = loop.getSuperclass()) != candidateParent) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadCategoryInfo
    extends HashMap<String, CategoryMethodList> {
        int level;

        private void newScope() {
            categoriesInUse.incrementAndGet();
            ++this.level;
        }

        private void endScope() {
            Iterator it = this.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                CategoryMethodList list = (CategoryMethodList)e.getValue();
                if (list.level != this.level) continue;
                CategoryMethodList prev = list.previous;
                if (prev == null) {
                    it.remove();
                    list.usage.addAndGet(-list.size());
                    continue;
                }
                e.setValue(prev);
                list.usage.addAndGet(prev.size() - list.size());
            }
            --this.level;
            categoriesInUse.getAndDecrement();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object use(Class categoryClass, Closure closure) {
            this.newScope();
            try {
                this.use(categoryClass);
                Object object = closure.call();
                return object;
            }
            finally {
                this.endScope();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object use(List<Class> categoryClasses, Closure closure) {
            this.newScope();
            try {
                for (Class clazz : categoryClasses) {
                    this.use(clazz);
                }
                Object object = closure.call();
                return object;
            }
            finally {
                this.endScope();
            }
        }

        private void use(Class categoryClass) {
            CachedClass cachedClass = ReflectionCache.getCachedClass(categoryClass);
            CachedMethod[] methods = cachedClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                CachedClass[] paramTypes;
                CachedMethod cachedMethod = methods[i];
                if (!cachedMethod.isStatic() || !cachedMethod.isPublic() || (paramTypes = cachedMethod.getParameterTypes()).length <= 0) continue;
                CachedClass metaClass = paramTypes[0];
                CategoryMethod mmethod = new CategoryMethod(cachedMethod, metaClass.getTheClass());
                String name = cachedMethod.getName();
                CategoryMethodList list = (CategoryMethodList)this.get(name);
                if (list == null || list.level != this.level) {
                    list = new CategoryMethodList(name, this.level, list);
                    this.put(name, list);
                }
                list.add(mmethod);
                Collections.sort(list);
            }
        }

        public CategoryMethodList getCategoryMethods(String name) {
            return this.level == 0 ? null : (CategoryMethodList)this.get(name);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CategoryMethodList
    extends ArrayList<CategoryMethod> {
        public final int level;
        final CategoryMethodList previous;
        final AtomicInteger usage;

        public CategoryMethodList(String name, int level, CategoryMethodList previous) {
            this.level = level;
            this.previous = previous;
            if (previous != null) {
                this.addAll(previous);
                this.usage = previous.usage;
            } else {
                this.usage = GroovyCategorySupport.getCategoryNameUsage(name);
            }
        }

        @Override
        public boolean add(CategoryMethod o) {
            this.usage.incrementAndGet();
            return super.add(o);
        }

        @Override
        public /* synthetic */ boolean add(Object x0) {
            return this.add((CategoryMethod)x0);
        }
    }
}

