/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovyjarjarretroruntime.java.lang._Class;
import groovyjarjarretroruntime.java.lang._Integer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    private static final Set<String> ignoredPackages;
    private static final Method magicMethod;

    public static boolean isCallingClassReflectionAvailable() {
        return magicMethod != null;
    }

    public static Class getCallingClass() {
        return ReflectionUtils.getCallingClass(1);
    }

    public static Class getCallingClass(int matchLevel) {
        return ReflectionUtils.getCallingClass(matchLevel, Collections.EMPTY_SET);
    }

    public static Class getCallingClass(int matchLevel, Collection<String> extraIgnoredPackages) {
        if (magicMethod == null) {
            return null;
        }
        int depth = 0;
        try {
            Class sc;
            Class c;
            do {
                sc = (c = (Class)magicMethod.invoke(null, _Integer.valueOf(depth++))) != null ? c.getSuperclass() : null;
            } while (ReflectionUtils.classShouldBeIgnored(c, extraIgnoredPackages) || ReflectionUtils.superClassShouldBeIgnored(sc) || c != null && matchLevel-- > 0);
            return c;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static boolean superClassShouldBeIgnored(Class sc) {
        return sc != null && sc.getPackage() != null && "org.codehaus.groovy.runtime.callsite".equals(sc.getPackage().getName());
    }

    private static boolean classShouldBeIgnored(Class c, Collection<String> extraIgnoredPackages) {
        return c != null && (_Class.isSynthetic(c) || c.getPackage() != null && (ignoredPackages.contains(c.getPackage().getName()) || extraIgnoredPackages.contains(c.getPackage().getName())));
    }

    static {
        Method meth;
        ignoredPackages = new HashSet<String>();
        ignoredPackages.add("groovy.lang");
        ignoredPackages.add("org.codehaus.groovy.reflection");
        ignoredPackages.add("org.codehaus.groovy.runtime.callsite");
        ignoredPackages.add("org.codehaus.groovy.runtime.metaclass");
        ignoredPackages.add("org.codehaus.groovy.runtime");
        ignoredPackages.add("sun.reflect");
        try {
            Class<?> srr = Class.forName("sun.reflect.Reflection");
            meth = srr.getMethod("getCallerClass", Integer.TYPE);
        }
        catch (Throwable t) {
            meth = null;
        }
        magicMethod = meth;
    }
}

