/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarretroruntime.java.util;

import groovyjarjarretroruntime.java.util.InvalidPropertiesFormatException_;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class _Properties {
    private static final String SYSTEM_ID = "http://java.sun.com/dtd/properties.dtd";
    private static final String DTD_CONTENT = "<?xml version='1.0' encoding='UTF-8'?><!ELEMENT properties ( comment?, entry* ) ><!ATTLIST properties version CDATA #FIXED '1.0'><!ELEMENT comment (#PCDATA) ><!ELEMENT entry (#PCDATA) ><!ATTLIST entry key CDATA #REQUIRED>";
    private static final ErrorHandler STRICT_ERROR_HANDLER = new ErrorHandler(){

        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    };

    public static void loadFromXML(Properties properties, InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        NodeList entryList = _Properties.parseStream(stream).getDocumentElement().getElementsByTagName("entry");
        int length = entryList.getLength();
        for (int i = 0; i < length; ++i) {
            Element entry = (Element)entryList.item(i);
            String key = entry.getAttribute("key");
            Node textNode = entry.getFirstChild();
            String value = textNode == null ? "" : textNode.getNodeValue();
            properties.setProperty(key, value);
        }
        stream.close();
    }

    public static void storeToXML(Properties properties, OutputStream stream, String comment) throws IOException {
        _Properties.storeToXML(properties, stream, comment, "UTF-8");
    }

    public static void storeToXML(Properties properties, OutputStream stream, String comment, String encoding) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        Document document = _Properties.createDocument();
        Element propertiesElement = document.createElement("properties");
        document.appendChild(propertiesElement);
        if (comment != null) {
            Element commentElement = document.createElement("comment");
            propertiesElement.appendChild(commentElement);
            commentElement.appendChild(document.createTextNode(comment));
        }
        Iterator<Object> i$ = properties.keySet().iterator();
        while (i$.hasNext()) {
            Object keyObject = i$.next();
            String key = (String)keyObject;
            String value = properties.getProperty(key);
            Element entryElement = document.createElement("entry");
            propertiesElement.appendChild(entryElement);
            entryElement.setAttribute("key", key);
            entryElement.appendChild(document.createTextNode(value));
        }
        Transformer transformer = _Properties.createTransformer();
        transformer.setOutputProperty("doctype-system", SYSTEM_ID);
        transformer.setOutputProperty("encoding", encoding);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("standalone", "no");
        try {
            transformer.transform(new DOMSource(document), new StreamResult(stream));
        }
        catch (TransformerException e) {
            IOException exception = new IOException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    private static Document parseStream(InputStream stream) throws IOException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setCoalescing(true);
        factory.setValidating(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.equals(_Properties.SYSTEM_ID)) {
                    InputSource source = new InputSource();
                    source.setSystemId(_Properties.SYSTEM_ID);
                    source.setCharacterStream(new StringReader(_Properties.DTD_CONTENT));
                    return source;
                }
                return null;
            }
        });
        builder.setErrorHandler(STRICT_ERROR_HANDLER);
        try {
            return builder.parse(stream);
        }
        catch (SAXException e) {
            throw new InvalidPropertiesFormatException_(e);
        }
    }

    private static Document createDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
    }

    private static Transformer createTransformer() {
        try {
            return TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new Error(e);
        }
    }
}

