/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarretroruntime.format;

import groovyjarjarretroruntime.format.Conversion;
import groovyjarjarretroruntime.format.FormatContext;
import groovyjarjarretroruntime.java.util.IllegalFormatCodePointException_;

class CharacterConversion
extends Conversion {
    CharacterConversion() {
    }

    public void format(FormatContext context) {
        context.assertNoPrecision();
        context.assertNoFlag('#');
        context.checkWidth();
        context.writePadded(CharacterConversion.printf(context));
    }

    private static String printf(FormatContext context) {
        Object argument = context.getArgument();
        if (argument instanceof Character || argument == null) {
            return String.valueOf(argument);
        }
        if (argument instanceof Byte) {
            return CharacterConversion.printf(((Byte)argument).byteValue());
        }
        if (argument instanceof Short) {
            return CharacterConversion.printf(((Short)argument).shortValue());
        }
        if (argument instanceof Integer) {
            return CharacterConversion.printf((Integer)argument);
        }
        throw context.getConversionException();
    }

    private static String printf(int codePoint) {
        if (codePoint < 0 || codePoint > 0x10FFFF) {
            throw new IllegalFormatCodePointException_(codePoint);
        }
        if (codePoint < 65536) {
            return Character.toString((char)codePoint);
        }
        int low = codePoint & 0x3FF | 0xDC00;
        int high = codePoint - 65536 >>> 10 | 0xD800;
        return new String(new char[]{(char)high, (char)low});
    }
}

