/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarbackport.java.util.concurrent;

import groovyjarjarbackport.java.util.concurrent.BrokenBarrierException;
import groovyjarjarbackport.java.util.concurrent.TimeUnit;
import groovyjarjarbackport.java.util.concurrent.TimeoutException;
import groovyjarjarbackport.java.util.concurrent.helpers.Utils;

public class CyclicBarrier {
    private final Object lock = new Object();
    private final int parties;
    private final Runnable barrierCommand;
    private Generation generation = new Generation();
    private int count;

    private void nextGeneration() {
        this.lock.notifyAll();
        this.count = this.parties;
        this.generation = new Generation();
    }

    private void breakBarrier() {
        this.generation.broken = true;
        this.count = this.parties;
        this.lock.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int dowait(boolean timed, long nanos) throws InterruptedException, BrokenBarrierException, TimeoutException {
        Object object = this.lock;
        synchronized (object) {
            int index;
            Generation g = this.generation;
            if (g.broken) {
                throw new BrokenBarrierException();
            }
            if (Thread.interrupted()) {
                this.breakBarrier();
                throw new InterruptedException();
            }
            if ((index = --this.count) == 0) {
                boolean ranAction = false;
                try {
                    Runnable command = this.barrierCommand;
                    if (command != null) {
                        command.run();
                    }
                    ranAction = true;
                    this.nextGeneration();
                    int n = 0;
                    return n;
                }
                finally {
                    if (!ranAction) {
                        this.breakBarrier();
                    }
                }
            }
            long deadline = timed ? Utils.nanoTime() + nanos : 0L;
            while (true) {
                block19: {
                    try {
                        if (!timed) {
                            this.lock.wait();
                            break block19;
                        }
                        if (nanos > 0L) {
                            TimeUnit.NANOSECONDS.timedWait(this.lock, nanos);
                        }
                    }
                    catch (InterruptedException ie) {
                        if (g == this.generation && !g.broken) {
                            this.breakBarrier();
                            throw ie;
                        }
                        Thread.currentThread().interrupt();
                    }
                }
                if (g.broken) {
                    throw new BrokenBarrierException();
                }
                if (g != this.generation) {
                    return index;
                }
                if (timed && nanos <= 0L) {
                    this.breakBarrier();
                    throw new TimeoutException();
                }
                nanos = deadline - Utils.nanoTime();
            }
        }
    }

    public CyclicBarrier(int parties, Runnable barrierAction) {
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties = parties;
        this.count = parties;
        this.barrierCommand = barrierAction;
    }

    public CyclicBarrier(int parties) {
        this(parties, null);
    }

    public int getParties() {
        return this.parties;
    }

    public int await() throws InterruptedException, BrokenBarrierException {
        try {
            return this.dowait(false, 0L);
        }
        catch (TimeoutException toe) {
            throw new Error(toe);
        }
    }

    public int await(long timeout, TimeUnit unit) throws InterruptedException, BrokenBarrierException, TimeoutException {
        return this.dowait(true, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBroken() {
        Object object = this.lock;
        synchronized (object) {
            return this.generation.broken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.breakBarrier();
            this.nextGeneration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberWaiting() {
        Object object = this.lock;
        synchronized (object) {
            return this.parties - this.count;
        }
    }

    private static class Generation {
        boolean broken = false;

        private Generation() {
        }
    }
}

