/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarbackport.java.util.concurrent;

import groovyjarjarbackport.java.util.concurrent.Callable;
import groovyjarjarbackport.java.util.concurrent.CancellationException;
import groovyjarjarbackport.java.util.concurrent.ExecutionException;
import groovyjarjarbackport.java.util.concurrent.ExecutorCompletionService;
import groovyjarjarbackport.java.util.concurrent.ExecutorService;
import groovyjarjarbackport.java.util.concurrent.Future;
import groovyjarjarbackport.java.util.concurrent.FutureTask;
import groovyjarjarbackport.java.util.concurrent.RunnableFuture;
import groovyjarjarbackport.java.util.concurrent.TimeUnit;
import groovyjarjarbackport.java.util.concurrent.TimeoutException;
import groovyjarjarbackport.java.util.concurrent.helpers.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractExecutorService
implements ExecutorService {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RunnableFuture newTaskFor(Runnable runnable, Object value) {
        return new FutureTask(runnable, value);
    }

    protected RunnableFuture newTaskFor(Callable callable) {
        return new FutureTask(callable);
    }

    public Future submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task, null);
        this.execute(ftask);
        return ftask;
    }

    public Future submit(Runnable task, Object result) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task, result);
        this.execute(ftask);
        return ftask;
    }

    public Future submit(Callable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task);
        this.execute(ftask);
        return ftask;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object doInvokeAny(Collection tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        if (tasks == null) {
            throw new NullPointerException();
        }
        int ntasks = tasks.size();
        if (ntasks == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<Future> futures = new ArrayList<Future>(ntasks);
        ExecutorCompletionService ecs = new ExecutorCompletionService(this);
        try {
            ExecutionException ee = null;
            long lastTime = timed ? Utils.nanoTime() : 0L;
            Iterator it = tasks.iterator();
            futures.add(ecs.submit((Callable)it.next()));
            --ntasks;
            int active = 1;
            while (true) {
                Object object;
                Future f;
                if ((f = ecs.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(ecs.submit((Callable)it.next()));
                        ++active;
                    } else {
                        if (active == 0) {
                            if (ee != null) throw ee;
                            break;
                        }
                        if (timed) {
                            f = ecs.poll(nanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            long now = Utils.nanoTime();
                            nanos -= now - lastTime;
                            lastTime = now;
                        } else {
                            f = ecs.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    object = f.get();
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (ExecutionException eex) {
                    ee = eex;
                    continue;
                }
                catch (RuntimeException rex) {
                    ee = new ExecutionException(rex);
                    continue;
                }
                Object var18_17 = null;
                Iterator f2 = futures.iterator();
                while (f2.hasNext()) {
                    ((Future)f2.next()).cancel(true);
                }
                return object;
                break;
            }
            ee = new ExecutionException();
            throw ee;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            Iterator f2 = futures.iterator();
            while (true) {
                if (!f2.hasNext()) {
                    throw throwable;
                }
                ((Future)f2.next()).cancel(true);
            }
        }
    }

    public Object invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(tasks, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(tasks, true, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List invokeAll(Collection tasks) throws InterruptedException {
        ArrayList<RunnableFuture> arrayList;
        block11: {
            Iterator i3;
            if (tasks == null) {
                throw new NullPointerException();
            }
            ArrayList<RunnableFuture> futures = new ArrayList<RunnableFuture>(tasks.size());
            boolean done = false;
            try {
                Future f;
                Iterator t = tasks.iterator();
                while (t.hasNext()) {
                    f = this.newTaskFor((Callable)t.next());
                    futures.add((RunnableFuture)f);
                    this.execute((Runnable)((Object)f));
                }
                Iterator i2 = futures.iterator();
                while (i2.hasNext()) {
                    f = (Future)i2.next();
                    if (f.isDone()) continue;
                    try {
                        f.get();
                    }
                    catch (CancellationException ignore) {
                    }
                    catch (ExecutionException ignore) {}
                }
                done = true;
                arrayList = futures;
                Object var8_9 = null;
                if (done) break block11;
                i3 = futures.iterator();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (!done) {
                    Iterator i3 = futures.iterator();
                    while (i3.hasNext()) {
                        Future f = (Future)i3.next();
                        f.cancel(true);
                    }
                }
                throw throwable;
            }
            while (i3.hasNext()) {
                Future f = (Future)i3.next();
                f.cancel(true);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<RunnableFuture> arrayList;
        boolean done;
        ArrayList<RunnableFuture> futures;
        block21: {
            ArrayList<RunnableFuture> arrayList2;
            block20: {
                Iterator i3;
                ArrayList<RunnableFuture> arrayList3;
                block19: {
                    if (tasks == null || unit == null) {
                        throw new NullPointerException();
                    }
                    long nanos = unit.toNanos(timeout);
                    futures = new ArrayList<RunnableFuture>(tasks.size());
                    done = false;
                    try {
                        Iterator t = tasks.iterator();
                        while (t.hasNext()) {
                            futures.add(this.newTaskFor((Callable)t.next()));
                        }
                        long lastTime = Utils.nanoTime();
                        Iterator it = futures.iterator();
                        while (it.hasNext()) {
                            this.execute((Runnable)it.next());
                            long now = Utils.nanoTime();
                            if ((nanos -= now - (lastTime = now)) > 0L) continue;
                            arrayList3 = futures;
                            Object var22_16 = null;
                            if (done) return arrayList3;
                            i3 = futures.iterator();
                            break block19;
                        }
                        Iterator i2 = futures.iterator();
                        while (i2.hasNext()) {
                            Future f = (Future)i2.next();
                            if (f.isDone()) continue;
                            if (nanos <= 0L) {
                                arrayList2 = futures;
                                break block20;
                            }
                            try {
                                f.get(nanos, TimeUnit.NANOSECONDS);
                            }
                            catch (CancellationException ignore) {
                            }
                            catch (ExecutionException ignore) {
                            }
                            catch (TimeoutException toe) {
                                ArrayList<RunnableFuture> arrayList4 = futures;
                                Object var22_18 = null;
                                if (done) return arrayList4;
                                Iterator i3 = futures.iterator();
                                while (true) {
                                    if (!i3.hasNext()) {
                                        return arrayList4;
                                    }
                                    Future f2 = (Future)i3.next();
                                    f2.cancel(true);
                                }
                            }
                            long now = Utils.nanoTime();
                            nanos -= now - lastTime;
                            lastTime = now;
                        }
                        done = true;
                        arrayList = futures;
                        break block21;
                    }
                    catch (Throwable throwable) {
                        Object var22_20 = null;
                        if (!done) {
                            Iterator i3 = futures.iterator();
                            while (i3.hasNext()) {
                                Future f2 = (Future)i3.next();
                                f2.cancel(true);
                            }
                        }
                        throw throwable;
                    }
                }
                while (i3.hasNext()) {
                    Future f2 = (Future)i3.next();
                    f2.cancel(true);
                }
                return arrayList3;
            }
            Object var22_17 = null;
            if (done) return arrayList2;
            Iterator i3 = futures.iterator();
            while (i3.hasNext()) {
                Future f2 = (Future)i3.next();
                f2.cancel(true);
            }
            return arrayList2;
        }
        Object var22_19 = null;
        if (done) return arrayList;
        Iterator i3 = futures.iterator();
        while (i3.hasNext()) {
            Future f2 = (Future)i3.next();
            f2.cancel(true);
        }
        return arrayList;
    }

    static {
        $assertionsDisabled = !AbstractExecutorService.class.desiredAssertionStatus();
    }
}

