/*
 * Decompiled with CFR 0.152.
 */
package groovy.xml;

import groovy.lang.Writable;
import groovyjarjarretroruntime.java.lang._Integer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;

public class XmlUtil {
    public static String serialize(Element element) {
        StringWriter sw = new StringWriter();
        XmlUtil.serialize((Source)new DOMSource(element), sw);
        return sw.toString();
    }

    public static void serialize(Element element, OutputStream os) {
        DOMSource source = new DOMSource(element);
        XmlUtil.serialize((Source)source, os);
    }

    public static String serialize(Writable writable) {
        return XmlUtil.serialize(XmlUtil.asString(writable));
    }

    public static void serialize(Writable writable, OutputStream os) {
        XmlUtil.serialize(XmlUtil.asString(writable), os);
    }

    public static String serialize(String xmlString) {
        StringWriter sw = new StringWriter();
        XmlUtil.serialize((Source)XmlUtil.asStreamSource(xmlString), sw);
        return sw.toString();
    }

    public static void serialize(String xmlString, OutputStream os) {
        XmlUtil.serialize((Source)XmlUtil.asStreamSource(xmlString), os);
    }

    private static String asString(Writable writable) {
        StringWriter sw = new StringWriter();
        try {
            writable.writeTo(sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ((Object)sw).toString();
    }

    private static StreamSource asStreamSource(String xmlString) {
        return new StreamSource(new StringReader(xmlString));
    }

    private static void serialize(Source source, OutputStream os) {
        try {
            XmlUtil.serialize(source, new StreamResult(new OutputStreamWriter(os, "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private static void serialize(Source source, Writer w) {
        XmlUtil.serialize(source, new StreamResult(w));
    }

    private static void serialize(Source source, StreamResult target) {
        TransformerFactory factory = TransformerFactory.newInstance();
        XmlUtil.setIndent(factory, 2);
        try {
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("media-type", "text/xml");
            transformer.transform(source, target);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    private static void setIndent(TransformerFactory factory, int indent) {
        try {
            factory.setAttribute("indent-number", _Integer.valueOf(indent));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

