/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.util.LinkedList;
import org.cloudfoundry.identity.uaa.authentication.GenericPasswordPolicy;
import org.cloudfoundry.identity.uaa.util.PasswordValidatorUtil;
import org.cloudfoundry.identity.uaa.zone.ClientSecretPolicy;
import org.cloudfoundry.identity.uaa.zone.ClientSecretValidator;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.InvalidClientSecretException;
import org.passay.MessageResolver;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.PropertiesMessageResolver;
import org.passay.RuleResult;

public class ZoneAwareClientSecretPolicyValidator
implements ClientSecretValidator {
    public static final String DEFAULT_MESSAGE_PATH = "/clientsecret-messages.properties";
    private static PropertiesMessageResolver messageResolver = PasswordValidatorUtil.messageResolver("/clientsecret-messages.properties");
    private final ClientSecretPolicy globalDefaultClientSecretPolicy;

    public ZoneAwareClientSecretPolicyValidator(ClientSecretPolicy globalDefaultClientSecretPolicy) {
        this.globalDefaultClientSecretPolicy = globalDefaultClientSecretPolicy;
    }

    @Override
    public void validate(String clientSecret) throws InvalidClientSecretException {
        PasswordValidator clientSecretValidator;
        RuleResult result;
        if (clientSecret == null) {
            throw new InvalidClientSecretException("Client Secret cannot be null.");
        }
        ClientSecretPolicy clientSecretPolicy = this.globalDefaultClientSecretPolicy;
        IdentityZone zone = IdentityZoneHolder.get();
        if (zone.getConfig().getClientSecretPolicy().getMinLength() != -1) {
            clientSecretPolicy = zone.getConfig().getClientSecretPolicy();
        }
        if (!(result = (clientSecretValidator = PasswordValidatorUtil.validator((GenericPasswordPolicy)clientSecretPolicy, (MessageResolver)messageResolver)).validate(new PasswordData(clientSecret))).isValid()) {
            LinkedList<String> errorMessages = new LinkedList<String>();
            for (String s : clientSecretValidator.getMessages(result)) {
                errorMessages.add(s);
            }
            if (!errorMessages.isEmpty()) {
                throw new InvalidClientSecretException(errorMessages);
            }
        }
    }
}

