/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.mfa.MfaProviderProvisioning;
import org.cloudfoundry.identity.uaa.zone.InvalidIdentityZoneConfigurationException;
import org.cloudfoundry.identity.uaa.zone.MfaConfig;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.util.StringUtils;

public class MfaConfigValidator {
    private static Log logger = LogFactory.getLog(MfaConfigValidator.class);
    private MfaProviderProvisioning mfaProviderProvisioning;

    public MfaProviderProvisioning getMfaProviderProvisioning() {
        return this.mfaProviderProvisioning;
    }

    public void setMfaProviderProvisioning(MfaProviderProvisioning mfaProviderProvisioning) {
        this.mfaProviderProvisioning = mfaProviderProvisioning;
    }

    public void validate(MfaConfig config, String zoneId) throws InvalidIdentityZoneConfigurationException {
        if (config.isEnabled() || StringUtils.hasText((String)config.getProviderName())) {
            try {
                this.mfaProviderProvisioning.retrieveByName(config.getProviderName(), zoneId);
            }
            catch (EmptyResultDataAccessException e) {
                logger.debug((Object)String.format("Provider with name %s not found", config.getProviderName()));
                throw new InvalidIdentityZoneConfigurationException("Active MFA Provider not found with name: " + config.getProviderName());
            }
        }
    }
}

