/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.oauth.UaaOauth2Authentication;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneProvisioning;
import org.cloudfoundry.identity.uaa.zone.ZoneDoesNotExistsException;
import org.cloudfoundry.identity.uaa.zone.ZoneManagementScopes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class IdentityZoneSwitchingFilter
extends OncePerRequestFilter {
    private final IdentityZoneProvisioning dao;
    public static final String HEADER = "X-Identity-Zone-Id";
    public static final String SUBDOMAIN_HEADER = "X-Identity-Zone-Subdomain";
    public static final List<String> zoneScopestoNotStripPrefix = Collections.unmodifiableList(Arrays.asList("admin", "read"));

    @Autowired
    public IdentityZoneSwitchingFilter(IdentityZoneProvisioning dao) {
        this.dao = dao;
    }

    protected OAuth2Authentication getAuthenticationForZone(String identityZoneId, HttpServletRequest servletRequest) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication instanceof OAuth2Authentication)) {
            return null;
        }
        OAuth2Authentication oa = (OAuth2Authentication)authentication;
        Object oaDetails = oa.getDetails();
        OAuth2Request request = oa.getOAuth2Request();
        Set requestAuthorities = UaaStringUtils.getStringsFromAuthorities((Collection)request.getAuthorities());
        HashSet<String> clientScopes = new HashSet<String>();
        HashSet<String> clientAuthorities = new HashSet<String>();
        for (String s : ZoneManagementScopes.getZoneSwitchingScopes((String)identityZoneId)) {
            String scope = this.stripPrefix(s, identityZoneId);
            if (request.getScope().contains(s)) {
                clientScopes.add(scope);
            }
            if (!requestAuthorities.contains(s)) continue;
            clientAuthorities.add(scope);
        }
        request = new OAuth2Request(request.getRequestParameters(), request.getClientId(), (Collection)UaaStringUtils.getAuthoritiesFromStrings(clientAuthorities), request.isApproved(), clientScopes, request.getResourceIds(), request.getRedirectUri(), request.getResponseTypes(), request.getExtensions());
        UaaAuthentication userAuthentication = (UaaAuthentication)oa.getUserAuthentication();
        if (userAuthentication != null) {
            userAuthentication = new UaaAuthentication(userAuthentication.getPrincipal(), null, UaaStringUtils.getAuthoritiesFromStrings(clientScopes), new UaaAuthenticationDetails(servletRequest), true, userAuthentication.getAuthenticatedTime());
        }
        oa = new UaaOauth2Authentication(((UaaOauth2Authentication)oa).getTokenValue(), IdentityZoneHolder.get().getId(), request, userAuthentication);
        oa.setDetails(oaDetails);
        return oa;
    }

    protected String stripPrefix(String s, String identityZoneId) {
        if (!StringUtils.hasText((String)s)) {
            return s;
        }
        String replace = "zones." + identityZoneId + ".";
        for (String scope : zoneScopestoNotStripPrefix) {
            if (!s.equals(replace + scope)) continue;
            return s;
        }
        if (s.startsWith(replace)) {
            return s.substring(replace.length());
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String identityZoneIdFromHeader = request.getHeader(HEADER);
        String identityZoneSubDomainFromHeader = request.getHeader(SUBDOMAIN_HEADER);
        if (StringUtils.isEmpty((Object)identityZoneIdFromHeader) && StringUtils.isEmpty((Object)identityZoneSubDomainFromHeader)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        IdentityZone identityZone = this.validateIdentityZone(identityZoneIdFromHeader, identityZoneSubDomainFromHeader);
        if (identityZone == null) {
            response.sendError(404, "Identity zone with id/subdomain " + identityZoneIdFromHeader + "/" + identityZoneSubDomainFromHeader + " does not exist");
            return;
        }
        String identityZoneId = identityZone.getId();
        OAuth2Authentication oAuth2Authentication = this.getAuthenticationForZone(identityZoneId, request);
        if (!IdentityZoneHolder.isUaa() || oAuth2Authentication == null || oAuth2Authentication.getOAuth2Request().getScope().isEmpty()) {
            response.sendError(403, "User is not authorized to switch to IdentityZone with id " + identityZoneId);
            return;
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)oAuth2Authentication);
        IdentityZone originalIdentityZone = IdentityZoneHolder.get();
        try {
            IdentityZoneHolder.set(identityZone);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            IdentityZoneHolder.set(originalIdentityZone);
        }
    }

    private IdentityZone validateIdentityZone(String identityZoneId, String identityZoneSubDomain) throws IOException {
        IdentityZone identityZone = null;
        try {
            identityZone = StringUtils.isEmpty((Object)identityZoneId) ? this.dao.retrieveBySubdomain(identityZoneSubDomain) : this.dao.retrieve(identityZoneId);
        }
        catch (ZoneDoesNotExistsException | EmptyResultDataAccessException throwable) {
        }
        catch (Exception ex) {
            throw ex;
        }
        return identityZone;
    }
}

