/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.BrandingInformation;
import org.cloudfoundry.identity.uaa.zone.InvalidIdentityZoneConfigurationException;
import org.springframework.util.StringUtils;

public class BannerValidator {
    private static Pattern hexColorPattern = Pattern.compile("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$");

    public static void validate(BrandingInformation.Banner banner) throws InvalidIdentityZoneConfigurationException {
        if (banner != null) {
            if (StringUtils.hasText((String)banner.getLink()) && !UaaUrlUtils.isUrl(banner.getLink())) {
                throw new InvalidIdentityZoneConfigurationException("Invalid banner link: " + banner.getLink() + ". Must be a properly formatted URI beginning with http:// or https://", null);
            }
            if (StringUtils.hasText((String)banner.getBackgroundColor()) && !hexColorPattern.matcher(banner.getBackgroundColor()).matches()) {
                throw new InvalidIdentityZoneConfigurationException("Invalid banner background color: " + banner.getBackgroundColor() + ". Must be a properly formatted hexadecimal color code.", null);
            }
            if (StringUtils.hasText((String)banner.getTextColor()) && !hexColorPattern.matcher(banner.getTextColor()).matches()) {
                throw new InvalidIdentityZoneConfigurationException("Invalid banner text color: " + banner.getTextColor() + ". Must be a properly formatted hexadecimal color code.", null);
            }
            if (StringUtils.hasText((String)banner.getLogo()) && !Base64.isBase64((String)banner.getLogo())) {
                throw new InvalidIdentityZoneConfigurationException("Invalid banner logo. Must be in BASE64 format.", null);
            }
        }
    }
}

