/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.cloudfoundry.identity.uaa.util.EmptyEnumerationOfString;

public class HttpHeadersFilterRequestWrapper
extends HttpServletRequestWrapper {
    private final List<String> filteredHeaders;

    public HttpHeadersFilterRequestWrapper(List<String> badHeaders, HttpServletRequest request) {
        super(request);
        this.filteredHeaders = Collections.unmodifiableList(Optional.ofNullable(badHeaders).orElse(Collections.emptyList()));
    }

    public String getHeader(String name) {
        if (this.shouldFilter(name)) {
            return null;
        }
        return super.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        if (this.shouldFilter(name)) {
            return EmptyEnumerationOfString.EMPTY_ENUMERATION;
        }
        return super.getHeaders(name);
    }

    private boolean shouldFilter(String name) {
        return this.filteredHeaders.stream().anyMatch(s -> s.equalsIgnoreCase(name));
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList headerNames = Collections.list(super.getHeaderNames());
        headerNames.removeIf(header -> this.shouldFilter((String)header));
        return Collections.enumeration(headerNames);
    }
}

