/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.web;

import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractView;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

public class ForwardAwareInternalResourceViewResolver
extends InternalResourceViewResolver {
    private static final String ACCEPT_HEADER = "Accept";

    protected Object getCacheKey(String viewName, Locale locale) {
        return super.getCacheKey(viewName + ";" + this.getRequestedMediaType(), locale);
    }

    protected View createView(String viewName, Locale locale) throws Exception {
        MediaType requestedMediaType;
        View view = super.createView(viewName, locale);
        if ((viewName.startsWith("forward:") || viewName.startsWith("redirect:")) && view instanceof AbstractView && (requestedMediaType = this.getRequestedMediaType()) != null) {
            ((AbstractView)view).setContentType(requestedMediaType.toString());
        }
        return view;
    }

    private MediaType getRequestedMediaType() {
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        Assert.isInstanceOf(ServletRequestAttributes.class, (Object)attrs);
        HttpServletRequest request = ((ServletRequestAttributes)attrs).getRequest();
        MediaType requestedMediaType = this.getMediaTypes(request);
        return requestedMediaType;
    }

    private MediaType getMediaTypes(HttpServletRequest request) {
        String acceptHeader = request.getHeader(ACCEPT_HEADER);
        if (StringUtils.hasText((String)acceptHeader)) {
            try {
                List acceptableMediaTypes = MediaType.parseMediaTypes((String)acceptHeader);
                return acceptableMediaTypes.isEmpty() ? null : (MediaType)acceptableMediaTypes.get(0);
            }
            catch (IllegalArgumentException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Could not parse accept header [" + acceptHeader + "]: " + ex.getMessage()));
                }
                return null;
            }
        }
        return null;
    }
}

