/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public enum UaaAuthority implements GrantedAuthority
{
    UAA_INVITED("uaa.invited", 1),
    UAA_ADMIN("uaa.admin", 1),
    UAA_USER("uaa.user", 0),
    UAA_NONE("uaa.none", -1);

    public static final List<UaaAuthority> ADMIN_AUTHORITIES;
    public static final List<UaaAuthority> USER_AUTHORITIES;
    public static final List<UaaAuthority> NONE_AUTHORITIES;
    private final int value;
    private final String userType;

    private UaaAuthority(String userType, int value) {
        this.userType = userType;
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public String getUserType() {
        return this.userType;
    }

    public String getAuthority() {
        return this.userType;
    }

    public String toString() {
        return this.userType;
    }

    @JsonCreator
    public static UaaAuthority fromAuthorities(String authorities) {
        String type = authorities == null ? "uaa.user" : authorities.toLowerCase();
        return type.contains("uaa.admin") ? UAA_ADMIN : UAA_USER;
    }

    public static GrantedAuthority authority(String value) {
        return value.equals("uaa.admin") ? UAA_ADMIN : (value.contains("uaa.user") ? UAA_USER : new SimpleGrantedAuthority(value));
    }

    static {
        ADMIN_AUTHORITIES = Collections.unmodifiableList(Arrays.asList(UAA_ADMIN, UAA_USER));
        USER_AUTHORITIES = Collections.unmodifiableList(Arrays.asList(UAA_USER));
        NONE_AUTHORITIES = Collections.unmodifiableList(Arrays.asList(UAA_NONE));
    }
}

