/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.user;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.user.UaaUserPrototype;
import org.cloudfoundry.identity.uaa.user.UserInfo;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcUaaUserDatabase
implements UaaUserDatabase {
    private static Log logger = LogFactory.getLog(JdbcUaaUserDatabase.class);
    public static final String USER_FIELDS = "id,username,password,email,givenName,familyName,created,lastModified,authorities,origin,external_id,verified,identity_zone_id,salt,passwd_lastmodified,phoneNumber,legacy_verification_behavior,passwd_change_required,last_logon_success_time,previous_logon_success_time ";
    public static final String PRE_DEFAULT_USER_BY_USERNAME_QUERY = "select id,username,password,email,givenName,familyName,created,lastModified,authorities,origin,external_id,verified,identity_zone_id,salt,passwd_lastmodified,phoneNumber,legacy_verification_behavior,passwd_change_required,last_logon_success_time,previous_logon_success_time from users where %s = ? and active=? and origin=? and identity_zone_id=?";
    public static final String DEFAULT_CASE_SENSITIVE_USER_BY_USERNAME_QUERY = String.format("select id,username,password,email,givenName,familyName,created,lastModified,authorities,origin,external_id,verified,identity_zone_id,salt,passwd_lastmodified,phoneNumber,legacy_verification_behavior,passwd_change_required,last_logon_success_time,previous_logon_success_time from users where %s = ? and active=? and origin=? and identity_zone_id=?", "lower(username)");
    public static final String DEFAULT_CASE_INSENSITIVE_USER_BY_USERNAME_QUERY = String.format("select id,username,password,email,givenName,familyName,created,lastModified,authorities,origin,external_id,verified,identity_zone_id,salt,passwd_lastmodified,phoneNumber,legacy_verification_behavior,passwd_change_required,last_logon_success_time,previous_logon_success_time from users where %s = ? and active=? and origin=? and identity_zone_id=?", "username");
    public static final String PRE_DEFAULT_USER_BY_EMAIL_AND_ORIGIN_QUERY = "select id,username,password,email,givenName,familyName,created,lastModified,authorities,origin,external_id,verified,identity_zone_id,salt,passwd_lastmodified,phoneNumber,legacy_verification_behavior,passwd_change_required,last_logon_success_time,previous_logon_success_time from users where %s=? and active=? and origin=? and identity_zone_id=?";
    public static final String DEFAULT_CASE_SENSITIVE_USER_BY_EMAIL_AND_ORIGIN_QUERY = String.format("select id,username,password,email,givenName,familyName,created,lastModified,authorities,origin,external_id,verified,identity_zone_id,salt,passwd_lastmodified,phoneNumber,legacy_verification_behavior,passwd_change_required,last_logon_success_time,previous_logon_success_time from users where %s=? and active=? and origin=? and identity_zone_id=?", "lower(email)");
    public static final String DEFAULT_CASE_INSENSITIVE_USER_BY_EMAIL_AND_ORIGIN_QUERY = String.format("select id,username,password,email,givenName,familyName,created,lastModified,authorities,origin,external_id,verified,identity_zone_id,salt,passwd_lastmodified,phoneNumber,legacy_verification_behavior,passwd_change_required,last_logon_success_time,previous_logon_success_time from users where %s=? and active=? and origin=? and identity_zone_id=?", "email");
    public static final String DEFAULT_UPDATE_USER_LAST_LOGON = "update users set previous_logon_success_time = last_logon_success_time, last_logon_success_time = ? where id = ? and identity_zone_id=?";
    public static final String DEFAULT_USER_BY_ID_QUERY = "select id,username,password,email,givenName,familyName,created,lastModified,authorities,origin,external_id,verified,identity_zone_id,salt,passwd_lastmodified,phoneNumber,legacy_verification_behavior,passwd_change_required,last_logon_success_time,previous_logon_success_time from users where id = ? and active=? and identity_zone_id=?";
    private final TimeService timeService;
    private JdbcTemplate jdbcTemplate;
    private final RowMapper<UaaUser> mapper = new UaaUserRowMapper();
    private final RowMapper<UserInfo> userInfoMapper = new UserInfoRowMapper();
    private boolean caseInsensitive = false;

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public RowMapper<UaaUser> getMapper() {
        return this.mapper;
    }

    public JdbcUaaUserDatabase(JdbcTemplate jdbcTemplate, TimeService timeService) {
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
        this.timeService = timeService;
    }

    @Override
    public UaaUser retrieveUserByName(String username, String origin) throws UsernameNotFoundException {
        try {
            String sql = this.isCaseInsensitive() ? DEFAULT_CASE_INSENSITIVE_USER_BY_USERNAME_QUERY : DEFAULT_CASE_SENSITIVE_USER_BY_USERNAME_QUERY;
            return (UaaUser)this.jdbcTemplate.queryForObject(sql, this.mapper, new Object[]{username.toLowerCase(Locale.US), true, origin, IdentityZoneHolder.get().getId()});
        }
        catch (EmptyResultDataAccessException e) {
            throw new UsernameNotFoundException(username);
        }
    }

    @Override
    public UaaUser retrieveUserById(String id) throws UsernameNotFoundException {
        try {
            return (UaaUser)this.jdbcTemplate.queryForObject(DEFAULT_USER_BY_ID_QUERY, this.mapper, new Object[]{id, true, IdentityZoneHolder.get().getId()});
        }
        catch (EmptyResultDataAccessException e) {
            throw new UsernameNotFoundException(id);
        }
    }

    @Override
    public UaaUser retrieveUserByEmail(String email, String origin) throws UsernameNotFoundException {
        String sql = this.isCaseInsensitive() ? DEFAULT_CASE_INSENSITIVE_USER_BY_EMAIL_AND_ORIGIN_QUERY : DEFAULT_CASE_SENSITIVE_USER_BY_EMAIL_AND_ORIGIN_QUERY;
        List results = this.jdbcTemplate.query(sql, this.mapper, new Object[]{email.toLowerCase(Locale.US), true, origin, IdentityZoneHolder.get().getId()});
        if (results.size() == 0) {
            return null;
        }
        if (results.size() == 1) {
            return (UaaUser)results.get(0);
        }
        throw new IncorrectResultSizeDataAccessException(String.format("Multiple users match email=%s origin=%s", email, origin), 1, results.size());
    }

    @Override
    public UserInfo getUserInfo(String id) {
        try {
            return (UserInfo)this.jdbcTemplate.queryForObject("select user_id, info from user_info where user_id = ?", this.userInfoMapper, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            logger.debug((Object)("No custom attributes stored for user:" + id));
            return null;
        }
    }

    @Override
    public UserInfo storeUserInfo(String id, UserInfo info) {
        if (StringUtils.isEmpty((Object)id)) {
            throw new NullPointerException("id is a required field");
        }
        String insertUserInfoSQL = "insert into user_info(user_id, info) values (?,?)";
        String updateUserInfoSQL = "update user_info set info = ? where user_id = ?";
        if (info == null) {
            info = new UserInfo();
        }
        String json = JsonUtils.writeValueAsString((Object)info);
        int count = this.jdbcTemplate.update("update user_info set info = ? where user_id = ?", new Object[]{json, id});
        if (count == 0) {
            this.jdbcTemplate.update("insert into user_info(user_id, info) values (?,?)", new Object[]{id, json});
        }
        return this.getUserInfo(id);
    }

    @Override
    public void updateLastLogonTime(String userId) {
        int update = this.jdbcTemplate.update(DEFAULT_UPDATE_USER_LAST_LOGON, new Object[]{this.timeService.getCurrentTimeMillis(), userId, IdentityZoneHolder.get().getId()});
    }

    private final class UaaUserRowMapper
    implements RowMapper<UaaUser> {
        private UaaUserRowMapper() {
        }

        public UaaUser mapRow(ResultSet rs, int rowNum) throws SQLException {
            String id = rs.getString("id");
            UaaUserPrototype prototype = new UaaUserPrototype().withId(id).withUsername(rs.getString("username")).withPassword(rs.getString("password")).withEmail(rs.getString("email")).withGivenName(rs.getString("givenName")).withFamilyName(rs.getString("familyName")).withCreated(rs.getTimestamp("created")).withModified(rs.getTimestamp("lastModified")).withOrigin(rs.getString("origin")).withExternalId(rs.getString("external_id")).withVerified(rs.getBoolean("verified")).withZoneId(rs.getString("identity_zone_id")).withSalt(rs.getString("salt")).withPasswordLastModified(rs.getTimestamp("passwd_lastmodified")).withPhoneNumber(rs.getString("phoneNumber")).withLegacyVerificationBehavior(rs.getBoolean("legacy_verification_behavior")).withPasswordChangeRequired(rs.getBoolean("passwd_change_required"));
            Long lastLogon = rs.getLong("last_logon_success_time");
            if (rs.wasNull()) {
                lastLogon = null;
            }
            Long previousLogon = rs.getLong("previous_logon_success_time");
            if (rs.wasNull()) {
                previousLogon = null;
            }
            prototype.withLastLogonSuccess(lastLogon).withPreviousLogonSuccess(previousLogon);
            List authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)this.getAuthorities(id));
            return new UaaUser(prototype.withAuthorities(authorities));
        }

        private String getAuthorities(String userId) {
            HashSet<String> authorities = new HashSet<String>();
            this.getAuthorities(authorities, Arrays.asList(userId));
            authorities.addAll(IdentityZoneHolder.get().getConfig().getUserConfig().getDefaultGroups());
            return StringUtils.collectionToCommaDelimitedString(new HashSet<String>(authorities));
        }

        protected void getAuthorities(Set<String> authorities, List<String> memberIdList) {
            if (memberIdList.size() == 0) {
                return;
            }
            StringBuffer dynamicAuthoritiesQuery = new StringBuffer("select g.id,g.displayName from groups g, group_membership m where g.id = m.group_id  and g.identity_zone_id=? and m.member_id in (");
            for (int i = 0; i < memberIdList.size() - 1; ++i) {
                dynamicAuthoritiesQuery.append("?,");
            }
            dynamicAuthoritiesQuery.append("?);");
            Object[] parameterList = ArrayUtils.addAll((Object[])new Object[]{IdentityZoneHolder.get().getId()}, (Object[])memberIdList.toArray());
            List results = JdbcUaaUserDatabase.this.jdbcTemplate.queryForList(dynamicAuthoritiesQuery.toString(), parameterList);
            ArrayList<String> newMemberIdList = new ArrayList<String>();
            for (int i = 0; i < results.size(); ++i) {
                Map record = (Map)results.get(i);
                String displayName = (String)record.get("displayName");
                String groupId = (String)record.get("id");
                if (authorities.contains(displayName)) continue;
                authorities.add(displayName);
                newMemberIdList.add(groupId);
            }
            this.getAuthorities(authorities, newMemberIdList);
        }
    }

    private final class UserInfoRowMapper
    implements RowMapper<UserInfo> {
        private UserInfoRowMapper() {
        }

        public UserInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            String id = rs.getString(1);
            String info = rs.getString(2);
            UserInfo userInfo = StringUtils.hasText((String)info) ? (UserInfo)JsonUtils.readValue((String)info, UserInfo.class) : new UserInfo();
            return userInfo;
        }
    }
}

