/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class UaaRequestMatcher
implements RequestMatcher,
BeanNameAware {
    private static final Log logger = LogFactory.getLog(UaaRequestMatcher.class);
    private final String path;
    private List<String> accepts;
    private HttpMethod method;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, List<String>> expectedHeaders = new HashMap<String, List<String>>();
    private String name;

    public UaaRequestMatcher(String path) {
        Assert.hasText((String)path);
        if (path.contains("*")) {
            throw new IllegalArgumentException("UaaRequestMatcher is not intended for use with wildcards");
        }
        this.path = path;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setAccept(List<String> accepts) {
        this.accepts = Collections.unmodifiableList(accepts);
        this.setHeaders(Collections.singletonMap("accept", this.accepts));
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public boolean matches(HttpServletRequest request) {
        String message = request.getRequestURI() + "'; '" + request.getContextPath() + this.path + "' with parameters=" + this.parameters + " and headers " + this.expectedHeaders;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("[" + this.name + "] Checking match of request : '" + message));
        }
        if (!request.getRequestURI().startsWith(request.getContextPath() + this.path)) {
            return false;
        }
        if (this.method != null && !this.method.toString().equals(request.getMethod().toUpperCase())) {
            return false;
        }
        for (Map.Entry<String, List<String>> expectedHeaderEntry : this.expectedHeaders.entrySet()) {
            String requestValue = request.getHeader(expectedHeaderEntry.getKey());
            if (!("accept".equalsIgnoreCase(expectedHeaderEntry.getKey()) ? !this.matchesAcceptHeader(requestValue, expectedHeaderEntry.getValue()) : !this.matchesHeader(requestValue, expectedHeaderEntry.getValue()))) continue;
            return false;
        }
        for (String key : this.parameters.keySet()) {
            String value = request.getParameter(key);
            if (value != null && value.startsWith(this.parameters.get(key))) continue;
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[" + this.name + "]Matched request " + message));
        }
        return true;
    }

    private boolean matchesHeader(String requestValue, List<String> expectedValues) {
        for (String headerValue : expectedValues) {
            if (!("bearer ".equalsIgnoreCase(headerValue) ? requestValue == null || !requestValue.toLowerCase().startsWith(headerValue) : requestValue == null || !requestValue.startsWith(headerValue))) continue;
            return false;
        }
        return true;
    }

    private boolean matchesAcceptHeader(String requestValue, List<String> expectedValues) {
        if (requestValue == null) {
            return true;
        }
        List requestValues = MediaType.parseMediaTypes((String)requestValue);
        for (String expectedValue : expectedValues) {
            if (!MediaType.parseMediaType((String)expectedValue).includes((MediaType)requestValues.get(0))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UaaRequestMatcher)) {
            return false;
        }
        UaaRequestMatcher other = (UaaRequestMatcher)obj;
        if (!this.path.equals(other.path)) {
            return false;
        }
        if (!(this.method == null && other.method == null || this.method != null && other.method != null && this.method == other.method)) {
            return false;
        }
        if (!(this.parameters == null && other.parameters == null || this.parameters != null && this.parameters.equals(other.parameters))) {
            return false;
        }
        if (!(this.accepts == null && other.accepts == null || this.accepts != null && this.accepts.equals(other.accepts))) {
            return false;
        }
        return this.expectedHeaders == null && other.expectedHeaders == null || this.expectedHeaders != null && this.expectedHeaders.equals(other.expectedHeaders);
    }

    public int hashCode() {
        int code = 0x1F ^ this.path.hashCode();
        if (this.method != null) {
            code ^= this.method.hashCode();
        }
        if (this.accepts != null) {
            code ^= this.accepts.hashCode();
        }
        if (this.parameters != null) {
            code ^= this.parameters.hashCode();
        }
        return code;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UAAPath(" + this.name + ") ['").append(this.path).append("'");
        if (this.accepts != null) {
            sb.append(", ").append(this.accepts);
        }
        sb.append("]");
        return sb.toString();
    }

    public void setHeaders(Map<String, List<String>> headers) {
        for (String headerName : headers.keySet()) {
            ArrayList expectedValues = new ArrayList();
            expectedValues.addAll(headers.get(headerName));
            this.expectedHeaders.put(headerName, expectedValues);
        }
    }

    public void setBeanName(String name) {
        this.name = name;
    }
}

