/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableToken;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableTokenProvisioning;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.util.StringUtils;

public class IsSelfCheck {
    private static Log logger = LogFactory.getLog(IsSelfCheck.class);
    private final RevocableTokenProvisioning tokenProvisioning;

    public IsSelfCheck(RevocableTokenProvisioning tokenProvisioning) {
        this.tokenProvisioning = tokenProvisioning;
    }

    public boolean isUserSelf(HttpServletRequest request, int pathParameterIndex) {
        String pathInfo = UaaUrlUtils.getRequestPath(request);
        String idFromUrl = this.extractIdFromUrl(pathParameterIndex, pathInfo);
        String idFromAuth = this.extractUserIdFromAuthentication(SecurityContextHolder.getContext().getAuthentication());
        return idFromAuth != null && idFromAuth.equals(idFromUrl);
    }

    protected String extractClientIdFromAuthentication(Authentication authentication) {
        if (authentication == null) {
            return null;
        }
        if (authentication instanceof OAuth2Authentication) {
            OAuth2Authentication a = (OAuth2Authentication)authentication;
            return a.getOAuth2Request().getClientId();
        }
        return null;
    }

    protected String extractUserIdFromAuthentication(Authentication authentication) {
        OAuth2Authentication a;
        if (authentication == null) {
            return null;
        }
        if (authentication.getPrincipal() instanceof UaaPrincipal) {
            return ((UaaPrincipal)authentication.getPrincipal()).getId();
        }
        if (authentication instanceof OAuth2Authentication && !(a = (OAuth2Authentication)authentication).isClientOnly() && a.getUserAuthentication().getPrincipal() instanceof UaaPrincipal) {
            return ((UaaPrincipal)a.getUserAuthentication().getPrincipal()).getId();
        }
        return null;
    }

    protected String extractIdFromUrl(int pathParameterIndex, String pathInfo) {
        if (!StringUtils.hasText((String)pathInfo)) {
            return null;
        }
        return UaaUrlUtils.extractPathVariableFromUrl(pathParameterIndex, pathInfo);
    }

    public boolean isTokenRevocationForSelf(HttpServletRequest request, int index) {
        String pathInfo = UaaUrlUtils.getRequestPath(request);
        String tokenId = this.extractIdFromUrl(index, pathInfo);
        if (StringUtils.hasText((String)pathInfo) && StringUtils.hasText((String)tokenId)) {
            try {
                RevocableToken revocableToken = (RevocableToken)this.tokenProvisioning.retrieve(tokenId, IdentityZoneHolder.get().getId());
                String clientIdFromToken = revocableToken.getClientId();
                String clientIdFromAuthentication = this.extractClientIdFromAuthentication(SecurityContextHolder.getContext().getAuthentication());
                if (clientIdFromToken.equals(clientIdFromAuthentication)) {
                    return true;
                }
                String userIdFromToken = revocableToken.getUserId();
                String userIdFromAuthentication = this.extractUserIdFromAuthentication(SecurityContextHolder.getContext().getAuthentication());
                if (StringUtils.hasText((String)userIdFromToken) && userIdFromToken.equals(userIdFromAuthentication)) {
                    return true;
                }
            }
            catch (EmptyResultDataAccessException x) {
                logger.debug((Object)("Token not found:" + tokenId));
            }
        }
        return false;
    }

    public boolean isUserTokenRevocationForSelf(HttpServletRequest request, int index) {
        String pathInfo = UaaUrlUtils.getRequestPath(request);
        String userIdFromPath = this.extractIdFromUrl(index, pathInfo);
        String userIdFromAuth = this.extractUserIdFromAuthentication(SecurityContextHolder.getContext().getAuthentication());
        return StringUtils.hasText((String)userIdFromPath) && userIdFromPath.equals(userIdFromAuth);
    }

    public boolean isClientTokenRevocationForSelf(HttpServletRequest request, int index) {
        String pathInfo = UaaUrlUtils.getRequestPath(request);
        String clientIdFromPath = this.extractIdFromUrl(index, pathInfo);
        String clientIdFromAuth = this.extractClientIdFromAuthentication(SecurityContextHolder.getContext().getAuthentication());
        return StringUtils.hasText((String)clientIdFromPath) && clientIdFromPath.equals(clientIdFromAuth);
    }

    public boolean isTokenListForAuthenticatedClient(HttpServletRequest request) {
        String pathInfo = UaaUrlUtils.getRequestPath(request);
        String clientId = this.extractIdFromUrl(4, pathInfo);
        String idFromAuth = this.extractClientIdFromAuthentication(SecurityContextHolder.getContext().getAuthentication());
        return StringUtils.hasText((String)idFromAuth) && idFromAuth.equals(clientId);
    }

    public boolean isTokenListForAuthenticatedUser(HttpServletRequest request) {
        String pathInfo = UaaUrlUtils.getRequestPath(request);
        String userId = this.extractIdFromUrl(4, pathInfo);
        String idFromAuth = this.extractUserIdFromAuthentication(SecurityContextHolder.getContext().getAuthentication());
        return StringUtils.hasText((String)idFromAuth) && idFromAuth.equals(userId);
    }
}

