/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.event;

import java.util.List;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.event.GroupModifiedEvent;
import org.cloudfoundry.identity.uaa.scim.event.UserModifiedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class ScimEventPublisher
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher publisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public void userCreated(ScimUser user) {
        this.publish(UserModifiedEvent.userCreated(user.getId(), user.getUserName()));
    }

    public void userVerified(ScimUser user) {
        this.publish(UserModifiedEvent.userVerified(user.getId(), user.getUserName()));
    }

    public void userModified(ScimUser user) {
        this.publish(UserModifiedEvent.userModified(user.getId(), user.getUserName()));
    }

    public void userDeleted(ScimUser user) {
        this.publish(UserModifiedEvent.userDeleted(user.getId(), user.getUserName()));
    }

    public void groupCreated(ScimGroup group) {
        this.publish(GroupModifiedEvent.groupCreated(group.getId(), group.getDisplayName(), ScimEventPublisher.getMembers(group)));
    }

    public void groupModified(ScimGroup group) {
        this.publish(GroupModifiedEvent.groupModified(group.getId(), group.getDisplayName(), ScimEventPublisher.getMembers(group)));
    }

    public void groupDeleted(ScimGroup group) {
        this.publish(GroupModifiedEvent.groupDeleted(group.getId(), group.getDisplayName(), ScimEventPublisher.getMembers(group)));
    }

    public static String[] getMembers(ScimGroup group) {
        List gm = group.getMembers();
        String[] members = new String[gm != null ? gm.size() : 0];
        for (int i = 0; i < members.length; ++i) {
            members[i] = ((ScimGroupMember)gm.get(i)).getMemberId();
        }
        return members;
    }

    public void publish(ApplicationEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent(event);
        }
    }
}

