/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.event.AbstractUaaEvent;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class GroupModifiedEvent
extends AbstractUaaEvent {
    private String groupId;
    private String groupName;
    private String[] members;
    private AuditEventType eventType;

    protected GroupModifiedEvent(String groupId, String name, String[] members, AuditEventType type, Authentication authentication) {
        super(authentication);
        this.groupId = groupId;
        this.groupName = name;
        this.members = members;
        this.eventType = type;
    }

    public static GroupModifiedEvent groupCreated(String group, String name, String[] members) {
        return new GroupModifiedEvent(group, name, members, AuditEventType.GroupCreatedEvent, GroupModifiedEvent.getContextAuthentication());
    }

    public static GroupModifiedEvent groupModified(String group, String name, String[] members) {
        return new GroupModifiedEvent(group, name, members, AuditEventType.GroupModifiedEvent, GroupModifiedEvent.getContextAuthentication());
    }

    public static GroupModifiedEvent groupDeleted(String group, String name, String[] members) {
        return new GroupModifiedEvent(group, name, members, AuditEventType.GroupDeletedEvent, GroupModifiedEvent.getContextAuthentication());
    }

    @Override
    public AuditEvent getAuditEvent() {
        String data = JsonUtils.writeValueAsString((Object)new GroupInfo(this.groupName, this.members));
        return this.createAuditRecord(this.groupId, this.eventType, this.getOrigin((Principal)this.getAuthentication()), data);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String[] getMembers() {
        return this.members;
    }

    protected static Authentication getContextAuthentication() {
        Authentication a = SecurityContextHolder.getContext().getAuthentication();
        if (a == null) {
            a = new Authentication(){
                ArrayList<GrantedAuthority> authorities = new ArrayList();

                public Collection<? extends GrantedAuthority> getAuthorities() {
                    return this.authorities;
                }

                public Object getCredentials() {
                    return null;
                }

                public Object getDetails() {
                    return null;
                }

                public Object getPrincipal() {
                    return "null";
                }

                public boolean isAuthenticated() {
                    return false;
                }

                public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
                }

                public String getName() {
                    return "null";
                }
            };
        }
        return a;
    }

    public static class GroupInfo {
        @JsonIgnore
        private String group;
        @JsonIgnore
        private String[] members;

        @JsonCreator
        public GroupInfo(@JsonProperty(value="group_name") String g, @JsonProperty(value="members") String[] m) {
            this.group = g;
            this.members = m;
            Arrays.sort(this.members);
        }

        @JsonProperty(value="group_name")
        public String getGroup() {
            return this.group;
        }

        @JsonProperty(value="members")
        public String[] getMembers() {
            return this.members;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupInfo groupInfo = (GroupInfo)o;
            if (!this.group.equals(groupInfo.group)) {
                return false;
            }
            return Arrays.equals(this.members, groupInfo.members);
        }

        public int hashCode() {
            int result = this.group.hashCode();
            result = 31 * result + Arrays.hashCode(this.members);
            return result;
        }

        public String toString() {
            return "GroupInfo{group='" + this.group + '\'' + ", members=" + Arrays.toString(this.members) + '}';
        }
    }
}

