/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.resources.jdbc;

import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.resources.AttributeNameMapper;
import org.cloudfoundry.identity.uaa.resources.SimpleAttributeNameMapper;
import org.cloudfoundry.identity.uaa.resources.jdbc.SearchQueryConverter;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class SimpleSearchQueryConverter
implements SearchQueryConverter {
    public static final List<String> VALID_ATTRIBUTE_NAMES = Collections.unmodifiableList(Arrays.asList("id", "created", "lastmodified", "version", "username", "password", "email", "givenname", "familyname", "name.familyname", "name.givenname", "active", "phonenumber", "verified", "origin", "identity_zone_id", "passwd_lastmodified", "passwd_change_required", "last_logon_success_time", "previous_logon_success_time", "displayname", "scope", "group_id", "member_id", "member_type", "description", "client_id", "authorized_grant_types", "web_server_redirect_uri", "redirect_uri", "access_token_validity", "refresh_token_validity", "autoapprove", "show_on_home_page", "created_by", "required_user_groups", "user_id", "meta.lastmodified", "meta.created", "meta.location", "meta.resourcetype", "meta.version", "emails.value", "groups.display", "phonenumbers.value", "gm.external_group", "gm.origin", "g.displayname", "g.id"));
    private static Log logger = LogFactory.getLog(SimpleSearchQueryConverter.class);
    private AttributeNameMapper mapper = new SimpleAttributeNameMapper(Collections.emptyMap());
    private boolean dbCaseInsensitive = false;

    public boolean isDbCaseInsensitive() {
        return this.dbCaseInsensitive;
    }

    public void setDbCaseInsensitive(boolean caseInsensitive) {
        this.dbCaseInsensitive = caseInsensitive;
    }

    public void setAttributeNameMapper(AttributeNameMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public SearchQueryConverter.ProcessedFilter convert(String filter, String sortBy, boolean ascending) {
        return this.convert(filter, sortBy, ascending, this.mapper);
    }

    @Override
    public SearchQueryConverter.ProcessedFilter convert(String filter, String sortBy, boolean ascending, AttributeNameMapper mapper) {
        String paramPrefix = this.generateParameterPrefix(filter);
        HashMap<String, Object> values = new HashMap<String, Object>();
        String where = StringUtils.hasText((String)filter) ? this.getWhereClause(filter, sortBy, ascending, values, mapper, paramPrefix) : null;
        SearchQueryConverter.ProcessedFilter pf = new SearchQueryConverter.ProcessedFilter(where, values, StringUtils.hasText((String)sortBy));
        pf.setParamPrefix(paramPrefix);
        return pf;
    }

    protected String generateParameterPrefix(String filter) {
        String s;
        while (filter.contains(s = new RandomValueStringGenerator().generate().toLowerCase())) {
        }
        return "__" + s + "_";
    }

    private String getWhereClause(String filter, String sortBy, boolean ascending, Map<String, Object> values, AttributeNameMapper mapper, String paramPrefix) {
        try {
            SCIMFilter scimFilter = this.scimFilter(filter);
            String whereClause = this.createFilter(scimFilter, values, mapper, paramPrefix);
            if (sortBy != null) {
                sortBy = mapper.mapToInternal(sortBy);
                whereClause = whereClause + " ORDER BY " + sortBy + (ascending ? " ASC" : " DESC");
            }
            return whereClause;
        }
        catch (SCIMException e) {
            logger.debug((Object)("Unable to parse " + filter), (Throwable)e);
            throw new IllegalArgumentException("Invalid SCIM Filter:" + filter + " Message:" + e.getMessage());
        }
    }

    @Override
    public MultiValueMap<String, Object> getFilterValues(String filter, List<String> validAttributes) throws IllegalArgumentException {
        try {
            SCIMFilter scimFilter = SCIMFilter.parse((String)filter);
            this.validateFilterAttributes(scimFilter, validAttributes);
            LinkedMultiValueMap result = new LinkedMultiValueMap();
            this.extractValues(scimFilter, (MultiValueMap<String, Object>)result);
            return result;
        }
        catch (SCIMException x) {
            throw new IllegalArgumentException(x.getMessage());
        }
    }

    protected SCIMFilter scimFilter(String filter) throws SCIMException {
        SCIMFilter scimFilter;
        try {
            scimFilter = SCIMFilter.parse((String)filter);
        }
        catch (SCIMException e) {
            logger.debug((Object)("Attempting legacy scim filter conversion for [" + filter + "]"), (Throwable)e);
            filter = filter.replaceAll("'", "\"");
            scimFilter = SCIMFilter.parse((String)filter);
        }
        this.validateFilterAttributes(scimFilter, VALID_ATTRIBUTE_NAMES);
        return scimFilter;
    }

    private void validateFilterAttributes(SCIMFilter filter, List<String> validAttributeNames) throws SCIMException {
        LinkedList<String> invalidAttributes = new LinkedList<String>();
        this.validateFilterAttributes(filter, invalidAttributes, validAttributeNames);
        if (!invalidAttributes.isEmpty()) {
            throw new InvalidResourceException("Invalid filter attributes:" + StringUtils.collectionToCommaDelimitedString(invalidAttributes));
        }
    }

    private void validateFilterAttributes(SCIMFilter filter, List<String> invalidAttribues, List<String> validAttributeNames) {
        if (filter.getFilterAttribute() != null && filter.getFilterAttribute().getAttributeName() != null) {
            String name = filter.getFilterAttribute().getAttributeName();
            if (filter.getFilterAttribute().getSubAttributeName() != null) {
                name = name + "." + filter.getFilterAttribute().getSubAttributeName();
            }
            if (!validAttributeNames.contains(name.toLowerCase())) {
                invalidAttribues.add(name);
            }
        }
        for (SCIMFilter subfilter : Optional.ofNullable(filter.getFilterComponents()).orElse(Collections.emptyList())) {
            this.validateFilterAttributes(subfilter, invalidAttribues, validAttributeNames);
        }
    }

    private void extractValues(SCIMFilter filter, MultiValueMap<String, Object> values) throws SCIMException {
        switch (filter.getFilterType()) {
            case AND: {
                this.extractValues((SCIMFilter)filter.getFilterComponents().get(0), values);
                this.extractValues((SCIMFilter)filter.getFilterComponents().get(1), values);
                break;
            }
            case OR: {
                throw SCIMException.createException((int)400, (String)"[or] operator is not supported.");
            }
            case EQUALITY: {
                Object value = this.getStringOrDate(filter.getFilterValue());
                String key = filter.getFilterAttribute().getAttributeName();
                values.add((Object)key, value);
                break;
            }
            case CONTAINS: {
                throw SCIMException.createException((int)400, (String)"[co] operator is not supported.");
            }
            case STARTS_WITH: {
                throw SCIMException.createException((int)400, (String)"[sw] operator is not supported.");
            }
            case PRESENCE: {
                throw SCIMException.createException((int)400, (String)"[pr] operator is not supported.");
            }
            case GREATER_THAN: {
                throw SCIMException.createException((int)400, (String)"[gt] operator is not supported.");
            }
            case GREATER_OR_EQUAL: {
                throw SCIMException.createException((int)400, (String)"[ge] operator is not supported.");
            }
            case LESS_THAN: {
                throw SCIMException.createException((int)400, (String)"[lt] operator is not supported.");
            }
            case LESS_OR_EQUAL: {
                throw SCIMException.createException((int)400, (String)"[le] operator is not supported.");
            }
            default: {
                throw SCIMException.createException((int)400, (String)("Unknown filter operator:" + filter.getFilterType()));
            }
        }
    }

    private String createFilter(SCIMFilter filter, Map<String, Object> values, AttributeNameMapper mapper, String paramPrefix) {
        switch (filter.getFilterType()) {
            case AND: {
                return "(" + this.createFilter((SCIMFilter)filter.getFilterComponents().get(0), values, mapper, paramPrefix) + " AND " + this.createFilter((SCIMFilter)filter.getFilterComponents().get(1), values, mapper, paramPrefix) + ")";
            }
            case OR: {
                return "(" + this.createFilter((SCIMFilter)filter.getFilterComponents().get(0), values, mapper, paramPrefix) + " OR " + this.createFilter((SCIMFilter)filter.getFilterComponents().get(1), values, mapper, paramPrefix) + ")";
            }
            case EQUALITY: {
                return this.comparisonClause(filter, "=", values, "", "", paramPrefix);
            }
            case CONTAINS: {
                return this.comparisonClause(filter, "LIKE", values, "%", "%", paramPrefix);
            }
            case STARTS_WITH: {
                return this.comparisonClause(filter, "LIKE", values, "", "%", paramPrefix);
            }
            case PRESENCE: {
                return this.getAttributeName(filter, mapper) + " IS NOT NULL";
            }
            case GREATER_THAN: {
                return this.comparisonClause(filter, ">", values, "", "", paramPrefix);
            }
            case GREATER_OR_EQUAL: {
                return this.comparisonClause(filter, ">=", values, "", "", paramPrefix);
            }
            case LESS_THAN: {
                return this.comparisonClause(filter, "<", values, "", "", paramPrefix);
            }
            case LESS_OR_EQUAL: {
                return this.comparisonClause(filter, "<=", values, "", "", paramPrefix);
            }
        }
        return null;
    }

    protected String comparisonClause(SCIMFilter filter, String comparator, Map<String, Object> values, String valuePrefix, String valueSuffix, String paramPrefix) {
        String pName = this.getParamName(values, paramPrefix);
        String paramName = ":" + pName;
        if (filter.getFilterValue() == null) {
            return this.getAttributeName(filter, this.mapper) + " IS NULL";
        }
        if (filter.isQuoteFilterValue()) {
            Object value = this.getStringOrDate(filter.getFilterValue());
            if (value instanceof String) {
                switch (filter.getFilterAttribute().getAttributeName().toLowerCase()) {
                    case "client_secret": 
                    case "password": 
                    case "salt": {
                        value = "";
                    }
                }
                values.put(pName, valuePrefix + value + valueSuffix);
                if (this.isDbCaseInsensitive()) {
                    return "" + this.getAttributeName(filter, this.mapper) + " " + comparator + " " + paramName + "";
                }
                return "LOWER(" + this.getAttributeName(filter, this.mapper) + ") " + comparator + " LOWER(" + paramName + ")";
            }
            values.put(pName, value);
            return this.getAttributeName(filter, this.mapper) + " " + comparator + " " + paramName;
        }
        try {
            values.put(pName, Double.parseDouble(filter.getFilterValue()));
        }
        catch (NumberFormatException x) {
            if ("true".equalsIgnoreCase(filter.getFilterValue())) {
                values.put(pName, Boolean.TRUE);
            }
            if ("false".equalsIgnoreCase(filter.getFilterValue())) {
                values.put(pName, Boolean.FALSE);
            }
            throw new IllegalArgumentException("Invalid non quoted value [" + filter.getFilterAttribute() + " : " + filter.getFilterValue() + "]");
        }
        return this.getAttributeName(filter, this.mapper) + " " + comparator + " " + paramName;
    }

    protected String getAttributeName(SCIMFilter filter, AttributeNameMapper mapper) {
        String name = filter.getFilterAttribute().getAttributeName();
        String subName = filter.getFilterAttribute().getSubAttributeName();
        if (StringUtils.hasText((String)subName)) {
            name = name + "." + subName;
        }
        name = mapper.mapToInternal(name);
        return name.replace("meta.", "");
    }

    protected String getParamName(Map<String, Object> values, String paramPrefix) {
        return paramPrefix + values.size();
    }

    protected Object getStringOrDate(String s) {
        try {
            SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            return TIMESTAMP_FORMAT.parse(s);
        }
        catch (ParseException x) {
            return s;
        }
    }

    @Override
    public String map(String attribute) {
        return StringUtils.hasText((String)attribute) ? this.mapper.mapToInternal(attribute) : attribute;
    }
}

