/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import java.util.Collection;
import java.util.HashSet;
import org.cloudfoundry.identity.uaa.provider.saml.idp.IdpExtendedMetadata;
import org.cloudfoundry.identity.uaa.provider.saml.idp.IdpMetadataGenerator;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.xml.security.credential.UsageType;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.util.StringUtils;

public class ZoneAwareIdpMetadataGenerator
extends IdpMetadataGenerator {
    @Override
    public boolean isAssertionsSigned() {
        if (!IdentityZoneHolder.isUaa()) {
            return this.getZoneDefinition().getSamlConfig().isAssertionSigned();
        }
        return super.isAssertionsSigned();
    }

    @Override
    public int getAssertionTimeToLiveSeconds() {
        if (!IdentityZoneHolder.isUaa()) {
            return this.getZoneDefinition().getSamlConfig().getAssertionTimeToLiveSeconds();
        }
        return super.getAssertionTimeToLiveSeconds();
    }

    @Override
    public IdpExtendedMetadata generateExtendedMetadata() {
        IdpExtendedMetadata metadata = super.generateExtendedMetadata();
        metadata.setAlias(UaaUrlUtils.getSubdomain(IdentityZoneHolder.get().getSubdomain()) + metadata.getAlias());
        return metadata;
    }

    @Override
    public String getEntityId() {
        String entityId = super.getEntityId();
        if (StringUtils.hasText((String)IdentityZoneHolder.get().getConfig().getSamlConfig().getEntityID())) {
            return IdentityZoneHolder.get().getConfig().getSamlConfig().getEntityID();
        }
        if (UaaUrlUtils.isUrl(entityId)) {
            return UaaUrlUtils.addSubdomainToUrl(entityId, IdentityZoneHolder.get().getSubdomain());
        }
        return UaaUrlUtils.getSubdomain(IdentityZoneHolder.get().getSubdomain()) + entityId;
    }

    @Override
    public String getEntityBaseURL() {
        return UaaUrlUtils.addSubdomainToUrl(super.getEntityBaseURL(), IdentityZoneHolder.get().getSubdomain());
    }

    @Override
    protected String getEntityAlias() {
        return UaaUrlUtils.getSubdomain(IdentityZoneHolder.get().getSubdomain()) + super.getEntityAlias();
    }

    @Override
    public boolean isWantAuthnRequestSigned() {
        if (!IdentityZoneHolder.isUaa()) {
            return this.getZoneDefinition().getSamlConfig().isWantAuthnRequestSigned();
        }
        return super.isWantAuthnRequestSigned();
    }

    protected IdentityZoneConfiguration getZoneDefinition() {
        IdentityZone zone = IdentityZoneHolder.get();
        IdentityZoneConfiguration definition = zone.getConfig();
        return definition != null ? definition : new IdentityZoneConfiguration();
    }

    @Override
    public EntityDescriptor generateMetadata() {
        EntityDescriptor result = super.generateMetadata();
        result.setID(SAMLUtil.getNCNameString((String)result.getEntityID()));
        return result;
    }

    @Override
    protected IDPSSODescriptor buildIDPSSODescriptor(String entityBaseURL, String entityAlias, boolean wantAuthnRequestSigned, Collection<String> includedNameID) {
        IDPSSODescriptor result = super.buildIDPSSODescriptor(entityBaseURL, entityAlias, wantAuthnRequestSigned, includedNameID);
        KeyManager samlSPKeyManager = IdentityZoneHolder.getSamlSPKeyManager();
        if (samlSPKeyManager != null && samlSPKeyManager.getAvailableCredentials() != null) {
            HashSet allKeyAliases = new HashSet(samlSPKeyManager.getAvailableCredentials());
            String activeKeyAlias = samlSPKeyManager.getDefaultCredentialName();
            allKeyAliases.remove(activeKeyAlias);
            for (String keyAlias : allKeyAliases) {
                result.getKeyDescriptors().add(this.getKeyDescriptor(UsageType.SIGNING, this.getServerKeyInfo(keyAlias)));
            }
        }
        return result;
    }
}

