/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.provider.saml.idp.IdpExtendedMetadata;
import org.cloudfoundry.identity.uaa.provider.saml.idp.IdpMetadataGenerator;
import org.cloudfoundry.identity.uaa.provider.saml.idp.IdpMetadataManager;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderConfigurator;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderHolder;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.ExtendedMetadataProvider;
import org.springframework.security.saml.metadata.MetadataMemoryProvider;
import org.springframework.security.saml.trust.httpclient.TLSProtocolConfigurer;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.util.StringUtils;

public class NonSnarlIdpMetadataManager
extends IdpMetadataManager
implements ExtendedMetadataProvider,
InitializingBean,
DisposableBean,
BeanNameAware {
    private static final Log logger = LogFactory.getLog(NonSnarlIdpMetadataManager.class);
    private SamlServiceProviderConfigurator configurator;
    private IdpMetadataGenerator generator;
    private Map<String, String> zoneHostedIdpNames;
    private ExtendedMetadata defaultExtendedMetadata;
    private String beanName = NonSnarlIdpMetadataManager.class.getName() + "-" + System.identityHashCode((Object)this);

    public NonSnarlIdpMetadataManager(SamlServiceProviderConfigurator configurator) throws MetadataProviderException {
        super(Collections.emptyList());
        this.configurator = configurator;
        super.setKeyManager(IdentityZoneHolder.getSamlSPKeyManager());
        super.setRefreshCheckInterval(0L);
        logger.info((Object)"-----> Internal Timer is disabled");
        this.defaultExtendedMetadata = new ExtendedMetadata();
        if (this.zoneHostedIdpNames == null) {
            this.zoneHostedIdpNames = new ConcurrentHashMap<String, String>();
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setProviders(List<MetadataProvider> newProviders) throws MetadataProviderException {
    }

    public void refreshMetadata() {
    }

    public void addMetadataProvider(MetadataProvider newProvider) throws MetadataProviderException {
    }

    public void removeMetadataProvider(MetadataProvider provider) {
    }

    public List<MetadataProvider> getProviders() {
        ArrayList<MetadataProvider> result = new ArrayList<MetadataProvider>();
        for (ExtendedMetadataDelegate delegate : this.getAvailableProviders()) {
            result.add((MetadataProvider)delegate);
        }
        return result;
    }

    public List<ExtendedMetadataDelegate> getAvailableProviders() {
        IdentityZone zone = IdentityZoneHolder.get();
        ArrayList<ExtendedMetadataDelegate> result = new ArrayList<ExtendedMetadataDelegate>();
        try {
            result.add(this.getLocalIdp());
        }
        catch (MetadataProviderException e) {
            throw new IllegalStateException(e);
        }
        for (SamlServiceProviderHolder holder : this.configurator.getSamlServiceProviders()) {
            this.log.info("Adding SAML SP zone[" + zone.getId() + "] alias[" + holder.getSamlServiceProvider().getEntityId() + "]");
            try {
                ExtendedMetadataDelegate delegate = holder.getExtendedMetadataDelegate();
                this.initializeProvider(delegate);
                this.initializeProviderData(delegate);
                this.initializeProviderFilters(delegate);
                result.add(delegate);
            }
            catch (MetadataProviderException e) {
                this.log.error("Invalid SAML IDP zone[" + zone.getId() + "] alias[" + holder.getSamlServiceProvider().getEntityId() + "]", (Throwable)e);
            }
        }
        return result;
    }

    public ExtendedMetadataDelegate getLocalIdp() throws MetadataProviderException {
        EntityDescriptor descriptor = this.generator.generateMetadata();
        IdpExtendedMetadata extendedMetadata = this.generator.generateExtendedMetadata();
        this.log.info("Initialized local identity provider for entityID: " + descriptor.getEntityID());
        MetadataMemoryProvider memoryProvider = new MetadataMemoryProvider(descriptor);
        memoryProvider.initialize();
        return new ExtendedMetadataDelegate((MetadataProvider)memoryProvider, (ExtendedMetadata)extendedMetadata);
    }

    protected void initializeProvider(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        this.log.debug("Initializing extendedMetadataDelegate {}", (Object)provider);
        provider.initialize();
    }

    protected void initializeProviderData(ExtendedMetadataDelegate provider) throws MetadataProviderException {
    }

    public Set<String> getIDPEntityNames() {
        HashSet<String> result = new HashSet<String>();
        ExtendedMetadataDelegate delegate = null;
        try {
            delegate = this.getLocalIdp();
            String idp = this.getProviderIdpAlias(delegate);
            if (StringUtils.hasText((String)idp)) {
                result.add(idp);
            }
        }
        catch (MetadataProviderException e) {
            this.log.error("Unable to get IDP alias for:" + delegate, (Throwable)e);
        }
        return result;
    }

    protected String getProviderIdpAlias(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        List stringSet = this.parseProvider((MetadataProvider)provider);
        for (String key : stringSet) {
            RoleDescriptor idpRoleDescriptor = provider.getRole(key, IDPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol");
            if (idpRoleDescriptor == null) continue;
            return key;
        }
        return null;
    }

    public Set<String> getSPEntityNames() {
        HashSet<String> result = new HashSet<String>();
        for (ExtendedMetadataDelegate delegate : this.getAvailableProviders()) {
            try {
                String sp = this.getSpName(delegate);
                if (!StringUtils.hasText((String)sp)) continue;
                result.add(sp);
            }
            catch (MetadataProviderException e) {
                this.log.error("Unable to get IDP alias for:" + delegate, (Throwable)e);
            }
        }
        return result;
    }

    protected String getSpName(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        List stringSet = this.parseProvider((MetadataProvider)provider);
        for (String key : stringSet) {
            ExtendedMetadata extendedMetadata;
            RoleDescriptor spRoleDescriptor = provider.getRole(key, SPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol");
            if (spRoleDescriptor == null || (extendedMetadata = this.getExtendedMetadata(key, (MetadataProvider)provider)) == null) continue;
            return key;
        }
        return null;
    }

    protected String getHostedSpName(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        String key = this.getSpName(provider);
        ExtendedMetadata extendedMetadata = this.getExtendedMetadata(key, (MetadataProvider)provider);
        if (extendedMetadata.isLocal()) {
            return key;
        }
        return null;
    }

    public List<RoleDescriptor> getRole(String entityID, QName roleName) throws MetadataProviderException {
        List roleDescriptors = null;
        for (MetadataProvider provider : this.getProviders()) {
            this.log.debug("Checking child metadata provider for entity descriptor with entity ID: {}", (Object)entityID);
            try {
                roleDescriptors = provider.getRole(entityID, roleName);
                if (roleDescriptors == null || roleDescriptors.isEmpty()) continue;
                break;
            }
            catch (MetadataProviderException e) {
                this.log.warn("Error retrieving metadata from provider of type {}, proceeding to next provider", (Object)provider.getClass().getName(), (Object)e);
            }
        }
        return roleDescriptors;
    }

    public RoleDescriptor getRole(String entityID, QName roleName, String supportedProtocol) throws MetadataProviderException {
        RoleDescriptor roleDescriptor = null;
        for (MetadataProvider provider : this.getProviders()) {
            this.log.debug("Checking child metadata provider for entity descriptor with entity ID: {}", (Object)entityID);
            try {
                roleDescriptor = provider.getRole(entityID, roleName, supportedProtocol);
                if (roleDescriptor == null) continue;
                break;
            }
            catch (MetadataProviderException e) {
                this.log.warn("Error retrieving metadata from provider of type {}, proceeding to next provider", (Object)provider.getClass().getName(), (Object)e);
            }
        }
        return roleDescriptor;
    }

    public boolean isIDPValid(String idpID) {
        return this.getIDPEntityNames().contains(idpID);
    }

    public boolean isSPValid(String spID) {
        return this.getSPEntityNames().contains(spID);
    }

    @Override
    public String getHostedIdpName() {
        return this.zoneHostedIdpNames.get(IdentityZoneHolder.get().getId());
    }

    @Override
    public void setHostedIdpName(String hostedIdpName) {
        String zoneId = IdentityZoneHolder.get().getId();
        this.zoneHostedIdpNames.put(zoneId, hostedIdpName);
    }

    public String getHostedSPName() {
        for (ExtendedMetadataDelegate delegate : this.getAvailableProviders()) {
            try {
                String spName = this.getHostedSpName(delegate);
                if (!StringUtils.hasText((String)spName)) continue;
                return spName;
            }
            catch (MetadataProviderException e) {
                this.log.error("Unable to find hosted SP name:" + delegate, (Throwable)e);
            }
        }
        return null;
    }

    public void setHostedSPName(String hostedSPName) {
    }

    public String getDefaultIDP() throws MetadataProviderException {
        Iterator<String> iterator = this.getIDPEntityNames().iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new MetadataProviderException("No IDP was configured, please update included metadata with at least one IDP");
    }

    public EntityDescriptor getEntityDescriptor(String entityID) throws MetadataProviderException {
        EntityDescriptor descriptor = null;
        for (MetadataProvider provider : this.getProviders()) {
            this.log.debug("Checking child metadata provider for entity descriptor with entity ID: {}", (Object)entityID);
            try {
                descriptor = provider.getEntityDescriptor(entityID);
                if (descriptor == null) continue;
                break;
            }
            catch (MetadataProviderException e) {
                this.log.warn("Error retrieving metadata from provider of type {}, proceeding to next provider", (Object)provider.getClass().getName(), (Object)e);
            }
        }
        return descriptor;
    }

    public EntityDescriptor getEntityDescriptor(byte[] hash) throws MetadataProviderException {
        for (String sp : this.getSPEntityNames()) {
            if (!SAMLUtil.compare((byte[])hash, (String)sp)) continue;
            return this.getEntityDescriptor(sp);
        }
        for (String idp : this.getIDPEntityNames()) {
            if (!SAMLUtil.compare((byte[])hash, (String)idp)) continue;
            return this.getEntityDescriptor(idp);
        }
        return null;
    }

    public String getEntityIdForAlias(String entityAlias) throws MetadataProviderException {
        ExtendedMetadata extendedMetadata;
        if (entityAlias == null) {
            return null;
        }
        String entityId = null;
        for (String sp : this.getSPEntityNames()) {
            extendedMetadata = this.getExtendedMetadata(sp);
            if (!entityAlias.equals(extendedMetadata.getAlias())) continue;
            if (entityId != null && !entityId.equals(sp)) {
                throw new MetadataProviderException("Alias " + entityAlias + " is used both for entity " + entityId + " and " + sp);
            }
            entityId = sp;
        }
        for (String idp : this.getIDPEntityNames()) {
            extendedMetadata = this.getExtendedMetadata(idp);
            if (!entityAlias.equals(extendedMetadata.getAlias())) continue;
            if (entityId != null && !entityId.equals(idp)) {
                throw new MetadataProviderException("Alias " + entityAlias + " is used both for entity " + entityId + " and " + idp);
            }
            entityId = idp;
        }
        return entityId;
    }

    public ExtendedMetadata getDefaultExtendedMetadata() {
        return this.defaultExtendedMetadata;
    }

    public void setDefaultExtendedMetadata(ExtendedMetadata defaultExtendedMetadata) {
        this.defaultExtendedMetadata = defaultExtendedMetadata;
    }

    public boolean isRefreshRequired() {
        return false;
    }

    public void setRefreshRequired(boolean refreshRequired) {
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
        super.setKeyManager(keyManager);
    }

    @Autowired(required=false)
    public void setTLSConfigurer(TLSProtocolConfigurer configurer) {
    }

    public void destroy() {
    }

    public ExtendedMetadata getExtendedMetadata(String entityID) throws MetadataProviderException {
        for (MetadataProvider metadataProvider : this.getAvailableProviders()) {
            ExtendedMetadata extendedMetadata = this.getExtendedMetadata(entityID, metadataProvider);
            if (extendedMetadata == null) continue;
            return extendedMetadata;
        }
        return this.getDefaultExtendedMetadata().clone();
    }

    private ExtendedMetadata getExtendedMetadata(String entityID, MetadataProvider provider) throws MetadataProviderException {
        ExtendedMetadataProvider extendedProvider;
        ExtendedMetadata extendedMetadata;
        if (provider instanceof ExtendedMetadataProvider && (extendedMetadata = (extendedProvider = (ExtendedMetadataProvider)provider).getExtendedMetadata(entityID)) != null) {
            return extendedMetadata.clone();
        }
        return null;
    }

    public IdpMetadataGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(IdpMetadataGenerator generator) {
        this.generator = generator;
    }
}

