/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import org.opensaml.xml.Configuration;
import org.opensaml.xml.security.BasicSecurityConfiguration;
import org.springframework.beans.factory.InitializingBean;

public class SamlConfigurationBean
implements InitializingBean {
    private SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.SHA1;

    public void setSignatureAlgorithm(SignatureAlgorithm s) {
        this.signatureAlgorithm = s;
    }

    public void afterPropertiesSet() throws Exception {
        BasicSecurityConfiguration config = (BasicSecurityConfiguration)Configuration.getGlobalSecurityConfiguration();
        switch (this.signatureAlgorithm) {
            case SHA1: {
                config.registerSignatureAlgorithmURI("RSA", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
                config.setSignatureReferenceDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
                break;
            }
            case SHA256: {
                config.registerSignatureAlgorithmURI("RSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
                config.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
                break;
            }
            case SHA512: {
                config.registerSignatureAlgorithmURI("RSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
                config.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512");
            }
        }
    }

    public static enum SignatureAlgorithm {
        SHA1,
        SHA256,
        SHA512;

    }
}

