/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.cloudfoundry.identity.uaa.provider.saml.LoginSAMLException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;

public class LoginSAMLAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private static final Log LOG = LogFactory.getLog(LoginSAMLAuthenticationFailureHandler.class);

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String[] redirectURI;
        DefaultSavedRequest savedRequest;
        HttpSession session;
        String redirectTo = null;
        if (exception instanceof LoginSAMLException && (session = request.getSession()) != null && (savedRequest = (DefaultSavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST")) != null && (redirectURI = (String[])savedRequest.getParameterMap().get("redirect_uri")) != null && redirectURI.length > 0) {
            URI uri = URI.create(redirectURI[0]);
            URIBuilder uriBuilder = new URIBuilder(uri);
            uriBuilder.addParameter("error", "access_denied");
            uriBuilder.addParameter("error_description", exception.getMessage());
            redirectTo = uriBuilder.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error redirect to: " + redirectTo));
            }
            this.getRedirectStrategy().sendRedirect(request, response, redirectTo);
        }
        if (redirectTo == null) {
            Throwable cause = exception.getCause();
            if (cause != null) {
                AuthenticationServiceException e = new AuthenticationServiceException(cause.getMessage(), cause.getCause());
                this.logger.debug((Object)cause);
                super.onAuthenticationFailure(request, response, (AuthenticationException)e);
            } else {
                this.logger.debug((Object)exception);
                super.onAuthenticationFailure(request, response, exception);
            }
        }
    }
}

