/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderWrapper;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class BootstrapSamlIdentityProviderData
implements InitializingBean {
    private static Log logger = LogFactory.getLog(BootstrapSamlIdentityProviderData.class);
    private String legacyIdpIdentityAlias;
    private volatile String legacyIdpMetaData;
    private String legacyNameId;
    private int legacyAssertionConsumerIndex;
    private boolean legacyMetadataTrustCheck = true;
    private boolean legacyShowSamlLink = true;
    private List<IdentityProviderWrapper<SamlIdentityProviderDefinition>> samlProviders = new LinkedList<IdentityProviderWrapper<SamlIdentityProviderDefinition>>();
    private Map<String, Map<String, Object>> providers = null;

    public List<SamlIdentityProviderDefinition> getIdentityProviderDefinitions() {
        return Collections.unmodifiableList(this.samlProviders.stream().map(p -> (SamlIdentityProviderDefinition)p.getProvider().getConfig()).collect(Collectors.toList()));
    }

    protected void parseIdentityProviderDefinitions() {
        if (this.getLegacyIdpMetaData() != null) {
            SamlIdentityProviderDefinition def = new SamlIdentityProviderDefinition();
            def.setMetaDataLocation(this.getLegacyIdpMetaData());
            def.setMetadataTrustCheck(this.isLegacyMetadataTrustCheck());
            def.setNameID(this.getLegacyNameId());
            def.setAssertionConsumerIndex(this.getLegacyAssertionConsumerIndex());
            String alias = this.getLegacyIdpIdentityAlias();
            if (alias == null) {
                throw new IllegalArgumentException("Invalid IDP - Alias must be not null for deprecated IDP.");
            }
            def.setIdpEntityAlias(alias);
            def.setShowSamlLink(this.isLegacyShowSamlLink());
            def.setLinkText("Use your corporate credentials");
            def.setZoneId(IdentityZone.getUaaZoneId());
            logger.debug((Object)("Legacy SAML provider configured with alias: " + alias));
            IdentityProviderWrapper<SamlIdentityProviderDefinition> wrapper = new IdentityProviderWrapper<SamlIdentityProviderDefinition>(BootstrapSamlIdentityProviderData.parseSamlProvider(def));
            wrapper.setOverride(true);
            this.samlProviders.add(wrapper);
        }
        HashSet<String> uniqueAlias = new HashSet<String>();
        for (IdentityProviderWrapper<SamlIdentityProviderDefinition> wrapper : this.samlProviders) {
            String alias = this.getUniqueAlias((SamlIdentityProviderDefinition)wrapper.getProvider().getConfig());
            if (uniqueAlias.contains(alias)) {
                throw new IllegalStateException("Duplicate IDP alias found:" + alias);
            }
            uniqueAlias.add(alias);
        }
    }

    protected String getUniqueAlias(SamlIdentityProviderDefinition def) {
        return def.getUniqueAlias();
    }

    public void setIdentityProviders(Map<String, Map<String, Object>> providers) {
        if (providers == null) {
            return;
        }
        this.providers = providers;
        for (Map.Entry<String, Map<String, Object>> entry : providers.entrySet()) {
            String alias = entry.getKey();
            Map<String, Object> saml = entry.getValue();
            String metaDataLocation = (String)saml.get("idpMetadata");
            String nameID = (String)saml.get("nameID");
            Integer assertionIndex = (Integer)saml.get("assertionConsumerIndex");
            Boolean trustCheck = (Boolean)saml.get("metadataTrustCheck");
            Boolean showLink = (Boolean)entry.getValue().get("showSamlLoginLink");
            String socketFactoryClassName = (String)saml.get("socketFactoryClassName");
            String linkText = (String)entry.getValue().get("linkText");
            String iconUrl = (String)entry.getValue().get("iconUrl");
            String zoneId = (String)entry.getValue().get("zoneId");
            String groupMappingMode = (String)entry.getValue().get("groupMappingMode");
            String providerDescription = (String)entry.getValue().get("providerDescription");
            Boolean addShadowUserOnLogin = (Boolean)entry.getValue().get("addShadowUserOnLogin");
            Boolean skipSslValidation = (Boolean)entry.getValue().get("skipSslValidation");
            Boolean storeCustomAttributes = (Boolean)entry.getValue().get("storeCustomAttributes");
            Boolean override = (Boolean)entry.getValue().get("override");
            List authnContext = (List)saml.get("authnContext");
            if (storeCustomAttributes == null) {
                storeCustomAttributes = true;
            }
            if (skipSslValidation == null) {
                skipSslValidation = socketFactoryClassName != null ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
            List emailDomain = (List)saml.get("emailDomain");
            List externalGroupsWhitelist = (List)saml.get("externalGroupsWhitelist");
            Map attributeMappings = (Map)saml.get("attributeMappings");
            SamlIdentityProviderDefinition def = new SamlIdentityProviderDefinition();
            def.setStoreCustomAttributes(storeCustomAttributes.booleanValue());
            if (StringUtils.hasText((String)providerDescription)) {
                def.setProviderDescription(providerDescription);
            }
            if (alias == null) {
                throw new IllegalArgumentException("Invalid IDP - alias must not be null [" + metaDataLocation + "]");
            }
            if (metaDataLocation == null) {
                throw new IllegalArgumentException("Invalid IDP - metaDataLocation must not be null [" + alias + "]");
            }
            def.setIdpEntityAlias(alias);
            def.setAssertionConsumerIndex(assertionIndex == null ? 0 : assertionIndex);
            def.setMetaDataLocation(metaDataLocation);
            def.setNameID(nameID);
            def.setMetadataTrustCheck(trustCheck == null ? true : trustCheck);
            if (StringUtils.hasText((String)groupMappingMode)) {
                def.setGroupMappingMode(SamlIdentityProviderDefinition.ExternalGroupMappingMode.valueOf((String)groupMappingMode));
            }
            def.setShowSamlLink(showLink == null ? true : showLink);
            def.setSocketFactoryClassName(socketFactoryClassName);
            def.setLinkText(linkText);
            def.setIconUrl(iconUrl);
            def.setEmailDomain(emailDomain);
            def.setExternalGroupsWhitelist(externalGroupsWhitelist);
            def.setAttributeMappings(attributeMappings);
            def.setZoneId(StringUtils.hasText((String)zoneId) ? zoneId : IdentityZone.getUaaZoneId());
            def.setAddShadowUserOnLogin(addShadowUserOnLogin == null ? true : addShadowUserOnLogin);
            def.setSkipSslValidation(skipSslValidation.booleanValue());
            def.setAuthnContext(authnContext);
            IdentityProvider<SamlIdentityProviderDefinition> provider = BootstrapSamlIdentityProviderData.parseSamlProvider(def);
            IdentityProviderWrapper<SamlIdentityProviderDefinition> wrapper = new IdentityProviderWrapper<SamlIdentityProviderDefinition>(provider);
            wrapper.setOverride(override == null ? true : override);
            this.samlProviders.add(wrapper);
        }
    }

    public static IdentityProvider<SamlIdentityProviderDefinition> parseSamlProvider(SamlIdentityProviderDefinition def) {
        IdentityProvider provider = new IdentityProvider();
        provider.setType("saml");
        provider.setOriginKey(def.getIdpEntityAlias());
        provider.setName("UAA SAML Identity Provider[" + provider.getOriginKey() + "]");
        provider.setActive(true);
        try {
            provider.setConfig((AbstractIdentityProviderDefinition)def);
        }
        catch (JsonUtils.JsonUtilException x) {
            throw new RuntimeException("Non serializable SAML config");
        }
        return provider;
    }

    public String getLegacyIdpIdentityAlias() {
        return this.legacyIdpIdentityAlias;
    }

    public void setLegacyIdpIdentityAlias(String legacyIdpIdentityAlias) {
        this.legacyIdpIdentityAlias = "null".equals(legacyIdpIdentityAlias) ? null : legacyIdpIdentityAlias;
    }

    public String getLegacyIdpMetaData() {
        return this.legacyIdpMetaData;
    }

    public void setLegacyIdpMetaData(String legacyIdpMetaData) {
        this.legacyIdpMetaData = "null".equals(legacyIdpMetaData) ? null : legacyIdpMetaData;
    }

    public String getLegacyNameId() {
        return this.legacyNameId;
    }

    public void setLegacyNameId(String legacyNameId) {
        this.legacyNameId = legacyNameId;
    }

    public int getLegacyAssertionConsumerIndex() {
        return this.legacyAssertionConsumerIndex;
    }

    public void setLegacyAssertionConsumerIndex(int legacyAssertionConsumerIndex) {
        this.legacyAssertionConsumerIndex = legacyAssertionConsumerIndex;
    }

    public boolean isLegacyMetadataTrustCheck() {
        return this.legacyMetadataTrustCheck;
    }

    public void setLegacyMetadataTrustCheck(boolean legacyMetadataTrustCheck) {
        this.legacyMetadataTrustCheck = legacyMetadataTrustCheck;
    }

    public boolean isLegacyShowSamlLink() {
        return this.legacyShowSamlLink;
    }

    public void setLegacyShowSamlLink(boolean legacyShowSamlLink) {
        this.legacyShowSamlLink = legacyShowSamlLink;
    }

    public void afterPropertiesSet() throws Exception {
        this.parseIdentityProviderDefinitions();
    }

    public List<IdentityProviderWrapper<SamlIdentityProviderDefinition>> getSamlProviders() {
        return Optional.ofNullable(this.samlProviders).orElse(Collections.emptyList());
    }
}

