/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.ldap;

import java.util.Arrays;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.provider.ldap.DynamicPasswordComparator;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.encoding.LdapShaPasswordEncoder;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticator;

public class PasswordComparisonAuthenticator
extends AbstractLdapAuthenticator {
    private static final Log logger = LogFactory.getLog(PasswordComparisonAuthenticator.class);
    private boolean localCompare;
    private String passwordAttributeName;
    private PasswordEncoder passwordEncoder = new LdapShaPasswordEncoder();

    public PasswordComparisonAuthenticator(BaseLdapPathContextSource contextSource) {
        super((ContextSource)contextSource);
    }

    public DirContextOperations authenticate(Authentication authentication) {
        DirContextOperations user = null;
        String username = authentication.getName();
        String password = (String)authentication.getCredentials();
        SpringSecurityLdapTemplate ldapTemplate = new SpringSecurityLdapTemplate(this.getContextSource());
        for (String userDn : this.getUserDns(username)) {
            try {
                user = ldapTemplate.retrieveEntry(userDn, this.getUserAttributes());
            }
            catch (NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            if (user == null) continue;
            break;
        }
        if (user == null && this.getUserSearch() != null) {
            user = this.getUserSearch().searchForUser(username);
        }
        if (user == null) {
            throw new UsernameNotFoundException("User not found: " + username);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing LDAP compare of password attribute '" + this.passwordAttributeName + "' for user '" + user.getDn() + "'"));
        }
        if (this.isLocalCompare()) {
            this.localCompareAuthenticate(user, password);
        } else {
            String encodedPassword = this.passwordEncoder.encodePassword(password, null);
            byte[] passwordBytes = Utf8.encode((CharSequence)encodedPassword);
            this.searchAuthenticate(user, passwordBytes, ldapTemplate);
        }
        return user;
    }

    public DirContextOperations localCompareAuthenticate(DirContextOperations user, String password) {
        boolean match = false;
        try {
            Attributes attributes = user.getAttributes();
            Attribute attr = attributes.get(this.getPasswordAttributeName());
            if (attr.size() == 0) {
                throw new AuthenticationCredentialsNotFoundException("Missing " + this.getPasswordAttributeName() + " attribute.");
            }
            for (int i = 0; attr != null && !match && i < attr.size(); ++i) {
                Object valObject = attr.get(i);
                if (valObject == null || !(valObject instanceof byte[])) continue;
                if (this.passwordEncoder instanceof DynamicPasswordComparator) {
                    byte[] received = password.getBytes();
                    byte[] stored = (byte[])valObject;
                    match = ((DynamicPasswordComparator)this.passwordEncoder).comparePasswords(received, stored);
                    continue;
                }
                String encodedPassword = this.passwordEncoder.encodePassword(password, null);
                byte[] passwordBytes = Utf8.encode((CharSequence)encodedPassword);
                match = Arrays.equals(passwordBytes, (byte[])valObject);
            }
        }
        catch (NamingException e) {
            throw new BadCredentialsException("Bad credentials", (Throwable)e);
        }
        if (!match) {
            throw new BadCredentialsException("Bad credentials");
        }
        return user;
    }

    public DirContextOperations searchAuthenticate(DirContextOperations user, byte[] passwordBytes, SpringSecurityLdapTemplate ldapTemplate) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing LDAP compare of password attribute '" + this.passwordAttributeName + "' for user '" + user.getDn() + "'"));
        }
        if (!ldapTemplate.compare(user.getDn().toString(), this.passwordAttributeName, (Object)passwordBytes)) {
            throw new BadCredentialsException(this.messages.getMessage("PasswordComparisonAuthenticator.badCredentials", "Bad credentials"));
        }
        return user;
    }

    public void setPasswordAttributeName(String passwordAttribute) {
        this.passwordAttributeName = passwordAttribute;
    }

    public String getPasswordAttributeName() {
        return this.passwordAttributeName;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public boolean isLocalCompare() {
        return this.localCompare;
    }

    public void setLocalCompare(boolean localCompare) {
        this.localCompare = localCompare;
    }
}

