/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.token;

import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.DefaultSecurityContextAccessor;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class JwtTokenGranter
extends AbstractTokenGranter {
    protected JwtTokenGranter(AuthorizationServerTokenServices tokenServices, ClientServicesExtension clientDetailsService, OAuth2RequestFactory requestFactory) {
        super(tokenServices, (ClientDetailsService)clientDetailsService, requestFactory, "urn:ietf:params:oauth:grant-type:jwt-bearer");
    }

    protected Authentication validateRequest(TokenRequest request) {
        if (new DefaultSecurityContextAccessor().isUser()) {
            if (request == null || request.getRequestParameters() == null || request.getRequestParameters().isEmpty()) {
                throw new InvalidGrantException("Missing token request object");
            }
            if (request.getRequestParameters().get("grant_type") == null) {
                throw new InvalidGrantException("Missing grant type");
            }
            if (!"urn:ietf:params:oauth:grant-type:jwt-bearer".equals(request.getRequestParameters().get("grant_type"))) {
                throw new InvalidGrantException("Invalid grant type");
            }
        } else {
            throw new InvalidGrantException("User authentication not found");
        }
        return SecurityContextHolder.getContext().getAuthentication();
    }

    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        Authentication userAuth = this.validateRequest(tokenRequest);
        OAuth2Request storedOAuth2Request = this.getRequestFactory().createOAuth2Request(client, tokenRequest);
        return new OAuth2Authentication(storedOAuth2Request, userAuth);
    }
}

