/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.refresh;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.cloudfoundry.identity.uaa.oauth.AuthTimeDateConverter;
import org.cloudfoundry.identity.uaa.oauth.AuthorizationAttributesParser;
import org.cloudfoundry.identity.uaa.oauth.KeyInfo;
import org.cloudfoundry.identity.uaa.oauth.KeyInfoService;
import org.cloudfoundry.identity.uaa.oauth.TokenEndpointBuilder;
import org.cloudfoundry.identity.uaa.oauth.TokenValidityResolver;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHelper;
import org.cloudfoundry.identity.uaa.oauth.refresh.CompositeExpiringOAuth2RefreshToken;
import org.cloudfoundry.identity.uaa.oauth.refresh.RefreshTokenRequestData;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.oauth2.common.exceptions.InsufficientScopeException;
import org.springframework.util.StringUtils;

public class RefreshTokenCreator {
    private boolean isRestrictRefreshGrant;
    private final TokenValidityResolver refreshTokenValidityResolver;
    private final TokenEndpointBuilder tokenEndpointBuilder;
    private TimeService timeService;
    private KeyInfoService keyInfoService;
    private final String UAA_REFRESH_TOKEN = "uaa.offline_token";

    public RefreshTokenCreator(boolean isRestrictRefreshGrant, TokenValidityResolver refreshTokenValidityResolver, TokenEndpointBuilder tokenEndpointBuilder, TimeService timeService, KeyInfoService keyInfoService) {
        this.isRestrictRefreshGrant = isRestrictRefreshGrant;
        this.refreshTokenValidityResolver = refreshTokenValidityResolver;
        this.tokenEndpointBuilder = tokenEndpointBuilder;
        this.timeService = timeService;
        this.keyInfoService = keyInfoService;
    }

    public CompositeExpiringOAuth2RefreshToken createRefreshToken(UaaUser user, RefreshTokenRequestData tokenRequestData, String revocableHashSignature) {
        String grantType = tokenRequestData.grantType;
        Set<String> scope = tokenRequestData.scopes;
        if (!this.isRefreshTokenSupported(grantType, scope)) {
            return null;
        }
        Map<String, String> additionalAuthorizationAttributes = new AuthorizationAttributesParser().getAdditionalAuthorizationAttributes(tokenRequestData.authorities);
        Date expirationDate = this.refreshTokenValidityResolver.resolve(tokenRequestData.clientId);
        String tokenId = UUID.randomUUID().toString().replace("-", "") + "-r";
        String jwtToken = this.buildJwtToken(user, tokenRequestData, revocableHashSignature, grantType, additionalAuthorizationAttributes, expirationDate, tokenId);
        return new CompositeExpiringOAuth2RefreshToken(jwtToken, expirationDate, tokenId);
    }

    private String buildJwtToken(UaaUser user, RefreshTokenRequestData tokenRequestData, String revocableHashSignature, String grantType, Map<String, String> additionalAuthorizationAttributes, Date expirationDate, String tokenId) {
        String content;
        try {
            LinkedHashMap<String, Object> claims = new LinkedHashMap<String, Object>();
            claims.put("jti", tokenId);
            claims.put("sub", user.getId());
            claims.put("iat", this.timeService.getCurrentTimeMillis() / 1000L);
            claims.put("exp", expirationDate.getTime() / 1000L);
            claims.put("cid", tokenRequestData.clientId);
            claims.put("client_id", tokenRequestData.clientId);
            claims.put("iss", this.tokenEndpointBuilder.getTokenEndpoint());
            claims.put("zid", IdentityZoneHolder.get().getId());
            claims.put("aud", tokenRequestData.resourceIds);
            claims.put("granted_scopes", tokenRequestData.scopes);
            if (null != tokenRequestData.authenticationMethods && !tokenRequestData.authenticationMethods.isEmpty()) {
                claims.put("amr", tokenRequestData.authenticationMethods);
            }
            if (null != tokenRequestData.authTime) {
                claims.put("auth_time", AuthTimeDateConverter.dateToAuthTime(tokenRequestData.authTime));
            }
            if (null != tokenRequestData.acr && !tokenRequestData.acr.isEmpty()) {
                HashMap acrMap = Maps.newHashMap();
                acrMap.put("values", tokenRequestData.acr);
                claims.put("acr", acrMap);
            }
            if (null != additionalAuthorizationAttributes) {
                claims.put("az_attr", additionalAuthorizationAttributes);
            }
            if (null != tokenRequestData.externalAttributes) {
                claims.putAll(tokenRequestData.externalAttributes);
            }
            if (null != grantType) {
                claims.put("grant_type", grantType);
            }
            if (null != user) {
                claims.put("user_name", user.getUsername());
                claims.put("origin", user.getOrigin());
                claims.put("user_id", user.getId());
            }
            if (tokenRequestData.revocable) {
                claims.put("revocable", true);
            }
            if (StringUtils.hasText((String)revocableHashSignature)) {
                claims.put("rev_sig", revocableHashSignature);
            }
            content = JsonUtils.writeValueAsString(claims);
        }
        catch (JsonUtils.JsonUtilException e) {
            throw new IllegalStateException("Cannot convert access token to JSON", e);
        }
        return JwtHelper.encode(content, this.getActiveKeyInfo()).getEncoded();
    }

    private KeyInfo getActiveKeyInfo() {
        return Optional.ofNullable(this.keyInfoService.getActiveKey()).orElseThrow(() -> new InternalAuthenticationServiceException("Unable to sign token, misconfigured JWT signing keys"));
    }

    protected boolean isRefreshTokenSupported(String grantType, Set<String> scope) {
        if (!this.isRestrictRefreshGrant) {
            return "authorization_code".equals(grantType) || "password".equals(grantType) || "user_token".equals(grantType) || "refresh_token".equals(grantType) || "urn:ietf:params:oauth:grant-type:saml2-bearer".equals(grantType);
        }
        return scope.contains("uaa.offline_token");
    }

    public void ensureRefreshTokenCreationNotRestricted(ArrayList<String> tokenScopes) {
        if (this.isRestrictRefreshGrant && !tokenScopes.contains("uaa.offline_token")) {
            throw new InsufficientScopeException(String.format("Expected scope %s is missing", "uaa.offline_token"));
        }
    }

    public void setRestrictRefreshGrant(boolean isRestrictRefreshGrant) {
        this.isRestrictRefreshGrant = isRestrictRefreshGrant;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }
}

