/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.jwt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.identity.uaa.oauth.jwk.JsonWebKey;
import org.cloudfoundry.identity.uaa.oauth.jwk.JsonWebKeySet;
import org.cloudfoundry.identity.uaa.oauth.jwt.CommonSignatureVerifier;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;

public class ChainedSignatureVerifier
implements SignatureVerifier {
    private final List<SignatureVerifier> delegates;

    public ChainedSignatureVerifier(JsonWebKeySet<? extends JsonWebKey> keys) {
        if (keys == null || keys.getKeys() == null || keys.getKeys().isEmpty()) {
            throw new IllegalArgumentException("keys cannot be null or empty");
        }
        ArrayList<CommonSignatureVerifier> ds = new ArrayList<CommonSignatureVerifier>(keys.getKeys().size());
        for (JsonWebKey key : keys.getKeys()) {
            ds.add(new CommonSignatureVerifier(key.getValue()));
        }
        this.delegates = Collections.unmodifiableList(ds);
    }

    public ChainedSignatureVerifier(List<SignatureVerifier> delegates) {
        this.delegates = delegates;
    }

    public void verify(byte[] content, byte[] signature) {
        Object last = new InvalidSignatureException("No matching keys found.");
        for (SignatureVerifier delegate : this.delegates) {
            try {
                delegate.verify(content, signature);
                return;
            }
            catch (Exception e) {
                last = e;
            }
        }
        throw last instanceof RuntimeException ? (RuntimeException)last : new RuntimeException((Throwable)last);
    }

    public String algorithm() {
        return null;
    }
}

