/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.oauth.KeyInfo;
import org.cloudfoundry.identity.uaa.oauth.KeyInfoService;
import org.cloudfoundry.identity.uaa.oauth.jwk.JsonWebKey;
import org.cloudfoundry.identity.uaa.oauth.token.VerificationKeyResponse;
import org.cloudfoundry.identity.uaa.oauth.token.VerificationKeysListResponse;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TokenKeyEndpoint {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private KeyInfoService keyInfoService;

    public TokenKeyEndpoint(KeyInfoService keyInfoService) {
        this.keyInfoService = keyInfoService;
    }

    @RequestMapping(value={"/token_key"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<VerificationKeyResponse> getKey(Principal principal, @RequestHeader(value="If-None-Match", required=false, defaultValue="NaN") String eTag) {
        String lastModified = Long.valueOf(IdentityZoneHolder.get().getLastModified().getTime()).toString();
        if (this.unmodifiedResource(eTag, lastModified)) {
            return new ResponseEntity(HttpStatus.NOT_MODIFIED);
        }
        HttpHeaders header = new HttpHeaders();
        header.put("ETag", Collections.singletonList(lastModified));
        return new ResponseEntity((Object)this.getKey(principal), (MultiValueMap)header, HttpStatus.OK);
    }

    @RequestMapping(value={"/token_keys"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<VerificationKeysListResponse> getKeys(Principal principal, @RequestHeader(value="If-None-Match", required=false, defaultValue="NaN") String eTag) {
        String lastModified = Long.valueOf(IdentityZoneHolder.get().getLastModified().getTime()).toString();
        if (this.unmodifiedResource(eTag, lastModified)) {
            return new ResponseEntity(HttpStatus.NOT_MODIFIED);
        }
        HttpHeaders header = new HttpHeaders();
        header.put("ETag", Collections.singletonList(lastModified));
        return new ResponseEntity((Object)this.getKeys(principal), (MultiValueMap)header, HttpStatus.OK);
    }

    public VerificationKeyResponse getKey(Principal principal) {
        KeyInfo key = this.keyInfoService.getActiveKey();
        if (!this.includeSymmetricalKeys(principal) && !JsonWebKey.KeyType.RSA.name().equals(key.type())) {
            throw new AccessDeniedException("You need to authenticate to see a shared key");
        }
        return TokenKeyEndpoint.getVerificationKeyResponse(key);
    }

    public static VerificationKeyResponse getVerificationKeyResponse(KeyInfo key) {
        return new VerificationKeyResponse(TokenKeyEndpoint.getResultMap(key));
    }

    public static Map<String, Object> getResultMap(KeyInfo key) {
        return key.getJwkMap();
    }

    private boolean unmodifiedResource(String eTag, String lastModified) {
        return !eTag.equals("NaN") && lastModified.equals(eTag);
    }

    public VerificationKeysListResponse getKeys(Principal principal) {
        boolean includeSymmetric = this.includeSymmetricalKeys(principal);
        Map<String, KeyInfo> keys = this.keyInfoService.getKeys();
        List keyResponses = keys.values().stream().filter(k -> includeSymmetric || JsonWebKey.KeyType.RSA.name().equals(k.type())).map(TokenKeyEndpoint::getVerificationKeyResponse).collect(Collectors.toList());
        return new VerificationKeysListResponse(keyResponses);
    }

    protected boolean includeSymmetricalKeys(Principal principal) {
        if (principal != null) {
            Authentication auth;
            if (principal instanceof AnonymousAuthenticationToken) {
                return false;
            }
            if (principal instanceof Authentication && (auth = (Authentication)principal).getAuthorities() != null) {
                for (GrantedAuthority authority : auth.getAuthorities()) {
                    if (!"uaa.resource".equals(authority.getAuthority())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

