/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdSessionStateCalculator {
    private final Logger logger = LoggerFactory.getLogger(OpenIdSessionStateCalculator.class);
    private SecureRandom secureRandom = new SecureRandom();

    public String calculate(String currentUserId, String clientId, String origin) {
        byte[] array = new byte[32];
        this.secureRandom.nextBytes(array);
        String salt = DatatypeConverter.printHexBinary((byte[])array).toLowerCase();
        String text = String.format("%s %s %s %s", clientId, origin, currentUserId, salt);
        byte[] hash = DigestUtils.sha256((byte[])text.getBytes(StandardCharsets.UTF_8));
        this.logger.debug(String.format("Calculated OIDC session state for clientId=%s, origin=%s, sessionId=REDACTED, salt=%s", clientId, origin, salt));
        return String.format("%s.%s", DatatypeConverter.printHexBinary((byte[])hash).toLowerCase(), salt);
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }
}

