/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class DisableIdTokenResponseTypeFilter
extends OncePerRequestFilter {
    public static final String ID_TOKEN = "id_token";
    protected static Log logger = LogFactory.getLog(DisableIdTokenResponseTypeFilter.class);
    private boolean active;
    private final List<String> paths;

    public DisableIdTokenResponseTypeFilter(boolean active, List<String> paths) {
        this.paths = paths;
        this.active = active;
    }

    public boolean isIdTokenDisabled() {
        return this.active;
    }

    public void setIdTokenDisabled(boolean disabled) {
        this.active = disabled;
    }

    protected boolean applyPath(String path) {
        if (this.paths == null || this.paths.size() == 0 || path == null) {
            return false;
        }
        AntPathMatcher matcher = new AntPathMatcher();
        for (String pattern : this.paths) {
            if (!(matcher.isPattern(pattern) ? matcher.match(pattern, path) : pattern.equals(path))) continue;
            return true;
        }
        return false;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        logger.debug((Object)"Processing id_token disable filter");
        Object requestWrapper = request;
        logger.debug((Object)String.format("pre id_token disable:%s pathinfo:%s request_uri:%s response_type:%s", this.isIdTokenDisabled(), requestWrapper.getPathInfo(), request.getRequestURI(), requestWrapper.getParameter("response_type")));
        if (this.isIdTokenDisabled() && (this.applyPath(request.getPathInfo()) || this.applyPath(request.getRequestURI()))) {
            requestWrapper = new RemoveIdTokenParameterValueWrapper(request);
        }
        logger.debug((Object)String.format("post id_token disable:%s pathinfo:%s request_uri:%s response_type:%s", this.isIdTokenDisabled(), requestWrapper.getPathInfo(), request.getRequestURI(), requestWrapper.getParameter("response_type")));
        filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)response);
    }

    public class RemoveIdTokenParameterValueWrapper
    extends HttpServletRequestWrapper {
        public RemoveIdTokenParameterValueWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getParameter(String name) {
            if ("response_type".equals(name)) {
                return this.removeIdTokenValue(super.getParameter(name));
            }
            return super.getParameter(name);
        }

        public Map<String, String[]> getParameterMap() {
            HashMap<String, String[]> map = super.getParameterMap();
            if (map.containsKey("response_type")) {
                HashMap<String, String[]> result = new HashMap<String, String[]>(map);
                result.put("response_type", this.getParameterValues("response_type"));
                map = result;
            }
            return map;
        }

        public String[] getParameterValues(String name) {
            String[] values = super.getParameterValues(name);
            if ("response_type".equals(name)) {
                for (int i = 0; values != null && i < values.length; ++i) {
                    values[i] = this.removeIdTokenValue(values[i]);
                }
            }
            return values;
        }

        private String removeIdTokenValue(String value) {
            if (StringUtils.hasText((String)value) && value.contains(DisableIdTokenResponseTypeFilter.ID_TOKEN)) {
                return value.replace(DisableIdTokenResponseTypeFilter.ID_TOKEN, "").trim();
            }
            return value;
        }
    }
}

