/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.mfa;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.event.EntityDeletedEvent;
import org.cloudfoundry.identity.uaa.mfa.MfaProvider;
import org.cloudfoundry.identity.uaa.mfa.MfaProviderProvisioning;
import org.cloudfoundry.identity.uaa.mfa.MfaProviderValidator;
import org.cloudfoundry.identity.uaa.mfa.exception.InvalidMfaProviderException;
import org.cloudfoundry.identity.uaa.mfa.exception.MfaAlreadyExistsException;
import org.cloudfoundry.identity.uaa.mfa.exception.MfaProviderUpdateIsNotAllowed;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneProvisioning;
import org.cloudfoundry.identity.uaa.zone.MfaConfig;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/mfa-providers"})
@RestController
public class MfaProviderEndpoints
implements ApplicationEventPublisherAware {
    protected static Log logger = LogFactory.getLog(MfaProviderEndpoints.class);
    private ApplicationEventPublisher publisher;
    private MfaProviderProvisioning mfaProviderProvisioning;
    private MfaProviderValidator mfaProviderValidator;
    private IdentityZoneProvisioning identityZoneProvisioning;

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<MfaProvider> createMfaProvider(@RequestBody MfaProvider body) {
        String zoneId = IdentityZoneHolder.get().getId();
        body.setIdentityZoneId(zoneId);
        this.mfaProviderValidator.validate(body);
        if (!StringUtils.hasText((String)body.getConfig().getIssuer())) {
            body.getConfig().setIssuer(IdentityZoneHolder.get().getName());
        }
        MfaProvider created = this.mfaProviderProvisioning.create(body, zoneId);
        return new ResponseEntity((Object)created, HttpStatus.CREATED);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<MfaProvider> updateMfaProvider() throws MfaProviderUpdateIsNotAllowed {
        throw new MfaProviderUpdateIsNotAllowed();
    }

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<List<MfaProvider>> retrieveMfaProviders() {
        String zoneId = IdentityZoneHolder.get().getId();
        List<MfaProvider> providers = this.mfaProviderProvisioning.retrieveAll(zoneId);
        return new ResponseEntity(providers, HttpStatus.OK);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    public ResponseEntity<MfaProvider> retrieveMfaProviderById(@PathVariable String id) {
        String zoneId = IdentityZoneHolder.get().getId();
        MfaProvider provider = this.mfaProviderProvisioning.retrieve(id, zoneId);
        return new ResponseEntity((Object)provider, HttpStatus.OK);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<MfaProvider> deleteMfaProviderById(@PathVariable String id) {
        MfaProvider existing = this.mfaProviderProvisioning.retrieve(id, IdentityZoneHolder.get().getId());
        MfaConfig currentMfaConfig = IdentityZoneHolder.get().getConfig().getMfaConfig();
        if (currentMfaConfig.isEnabled() && currentMfaConfig.getProviderName().equals(existing.getName())) {
            throw new MfaAlreadyExistsException("MFA provider is currently active on zone: " + IdentityZoneHolder.get().getId() + ". Please deactivate it from the zone or set another MFA provider");
        }
        this.publisher.publishEvent(new EntityDeletedEvent<MfaProvider>(existing, SecurityContextHolder.getContext().getAuthentication()));
        return new ResponseEntity((Object)existing, HttpStatus.OK);
    }

    @ExceptionHandler(value={InvalidMfaProviderException.class})
    public ResponseEntity<InvalidMfaProviderException> handleInvalidMfaProviderException(InvalidMfaProviderException e) {
        return new ResponseEntity((Object)e, HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={MfaAlreadyExistsException.class})
    public ResponseEntity<InvalidMfaProviderException> handleInvalidMfaProviderException(MfaAlreadyExistsException e) {
        return new ResponseEntity((Object)new InvalidMfaProviderException(e.getMessage()), HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={EmptyResultDataAccessException.class})
    public ResponseEntity<EmptyResultDataAccessException> handleEmptyResultDataAccessException(EmptyResultDataAccessException e) {
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={MfaProviderUpdateIsNotAllowed.class})
    public ResponseEntity<MfaProviderUpdateIsNotAllowed> handleMfaUpdatingNameOfActiveProvider(MfaProviderUpdateIsNotAllowed e) {
        return new ResponseEntity(HttpStatus.METHOD_NOT_ALLOWED);
    }

    public MfaProviderProvisioning getMfaProviderProvisioning() {
        return this.mfaProviderProvisioning;
    }

    public void setMfaProviderProvisioning(MfaProviderProvisioning mfaProviderProvisioning) {
        this.mfaProviderProvisioning = mfaProviderProvisioning;
    }

    public void setMfaProviderValidator(MfaProviderValidator mfaProviderValidator) {
        this.mfaProviderValidator = mfaProviderValidator;
    }

    public void setIdentityZoneProvisioning(IdentityZoneProvisioning identityZoneProvisioning) {
        this.identityZoneProvisioning = identityZoneProvisioning;
    }
}

