/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.mfa;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.event.SystemDeletable;
import org.cloudfoundry.identity.uaa.mfa.AbstractMfaProviderConfig;
import org.cloudfoundry.identity.uaa.mfa.GoogleMfaProviderConfig;
import org.cloudfoundry.identity.uaa.mfa.MfaProvider;
import org.cloudfoundry.identity.uaa.mfa.MfaProviderProvisioning;
import org.cloudfoundry.identity.uaa.mfa.MfaProviderValidator;
import org.cloudfoundry.identity.uaa.mfa.exception.MfaAlreadyExistsException;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.StringUtils;

public class JdbcMfaProviderProvisioning
implements MfaProviderProvisioning,
SystemDeletable {
    private static Log logger = LogFactory.getLog(JdbcMfaProviderProvisioning.class);
    public static final String TABLE_NAME = "mfa_providers";
    public static final String MFA_PROVIDER_FIELDS = "id,name,type,config,identity_zone_id,created,lastmodified";
    public static final String CREATE_PROVIDER_SQL = "insert into mfa_providers(id,name,type,config,identity_zone_id,created,lastmodified) values (?,?,?,?,?,?,?)";
    public static final String MFA_PROVIDER_UPDATE_FIELDS = "name,type,config,identity_zone_id,lastmodified".replace(",", "=?,") + "=?";
    public static final String UPDATE_PROVIDER_SQL = "update mfa_providers set " + MFA_PROVIDER_UPDATE_FIELDS + " where id=? and identity_zone_id=?";
    public static final String MFA_PROVIDER_BY_ID_QUERY = "select id,name,type,config,identity_zone_id,created,lastmodified from mfa_providers where id=? and identity_zone_id=?";
    public static final String MFA_PROVIDER_BY_NAME_QUERY = "select id,name,type,config,identity_zone_id,created,lastmodified from mfa_providers where name=? and identity_zone_id=?";
    public static final String MFA_PROVIDERS_QUERY = "select id,name,type,config,identity_zone_id,created,lastmodified from mfa_providers where identity_zone_id=?";
    public static final String MFA_PROVIDER_DELETE_BY_ID = "delete from mfa_providers where id =? and identity_zone_id=?";
    public static final String MFA_PROVIDER_DELETE_BY_ZONE_ID = "delete from mfa_providers where identity_zone_id=?";
    protected final JdbcTemplate jdbcTemplate;
    private MfaProviderValidator mfaProviderValidator;
    private MfaProviderMapper mapper = new MfaProviderMapper();

    public JdbcMfaProviderProvisioning(JdbcTemplate jdbcTemplate, MfaProviderValidator mfaProviderValidator) {
        this.jdbcTemplate = jdbcTemplate;
        this.mfaProviderValidator = mfaProviderValidator;
    }

    @Override
    public MfaProvider create(final MfaProvider provider, final String zoneId) {
        this.mfaProviderValidator.validate(provider);
        final String id = UUID.randomUUID().toString();
        try {
            this.jdbcTemplate.update(CREATE_PROVIDER_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    int pos = 1;
                    ps.setString(pos++, id);
                    ps.setString(pos++, provider.getName());
                    ps.setString(pos++, provider.getType().toValue());
                    ps.setString(pos++, JsonUtils.writeValueAsString((Object)provider.getConfig()));
                    ps.setString(pos++, zoneId);
                    ps.setTimestamp(pos++, new Timestamp(System.currentTimeMillis()));
                    ps.setTimestamp(pos++, new Timestamp(System.currentTimeMillis()));
                }
            });
        }
        catch (DuplicateKeyException e) {
            String message = e.getMostSpecificCause().getMessage();
            if (message.toUpperCase().contains("IDX_MFA_UNIQUE_NAME")) {
                message = "An MFA Provider with that name already exists.";
            }
            throw new MfaAlreadyExistsException(message);
        }
        return this.retrieve(id, zoneId);
    }

    @Override
    public MfaProvider update(MfaProvider provider, String zoneId) {
        try {
            this.jdbcTemplate.update(UPDATE_PROVIDER_SQL, ps -> {
                int pos = 1;
                ps.setString(pos++, provider.getName());
                ps.setString(pos++, provider.getType().toValue());
                ps.setString(pos++, JsonUtils.writeValueAsString((Object)provider.getConfig()));
                ps.setString(pos++, zoneId);
                ps.setTimestamp(pos++, new Timestamp(System.currentTimeMillis()));
                ps.setString(pos++, provider.getId().trim());
                ps.setString(pos++, zoneId);
            });
        }
        catch (DuplicateKeyException e) {
            String message = e.getMostSpecificCause().getMessage();
            if (message.toUpperCase().contains("IDX_MFA_UNIQUE_NAME")) {
                message = "An MFA Provider with that name already exists.";
            }
            throw new MfaAlreadyExistsException(message);
        }
        return this.retrieve(provider.getId(), zoneId);
    }

    @Override
    public MfaProvider retrieve(String id, String zoneId) {
        MfaProvider provider = (MfaProvider)this.jdbcTemplate.queryForObject(MFA_PROVIDER_BY_ID_QUERY, (RowMapper)this.mapper, new Object[]{id, zoneId});
        return provider;
    }

    @Override
    public MfaProvider retrieveByName(String name, String zoneId) {
        MfaProvider provider = (MfaProvider)this.jdbcTemplate.queryForObject(MFA_PROVIDER_BY_NAME_QUERY, (RowMapper)this.mapper, new Object[]{name, zoneId});
        return provider;
    }

    @Override
    public List<MfaProvider> retrieveAll(String zoneId) {
        return this.jdbcTemplate.query(MFA_PROVIDERS_QUERY, (RowMapper)this.mapper, new Object[]{zoneId});
    }

    @Override
    public int deleteByMfaProvider(String providerId, String zoneId) {
        return this.jdbcTemplate.update(MFA_PROVIDER_DELETE_BY_ID, new Object[]{providerId, zoneId});
    }

    @Override
    public int deleteByIdentityZone(String zoneId) {
        return this.jdbcTemplate.update(MFA_PROVIDER_DELETE_BY_ZONE_ID, new Object[]{zoneId});
    }

    @Override
    public Log getLogger() {
        return logger;
    }

    private static final class MfaProviderMapper
    implements RowMapper<MfaProvider> {
        private MfaProviderMapper() {
        }

        public MfaProvider mapRow(ResultSet rs, int rowNum) throws SQLException {
            MfaProvider result = new MfaProvider();
            int pos = 1;
            result.setId(rs.getString(pos++).trim());
            result.setName(rs.getString(pos++));
            result.setType(MfaProvider.MfaProviderType.forValue((String)rs.getString(pos++)));
            String config = rs.getString(pos++);
            GoogleMfaProviderConfig definition = null;
            switch (result.getType()) {
                case GOOGLE_AUTHENTICATOR: {
                    definition = StringUtils.hasText((String)config) ? (AbstractMfaProviderConfig)JsonUtils.readValue((String)config, GoogleMfaProviderConfig.class) : new GoogleMfaProviderConfig();
                    break;
                }
            }
            result.setConfig(definition);
            result.setIdentityZoneId(rs.getString(pos++));
            result.setCreated((Date)rs.getTimestamp(pos++));
            result.setLastModified((Date)rs.getTimestamp(pos++));
            return result;
        }
    }
}

