/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.management.Notification;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.metrics.IdleTimer;
import org.cloudfoundry.identity.uaa.metrics.MetricsAccessor;
import org.cloudfoundry.identity.uaa.metrics.MetricsQueue;
import org.cloudfoundry.identity.uaa.metrics.RequestMetric;
import org.cloudfoundry.identity.uaa.metrics.UaaMetrics;
import org.cloudfoundry.identity.uaa.metrics.UrlGroup;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.util.TimeServiceImpl;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.notification.NotificationPublisher;
import org.springframework.jmx.export.notification.NotificationPublisherAware;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import org.yaml.snakeyaml.Yaml;

@ManagedResource(objectName="cloudfoundry.identity:name=ServerRequests", description="UAA Performance Metrics")
public class UaaMetricsFilter
extends OncePerRequestFilter
implements UaaMetrics,
NotificationPublisherAware {
    public static final int MAX_TIME = 3000;
    public static final UrlGroup FALLBACK = new UrlGroup().setCategory("Unknown").setGroup("/unknown").setLimit(3000L).setPattern("/**");
    private static Log logger = LogFactory.getLog(UaaMetricsFilter.class);
    private TimeService timeService = new TimeServiceImpl();
    private IdleTimer inflight = new IdleTimer();
    private Map<String, MetricsQueue> perUriMetrics = new ConcurrentHashMap<String, MetricsQueue>();
    private LinkedHashMap<AntPathRequestMatcher, UrlGroup> urlGroups;
    private boolean enabled = true;
    private boolean perRequestMetrics = false;
    private NotificationPublisher notificationPublisher;

    public UaaMetricsFilter() throws IOException {
        this.perUriMetrics.put("uaa.global.metrics", new MetricsQueue());
        this.urlGroups = new LinkedHashMap();
        List<UrlGroup> groups = this.getUrlGroups();
        groups.stream().forEach(group -> this.urlGroups.put(new AntPathRequestMatcher(group.getPattern()), (UrlGroup)group));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        block7: {
            block6: {
                UrlGroup uriGroup;
                UrlGroup urlGroup = uriGroup = this.enabled ? this.getUriGroup(request) : null;
                if (uriGroup == null) break block6;
                RequestMetric metric = RequestMetric.start((String)request.getRequestURI(), (UrlGroup)uriGroup, (long)this.timeService.getCurrentTimeMillis());
                try {
                    MetricsAccessor.setCurrent(metric);
                    this.inflight.startRequest();
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                catch (Throwable throwable) {
                    MetricsAccessor.clear();
                    this.inflight.endRequest();
                    metric.stop(response.getStatus(), this.timeService.getCurrentTimeMillis());
                    if (this.isPerRequestMetrics()) {
                        this.sendRequestTime(uriGroup.getGroup(), metric.getRequestCompleteTime() - metric.getRequestStartTime());
                    }
                    for (String group : Arrays.asList(uriGroup.getGroup(), "uaa.global.metrics")) {
                        MetricsQueue queue = this.getMetricsQueue(group);
                        queue.offer(metric);
                    }
                    throw throwable;
                }
                MetricsAccessor.clear();
                this.inflight.endRequest();
                metric.stop(response.getStatus(), this.timeService.getCurrentTimeMillis());
                if (this.isPerRequestMetrics()) {
                    this.sendRequestTime(uriGroup.getGroup(), metric.getRequestCompleteTime() - metric.getRequestStartTime());
                }
                for (String group : Arrays.asList(uriGroup.getGroup(), "uaa.global.metrics")) {
                    MetricsQueue queue = this.getMetricsQueue(group);
                    queue.offer(metric);
                }
                break block7;
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected MetricsQueue getMetricsQueue(String uri) {
        if (!this.perUriMetrics.containsKey(uri)) {
            this.perUriMetrics.putIfAbsent(uri, new MetricsQueue());
        }
        return this.perUriMetrics.get(uri);
    }

    protected UrlGroup getUriGroup(HttpServletRequest request) {
        if (this.urlGroups != null) {
            String uri = request.getRequestURI();
            for (Map.Entry<AntPathRequestMatcher, UrlGroup> entry : this.urlGroups.entrySet()) {
                if (!entry.getKey().matches(request)) continue;
                UrlGroup group = entry.getValue();
                logger.debug((Object)String.format("Successfully matched URI: %s to a group: %s", uri, group.getGroup()));
                return group;
            }
            return FALLBACK;
        }
        return FALLBACK;
    }

    @ManagedMetric(category="performance", displayName="Inflight Requests")
    public long getInflightCount() {
        return this.inflight.getInflightRequests();
    }

    @ManagedMetric(category="performance", displayName="Idle time (ms)")
    public long getIdleTime() {
        return this.inflight.getIdleTime();
    }

    @ManagedMetric(category="performance", displayName="Total server run time (ms)")
    public long getUpTime() {
        return this.inflight.getRunTime();
    }

    @ManagedMetric(category="performance", displayName="Server Requests for all URI Groups")
    public Map<String, String> getSummary() {
        HashMap<String, String> data = new HashMap<String, String>();
        this.perUriMetrics.entrySet().stream().forEach(entry -> data.put((String)entry.getKey(), JsonUtils.writeValueAsString(entry.getValue())));
        return data;
    }

    @ManagedMetric(category="performance", displayName="Global Server Request Summary")
    public String getGlobals() {
        return JsonUtils.writeValueAsString((Object)this.perUriMetrics.get("uaa.global.metrics"));
    }

    public TimeService getTimeService() {
        return this.timeService;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }

    public List<UrlGroup> getUrlGroups() throws IOException {
        ClassPathResource resource = new ClassPathResource("performance-url-groups.yml");
        Yaml yaml = new Yaml();
        List load = (List)yaml.load(resource.getInputStream());
        return load.stream().map(map -> UrlGroup.from((Map)map)).collect(Collectors.toList());
    }

    public void sendRequestTime(String urlGroup, long time) {
        if (this.notificationPublisher != null) {
            Notification note = new Notification(urlGroup, time, 0L);
            this.notificationPublisher.sendNotification(note);
        } else {
            logger.debug((Object)"notification publisher not found by UaaMetricsFilter");
        }
    }

    public void setNotificationPublisher(NotificationPublisher notificationPublisher) {
        this.notificationPublisher = notificationPublisher;
    }

    public boolean isPerRequestMetrics() {
        return this.perRequestMetrics;
    }

    public void setPerRequestMetrics(boolean perRequestMetrics) {
        this.perRequestMetrics = perRequestMetrics;
    }

    public void setInflight(IdleTimer inflight) {
        this.inflight = inflight;
    }
}

