/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.logging;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.logging.LogSanitizerUtil;

public class SanitizedLogFactory {
    public static SanitizedLog getLog(Class<?> clazz) {
        return new SanitizedLog(LogFactory.getLog(clazz));
    }

    public static class SanitizedLog {
        private Log fallback;

        public SanitizedLog(Log log) {
            this.fallback = log;
        }

        public boolean isDebugEnabled() {
            return this.fallback.isDebugEnabled();
        }

        public void info(String message) {
            this.fallback.info((Object)LogSanitizerUtil.sanitize(message));
        }

        public void warn(String message) {
            this.fallback.warn((Object)LogSanitizerUtil.sanitize(message));
        }

        public void debug(String message) {
            this.fallback.debug((Object)LogSanitizerUtil.sanitize(message));
        }

        public void debug(String message, Throwable t) {
            this.fallback.debug((Object)LogSanitizerUtil.sanitize(message), t);
        }
    }
}

