/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.invitations;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.account.PasswordChangeRequest;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeType;
import org.cloudfoundry.identity.uaa.invitations.InvitationsService;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;

@Service
public class EmailInvitationsService
implements InvitationsService {
    public static final String USER_ID = "user_id";
    public static final String EMAIL = "email";
    private final Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    private ScimUserProvisioning scimUserProvisioning;
    @Autowired
    private ExpiringCodeStore expiringCodeStore;
    @Autowired
    private ClientServicesExtension clientDetailsService;

    @Override
    public InvitationsService.AcceptedInvitation acceptInvitation(String code, String password) {
        ExpiringCode expiringCode = this.expiringCodeStore.retrieveCode(code, IdentityZoneHolder.get().getId());
        if (null == expiringCode || null != expiringCode.getIntent() && !ExpiringCodeType.INVITATION.name().equals(expiringCode.getIntent())) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST);
        }
        Map userData = (Map)JsonUtils.readValue((String)expiringCode.getData(), (TypeReference)new TypeReference<Map<String, String>>(){});
        String userId = (String)userData.get(USER_ID);
        String clientId = (String)userData.get("client_id");
        String redirectUri = (String)userData.get("redirect_uri");
        ScimUser user = (ScimUser)this.scimUserProvisioning.retrieve(userId, IdentityZoneHolder.get().getId());
        if ("uaa".equals(user.getOrigin())) {
            user = this.scimUserProvisioning.verifyUser(userId, user.getVersion(), IdentityZoneHolder.get().getId());
            if (StringUtils.hasText((String)password)) {
                PasswordChangeRequest request = new PasswordChangeRequest();
                request.setPassword(password);
                this.scimUserProvisioning.changePassword(userId, null, password, IdentityZoneHolder.get().getId());
            }
        }
        String redirectLocation = "/home";
        try {
            ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(clientId, IdentityZoneHolder.get().getId());
            Set redirectUris = clientDetails.getRegisteredRedirectUri();
            redirectLocation = UaaUrlUtils.findMatchingRedirectUri(redirectUris, redirectUri, redirectLocation);
        }
        catch (NoSuchClientException x) {
            this.logger.debug((Object)("Unable to find client_id for invitation:" + clientId));
        }
        catch (Exception x) {
            this.logger.error((Object)("Unable to resolve redirect for clientID:" + clientId), (Throwable)x);
        }
        return new InvitationsService.AcceptedInvitation(redirectLocation, user);
    }
}

